/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.common;

import com.kingdee.bos.ctrl.common.GlobalLocator;
import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.common.util.StreamUtil;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.common.util.xml.XmlUtil;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.log4j.Logger;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.JDOMException;

public class VersionManager {
    private static Logger logger = LogUtil.getPackageLogger(VersionManager.class);
    private GlobalLocator globalLocator;
    private String localFile;
    private String resourceFile;
    private Element localRoot;

    public VersionManager(GlobalLocator gl) {
        this.globalLocator = gl;
        this.localFile = gl.makeFilePath("/CtrlConfig.xml");
        this.resourceFile = gl.makeResourcePath("/CtrlConfig.xml");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update() {
        Element root = null;
        InputStream in = null;
        try {
            ClassLoader clsLdr = this.getClass().getClassLoader();
            if (clsLdr == null) {
                clsLdr = ClassLoader.getSystemClassLoader();
            }
            in = clsLdr.getResourceAsStream(this.resourceFile);
            root = XmlUtil.loadXmlStream(in);
        }
        catch (IOException e) {
            logger.error((Object)"", (Throwable)e);
            return;
        }
        catch (JDOMException e) {
            logger.error((Object)"", (Throwable)e);
            return;
        }
        finally {
            if (null != in) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        Element folder = root.getChild("Folder");
        this.updateFolder(folder, null);
        if (this.localRoot != null) {
            try {
                XmlUtil.saveXmlFile(this.localFile, this.localRoot);
            }
            catch (IOException e) {
                logger.error((Object)"", (Throwable)e);
                return;
            }
        }
    }

    private void updateFolder(Element folderNode, XMLPath parentPath) {
        for (Element child : folderNode.getChildren()) {
            String name = child.getAttributeValue("name");
            if (StringUtil.isEmptyString(name)) continue;
            XMLPath currentPath = new XMLPath(parentPath, child.getAttributeValue("name"));
            if (StringUtil.equalsIgnoreCase(child.getName(), "Folder")) {
                this.updateFolder(child, currentPath);
                continue;
            }
            if (!StringUtil.equalsIgnoreCase(child.getName(), "File")) continue;
            this.updateFile(child, currentPath);
        }
    }

    private void updateFile(Element fileNode, XMLPath path) {
        if (this.localRoot == null) {
            this.localRoot = this.getLocalFileRoot();
        }
        Element parallelNode = this.getLocalParallelNode(this.localRoot, path);
        String localVersion = parallelNode.getAttributeValue("version");
        float localVer = 0.0f;
        if (!StringUtil.isEmptyString(localVersion)) {
            localVer = Float.valueOf(localVersion).floatValue();
        }
        String version = fileNode.getAttributeValue("version");
        float ver = Float.valueOf(version).floatValue();
        String updator = fileNode.getAttributeValue("updator");
        if (ver > localVer) {
            try {
                boolean exist = new File(this.globalLocator.makeFilePath(path.getPathString())).exists();
                if (StringUtil.isEmptyString(updator)) {
                    logger.info((Object)("Overriding file: " + path.getPathString()));
                    this.globalLocator.createResourceFile(path.getPathString());
                    parallelNode.setAttribute("version", version);
                } else if (!exist) {
                    logger.info((Object)("Creating file : " + path.getPathString()));
                    this.globalLocator.createResourceFile(path.getPathString());
                    parallelNode.setAttribute("version", version);
                } else {
                    logger.info((Object)("Updating file: " + updator));
                    Object cls = null;
                    cls = Class.forName(updator).newInstance();
                    IUpdator udt = null;
                    if (cls instanceof IUpdator) {
                        udt = cls;
                        if (udt.doUpdate()) {
                            logger.info((Object)"Updated successfully.");
                            parallelNode.setAttribute("version", version);
                            return;
                        }
                        logger.error((Object)"Update failed.");
                        return;
                    }
                    logger.error((Object)"Cannot locate (Updator) object.");
                }
            }
            catch (Exception e) {
                logger.error((Object)"Cannot create object(Updator) for update.", (Throwable)e);
            }
        }
    }

    private Element getLocalParallelNode(Element root, XMLPath xmlPath) {
        Element node = root;
        String[] path = xmlPath.getPath();
        for (int i = 0; i < path.length; ++i) {
            String name = path[i];
            node = this.getChildByAttribute(node, "name", name, i == path.length - 1);
        }
        return node;
    }

    private Element getChildByAttribute(Element parentNode, String attr, String attrValue, boolean isFile) {
        Element child2;
        if (parentNode == null) {
            return null;
        }
        for (Element child2 : parentNode.getChildren()) {
            if (!StringUtil.equals(child2.getAttributeValue(attr), attrValue)) continue;
            return child2;
        }
        child2 = isFile ? new Element("File") : new Element("Folder");
        child2.setAttribute(attr, attrValue);
        parentNode.addContent((Content)child2);
        return child2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Element getLocalFileRoot() {
        Element root = null;
        FileInputStream in = null;
        try {
            in = new FileInputStream(this.localFile);
            root = XmlUtil.loadXmlStream(in);
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                StreamUtil.closeCloseable(in);
                throw throwable;
            }
            StreamUtil.closeCloseable((Closeable)in);
        }
        StreamUtil.closeCloseable((Closeable)in);
        if (root == null) {
            root = new Element("CtrlConfig");
            root.setAttribute("version", "1.0");
        }
        return root;
    }

    public static interface IUpdator {
        public boolean doUpdate();
    }

    private class XMLPath {
        private XMLPath parentPath;
        private String name;

        public XMLPath(XMLPath parentPath, String name) {
            this.parentPath = parentPath;
            this.name = name;
        }

        public String getPathString() {
            XMLPath parent = this.parentPath;
            String pathStr = "/" + this.name;
            while (parent != null) {
                pathStr = "/" + parent.name + pathStr;
                parent = parent.parentPath;
            }
            return pathStr;
        }

        public String[] getPath() {
            int deep = this.getDeep();
            String[] path = new String[deep];
            XMLPath parent = this.parentPath;
            path[--deep] = this.name;
            while (parent != null) {
                path[--deep] = parent.name;
                parent = parent.parentPath;
            }
            return path;
        }

        public int getDeep() {
            XMLPath parent = this.parentPath;
            int deep = 1;
            while (parent != null) {
                parent = parent.parentPath;
                ++deep;
            }
            return deep;
        }

        public String getName() {
            return this.name;
        }
    }
}

