/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.common.session;

import com.kingdee.bos.ctrl.common.session.Session;
import com.kingdee.bos.ctrl.common.util.LogUtil;
import java.util.HashMap;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.log4j.Logger;

public class SessionManager {
    private static final Logger log = LogUtil.getPackageLogger(SessionManager.class);
    protected ClearExpiredSession clearTask;
    private long timeout;
    private long clearPeriod;
    private HashMap sessions = new HashMap();

    public SessionManager(long timeout, long clearPeriod) {
        this.timeout = timeout;
        this.clearPeriod = clearPeriod;
        this.clearTask = new ClearExpiredSession(this.clearPeriod);
        log.info((Object)("Create session manager, timeout:" + this.timeout + "(ms), clear period:" + this.clearPeriod + "(ms)"));
    }

    public Session getSession(Object ssnId) {
        return (Session)this.sessions.get(ssnId);
    }

    public Session createSession(Object ctx) {
        Session ssn = new Session(ctx);
        this.sessions.put(ssn.getId(), ssn);
        return ssn;
    }

    public Session removeSession(Object ssnId) {
        Session session = (Session)this.sessions.remove(ssnId);
        if (session != null) {
            session.destroy();
        }
        return session;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public long getClearPeriod() {
        return this.clearPeriod;
    }

    public int removeExpiredSessions() {
        return 0;
    }

    public void clearAllSessions() {
        Object[] vals = this.sessions.values().toArray();
        for (int i = 0; i < vals.length; ++i) {
            Session ssn = (Session)vals[i];
            this.sessions.remove(ssn.getId());
        }
    }

    private class ClearExpiredSession
    extends TimerTask {
        private Timer timer = new Timer();

        private ClearExpiredSession(long period) {
            this.timer.schedule((TimerTask)this, period, period);
        }

        @Override
        public void run() {
            if (SessionManager.this.sessions.size() == 0) {
                return;
            }
            int clearCount = 0;
            int remainCount = 0;
            long expriedTime = System.currentTimeMillis() - SessionManager.this.timeout;
            Object[] vals = SessionManager.this.sessions.values().toArray();
            for (int i = 0; i < vals.length; ++i) {
                Session ssn = (Session)vals[i];
                if (expriedTime > ssn.getLastTime()) {
                    log.info((Object)("Remove exprired session:" + ssn.getId()));
                    ++clearCount;
                    SessionManager.this.sessions.remove(ssn.getId());
                    ssn.destroy();
                    continue;
                }
                ++remainCount;
            }
            log.info((Object)("Cleared " + clearCount + " expired, remain " + remainCount + " sessions"));
        }
    }
}

