/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.common.util.list;

import com.kingdee.bos.ctrl.common.util.list.BasicList;
import com.kingdee.bos.ctrl.common.util.list.exception.OutOfCapacityException;

public class ArrayBasedList
extends BasicList {
    private Object[] objects;
    private boolean autoIncrease;

    public ArrayBasedList(int maxSize) {
        super(maxSize, true);
        this.autoIncrease = maxSize == -1;
        if (!this.autoIncrease) {
            this.objects = new Object[maxSize];
        }
    }

    private final void ensureSize(int size) {
        if (this.autoIncrease) {
            if (this.objects == null) {
                this.objects = new Object[size];
            } else if (this.objects.length < size) {
                Object[] temp = new Object[(int)((double)size * 1.5)];
                System.arraycopy(this.objects, 0, temp, 0, this.objects.length);
                this.objects = temp;
            }
        }
    }

    @Override
    public boolean set(int index, Object object) {
        try {
            return super.set(index, object);
        }
        catch (OutOfCapacityException outOfCapacityException) {
            return true;
        }
    }

    @Override
    protected Object pureReadObject(int position, int ttttt) {
        this.ensureSize(position + 1);
        return this.objects[position];
    }

    @Override
    protected int pureWriteObject(int position, Object obj) {
        this.ensureSize(position + 1);
        this.objects[position] = obj;
        return 1;
    }

    @Override
    protected void pureClearObject(int position, int size) {
        this.ensureSize(position + 1);
        this.pureWriteObject(position, null);
    }

    @Override
    protected int pureGetObjectStoreSize(Object obj) {
        return 1;
    }

    @Override
    public void clear() {
        super.clear();
        if (this.autoIncrease) {
            this.objects = null;
        }
    }
}

