/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.data.meta.io;

import com.kingdee.bos.ctrl.common.DataType;
import com.kingdee.bos.ctrl.data.meta.MetaClass;
import com.kingdee.bos.ctrl.data.meta.MetaField;
import com.kingdee.bos.ctrl.data.meta.MetaLibrary;
import com.kingdee.bos.ctrl.data.meta.MetaPackage;
import com.kingdee.bos.ctrl.data.modal.io.ParameterIO;
import com.kingdee.bos.ctrl.data.modal.io.Xml2Def;
import java.util.Iterator;
import org.jdom2.Element;

public class Xml2Meta {
    public MetaLibrary transform(Element xmlLib) {
        if ("Library".equals(xmlLib.getName())) {
            return Xml2Meta.parseLibrary(xmlLib);
        }
        return null;
    }

    public static MetaLibrary parseLibrary(Element xmlLib) {
        MetaLibrary ml = new MetaLibrary();
        Xml2Def.parseDefObj(ml, xmlLib);
        Xml2Meta.parsePackage(ml.getRootPackage(), xmlLib);
        return ml;
    }

    public static void parsePackage(MetaPackage pkg, Element xmlPkg) {
        Iterator itrCls = xmlPkg.getChildren("Class").iterator();
        while (itrCls.hasNext()) {
            MetaClass subCls = Xml2Meta.parseClass((Element)itrCls.next());
            if (subCls == null) continue;
            pkg.addClass(subCls);
        }
        Iterator itrPkg = xmlPkg.getChildren("Package").iterator();
        while (itrPkg.hasNext()) {
            MetaPackage subPkg = Xml2Meta.parsePackage((Element)itrPkg.next());
            if (subPkg == null) continue;
            pkg.addPackage(subPkg);
        }
    }

    public static MetaPackage parsePackage(Element xmlPkg) {
        if (!"Package".equals(xmlPkg.getName())) {
            return null;
        }
        MetaPackage mp = new MetaPackage();
        Xml2Def.parseDefObj(mp, xmlPkg);
        Xml2Meta.parsePackage(mp, xmlPkg);
        return mp;
    }

    public static MetaClass parseClass(Element xmlCls) {
        if (!"Class".equals(xmlCls.getName())) {
            return null;
        }
        MetaClass mc = new MetaClass();
        String ver = xmlCls.getAttributeValue("version");
        if (ver == null) {
            Xml2Def.upgradeSC(mc, xmlCls);
        } else {
            Xml2Def.parseDefObj(mc, xmlCls);
        }
        mc.setType(xmlCls.getAttributeValue("type"));
        mc.setExpr(xmlCls.getAttributeValue("expr"));
        Element elm = xmlCls.getChild("Parameters");
        if (elm != null) {
            mc.setParameters(ParameterIO.parseParameters(elm));
        }
        Iterator itr = xmlCls.getChildren("Field").iterator();
        while (itr.hasNext()) {
            MetaField fld = Xml2Meta.parseField((Element)itr.next(), ver);
            if (fld == null) continue;
            mc.addField(fld);
        }
        return mc;
    }

    public static MetaField parseField(Element xmlFld, String ver) {
        if (!"Field".equals(xmlFld.getName())) {
            return null;
        }
        MetaField mf = new MetaField();
        if (ver == null) {
            Xml2Def.upgradeSC(mf, xmlFld);
        } else {
            Xml2Def.parseDefObj(mf, xmlFld);
        }
        mf.setType(DataType.fromName(xmlFld.getAttributeValue("type")));
        mf.setExpr(xmlFld.getAttributeValue("expr"));
        return mf;
    }
}

