/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.data.modal.io;

import com.kingdee.bos.ctrl.common.DataType;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.data.modal.Parameter;
import com.kingdee.bos.ctrl.data.modal.io.Def2Xml;
import com.kingdee.bos.ctrl.data.modal.io.Xml2Def;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jdom2.Content;
import org.jdom2.Element;

public class ParameterIO {
    public static final String T_PARAMETERS = "Parameters";
    public static final String T_PARAMETER = "Parameter";
    public static final String A_DATA_TYPE = "dataType";
    public static final String A_SCOPE = "scope";
    public static final String A_ALLOW_NULL = "allowNull";
    public static final String A_DEFAULT_VALUE = "defaultValue";
    public static final String T_INPUT = "Input";
    public static final String A_TYPE = "type";

    public static final Element makeParameter(Parameter p) {
        Element xml = new Element(T_PARAMETER);
        if (p != null) {
            Def2Xml.makeDefObj(p, xml);
            Def2Xml.makeProperties(Parameter.CUSTEM_PROPERTIES, p.getProperties(), xml);
            if (p.getDataType() != null) {
                xml.setAttribute(A_DATA_TYPE, p.getDataType().getName());
            }
            xml.setAttribute(A_ALLOW_NULL, Boolean.toString(p.isAllowNull()));
            String s = p.getDefaultValue();
            if (!StringUtil.isEmptyString(s)) {
                xml.setAttribute(A_DEFAULT_VALUE, p.getDefaultValue());
            }
        }
        return xml;
    }

    public static final Element makeParameters(List ps) {
        Element xml = new Element(T_PARAMETERS);
        Iterator itr = ps.iterator();
        while (itr.hasNext()) {
            xml.addContent((Content)ParameterIO.makeParameter((Parameter)itr.next()));
        }
        return xml;
    }

    public static Parameter parseParameter(Element xml) {
        Parameter obj = new Parameter();
        Xml2Def.parseDefObj(obj, xml);
        Xml2Def.parseProperties(Parameter.CUSTEM_PROPERTIES, obj.getProperties(), xml);
        obj.setDataType(DataType.fromName(xml.getAttributeValue(A_DATA_TYPE)));
        obj.setAllowNull(Boolean.valueOf(xml.getAttributeValue(A_ALLOW_NULL)));
        obj.setDefaultValue(xml.getAttributeValue(A_DEFAULT_VALUE));
        return obj;
    }

    public static final List parseParameters(Element xml) {
        ArrayList<Parameter> ps = new ArrayList<Parameter>();
        List lst = xml.getChildren(T_PARAMETER);
        Iterator i = lst.iterator();
        while (i.hasNext()) {
            Parameter p = ParameterIO.parseParameter((Element)i.next());
            ps.add(p);
        }
        return ps;
    }
}

