/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.excel.model.util;

import com.kingdee.bos.ctrl.common.KDToolkit;
import java.io.Serializable;
import java.util.Arrays;

public class ObjectArray
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 8070335813395513558L;
    protected Object[] _array;
    protected int _count;

    public ObjectArray() {
        this(10);
    }

    public ObjectArray(int initCap) {
        this._array = new Object[initCap];
        this._count = 0;
    }

    public ObjectArray(Object[] array) {
        this.setArray(array);
    }

    protected Object clone() {
        ObjectArray array = null;
        try {
            array = (ObjectArray)super.clone();
            array._array = new Object[Math.max(this._count, 2)];
            KDToolkit.arraycopy(this._array, 0, array._array, 0, this._count);
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return array;
    }

    protected int getIncreasedCellsSize() {
        return (this._array.length * 3 >> 1) + 1;
    }

    public void ensureCapacity(int minCapacity) {
        if (minCapacity > this._array.length) {
            Object[] oldData = this._array;
            int newCapacity = this.getIncreasedCellsSize();
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            this._array = new Object[newCapacity];
            KDToolkit.arraycopy(oldData, 0, this._array, 0, this._count);
        }
    }

    public void setArray(Object[] array) {
        if (array == null || array.length == 0) {
            this._array = new Object[10];
            this._count = 0;
        } else {
            this._array = array;
            this._count = array.length;
        }
    }

    public Object[] toArray() {
        return this.toArray(null, 0);
    }

    public Object[] toArray(Object[] array, int destPos) {
        if (this._count == 0) {
            return array == null ? new Object[]{} : array;
        }
        if (array == null || array.length - destPos < this._count) {
            Object[] newArray = new Object[this._count + destPos];
            if (destPos > 0) {
                KDToolkit.arraycopy(array, 0, newArray, 0, destPos);
            }
            array = newArray;
        }
        KDToolkit.arraycopy(this._array, 0, array, destPos, this._count);
        return array;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("[");
        if (!this.isEmpty()) {
            for (int i = 0; i < this._count; ++i) {
                if (i != 0) {
                    sb.append(',');
                }
                sb.append(this._array[i].toString());
            }
        }
        sb.append(']');
        return sb.toString();
    }

    public int size() {
        return this._count;
    }

    public void clear() {
        if (this._count > 0) {
            Arrays.fill(this._array, 0, this._count, null);
            this._count = 0;
        }
    }

    public boolean isEmpty() {
        return this._count == 0;
    }

    public Object[] getArray() {
        return this._array;
    }

    public Object get(int index) {
        return this._array[index];
    }

    public Object getAt(int index) {
        return this._array[index];
    }

    public Object set(int index, Object element) {
        if (index >= this._count) {
            this._count = index + 1;
        }
        Object oldValue = this._array[index];
        this._array[index] = element;
        return oldValue;
    }

    public Object getLast() {
        return this._count == 0 ? null : this._array[this._count - 1];
    }

    public void append(Object obj) {
        if (this._count + 1 > this._array.length) {
            Object[] newArray = new Object[this.getIncreasedCellsSize()];
            KDToolkit.arraycopy(this._array, 0, newArray, 0, this._count);
            this._array = newArray;
        }
        this._array[this._count++] = obj;
    }

    public void appendAll(ObjectArray src) {
        this.insertAll(this._count, src);
    }

    public void appendAll(Object[] objs) {
        if (objs == null || objs.length == 0) {
            return;
        }
        this.insert(objs, 0, this._count, objs.length);
    }

    public void insert(int pos, Object obj) {
        if (this._count == 0) {
            this._array[0] = obj;
            this._count = 1;
        } else {
            if (pos < 0) {
                pos = -(pos + 1);
            }
            if (this._count + 1 > this._array.length) {
                Object[] newArray = new Object[this.getIncreasedCellsSize()];
                KDToolkit.arraycopy(this._array, 0, newArray, 0, pos);
                KDToolkit.arraycopy(this._array, pos, newArray, pos + 1, this._count - pos);
                this._array = newArray;
            } else {
                KDToolkit.arraycopy(this._array, pos, this._array, pos + 1, this._count - pos);
            }
            this._array[pos] = obj;
            ++this._count;
        }
    }

    public void insert(Object[] objs, int srcPos, int dstPos, int length) {
        if (dstPos > this._array.length) {
            throw new IndexOutOfBoundsException();
        }
        if (this._count + length > this._array.length) {
            Object[] newArray = new Object[this._count + length];
            KDToolkit.arraycopy(this._array, 0, newArray, 0, dstPos);
            KDToolkit.arraycopy(this._array, dstPos, newArray, dstPos + length, this._count - dstPos);
            this._array = newArray;
        }
        KDToolkit.arraycopy(objs, 0, this._array, dstPos, length);
        this._count += length;
    }

    public void insertAll(int pos, ObjectArray src) {
        int ins;
        if (pos < 0) {
            pos = -(pos + 1);
        }
        if (this._count + (ins = src.size()) > this._array.length) {
            Object[] newArray = new Object[((this._count + ins) * 3 >> 1) + 1];
            KDToolkit.arraycopy(this._array, 0, newArray, 0, pos);
            KDToolkit.arraycopy(this._array, pos, newArray, pos + ins, this._count - pos);
            this._array = newArray;
        } else {
            KDToolkit.arraycopy(this._array, pos, this._array, pos + ins, this._count - pos);
        }
        KDToolkit.arraycopy(src._array, 0, this._array, pos, ins);
        this._count += ins;
    }

    public Object remove(Object obj) {
        for (int i = 0; i < this._array.length; ++i) {
            if (this._array[i] != obj) continue;
            return this.removeByPos(i);
        }
        return null;
    }

    public Object removeByPos(int pos) {
        if (pos < 0 || pos >= this._count) {
            return null;
        }
        Object obj = this._array[pos];
        int remain = this._count - (pos + 1);
        if (remain > 0) {
            KDToolkit.arraycopy(this._array, pos + 1, this._array, pos, remain);
        }
        this._array[--this._count] = null;
        return obj;
    }

    public Object[] removeByPos(int pos, int pos2, boolean bRet) {
        int remain;
        if (pos < 0 || pos >= this._count || pos2 < 0 || pos2 >= this._count || pos2 < pos) {
            return null;
        }
        int len = pos2 - pos + 1;
        Object[] dst = null;
        if (bRet) {
            dst = new Object[len];
            KDToolkit.arraycopy(this._array, pos, dst, 0, len);
        }
        if ((remain = this._count - (pos2 + 1)) > 0) {
            KDToolkit.arraycopy(this._array, pos2 + 1, this._array, pos, remain);
        }
        Arrays.fill(this._array, this._count - len, this._count, null);
        this._count -= len;
        return dst;
    }

    public void trimToSize() {
        int count = Math.max(this._count, 10);
        if (count < this._array.length) {
            Object[] newArray = new Object[count];
            KDToolkit.arraycopy(this._array, 0, newArray, 0, this._count);
            this._array = newArray;
        }
    }

    public boolean reduce() {
        int oldCount = this._count;
        for (int i = 0; i < this._count; ++i) {
            int to;
            int from = to = i;
            while (to < this._count && this._array[to] == null) {
                ++to;
            }
            if (from == to) continue;
            int remain = this._count - to;
            KDToolkit.arraycopy(this._array, to, this._array, from, remain);
            int offset = to - from;
            Arrays.fill(this._array, this._count - offset, this._count, null);
            this._count -= offset;
        }
        return oldCount != this._count;
    }

    public boolean contains(Object elem) {
        return this.indexOf(elem) >= 0;
    }

    public int indexOf(Object elem) {
        if (elem == null) {
            for (int i = 0; i < this._count; ++i) {
                if (this._array[i] != null) continue;
                return i;
            }
        } else {
            for (int i = 0; i < this._count; ++i) {
                if (!elem.equals(this._array[i])) continue;
                return i;
            }
        }
        return -1;
    }
}

