/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.expr;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.kdf.expr.ArrayStack;
import com.kingdee.bos.ctrl.kdf.expr.ExprError;
import com.kingdee.bos.ctrl.kdf.expr.HashStack;
import com.kingdee.bos.ctrl.kdf.expr.Macro;
import com.kingdee.bos.ctrl.kdf.expr.MacroEngineFactory;
import com.kingdee.bos.ctrl.kdf.expr.MacroHelperListener;
import com.kingdee.bos.ctrl.kdf.expr.RelationKey;
import com.kingdee.bos.ctrl.kdf.expr.RelationNode;
import com.kingdee.bos.ctrl.kdf.expr.RelationsListener;
import com.kingdee.bos.ctrl.kdf.expr.SyntaxErrorException;
import com.kingdee.bos.ctrl.kdf.expr.Variant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public abstract class AbstractRelations
implements MacroHelperListener {
    private static final int DEPS_CALLSTACK_OVERFLOW = 100;
    private boolean autoRun = true;
    protected HashMap deps = new HashMap();
    protected HashMap nodes = new HashMap();
    protected HashMap listeners = new HashMap();
    private ArrayList calcList;
    private ArrayStack callStack = new ArrayStack();
    private HashStack cycCheck = new HashStack();
    private ArrayList defaultFunctionProviders;
    private RelationNode currentNode;

    public AbstractRelations() {
        this.calcList = new ArrayList();
    }

    public void setDefaultFunctionProvider(ArrayList functionProviders) {
        this.defaultFunctionProviders = functionProviders;
    }

    public ArrayList getDefaultFunctionProvider() {
        if (this.defaultFunctionProviders == null) {
            this.defaultFunctionProviders = new ArrayList();
        }
        return this.defaultFunctionProviders;
    }

    public RelationNode getCurrentNode() {
        return this.currentNode;
    }

    public RelationsListener getCurrentListener() {
        RelationKey key;
        if (this.currentNode != null && (key = this.currentNode.getRelationKey()) != null) {
            return key.getRelationsListener();
        }
        return null;
    }

    public boolean appendRelations(AbstractRelations rels) {
        if (rels == null) {
            return false;
        }
        this.nodes.putAll(rels.nodes);
        this.deps.putAll(rels.deps);
        return true;
    }

    public boolean queue(RelationKey key, String formula) {
        boolean succeed = false;
        boolean deleteNode = false;
        RelationNode node = null;
        if (this.nodes.containsKey(key)) {
            node = (RelationNode)this.nodes.get(key);
            node.setFormula(formula);
            if (StringUtil.isEmptyString(formula)) {
                deleteNode = true;
            }
        } else if (!StringUtil.isEmptyString(formula)) {
            node = new RelationNode(key, formula);
            this.nodes.put(key, node);
            assert (node.isNeedCalculate());
        }
        if (node == null || node.isNeedCalculate() || deleteNode) {
            succeed = this.queueElement(key, true);
        }
        if (deleteNode && node != null) {
            this.nodes.remove(key);
        }
        return succeed;
    }

    public boolean queue(RelationKey key, Object value, String formula) {
        boolean succeed = false;
        boolean deleteNode = false;
        boolean formulaChanged = false;
        RelationNode node = null;
        if (this.nodes.containsKey(key)) {
            node = (RelationNode)this.nodes.get(key);
            formulaChanged = node.setFormula(formula);
            Variant v = Variant.getNewEmptyVariant();
            v.setObject(value);
            node.setData(v);
            node.setQueued(false);
            if (StringUtil.isEmptyString(formula)) {
                deleteNode = true;
                node.setNeedCalculate(false);
            } else {
                node.setNeedCalculate(true);
            }
        } else if (!StringUtil.isEmptyString(formula)) {
            node = new RelationNode(key, formula);
            this.nodes.put(key, node);
            assert (node.isNeedCalculate());
        }
        if (node == null || node.isNeedCalculate() || deleteNode) {
            succeed = this.queueElement(key, true);
            if (!formulaChanged && node != null) {
                node.setNeedCalculate(false);
            }
        }
        if (deleteNode && node != null) {
            this.nodes.remove(key);
        }
        return succeed;
    }

    public boolean removeNode(RelationKey key) {
        boolean succeed = false;
        RelationNode node = (RelationNode)this.nodes.remove(key);
        if (node != null) {
            node.setNeedCalculate(true);
            succeed = true;
        }
        succeed = succeed && this.queueElement(key, true);
        this.deps.remove(key);
        if (node != null) {
            Iterator i = this.calcList.iterator();
            while (i.hasNext()) {
                RelationNode node2 = (RelationNode)i.next();
                if (node != node2) continue;
                i.remove();
            }
        }
        return succeed;
    }

    public RelationNode getNode(RelationKey key) {
        RelationNode node = (RelationNode)this.nodes.get(key);
        if (node == null) {
            node = new RelationNode(key, null);
        }
        return node;
    }

    public int size() {
        return this.deps.size();
    }

    public boolean removeAll(RelationsListener thisListener) {
        if (!this.nodes.isEmpty()) {
            RelationKey key2;
            if (thisListener == null) {
                this.deps.clear();
                this.nodes.clear();
                this.listeners.clear();
                this.calcList.clear();
                this.callStack.clear();
                this.cycCheck.clear();
                return true;
            }
            HashMap<RelationKey, RelationKey> pickout = new HashMap<RelationKey, RelationKey>();
            for (RelationKey key2 : this.deps.keySet()) {
                if (key2.getRelationsListener() != thisListener) continue;
                pickout.put(key2, key2);
            }
            for (RelationKey key2 : pickout.keySet()) {
                this.removeNode(key2);
            }
            Iterator<Object> i = this.nodes.keySet().iterator();
            while (i.hasNext()) {
                key2 = (RelationKey)i.next();
                if (key2.getRelationsListener() != thisListener) continue;
                i.remove();
            }
            i = this.calcList.iterator();
            while (i.hasNext()) {
                key2 = ((RelationNode)i.next()).getRelationKey();
                if (key2.getRelationsListener() != thisListener) continue;
                i.remove();
            }
            Variant varListener = new Variant(thisListener, 17);
            for (Map.Entry entry : this.listeners.entrySet()) {
                if (!varListener.equals(entry.getValue())) continue;
                this.listeners.remove(entry.getKey());
                break;
            }
            return this.calculateQueue();
        }
        return false;
    }

    public Macro getNewMacroEngine(RelationsListener listener, String formula) {
        RelationKey key = new RelationKey(listener, "__Calc__", null);
        RelationNode node = new RelationNode(key, formula);
        return MacroEngineFactory.createMacro(this, this.defaultFunctionProviders, node, formula);
    }

    public void releaseMacroEngine(Macro m) {
        MacroEngineFactory.recycleMacro(m);
    }

    private void createDependent(RelationNode refer, RelationKey referencedKey) {
        Object objList = this.deps.get(referencedKey);
        if (objList == null) {
            objList = new ArrayList(2);
            this.deps.put(referencedKey, objList);
        }
        ArrayList list = (ArrayList)objList;
        list.add(refer);
    }

    protected boolean queueElement(RelationKey startKey, boolean bRemoveKey) {
        Object depList;
        boolean succeed = false;
        RelationNode startNode = (RelationNode)this.nodes.get(startKey);
        if (startNode != null) {
            if (!startNode.isNeedCalculate() || startNode.isQueued()) {
                return false;
            }
            this.calcList.add(startNode);
            startNode.setQueued(true);
            succeed = true;
        }
        if ((depList = this.deps.get(startKey)) == null) {
            return succeed;
        }
        int iStart = this.calcList.size();
        block0: while (true) {
            ArrayList list = (ArrayList)depList;
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                RelationNode node = (RelationNode)list.get(i);
                if (node.isDeleted()) continue;
                node.setNeedCalculate(true);
                this.calcList.add(node);
                node.setQueued(true);
            }
            depList = null;
            if (bRemoveKey) {
                this.deps.remove(startKey);
            }
            while (iStart < this.calcList.size()) {
                startKey = ((RelationNode)this.calcList.get(iStart)).getRelationKey();
                depList = this.deps.get(startKey);
                if (depList != null) continue block0;
                ++iStart;
            }
            if (depList == null) break;
        }
        return succeed;
    }

    public void recalcAll(RelationsListener thisListener) {
        if (thisListener == null) {
            this.deps.clear();
        } else {
            Iterator i = this.deps.keySet().iterator();
            while (i.hasNext()) {
                RelationKey key = (RelationKey)i.next();
                if (key.getRelationsListener() != thisListener) continue;
                i.remove();
            }
        }
        assert (this.cycCheck.size() == 0);
        if (thisListener == null) {
            this.calcList.clear();
        }
        RelationNode node = null;
        for (Map.Entry e : this.nodes.entrySet()) {
            node = thisListener == null ? (RelationNode)e.getValue() : (((RelationKey)e.getKey()).getRelationsListener() == thisListener ? (RelationNode)e.getValue() : null);
            if (node == null) continue;
            node.setNeedCalculate(true);
            this.calcList.add(node);
            node.setQueued(true);
        }
        this.calculateQueue();
    }

    public synchronized boolean calculateQueue() {
        if (!this.isAutoRun()) {
            return true;
        }
        assert (this.callStack.size() == 0);
        assert (this.cycCheck.size() == 0);
        int i = 0;
        while (i < this.calcList.size()) {
            try {
                RelationNode node = (RelationNode)this.calcList.get(i);
                if (node.isNeedCalculate() && !StringUtil.isEmptyString(node.getFormula())) {
                    this.currentNode = node;
                    this.calculateNode(node);
                    assert (this.callStack.size() == 0);
                    this.cycCheck.clear();
                }
                ++i;
            }
            catch (StackOverflowError e) {
                Object[] ao = this.callStack.toArray();
                for (int j = 0; j < ao.length; ++j) {
                    this.calcList.add(i, ao[j]);
                }
                this.callStack.clear();
            }
            this.currentNode = null;
        }
        this.calcList.clear();
        return true;
    }

    protected void calculateNode(RelationNode node) {
        if (node.isNeedCalculate()) {
            this.callStack.push(node);
            if (!this.cycCheck.contains(node.getRelationKey())) {
                this.cycCheck.push(node.getRelationKey());
            }
            node.firePreIntepretedEvent();
            node.setQueued(false);
            Macro m = MacroEngineFactory.createMacro(this, this.defaultFunctionProviders, node, node.getFormula());
            boolean succeed = m.execute();
            node.setNeedCalculate(false);
            node.fireIntepretedCompleteEvent(succeed, m);
            node.setQueued(false);
            MacroEngineFactory.recycleMacro(m);
            this.cycCheck.pop();
            this.callStack.pop();
        }
    }

    protected void objectRef(RelationNode refer, RelationKey referencedKey) throws SyntaxErrorException {
        this.createDependent(refer, referencedKey);
        if (this.cycCheck.contains(referencedKey)) {
            ArrayList<String> al = new ArrayList<String>();
            Object[] ao = this.cycCheck.getStack().toArray();
            for (int i = 0; i < ao.length; ++i) {
                RelationKey key = (RelationKey)ao[i];
                RelationNode node = (RelationNode)this.nodes.get(key);
                al.add(key.toString() + "=" + node.getFormula());
            }
            ExprError.goError(32768L, al);
        }
        if (this.callStack.size() >= 100) {
            throw new StackOverflowError();
        }
        RelationNode referenced = (RelationNode)this.nodes.get(referencedKey);
        if (referenced != null && referenced.isNeedCalculate()) {
            this.calculateNode(referenced);
        }
    }

    public boolean isAutoRun() {
        return this.autoRun;
    }

    public void setAutoRun(boolean autoRun) {
        this.autoRun = autoRun;
    }
}

