/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.formatter;

public class NumberTransEnglish {
    private static final String[] sep_American = new String[]{"", " Thousand", " Million", " Billion", " Trillion"};
    private static final String[] sep_British = new String[]{"", " Thousand", " Million", " milliard", " Billion"};
    private static final String[] numbers1 = new String[]{"Zero", "Ten", "Twenty", "Thirty", "Forty", "Fifty", "Sixty", "Seventy", "Eighty", "Ninety"};
    private static final String[] numbers2 = new String[]{"Zero", "One", "Two", "Three", "Four", "Five", "Six", "Seven", "Eight", "Nine"};
    private static final String[] numbers3 = new String[]{"Ten", "Eleven", "Twelve", "Thirteen", "Fourteen", "Fifteen", "Sixteen", "Seventeen", "Eighteen", "Nineteen"};

    public static String toEnglishNumber(String num) {
        return NumberTransEnglish.toEnglishNumber(num, 0);
    }

    public static String toEnglishNumber(String num, int type) {
        if (num == null || num.length() <= 0) {
            return "";
        }
        String result = "";
        if (num.indexOf("-") >= 0) {
            result = "Minus ";
            num = num.substring(1).trim();
        }
        String[] part = num.split("\\p{Punct}");
        String before = part[0];
        String over = "";
        int len = before.length();
        if (len > 15) {
            over = before.substring(0, len - 12);
            result = result + NumberTransEnglish.transOver(over, type) + " ";
            before = before.substring(len - 12);
        }
        result = result + NumberTransEnglish.transBefore(before, type);
        if (part.length == 2 && part[1] != null && part[1].length() > 0) {
            result = result + NumberTransEnglish.transAfter(part[1]);
        }
        return result;
    }

    private static String transBefore(String num, int type) {
        int len = num.length();
        int cols = (int)Math.ceil((double)len / 3.0);
        int first = len - cols * 3;
        String strReturn = "";
        int j = 0;
        String num3 = "";
        String strEng = "";
        for (int i = first; i < len; i += 3) {
            ++j;
            num3 = i >= 0 ? num.substring(i, i + 3) : num.substring(0, first + 3);
            strEng = NumberTransEnglish.english(num3);
            if ("".equals(strEng)) continue;
            if (!"".equals(strReturn)) {
                strReturn = strReturn + " ";
            }
            strReturn = type == 0 ? strReturn + strEng + sep_American[cols - j] : strReturn + strEng + sep_British[cols - j];
        }
        return strReturn;
    }

    private static String transOver(String num, int type) {
        String strReturn = "";
        for (int i = 0; i < num.length(); ++i) {
            strReturn = strReturn + (i == 0 ? "" : " ") + NumberTransEnglish.english(String.valueOf(num.charAt(i)).toString());
        }
        strReturn = type == 0 ? strReturn + sep_American[4] : strReturn + sep_British[4];
        return strReturn;
    }

    private static String transAfter(String num) {
        String strReturn = "";
        if (!"".equals(num)) {
            int length = num.length();
            strReturn = " point";
            String tempch = "";
            for (int i = 0; i < length; ++i) {
                tempch = num.substring(i, i + 1);
                strReturn = strReturn + " " + numbers2[Integer.valueOf(tempch)];
            }
        }
        return strReturn;
    }

    private static String english(String num) {
        String strReturn = "";
        if (num.length() == 1) {
            strReturn = numbers2[Integer.valueOf(num)];
            return strReturn;
        }
        if (num.length() == 3 && !"000".equals(num.substring(0, 3))) {
            if (!"0".equals(num.substring(0, 1))) {
                strReturn = strReturn + numbers2[Integer.valueOf(num.substring(0, 1))] + " Hundred";
                if (!"00".equals(num.substring(1, 3))) {
                    strReturn = strReturn + " and ";
                }
            }
            num = num.substring(1);
        }
        if (num.length() == 2) {
            if ("0".equals(num.substring(0, 1))) {
                num = num.substring(1);
            } else if ("1".equals(num.substring(0, 1))) {
                strReturn = strReturn + numbers3[Integer.valueOf(num.substring(1, 2))];
            } else {
                strReturn = strReturn + numbers1[Integer.valueOf(num.substring(0, 1))];
                if (!"0".equals(num.substring(1, 2))) {
                    strReturn = strReturn + "-";
                }
                num = num.substring(1);
            }
        }
        if (num.length() == 1 && !"0".equals(num.substring(0, 1))) {
            strReturn = strReturn + numbers2[Integer.valueOf(num.substring(0, 1))];
        }
        return strReturn;
    }
}

