/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.script.miniscript.exec;

import com.kingdee.bos.ctrl.common.util.ReflectUtil;
import com.kingdee.bos.ctrl.script.miniscript.ScriptContext;
import com.kingdee.bos.ctrl.script.miniscript.exec.CMD;
import com.kingdee.bos.ctrl.script.miniscript.exec.IScriptObjectDelegate;
import com.kingdee.bos.ctrl.script.miniscript.exec.RunJava;
import com.kingdee.bos.ctrl.script.miniscript.exec.TypeValueMap;
import com.kingdee.bos.ctrl.script.miniscript.exec.objs.Null;
import com.kingdee.bos.ctrl.script.miniscript.exec.objs.Persistent;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;

public class SystemObject
implements Persistent {
    public static final String SYSTEMOBJECT_NAME = "sys";
    public static final String USER_DEFAULT_OBJECT_NAME = "user_default_object";
    public static final String JAVA_SYSTEM_NAME = "system";
    public static final String VERSION = "MiniScript V0.92 2006(c).";
    private Random random = new SecureRandom();
    protected ScriptContext ctx;
    private static final Map classMap = new HashMap();
    private final Map importedClassTypeMap = new HashMap();
    private final HashMap importedPackage = new HashMap();
    private static final Map classTypeMap;

    public SystemObject(ScriptContext ctx) {
        this.ctx = ctx;
        this.init();
    }

    private void init() {
        this.importPackage("java.lang.*");
        this.importPackage("java.util.*");
        this.importPackage("java.io.*");
    }

    private static Object invokeField(Object bean, String fieldName) throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        Field f;
        Class<?> cl = null;
        cl = bean instanceof Class ? (Class<?>)bean : bean.getClass();
        if (cl.isArray()) {
            if ("length".equals(fieldName)) {
                return new Integer(Array.getLength(bean));
            }
            f = Object.class.getField(fieldName);
        } else {
            f = cl.getField(fieldName);
        }
        return f.get(bean);
    }

    public Object invokeGet(Object obj, String attribute) {
        try {
            return SystemObject.invokeField(obj, attribute);
        }
        catch (Exception exception) {
            String accessAttribute = Character.toUpperCase(attribute.charAt(0)) + attribute.substring(1);
            Method m = null;
            try {
                m = obj.getClass().getMethod("get" + accessAttribute, null);
            }
            catch (NoSuchMethodException e) {
                try {
                    m = obj.getClass().getDeclaredMethod("is" + accessAttribute, null);
                }
                catch (NoSuchMethodException ex) {
                    try {
                        m = obj.getClass().getDeclaredMethod(attribute, null);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        // empty catch block
                    }
                }
            }
            if (m == null) {
                if (obj instanceof IScriptObjectDelegate) {
                    return ((IScriptObjectDelegate)obj).invoke(attribute, null, false);
                }
            } else {
                try {
                    return m.invoke(obj, null);
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
            return null;
        }
    }

    public Object invokeMethod(Object bean, String methodName, List params) {
        final Method m = bean instanceof Class ? this.findMethod((Class)bean, methodName, params) : this.findMethod(bean.getClass(), methodName, params);
        if (m == null && bean instanceof IScriptObjectDelegate) {
            return ((IScriptObjectDelegate)bean).invoke(methodName, params, true);
        }
        if (m == null) {
            throw new RuntimeException("Method " + bean.getClass() + "#" + methodName + " not exist!");
        }
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                ReflectUtil.makeAccessible(m);
                return null;
            }
        });
        return SystemObject.invokeMethod(bean, m, params);
    }

    public Object invokeMethod(Class cl, String methodName, List params) {
        Method m = this.findMethod(cl, methodName, params);
        if (m == null) {
            throw new RuntimeException("Method " + cl + "#" + methodName + " not exist!");
        }
        return SystemObject.invokeMethod(null, m, params);
    }

    private static Object invokeMethod(Object bean, Method m, List params) {
        try {
            if (params == null || params.size() == 0) {
                return m.invoke(bean, null);
            }
            return m.invoke(bean, params.toArray());
        }
        catch (Exception e) {
            Throwable ex = e;
            if (ex instanceof InvocationTargetException) {
                ex = ((InvocationTargetException)ex).getTargetException();
            }
            throw new RuntimeException("Invoke " + bean.getClass().getName() + "#" + m.getName() + " failed!", ex);
        }
    }

    private Method findMethod(Class cl, String methodName, List params) {
        Method m = null;
        Method[] ms = cl.getMethods();
        for (int i = 0; i < ms.length; ++i) {
            Class[] cls;
            m = ms[i];
            if (!m.getName().equals(methodName) || !(params == null ? m.getParameterTypes().length == 0 : this.matchClassType(params, cls = m.getParameterTypes()))) continue;
            return m;
        }
        return null;
    }

    public boolean matchClassType(List params, Class[] cls) {
        int n = cls.length;
        if (n == params.size()) {
            for (int j = 0; j < n; ++j) {
                boolean match;
                Object p;
                Class cc = (Class)classMap.get(cls[j]);
                if (cc == null) {
                    cc = cls[j];
                }
                if ((p = params.get(j)) == null || p.getClass() == Null.class || (match = cc.isAssignableFrom(p.getClass()))) continue;
                int t1 = TypeValueMap.getTypeValue(cc);
                int t2 = TypeValueMap.getTypeValue(p.getClass());
                if (t2 != -1) {
                    boolean bl = match = t1 > t2;
                }
                if (match) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public String version() {
        return VERSION;
    }

    public String author() {
        return "Author:Jamesfang/james_fang008@163.com";
    }

    public void println(Object v) {
        System.out.println(v);
    }

    public void println() {
        System.out.println();
    }

    public void print(Object v) {
        System.out.print(v);
    }

    public void sleep(Number n) throws InterruptedException {
        Thread.sleep(n.longValue());
    }

    public Date now() {
        return new Date();
    }

    public double random() {
        this.random.setSeed(System.currentTimeMillis());
        return this.random.nextDouble();
    }

    public void raise(String msg) {
        throw new RuntimeException(msg);
    }

    public int toInt(Object v) {
        if (v == null) {
            throw new RuntimeException("Can not convert null value to integer.");
        }
        if (v instanceof Number) {
            return ((Number)v).intValue();
        }
        return new BigDecimal(v.toString()).intValue();
    }

    public float toFloat(Object v) {
        if (v == null) {
            throw new RuntimeException("Can not convert null value to float.");
        }
        if (v instanceof Number) {
            return ((Number)v).floatValue();
        }
        return new BigDecimal(v.toString()).floatValue();
    }

    public double toDouble(Object v) {
        if (v == null) {
            throw new RuntimeException("Can not convert null value to double.");
        }
        if (v instanceof Number) {
            return ((Number)v).doubleValue();
        }
        return new BigDecimal(v.toString()).doubleValue();
    }

    public BigDecimal toNumber(Object v) {
        if (v == null) {
            throw new RuntimeException("Can not convert null value to double.");
        }
        return new BigDecimal(v.toString());
    }

    public boolean toBoolean(Object v) {
        return Boolean.valueOf(String.valueOf(v));
    }

    public String toStr(Object v) {
        return String.valueOf(v);
    }

    public double round(Object v, Integer scale) {
        if (v == null) {
            throw new RuntimeException("Can not round null value.");
        }
        BigDecimal bd = new BigDecimal(v.toString());
        bd = bd.setScale((int)scale, 4);
        if (v instanceof Integer) {
            return bd.intValue();
        }
        if (v instanceof Long) {
            return bd.longValue();
        }
        if (v instanceof Float) {
            return bd.floatValue();
        }
        return bd.doubleValue();
    }

    public Object trunc(Object v, Integer scale) {
        if (v == null) {
            throw new RuntimeException("Can not trunc null value.");
        }
        if (v instanceof Number) {
            BigDecimal bd = new BigDecimal(v.toString());
            bd = bd.setScale((int)scale, 1);
            if (v instanceof Integer) {
                return new Integer(bd.intValue());
            }
            if (v instanceof Long) {
                return new Long(bd.longValue());
            }
            if (v instanceof Float) {
                return new Float(bd.floatValue());
            }
            return new Double(bd.doubleValue());
        }
        String s = v.toString();
        int n = s.length();
        if (n > scale) {
            return s.substring(0, scale);
        }
        return s;
    }

    public Object runJava(String code) throws Exception {
        return RunJava.runJavaCode(code, null, this.ctx);
    }

    public Object runJava(String code, String imports) throws Exception {
        return RunJava.runJavaCode(code, imports, this.ctx);
    }

    public CMD cmd(String cmd) throws IOException {
        CMD c = new CMD(cmd);
        c.execute();
        return c;
    }

    public void importPackage(String pkname) {
        String[] pks = pkname.split(";");
        int n = pks.length;
        for (int i = 0; i < n; ++i) {
            String pk = pks[i].trim();
            if (pk.endsWith("*")) {
                this.importedPackage.put(pk.substring(0, pk.length() - 1), pk);
                continue;
            }
            int d = pk.lastIndexOf(46);
            String name = d != -1 ? pk.substring(d + 1) : pk;
            this.importedPackage.put(name, pk);
        }
    }

    public Class getClassByName(String typeClassName) throws Exception {
        Class cl = (Class)classTypeMap.get(typeClassName);
        if (cl != null) {
            return cl;
        }
        cl = (Class)this.importedClassTypeMap.get(typeClassName);
        if (cl != null) {
            return cl;
        }
        if (typeClassName.indexOf(46) != -1) {
            return Class.forName(typeClassName);
        }
        String fullPath = (String)this.importedPackage.get(typeClassName);
        if (fullPath != null) {
            cl = Class.forName(fullPath);
        } else {
            String tryPath = null;
            for (String key : this.importedPackage.keySet()) {
                if (key.length() <= 0 || key.charAt(key.length() - 1) != '.') continue;
                tryPath = key + typeClassName;
                try {
                    cl = Class.forName(tryPath);
                    break;
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
            }
        }
        if (cl != null) {
            this.importedClassTypeMap.put(typeClassName, cl);
            return cl;
        }
        throw new ClassNotFoundException(typeClassName);
    }

    public Object createObject(String typeClassName) throws Exception {
        return this.getClassByName(typeClassName).newInstance();
    }

    public Object createArray(Integer size, String typeClassName) throws Exception {
        return Array.newInstance(this.getClassByName(typeClassName), (int)size);
    }

    public Object createArray(Integer[] size, String typeClassName) throws Exception {
        Method m = Array.class.getMethod("newInstance", Class.class, int[].class);
        return m.invoke(null, this.getClassByName(typeClassName), size);
    }

    public Reader fopen(String path) throws Exception {
        return new BufferedReader(new FileReader(path));
    }

    public void fclose(Object f) throws Exception {
        if (f != null) {
            if (f instanceof Reader) {
                ((Reader)f).close();
            } else if (f instanceof Writer) {
                ((Writer)f).close();
            } else if (f instanceof InputStream) {
                ((InputStream)f).close();
            } else if (f instanceof OutputStream) {
                ((OutputStream)f).close();
            } else {
                throw new Exception(f + " is not a i/o handler.");
            }
        }
    }

    public String readStream(InputStream is) throws IOException {
        int size;
        StringBuffer s = new StringBuffer();
        InputStreamReader r = new InputStreamReader(is);
        char[] buf = new char[4096];
        while ((size = r.read(buf)) > 0) {
            s.append(buf, 0, size);
        }
        return s.toString();
    }

    static {
        classMap.put(Short.TYPE, Integer.class);
        classMap.put(Integer.TYPE, Integer.class);
        classMap.put(Long.TYPE, Long.class);
        classMap.put(Float.TYPE, Float.class);
        classMap.put(Double.TYPE, Double.class);
        classMap.put(Boolean.TYPE, Boolean.class);
        classTypeMap = new HashMap();
        classTypeMap.put("boolean", Boolean.TYPE);
        classTypeMap.put("Boolean", Boolean.class);
        classTypeMap.put("byte", Byte.TYPE);
        classTypeMap.put("Byte", Byte.class);
        classTypeMap.put("char", Character.TYPE);
        classTypeMap.put("Character", Character.class);
        classTypeMap.put("short", Short.TYPE);
        classTypeMap.put("Short", Short.class);
        classTypeMap.put("int", Integer.TYPE);
        classTypeMap.put("Integer", Integer.class);
        classTypeMap.put("long", Long.TYPE);
        classTypeMap.put("Long", Long.class);
        classTypeMap.put("float", Float.TYPE);
        classTypeMap.put("Float", Float.class);
        classTypeMap.put("double", Double.TYPE);
        classTypeMap.put("Double", Double.class);
        classTypeMap.put("String", String.class);
        classTypeMap.put("List", ArrayList.class);
        classTypeMap.put("Map", HashMap.class);
        classTypeMap.put("Set", HashSet.class);
    }
}

