/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.script.miniscript.parser.visitor;

import com.kingdee.bos.ctrl.script.miniscript.parser.syntaxtree.AdditiveExpression;
import com.kingdee.bos.ctrl.script.miniscript.parser.syntaxtree.AndExpression;
import com.kingdee.bos.ctrl.script.miniscript.parser.syntaxtree.ArgumentList;
import com.kingdee.bos.ctrl.script.miniscript.parser.syntaxtree.Arguments;
import com.kingdee.bos.ctrl.script.miniscript.parser.syntaxtree.Assignment;
import com.kingdee.bos.ctrl.script.miniscript.parser.syntaxtree.AssignmentOperator;
import com.kingdee.bos.ctrl.script.miniscript.parser.syntaxtree.Block;
import com.kingdee.bos.ctrl.script.miniscript.parser.syntaxtree.BooleanLiteral;
import com.kingdee.bos.ctrl.script.miniscript.parser.syntaxtree.BreakStatement;
import com.kingdee.bos.ctrl.script.miniscript.parser.syntaxtree.CharacterLiteral;
import com.kingdee.bos.ctrl.script.miniscript.parser.syntaxtree.ConditionalAndExpression;
import com.kingdee.bos.ctrl.script.miniscript.parser.syntaxtree.ConditionalExpression;
import com.kingdee.bos.ctrl.script.miniscript.parser.syntaxtree.ConditionalOrExpression;
import com.kingdee.bos.ctrl.script.miniscript.parser.syntaxtree.ContinueStatement;
import com.kingdee.bos.ctrl.script.miniscript.parser.syntaxtree.EmptyStatement;
import com.kingdee.bos.ctrl.script.miniscript.parser.syntaxtree.EqualityExpression;
import com.kingdee.bos.ctrl.script.miniscript.parser.syntaxtree.ExclusiveOrExpression;
import com.kingdee.bos.ctrl.script.miniscript.parser.syntaxtree.ExitStatement;
import com.kingdee.bos.ctrl.script.miniscript.parser.syntaxtree.Expression;
import com.kingdee.bos.ctrl.script.miniscript.parser.syntaxtree.FloatLiteral;
import com.kingdee.bos.ctrl.script.miniscript.parser.syntaxtree.ForEachStatement;
import com.kingdee.bos.ctrl.script.miniscript.parser.syntaxtree.ForInit;
import com.kingdee.bos.ctrl.script.miniscript.parser.syntaxtree.ForStatement;
import com.kingdee.bos.ctrl.script.miniscript.parser.syntaxtree.Function;
import com.kingdee.bos.ctrl.script.miniscript.parser.syntaxtree.IfStatement;
import com.kingdee.bos.ctrl.script.miniscript.parser.syntaxtree.InclusiveOrExpression;
import com.kingdee.bos.ctrl.script.miniscript.parser.syntaxtree.IntegerLiteral;
import com.kingdee.bos.ctrl.script.miniscript.parser.syntaxtree.Literal;
import com.kingdee.bos.ctrl.script.miniscript.parser.syntaxtree.MiniScript;
import com.kingdee.bos.ctrl.script.miniscript.parser.syntaxtree.MultiplicativeExpression;
import com.kingdee.bos.ctrl.script.miniscript.parser.syntaxtree.Node;
import com.kingdee.bos.ctrl.script.miniscript.parser.syntaxtree.NodeListInterface;
import com.kingdee.bos.ctrl.script.miniscript.parser.syntaxtree.NodeToken;
import com.kingdee.bos.ctrl.script.miniscript.parser.syntaxtree.NullLiteral;
import com.kingdee.bos.ctrl.script.miniscript.parser.syntaxtree.PostfixExpression;
import com.kingdee.bos.ctrl.script.miniscript.parser.syntaxtree.PreDecrementExpression;
import com.kingdee.bos.ctrl.script.miniscript.parser.syntaxtree.PreIncrementExpression;
import com.kingdee.bos.ctrl.script.miniscript.parser.syntaxtree.PrimaryExpression;
import com.kingdee.bos.ctrl.script.miniscript.parser.syntaxtree.PrimaryPrefix;
import com.kingdee.bos.ctrl.script.miniscript.parser.syntaxtree.PrimarySuffix;
import com.kingdee.bos.ctrl.script.miniscript.parser.syntaxtree.PrimaryVariable;
import com.kingdee.bos.ctrl.script.miniscript.parser.syntaxtree.RelationalExpression;
import com.kingdee.bos.ctrl.script.miniscript.parser.syntaxtree.ReturnStatement;
import com.kingdee.bos.ctrl.script.miniscript.parser.syntaxtree.ShiftExpression;
import com.kingdee.bos.ctrl.script.miniscript.parser.syntaxtree.Statement;
import com.kingdee.bos.ctrl.script.miniscript.parser.syntaxtree.StatementExpression;
import com.kingdee.bos.ctrl.script.miniscript.parser.syntaxtree.StringLiteral;
import com.kingdee.bos.ctrl.script.miniscript.parser.syntaxtree.SwitchLabel;
import com.kingdee.bos.ctrl.script.miniscript.parser.syntaxtree.SwitchStatement;
import com.kingdee.bos.ctrl.script.miniscript.parser.syntaxtree.UnaryExpression;
import com.kingdee.bos.ctrl.script.miniscript.parser.syntaxtree.UnaryExpressionNotPlusMinus;
import com.kingdee.bos.ctrl.script.miniscript.parser.syntaxtree.VariableDeclarator;
import com.kingdee.bos.ctrl.script.miniscript.parser.syntaxtree.WhileStatement1;
import com.kingdee.bos.ctrl.script.miniscript.parser.syntaxtree.WhileStatement2;
import com.kingdee.bos.ctrl.script.miniscript.parser.visitor.DepthFirstVisitor;
import com.kingdee.bos.ctrl.script.miniscript.parser.visitor.FormatCommand;
import com.kingdee.bos.ctrl.script.miniscript.parser.visitor.TreeFormatterException;
import java.util.Enumeration;
import java.util.Vector;

public class TreeFormatter
extends DepthFirstVisitor {
    private Vector cmdQueue = new Vector();
    private boolean lineWrap;
    private int wrapWidth;
    private int indentAmt;
    private int curLine = 1;
    private int curColumn = 1;
    private int curIndent = 0;

    public TreeFormatter() {
        this(3, 0);
    }

    public TreeFormatter(int indentAmt, int wrapWidth) {
        this.indentAmt = indentAmt;
        this.wrapWidth = wrapWidth;
        this.lineWrap = wrapWidth > 0;
    }

    protected void processList(NodeListInterface n) {
        this.processList(n, null);
    }

    protected void processList(NodeListInterface n, FormatCommand cmd) {
        Enumeration e = n.elements();
        while (e.hasMoreElements()) {
            ((Node)e.nextElement()).accept(this);
            if (cmd == null || !e.hasMoreElements()) continue;
            this.cmdQueue.addElement(cmd);
        }
    }

    protected FormatCommand force() {
        return this.force(1);
    }

    protected FormatCommand force(int i) {
        return new FormatCommand(0, i);
    }

    protected FormatCommand indent() {
        return this.indent(1);
    }

    protected FormatCommand indent(int i) {
        return new FormatCommand(1, i);
    }

    protected FormatCommand outdent() {
        return this.outdent(1);
    }

    protected FormatCommand outdent(int i) {
        return new FormatCommand(2, i);
    }

    protected FormatCommand space() {
        return this.space(1);
    }

    protected FormatCommand space(int i) {
        return new FormatCommand(3, i);
    }

    protected void add(FormatCommand cmd) {
        this.cmdQueue.addElement(cmd);
    }

    @Override
    public void visit(NodeToken n) {
        Enumeration e = this.cmdQueue.elements();
        block6: while (e.hasMoreElements()) {
            FormatCommand cmd = (FormatCommand)e.nextElement();
            switch (cmd.getCommand()) {
                case 0: {
                    this.curLine += cmd.getNumCommands();
                    this.curColumn = this.curIndent + 1;
                    continue block6;
                }
                case 1: {
                    this.curIndent += this.indentAmt * cmd.getNumCommands();
                    continue block6;
                }
                case 2: {
                    if (this.curIndent < this.indentAmt) continue block6;
                    this.curIndent -= this.indentAmt * cmd.getNumCommands();
                    continue block6;
                }
                case 3: {
                    this.curColumn += cmd.getNumCommands();
                    continue block6;
                }
            }
            throw new TreeFormatterException("Invalid value in command queue.");
        }
        this.cmdQueue.removeAllElements();
        if (n.numSpecials() > 0) {
            e = n.specialTokens.elements();
            while (e.hasMoreElements()) {
                NodeToken special = (NodeToken)e.nextElement();
                this.placeToken(special, this.curLine, this.curColumn);
                this.curLine = special.endLine + 1;
            }
        }
        this.placeToken(n, this.curLine, this.curColumn);
        this.curLine = n.endLine;
        this.curColumn = n.endColumn;
    }

    private void placeToken(NodeToken n, int line, int column) {
        int length = n.tokenImage.length();
        if (!this.lineWrap || n.tokenImage.indexOf(10) != -1 || column + length <= this.wrapWidth) {
            n.beginColumn = column;
        } else {
            ++line;
            n.beginColumn = column = this.curIndent + this.indentAmt + 1;
        }
        n.beginLine = line;
        for (int i = 0; i < length; ++i) {
            if (n.tokenImage.charAt(i) == '\n' && i < length - 1) {
                ++line;
                column = 1;
                continue;
            }
            ++column;
        }
        n.endLine = line;
        n.endColumn = column;
    }

    @Override
    public void visit(MiniScript n) {
        if (n.nodeListOptional.present()) {
            this.processList(n.nodeListOptional);
        }
    }

    @Override
    public void visit(Statement n) {
        n.nodeChoice.accept(this);
    }

    @Override
    public void visit(Function n) {
        n.nodeToken.accept(this);
        n.nodeToken1.accept(this);
        n.nodeToken2.accept(this);
        if (n.nodeOptional.present()) {
            n.nodeOptional.accept(this);
        }
        n.nodeToken3.accept(this);
        n.nodeToken4.accept(this);
        if (n.nodeListOptional.present()) {
            this.processList(n.nodeListOptional);
        }
        n.nodeToken5.accept(this);
    }

    @Override
    public void visit(Block n) {
        n.nodeToken.accept(this);
        if (n.nodeListOptional.present()) {
            this.processList(n.nodeListOptional);
        }
        n.nodeToken1.accept(this);
    }

    @Override
    public void visit(VariableDeclarator n) {
        n.nodeToken.accept(this);
        n.nodeToken1.accept(this);
        if (n.nodeOptional.present()) {
            n.nodeOptional.accept(this);
        }
    }

    @Override
    public void visit(EmptyStatement n) {
        n.nodeToken.accept(this);
    }

    @Override
    public void visit(IfStatement n) {
        n.nodeToken.accept(this);
        n.nodeToken1.accept(this);
        n.expression.accept(this);
        n.nodeToken2.accept(this);
        n.statement.accept(this);
        if (n.nodeOptional.present()) {
            n.nodeOptional.accept(this);
        }
        if (n.nodeOptional1.present()) {
            n.nodeOptional1.accept(this);
        }
    }

    @Override
    public void visit(ForStatement n) {
        n.nodeToken.accept(this);
        n.nodeToken1.accept(this);
        if (n.nodeOptional.present()) {
            n.nodeOptional.accept(this);
        }
        n.emptyStatement.accept(this);
        n.expression.accept(this);
        n.emptyStatement1.accept(this);
        if (n.nodeOptional1.present()) {
            n.nodeOptional1.accept(this);
        }
        n.nodeToken2.accept(this);
        n.statement.accept(this);
        if (n.nodeOptional2.present()) {
            n.nodeOptional2.accept(this);
        }
    }

    @Override
    public void visit(ForInit n) {
        n.nodeChoice.accept(this);
        if (n.nodeListOptional.present()) {
            this.processList(n.nodeListOptional);
        }
    }

    @Override
    public void visit(ForEachStatement n) {
        n.nodeToken.accept(this);
        n.nodeToken1.accept(this);
        if (n.nodeOptional.present()) {
            n.nodeOptional.accept(this);
        }
        n.nodeToken2.accept(this);
        n.nodeToken3.accept(this);
        n.expression.accept(this);
        n.nodeToken4.accept(this);
        n.statement.accept(this);
        if (n.nodeOptional1.present()) {
            n.nodeOptional1.accept(this);
        }
    }

    @Override
    public void visit(WhileStatement1 n) {
        n.nodeToken.accept(this);
        n.nodeToken1.accept(this);
        n.expression.accept(this);
        n.nodeToken2.accept(this);
        n.statement.accept(this);
        if (n.nodeOptional.present()) {
            n.nodeOptional.accept(this);
        }
    }

    @Override
    public void visit(WhileStatement2 n) {
        n.nodeToken.accept(this);
        n.statement.accept(this);
        if (n.nodeOptional.present()) {
            n.nodeOptional.accept(this);
        }
        n.nodeToken1.accept(this);
        n.nodeToken2.accept(this);
        n.expression.accept(this);
        n.nodeToken3.accept(this);
        n.emptyStatement.accept(this);
    }

    @Override
    public void visit(SwitchStatement n) {
        n.nodeToken.accept(this);
        n.nodeToken1.accept(this);
        n.expression.accept(this);
        n.nodeToken2.accept(this);
        n.nodeToken3.accept(this);
        if (n.nodeListOptional.present()) {
            this.processList(n.nodeListOptional);
        }
        n.nodeToken4.accept(this);
    }

    @Override
    public void visit(SwitchLabel n) {
        n.nodeChoice.accept(this);
    }

    @Override
    public void visit(BreakStatement n) {
        n.nodeToken.accept(this);
        n.emptyStatement.accept(this);
    }

    @Override
    public void visit(ReturnStatement n) {
        n.nodeToken.accept(this);
        n.expression.accept(this);
        if (n.nodeListOptional.present()) {
            this.processList(n.nodeListOptional);
        }
    }

    @Override
    public void visit(ContinueStatement n) {
        n.nodeToken.accept(this);
        n.emptyStatement.accept(this);
    }

    @Override
    public void visit(ExitStatement n) {
        n.nodeToken.accept(this);
        n.emptyStatement.accept(this);
    }

    @Override
    public void visit(StatementExpression n) {
        n.nodeChoice.accept(this);
    }

    @Override
    public void visit(Assignment n) {
        n.primaryExpression.accept(this);
        n.assignmentOperator.accept(this);
        n.expression.accept(this);
    }

    @Override
    public void visit(PreIncrementExpression n) {
        n.nodeToken.accept(this);
        n.primaryExpression.accept(this);
    }

    @Override
    public void visit(PreDecrementExpression n) {
        n.nodeToken.accept(this);
        n.primaryExpression.accept(this);
    }

    @Override
    public void visit(PrimaryExpression n) {
        n.primaryPrefix.accept(this);
        if (n.nodeListOptional.present()) {
            this.processList(n.nodeListOptional);
        }
    }

    @Override
    public void visit(PrimaryPrefix n) {
        n.nodeChoice.accept(this);
    }

    @Override
    public void visit(PrimaryVariable n) {
        if (n.nodeOptional.present()) {
            n.nodeOptional.accept(this);
        }
        n.nodeToken.accept(this);
        if (n.nodeOptional1.present()) {
            n.nodeOptional1.accept(this);
        }
    }

    @Override
    public void visit(PrimarySuffix n) {
        n.nodeChoice.accept(this);
    }

    @Override
    public void visit(Literal n) {
        n.nodeChoice.accept(this);
    }

    @Override
    public void visit(IntegerLiteral n) {
        n.nodeToken.accept(this);
    }

    @Override
    public void visit(FloatLiteral n) {
        n.nodeToken.accept(this);
    }

    @Override
    public void visit(CharacterLiteral n) {
        n.nodeToken.accept(this);
    }

    @Override
    public void visit(StringLiteral n) {
        n.nodeChoice.accept(this);
    }

    @Override
    public void visit(BooleanLiteral n) {
        n.nodeChoice.accept(this);
    }

    @Override
    public void visit(NullLiteral n) {
        n.nodeToken.accept(this);
    }

    @Override
    public void visit(Arguments n) {
        n.nodeChoice.accept(this);
    }

    @Override
    public void visit(ArgumentList n) {
        n.nodeSequence.accept(this);
    }

    @Override
    public void visit(AssignmentOperator n) {
        n.nodeChoice.accept(this);
    }

    @Override
    public void visit(PostfixExpression n) {
        n.primaryExpression.accept(this);
        if (n.nodeOptional.present()) {
            n.nodeOptional.accept(this);
        }
    }

    @Override
    public void visit(Expression n) {
        n.nodeChoice.accept(this);
    }

    @Override
    public void visit(ConditionalExpression n) {
        n.conditionalOrExpression.accept(this);
        if (n.nodeOptional.present()) {
            n.nodeOptional.accept(this);
        }
    }

    @Override
    public void visit(ConditionalOrExpression n) {
        n.conditionalAndExpression.accept(this);
        if (n.nodeListOptional.present()) {
            this.processList(n.nodeListOptional);
        }
    }

    @Override
    public void visit(ConditionalAndExpression n) {
        n.inclusiveOrExpression.accept(this);
        if (n.nodeListOptional.present()) {
            this.processList(n.nodeListOptional);
        }
    }

    @Override
    public void visit(InclusiveOrExpression n) {
        n.exclusiveOrExpression.accept(this);
        if (n.nodeListOptional.present()) {
            this.processList(n.nodeListOptional);
        }
    }

    @Override
    public void visit(ExclusiveOrExpression n) {
        n.andExpression.accept(this);
        if (n.nodeListOptional.present()) {
            this.processList(n.nodeListOptional);
        }
    }

    @Override
    public void visit(AndExpression n) {
        n.equalityExpression.accept(this);
        if (n.nodeListOptional.present()) {
            this.processList(n.nodeListOptional);
        }
    }

    @Override
    public void visit(EqualityExpression n) {
        n.relationalExpression.accept(this);
        if (n.nodeListOptional.present()) {
            this.processList(n.nodeListOptional);
        }
    }

    @Override
    public void visit(RelationalExpression n) {
        n.shiftExpression.accept(this);
        if (n.nodeListOptional.present()) {
            this.processList(n.nodeListOptional);
        }
    }

    @Override
    public void visit(ShiftExpression n) {
        n.additiveExpression.accept(this);
        if (n.nodeListOptional.present()) {
            this.processList(n.nodeListOptional);
        }
    }

    @Override
    public void visit(AdditiveExpression n) {
        n.multiplicativeExpression.accept(this);
        if (n.nodeListOptional.present()) {
            this.processList(n.nodeListOptional);
        }
    }

    @Override
    public void visit(MultiplicativeExpression n) {
        n.unaryExpression.accept(this);
        if (n.nodeListOptional.present()) {
            this.processList(n.nodeListOptional);
        }
    }

    @Override
    public void visit(UnaryExpression n) {
        n.nodeChoice.accept(this);
    }

    @Override
    public void visit(UnaryExpressionNotPlusMinus n) {
        n.nodeChoice.accept(this);
    }
}

