/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.common.ui;

import com.kingdee.bos.ctrl.common.LanguageManager;
import com.kingdee.bos.ctrl.common.ResourceManager;
import com.kingdee.bos.ctrl.common.util.LangUtil;
import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.common.util.MultilanguageKey;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.swing.KDCheckBoxMenuItem;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDComboColor;
import com.kingdee.bos.ctrl.swing.KDFontChooser;
import com.kingdee.bos.ctrl.swing.KDMenu;
import com.kingdee.bos.ctrl.swing.KDMenuBar;
import com.kingdee.bos.ctrl.swing.KDMenuItem;
import com.kingdee.bos.ctrl.swing.KDToggleButton;
import com.kingdee.bos.ctrl.swing.KDToolBar;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.apache.log4j.Logger;
import org.jdom2.Element;

public abstract class XmlMenuBuilder {
    private static final Logger log = LogUtil.getLogger(XmlMenuBuilder.class);
    private static final String TAG_Menus = "Menus";
    private static final String TAG_Toolbars = "Toolbars";
    private static final String TAG_CustomActions = "CustomActions";
    private static final String TAG_Menu = "Menu";
    private static final String TAG_MenuItem = "MenuItem";
    private static final String TAG_CheckBox = "CheckBox";
    private static final String TAG_Separator = "Separator";
    private static final String TAG_Button = "Button";
    private static final String TAG_ToggleButton = "ToggleButton";
    private static final String TAG_COMBOBOX = "ComboBox";
    private static final String TAG_Font = "Font";
    private static final String TAG_Color = "Color";
    private static final String ATTR_Id = "id";
    private static final String ATTR_Classname = "classname";
    private static final String ATTR_Text = "text";
    private static final String ATTR_Mnemonic = "mnemonic";
    private static final String ATTR_ToolTips = "toolTips";
    private static final String ATTR_IconPack = "iconPackage";
    private static final String ATTR_Icon = "icon";
    private static final String ATTR_LanguagePack = "multiLanguagePack";
    private Element _rootNode;
    private HashMap _mapClassName;
    private HashMap _mapActions = new HashMap();
    private static DoNothingAction doNothingAction;

    public XmlMenuBuilder(Element root) {
        this._rootNode = root;
        this.cacheCustomAction();
    }

    private List getNodes(String tag) {
        Element child = this._rootNode.getChild(tag);
        if (child != null) {
            return child.getChildren();
        }
        return null;
    }

    private void cacheCustomAction() {
        this._mapClassName = new HashMap();
        List list = this.getNodes(TAG_CustomActions);
        if (list == null) {
            return;
        }
        for (Element action : list) {
            String id = action.getAttributeValue(ATTR_Id);
            String clsName = action.getAttributeValue(ATTR_Classname);
            this._mapClassName.put(id, clsName);
        }
    }

    public Action getAction(String key) {
        Action action = (Action)this._mapActions.get(key);
        if (action == null) {
            return XmlMenuBuilder.getDoNothingAction();
        }
        return action;
    }

    public void buildMenuBar(KDMenuBar menuBar) {
        List listMenus = this.getNodes(TAG_Menus);
        if (listMenus == null) {
            return;
        }
        for (Element menu : listMenus) {
            menuBar.add((JMenu)this.createKDMenuFromXMLNode(menu));
        }
    }

    public KDToolBar[] createToolBars() {
        List list = this.getNodes(TAG_Toolbars);
        int len = list == null ? 0 : list.size();
        KDToolBar[] kdToolbars = new KDToolBar[len];
        for (int i = 0; i < len; ++i) {
            Element toolbarNode = (Element)list.get(i);
            kdToolbars[i] = this.createKDToolBarFromXMLNode(toolbarNode);
        }
        return kdToolbars;
    }

    private KDMenu createKDMenuFromXMLNode(Element menuNode) {
        KDMenu menu = new KDMenu();
        this.buildMenuItemCommon((JMenuItem)menu, menuNode);
        String id = menuNode.getAttributeValue(ATTR_Id);
        this.cacheMenu(id, menu);
        for (Element item : menuNode.getChildren()) {
            String itemName = item.getName();
            if (StringUtil.equalsIgnoreCase((String)TAG_Menu, (String)itemName)) {
                menu.add((JMenuItem)this.createKDMenuFromXMLNode(item));
                continue;
            }
            if (StringUtil.equalsIgnoreCase((String)TAG_Separator, (String)itemName)) {
                menu.addSeparator();
                continue;
            }
            JMenuItem ctrl = this.createMenuItemFromXMLNode(item, itemName);
            if (item == null) continue;
            menu.add(ctrl);
        }
        return menu;
    }

    private JMenuItem createMenuItemFromXMLNode(Element node, String tag) {
        KDMenuItem menuItem = null;
        if (TAG_MenuItem.equalsIgnoreCase(tag)) {
            menuItem = new KDMenuItem();
        } else if (TAG_CheckBox.equalsIgnoreCase(tag)) {
            menuItem = new KDCheckBoxMenuItem();
        } else {
            return null;
        }
        String id = node.getAttributeValue(ATTR_Id);
        Action action = null;
        Object objAction = this.createAction((String)this._mapClassName.get(id));
        if (objAction instanceof Action) {
            action = (Action)objAction;
        }
        action = this.initAction(id, action);
        menuItem.setAction(action);
        this.buildMenuItemCommon((JMenuItem)menuItem, node);
        this.initMenuItemExtended((JMenuItem)menuItem, action);
        return menuItem;
    }

    private void buildMenuItemCommon(JMenuItem target, Element node) {
        String mnStr;
        MultilanguageKey attrValue = LangUtil.getAttrKeyValue((Element)node, (String)ATTR_Text);
        String text = attrValue.getAttrValue();
        if (attrValue.isKey()) {
            text = this.getMulitiLanguage(text, node, "text.");
        }
        char mnemonic = StringUtil.isEmptyString((String)(mnStr = node.getAttributeValue(ATTR_Mnemonic))) ? (char)' ' : (char)mnStr.charAt(0);
        target.setText(this.autoAddMnemonicChar(text, mnemonic));
        target.setMnemonic(mnemonic);
        this.buildCtrlIcon(target, node);
    }

    private void buildCtrlIcon(AbstractButton ctrl, Element node) {
        String strIcon = node.getAttributeValue(ATTR_Icon);
        if (StringUtil.isEmptyString((String)strIcon)) {
            return;
        }
        String strIconPack = XmlMenuBuilder.searchNodeValue(node, ATTR_IconPack);
        ctrl.setIcon(ResourceManager.getIcon(strIconPack, strIcon));
    }

    private static String searchNodeValue(Element node, String nodeName) {
        for (Element tempNode = node; tempNode != null; tempNode = tempNode.getParentElement()) {
            String pack = tempNode.getAttributeValue(nodeName);
            if (StringUtil.isEmptyString((String)pack)) continue;
            return pack;
        }
        return null;
    }

    private String autoAddMnemonicChar(String text, char mnemonic) {
        String uMnemonic = String.valueOf(mnemonic).toUpperCase();
        String lMnemonic = String.valueOf(mnemonic).toLowerCase();
        if (text.indexOf(uMnemonic) == -1 && text.indexOf(lMnemonic) == -1) {
            StringBuffer sb = new StringBuffer(text);
            sb.append("(");
            sb.append(uMnemonic);
            sb.append(")");
            text = sb.toString();
        }
        return text;
    }

    private KDToolBar createKDToolBarFromXMLNode(Element toolbarNode) {
        KDToolBar bar = new KDToolBar();
        bar.setTextIconDisStyle((short)3);
        bar.setPopupMenuShowable(false);
        bar.setIsControlByParent(false);
        for (Element item : toolbarNode.getChildren()) {
            String itemName = item.getName();
            if (StringUtil.equalsIgnoreCase((String)TAG_Separator, (String)itemName)) {
                bar.addSeparator();
                continue;
            }
            JComponent ctrl = this.createButtonFromXMLNode(item, itemName);
            if (ctrl == null) continue;
            bar.add((Component)ctrl);
        }
        return bar;
    }

    private JComponent createButtonFromXMLNode(Element node, String tag) {
        KDWorkButton ctrl = null;
        if (StringUtil.equalsIgnoreCase((String)TAG_Button, (String)tag)) {
            ctrl = new KDWorkButton();
        } else if (StringUtil.equalsIgnoreCase((String)TAG_ToggleButton, (String)tag)) {
            ctrl = new KDToggleButton();
        } else if (StringUtil.equalsIgnoreCase((String)TAG_COMBOBOX, (String)tag)) {
            KDComboBox cmbScale = new KDComboBox();
            List items = node.getChildren();
            for (int i = 0; i < items.size(); ++i) {
                Element item = (Element)items.get(i);
                String value = item.getAttributeValue("value");
                String isDefault = item.getAttributeValue("default");
                cmbScale.addItem((Object)value);
                if (isDefault == null || !Boolean.parseBoolean(isDefault)) continue;
                cmbScale.setSelectedItem((Object)value);
            }
            ctrl = cmbScale;
        } else if (StringUtil.equalsIgnoreCase((String)TAG_Font, (String)tag)) {
            ctrl = new KDFontChooser();
            ((KDFontChooser)ctrl).setCustomInsets(new Insets(0, 3, 0, 3));
            ((KDFontChooser)ctrl).setEnabled(false);
            ((KDFontChooser)ctrl).setViewType(1);
        } else if (StringUtil.equalsIgnoreCase((String)TAG_Color, (String)tag)) {
            ctrl = new KDComboColor();
            ((KDComboColor)ctrl).setEnabled(false);
            ((KDComboColor)ctrl).setViewType(2);
        } else {
            return null;
        }
        String id = node.getAttributeValue(ATTR_Id);
        Object objAction = this.createAction((String)this._mapClassName.get(id));
        if (objAction instanceof Action || objAction == null) {
            objAction = this.initAction(id, (Action)objAction);
            if (ctrl instanceof AbstractButton) {
                ((AbstractButton)ctrl).setAction((Action)objAction);
            }
            if (ctrl instanceof JComboBox) {
                ((JComboBox)ctrl).setAction((Action)objAction);
            }
        }
        this.buildButtonCommon((JComponent)ctrl, node);
        this.initButtonExtended((JComponent)ctrl, objAction);
        return ctrl;
    }

    private void buildButtonCommon(JComponent target, Element node) {
        MultilanguageKey attrValue;
        if (target instanceof AbstractButton) {
            attrValue = LangUtil.getAttrKeyValue((Element)node, (String)ATTR_Text);
            String text = attrValue.getAttrValue();
            if (attrValue.isKey()) {
                text = this.getMulitiLanguage(text, node, "text.");
            }
            if (!StringUtil.isEmptyString((String)text)) {
                ((AbstractButton)target).setText(text);
            }
            this.buildCtrlIcon((AbstractButton)target, node);
        }
        attrValue = LangUtil.getAttrKeyValue((Element)node, (String)ATTR_ToolTips);
        String toolTips = attrValue.getAttrValue();
        if (attrValue.isKey()) {
            toolTips = this.getMulitiLanguage(toolTips, node, "toolTips.");
        }
        target.setToolTipText(toolTips);
    }

    private Object createAction(String className) {
        return this.wrapAction(this.reflectInstance(className));
    }

    protected Object wrapAction(Object obj) {
        return obj;
    }

    private Object reflectInstance(String className) {
        if (StringUtil.isEmptyString((String)className)) {
            return null;
        }
        try {
            return Class.forName(className).newInstance();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return null;
    }

    protected static DoNothingAction getDoNothingAction() {
        if (doNothingAction == null) {
            doNothingAction = new DoNothingAction();
        }
        return doNothingAction;
    }

    private Action initAction(String id, Action cstm) {
        Action cachedAction = (Action)this._mapActions.get(id);
        if (cachedAction != null) {
            return cachedAction;
        }
        Action tempAction = cstm;
        if (tempAction == null) {
            tempAction = this.createDefaultAction(id);
        }
        this._mapActions.put(id, tempAction);
        return tempAction;
    }

    private String getMulitiLanguage(String key, Element node, String type) {
        String path = XmlMenuBuilder.searchNodeValue(node, ATTR_LanguagePack);
        if (!StringUtil.isEmptyString((String)path)) {
            if (!StringUtil.isEmptyString((String)key)) {
                key = LanguageManager.getLangMessage((String)(type + key), (String)path, (String)key);
            }
        } else {
            log.info((Object)"\u8bbe\u8ba1\u5668\u83dc\u5355\u591a\u8bed\u8a00\u8def\u5f84\u4fe1\u606f\u672a\u627e\u5230\uff01");
        }
        return key;
    }

    protected abstract Action createDefaultAction(String var1);

    protected abstract void cacheMenu(String var1, KDMenu var2);

    protected abstract void initMenuItemExtended(JMenuItem var1, Action var2);

    protected abstract void initButtonExtended(JComponent var1, Object var2);

    private static class DoNothingAction
    extends AbstractAction {
        private static final long serialVersionUID = 3865873490603298235L;

        private DoNothingAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
        }
    }
}

