/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.common.ui.joineditor;

import com.kingdee.bos.ctrl.common.ui.joineditor.AbstractModelObject;
import com.kingdee.bos.ctrl.common.ui.joineditor.Icons;
import com.kingdee.bos.ctrl.common.ui.joineditor.JoinPanel;
import com.kingdee.bos.ctrl.common.ui.joineditor.ModelField;
import com.kingdee.bos.ctrl.common.ui.joineditor.ModelLine;
import com.kingdee.bos.ctrl.common.ui.joineditor.ModelTable;
import com.kingdee.bos.ctrl.common.ui.joineditor.SelectionEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.basic.BasicListUI;

public class UITable
extends JPanel {
    private JoinPanel parentPanel;
    private ModelTable model;
    private JLabel labName;
    private JList list;
    private JScrollPane scrollPane;
    private JLabel labResizeTag;
    private JPanel panFoot;
    private static final Cursor CURSOR_DEFAULT = Cursor.getDefaultCursor();
    private static final Cursor CURSOR_RESIZE = Cursor.getPredefinedCursor(5);
    private static final Cursor CURSOR_MOVE = Cursor.getPredefinedCursor(13);
    private static final Cursor CURSOR_DRAG = Toolkit.getDefaultToolkit().createCustomCursor(Icons.createImage("icon/cursors/mos_movedrop.gif"), new Point(0, 0), "CanDrop");
    private static final Cursor CURSOR_FORBID = Toolkit.getDefaultToolkit().createCustomCursor(Icons.createImage("icon/cursors/cursor_lock.gif"), new Point(0, 0), "Forbid");
    private int xOld = 0;
    private int yOld = 0;
    private int wOld = 0;
    private int hOld = 0;
    private boolean isDraged;
    private int xPress;
    private int yPress;
    private boolean isCanDrop;
    private boolean isDraggingLine;
    private ModelLine draggingLine;

    public UITable(ModelTable model) {
        this.model = model;
        model.setUi(this);
        this.setBorder(BorderFactory.createRaisedBevelBorder());
        this.labName = new JLabel(model.toString());
        this.labName.setIcon(Icons.createIcon("icon/tbtn_wizardtable.gif"));
        this.labName.setPreferredSize(new Dimension(1, 20));
        this.labName.setOpaque(true);
        this.setMouseIcon(this.labName, CURSOR_MOVE);
        this.labResizeTag = new JLabel();
        this.labResizeTag.setIcon(Icons.createIcon("icon/resize.gif"));
        this.labResizeTag.setPreferredSize(new Dimension(15, 14));
        this.labResizeTag.setHorizontalAlignment(2);
        this.labResizeTag.setVerticalAlignment(1);
        this.setMouseIcon(this.labResizeTag, CURSOR_RESIZE);
        this.list = new JList();
        this.refreshField();
        this.list.setSelectionMode(0);
        MouseMotionListener[] mml = this.list.getMouseMotionListeners();
        for (int i = 0; i < mml.length; ++i) {
            if (!(mml[i] instanceof BasicListUI.MouseInputHandler)) continue;
            this.list.removeMouseMotionListener(mml[i]);
        }
        this.scrollPane = new JScrollPane(this.list);
        this.panFoot = new JPanel(new BorderLayout());
        this.panFoot.add((Component)new JSeparator(), "North");
        this.panFoot.add((Component)this.labResizeTag, "East");
        this.setLayout(new BorderLayout());
        this.add((Component)this.labName, "North");
        this.add((Component)this.scrollPane, "Center");
        this.add((Component)this.panFoot, "South");
        this.installListener();
    }

    public void refreshTable() {
        this.labName.setText(this.model.toString());
    }

    public void refreshField() {
        DefaultListModel lm = new DefaultListModel();
        Iterator it = this.model.getFields().iterator();
        while (it.hasNext()) {
            lm.addElement(it.next());
        }
        this.list.setModel(lm);
    }

    private void installListener() {
        this.labName.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                Graphics g2d = UITable.this.getParent().getGraphics();
                g2d.setColor(Color.DARK_GRAY);
                g2d.setXORMode(Color.WHITE);
                if (UITable.this.isDraged) {
                    g2d.drawRect(UITable.this.xOld, UITable.this.yOld, UITable.this.getWidth(), UITable.this.getHeight());
                }
                UITable.this.xOld = UITable.this.getX() + e.getX() - UITable.this.xPress;
                UITable.this.yOld = UITable.this.getY() + e.getY() - UITable.this.yPress;
                if (UITable.this.xOld < 0) {
                    UITable.this.xOld = 0;
                }
                if (UITable.this.yOld < 0) {
                    UITable.this.yOld = 0;
                }
                g2d.drawRect(UITable.this.xOld, UITable.this.yOld, UITable.this.getWidth(), UITable.this.getHeight());
                UITable.this.isDraged = true;
            }
        });
        this.labName.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                UITable.this.xPress = e.getX();
                UITable.this.yPress = e.getY();
                UITable.this.selectTable();
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (UITable.this.isDraged) {
                    UITable.this.setBounds(UITable.this.xOld, UITable.this.yOld, UITable.this.getWidth(), UITable.this.getHeight());
                    Dimension maxChild = UITable.this.parentPanel.getChildrenMaxRightDown();
                    if (!UITable.this.parentPanel.getPreferredSize().equals(maxChild)) {
                        UITable.this.parentPanel.setPreferredSize(maxChild);
                        UITable.this.parentPanel.revalidate();
                    }
                    UITable.this.parentPanel.repaint();
                    UITable.this.isDraged = false;
                }
            }
        });
        this.panFoot.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                UITable.this.selectTable();
            }
        });
        this.scrollPane.getViewport().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                UITable.this.getParent().repaint();
            }
        });
        this.labResizeTag.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                UITable.this.xPress = e.getX();
                UITable.this.yPress = e.getY();
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (UITable.this.isDraged) {
                    UITable.this.setBounds(UITable.this.getX(), UITable.this.getY(), UITable.this.wOld, UITable.this.hOld);
                    UITable.this.validate();
                    Dimension maxChild = UITable.this.parentPanel.getChildrenMaxRightDown();
                    if (!UITable.this.parentPanel.getPreferredSize().equals(maxChild)) {
                        UITable.this.parentPanel.setPreferredSize(maxChild);
                        UITable.this.parentPanel.revalidate();
                    }
                    UITable.this.getParent().repaint();
                    UITable.this.isDraged = false;
                }
            }
        });
        this.labResizeTag.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                Graphics g2d = UITable.this.getParent().getGraphics();
                g2d.setColor(Color.WHITE);
                g2d.setXORMode(Color.DARK_GRAY);
                if (UITable.this.isDraged) {
                    g2d.drawRect(UITable.this.getX() - 1, UITable.this.getY() - 1, UITable.this.wOld, UITable.this.hOld);
                }
                UITable.this.wOld = UITable.this.getWidth() + e.getX() - UITable.this.xPress;
                UITable.this.hOld = UITable.this.getHeight() + e.getY() - UITable.this.yPress;
                UITable.this.wOld = UITable.this.wOld < 80 ? 80 : UITable.this.wOld;
                UITable.this.hOld = UITable.this.hOld < 40 ? 40 : UITable.this.hOld;
                g2d.drawRect(UITable.this.getX() - 1, UITable.this.getY() - 1, UITable.this.wOld, UITable.this.hOld);
                UITable.this.isDraged = true;
            }
        });
        this.list.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int idx = UITable.this.list.locationToIndex(e.getPoint());
                if (idx >= 0) {
                    AbstractModelObject old = UITable.this.parentPanel.getCurrentObject();
                    ModelField mf = (ModelField)UITable.this.list.getModel().getElementAt(idx);
                    UITable.this.parentPanel.setSelectedField(UITable.this.model, mf);
                    if (old != mf) {
                        UITable.this.parentPanel.fireFieldSelected(mf, SelectionEvent.SELECTED);
                    }
                }
            }
        });
        this.list.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                ModelField field = (ModelField)UITable.this.list.getSelectedValue();
                UITable.this.draggingLine = new ModelLine();
                UITable.this.draggingLine.setFromTable(UITable.this.model);
                UITable.this.draggingLine.setFromField(field);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (UITable.this.isDraggingLine) {
                    if (UITable.this.isCanDrop) {
                        UITable.this.parentPanel.addLine(UITable.this.draggingLine);
                        UITable.this.isCanDrop = false;
                    }
                    UITable.this.isDraggingLine = false;
                    UITable.this.setMouseIcon(UITable.this.parentPanel, CURSOR_DEFAULT);
                }
            }
        });
        this.list.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                if (UITable.this.isDraggingLine) {
                    int x = e.getX() - ((UITable)UITable.this).scrollPane.getViewport().getViewRect().x + UITable.this.getX() + UITable.this.scrollPane.getX();
                    int y = e.getY() - ((UITable)UITable.this).scrollPane.getViewport().getViewRect().y + UITable.this.getY() + UITable.this.scrollPane.getY();
                    UITable.this.isCanDrop = UITable.this.parentPanel.processDraggingLine(UITable.this.draggingLine, new Point(x, y));
                    if (UITable.this.isCanDrop) {
                        UITable.this.setMouseIcon(UITable.this.parentPanel, CURSOR_DRAG);
                    } else {
                        UITable.this.setMouseIcon(UITable.this.parentPanel, CURSOR_FORBID);
                    }
                } else {
                    UITable.this.isDraggingLine = true;
                }
            }
        });
    }

    private void setMouseIcon(JComponent source, Cursor cs) {
        if (source.getCursor() != cs) {
            source.setCursor(cs);
        }
    }

    private int getIndexOfField(ModelField field) {
        return ((DefaultListModel)this.list.getModel()).indexOf(field);
    }

    private int calculateFieldY(ModelField field) {
        int idx = this.getIndexOfField(field);
        Point pt = this.list.indexToLocation(idx);
        if (pt == null) {
            return 0;
        }
        int top = this.scrollPane.getY();
        int y = pt.y - this.scrollPane.getViewport().getViewPosition().y;
        if (y < 0) {
            return top - 3;
        }
        if (y > this.scrollPane.getViewport().getViewRect().height) {
            return this.scrollPane.getViewport().getViewRect().height + top + 3;
        }
        return y + top + 10;
    }

    public Point getFieldRightPoint(ModelField field) {
        int y = this.calculateFieldY(field);
        Point pt = new Point(this.getX() + this.getWidth() + 8, this.getY() + y);
        return pt;
    }

    public Point getFieldLeftPoint(ModelField field) {
        int y = this.calculateFieldY(field);
        Point pt = new Point(this.getX() - 8, this.getY() + y);
        return pt;
    }

    public void setParentPanel(JoinPanel parent) {
        this.parentPanel = parent;
    }

    public void setSelectedField(ModelField field) {
        if (field == null) {
            this.list.getSelectionModel().clearSelection();
        } else {
            this.list.setSelectedValue(field, true);
        }
    }

    public ModelField getFieldByPoint(Point ptOfParent) {
        Point view = this.scrollPane.getViewport().getViewPosition();
        ptOfParent.translate(-this.getX() - this.scrollPane.getX() + view.x, -this.getY() - this.scrollPane.getY() + view.y);
        int idx = this.list.locationToIndex(ptOfParent);
        if (idx < 0) {
            return null;
        }
        return (ModelField)this.list.getModel().getElementAt(idx);
    }

    public Rectangle getListViewRect() {
        Rectangle rect = new Rectangle();
        rect.x = this.scrollPane.getX();
        rect.y = this.scrollPane.getY();
        rect.width = this.scrollPane.getViewport().getViewRect().width;
        rect.height = this.scrollPane.getViewport().getViewRect().height;
        return rect;
    }

    public static Dimension caculateDefaultSize(ModelTable mo) {
        int fieldCount;
        int n = fieldCount = mo.getFields() == null ? 0 : mo.getFields().size();
        if (fieldCount < 2) {
            fieldCount = 2;
        }
        if (fieldCount > 10) {
            fieldCount = 10;
        }
        int w = 80 + fieldCount * 5;
        int h = fieldCount * 20 + 46;
        return new Dimension(w, h);
    }

    public void setIcon(Icon icon) {
        this.labName.setIcon(icon);
    }

    public void setTableBackground(Color color) {
        this.labName.setBackground(color);
        this.labResizeTag.setBackground(color);
        this.panFoot.setBackground(color);
    }

    private void selectTable() {
        AbstractModelObject old = this.parentPanel.getCurrentObject();
        this.parentPanel.setSelectedTable(this.model);
        if (old != this.model) {
            this.parentPanel.fireTableSelected(this.model, SelectionEvent.SELECTED);
        }
    }

    protected void drawSelectedTag(boolean isSelect) {
        if (isSelect) {
            this.labName.setBackground(Color.BLUE);
            this.labName.setForeground(Color.WHITE);
        } else {
            this.labName.setBackground(this.labResizeTag.getBackground());
            this.labName.setForeground(Color.BLACK);
        }
    }
}

