/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.common.ui.mdi;

import java.beans.PropertyVetoException;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;

public class MdiDesktopPane
extends JDesktopPane {
    private static final long serialVersionUID = -1946887499193130502L;

    public void addInternalFrameListener(InternalFrameListener listener) {
        this.listenerList.add(InternalFrameListener.class, listener);
    }

    public void removeInternalFrameListener(InternalFrameListener listener) {
        this.listenerList.remove(InternalFrameListener.class, listener);
    }

    void fireInternalFrameListener(InternalFrameEvent event, int type) {
        Object[] listeners = this.listenerList.getListenerList();
        block9: for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != InternalFrameListener.class) continue;
            InternalFrameListener ltn = (InternalFrameListener)listeners[i + 1];
            switch (type) {
                case 25549: {
                    ltn.internalFrameOpened(event);
                    continue block9;
                }
                case 25554: {
                    ltn.internalFrameActivated(event);
                    continue block9;
                }
                case 25555: {
                    ltn.internalFrameDeactivated(event);
                    continue block9;
                }
                case 25552: {
                    ltn.internalFrameIconified(event);
                    continue block9;
                }
                case 25553: {
                    ltn.internalFrameDeiconified(event);
                    continue block9;
                }
                case 25550: {
                    ltn.internalFrameClosing(event);
                    continue block9;
                }
                case 25551: {
                    ltn.internalFrameClosed(event);
                    continue block9;
                }
            }
        }
    }

    public void cascade() {
        JInternalFrame[] frames = this.getAllFrames();
        if (frames.length == 0) {
            return;
        }
        JInternalFrame activeframe = this.getSelectedFrame();
        int position = 0;
        for (int i = 0; i < frames.length; ++i) {
            try {
                frames[i].setMaximum(false);
                frames[i].setIcon(false);
            }
            catch (PropertyVetoException e) {
                e.printStackTrace();
            }
            frames[i].moveToFront();
            if (frames[i] == activeframe) continue;
            frames[i].setLocation(position, position);
            position += 24;
        }
        if (activeframe != null) {
            activeframe.moveToFront();
            activeframe.setLocation(position, position);
        }
    }

    public void tileVertically() {
        JInternalFrame[] frames_tmp = this.getAllFrames();
        if (frames_tmp.length == 0) {
            return;
        }
        JInternalFrame[] frames = new JInternalFrame[frames_tmp.length];
        if (this.getSelectedFrame() == null && frames_tmp[0].isIcon()) {
            try {
                frames_tmp[0].setIcon(false);
                frames_tmp[0].setSelected(true);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return;
            }
        }
        frames[0] = this.getSelectedFrame();
        int k = 1;
        for (int i = 0; i < frames_tmp.length; ++i) {
            if (frames_tmp[i] == frames[0]) continue;
            frames[k] = frames_tmp[i];
            ++k;
        }
        int w = this.getWidth() / frames.length;
        int lastWidth = 0;
        lastWidth = frames.length > 1 ? this.getWidth() - w * (frames.length - 1) : w;
        int h = this.getHeight();
        int posX = 0;
        for (int i = 0; i < frames.length; ++i) {
            try {
                frames[i].setMaximum(false);
                frames[i].setIcon(false);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            frames[i].moveToFront();
            if (i < frames.length) {
                frames[i].setLocation(posX, 0);
                frames[i].setSize(w, h);
                posX += w;
                continue;
            }
            frames[i].setLocation(posX, 0);
            frames[i].setSize(lastWidth, h);
        }
    }

    public void tileHorizontally() {
        JInternalFrame[] frames_tmp = this.getAllFrames();
        if (frames_tmp.length == 0) {
            return;
        }
        JInternalFrame[] frames = new JInternalFrame[frames_tmp.length];
        if (this.getSelectedFrame() == null && frames_tmp[0].isIcon()) {
            try {
                frames_tmp[0].setIcon(false);
                frames_tmp[0].setSelected(true);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return;
            }
        }
        frames[0] = this.getSelectedFrame();
        int k = 1;
        for (int i = 0; i < frames_tmp.length; ++i) {
            if (frames_tmp[i] == frames[0]) continue;
            frames[k] = frames_tmp[i];
            ++k;
        }
        int w = this.getWidth();
        int h = this.getHeight() / frames.length;
        int lastHeight = 0;
        lastHeight = frames.length > 1 ? this.getHeight() - h * (frames.length - 1) : h;
        int posY = 0;
        for (int i = 0; i < frames.length; ++i) {
            try {
                frames[i].setMaximum(false);
                frames[i].setIcon(false);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            frames[i].moveToFront();
            if (i < frames.length) {
                frames[i].setLocation(0, posY);
                frames[i].setSize(w, h);
                posY += h;
                continue;
            }
            frames[i].setLocation(0, posY);
            frames[i].setSize(w, lastHeight);
        }
    }

    public void tileAnodine() {
        int numCurCol;
        JInternalFrame[] frames_tmp = this.getAllFrames();
        if (frames_tmp.length == 0) {
            return;
        }
        JInternalFrame[] frames = new JInternalFrame[frames_tmp.length];
        if (this.getSelectedFrame() == null && frames_tmp[0].isIcon()) {
            try {
                frames_tmp[0].setIcon(false);
                frames_tmp[0].setSelected(true);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return;
            }
        }
        frames[0] = this.getSelectedFrame();
        int k = 1;
        for (int i = 0; i < frames_tmp.length; ++i) {
            if (frames_tmp[i] == frames[0]) continue;
            frames[k] = frames_tmp[i];
            ++k;
        }
        int numVisible = frames.length;
        if (numVisible < 1) {
            return;
        }
        int numCols = (int)Math.sqrt(numVisible);
        int[] numRows = new int[numCols];
        for (numCurCol = 0; numCurCol < numCols; ++numCurCol) {
            numRows[numCurCol] = numCols;
        }
        int numCurDiffCol = numCols;
        for (int numDiff = numVisible - numCols * numCols; numDiff > 0; --numDiff) {
            int n = --numCurDiffCol;
            numRows[n] = numRows[n] + 1;
            if (numCurDiffCol >= 1) continue;
            numCurDiffCol = numCols;
        }
        numCurCol = 0;
        int numCurRow = 0;
        int curX = 0;
        int curY = 0;
        int xQuantum = this.getWidth() / numCols;
        int yQuantum = this.getHeight() / numRows[numCurCol];
        for (int i = 0; i < frames.length; ++i) {
            try {
                frames[i].setMaximum(false);
                frames[i].setIcon(false);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            frames[i].moveToFront();
            frames[i].setLocation(curX, curY);
            frames[i].setSize(xQuantum, yQuantum);
            curY += yQuantum;
            if (++numCurRow != numRows[numCurCol]) continue;
            numCurRow = 0;
            curY = 0;
            curX += xQuantum;
            if (++numCurCol == numCols) continue;
            yQuantum = this.getHeight() / numRows[numCurCol];
        }
    }
}

