/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.util.render;

import com.kingdee.bos.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;

public class BorderRenderW {
    protected boolean leftActive;
    protected boolean rightActive = true;
    protected boolean topActive;
    protected boolean bottomActive = true;
    protected boolean topBiasActive;
    protected boolean bottomBiasActive;
    protected Graphics2D g2d;
    private Line2D.Double line = new Line2D.Double();
    private double top;
    private double bottom;
    private double left;
    private double right;

    public BorderRenderW() {
        this.loadDefaultSetting();
    }

    public BorderRenderW(Graphics g) {
        this();
        this.setG2d((Graphics2D)g);
    }

    public void draw(Graphics g, Rectangle2D rect, Style style) {
        this.setG2d((Graphics2D)g);
        this.draw(rect, style);
    }

    public void draw(Graphics g, Rectangle2D rect, StyleAttributes sa) {
        this.setG2d((Graphics2D)g);
        ShareStyleAttributes ssa = Styles.getSSA(sa);
        this.draw(rect, Styles.getStyle(ssa));
    }

    public void draw(Rectangle2D rect, StyleAttributes sa) {
        this.draw(rect, Styles.getStyle(sa));
    }

    public void draw(Rectangle2D rect, Style style) {
        this.top = rect.getMinY();
        this.bottom = rect.getMaxY();
        this.left = rect.getMinX();
        this.right = rect.getMaxX();
        Graphics2D graphics = this.getG2d();
        Shape clipSave = graphics.getClip();
        Color colorSave = graphics.getColor();
        Stroke penSave = graphics.getStroke();
        graphics.setClip(rect);
        if (this.isTopBiasActive()) {
            this.caculateTopBias(rect, style);
            if (!this.isNullBorder(style, Styles.Position.DIAGONALLEFT)) {
                this.drawBorder(style, Styles.Position.DIAGONALLEFT, this.line);
            }
        }
        if (this.isBottomBiasActive()) {
            this.caculateBottomBias(rect, style);
            if (!this.isNullBorder(style, Styles.Position.DIAGONALRIGHT)) {
                this.drawBorder(style, Styles.Position.DIAGONALRIGHT, this.line);
            }
        }
        graphics.setClip(clipSave);
        if (this.isLeftActive()) {
            this.caculateLeft(rect, style);
            if (!this.isNullBorder(style, Styles.Position.LEFT)) {
                this.drawBorder(style, Styles.Position.LEFT, this.line);
            }
        }
        if (this.isTopActive()) {
            this.caculateTop(rect, style);
            if (!this.isNullBorder(style, Styles.Position.TOP)) {
                this.drawBorder(style, Styles.Position.TOP, this.line);
            }
        }
        if (this.isRightActive()) {
            this.caculateRight(rect, style);
            if (!this.isNullBorder(style, Styles.Position.RIGHT)) {
                this.drawBorder(style, Styles.Position.RIGHT, this.line);
            }
        }
        if (this.isBottomActive()) {
            this.caculateBottom(rect, style);
            if (!this.isNullBorder(style, Styles.Position.BOTTOM)) {
                this.drawBorder(style, Styles.Position.BOTTOM, this.line);
            }
        }
        graphics.setColor(colorSave);
        graphics.setStroke(penSave);
    }

    protected boolean isNullBorder(ShareStyleAttributes ssa, Styles.Position pos) {
        return ssa == null || ssa.isNullBorder(pos);
    }

    protected void caculateBottom(Rectangle2D rect, Style style) {
        this.line.setLine(this.left, this.bottom, this.right, this.bottom);
    }

    protected void caculateTop(Rectangle2D rect, Style style) {
        int leftOffset = (style.getBorderLineStyle(Styles.Position.LEFT).getWidth() - 1) / 2;
        int rightOffset = style.getBorderLineStyle(Styles.Position.RIGHT).getWidth() / 2;
        this.line.setLine(this.left - (double)leftOffset, this.top, this.right + (double)rightOffset, this.top);
    }

    protected void caculateRight(Rectangle2D rect, Style style) {
        this.line.setLine(this.right, this.top, this.right, this.bottom);
    }

    protected void caculateLeft(Rectangle2D rect, Style style) {
        int bottomOffset = (style.getBorderLineStyle(Styles.Position.BOTTOM).getWidth() + 1) / 2;
        int topOffset = style.getBorderLineStyle(Styles.Position.TOP).getWidth() / 2;
        this.line.setLine(this.left, this.top + (double)topOffset, this.left, this.bottom + (double)bottomOffset);
    }

    protected void drawBorder(Style stl, Styles.Position pos, Line2D.Double line) {
        if (stl.getBorderLineStyle(pos).getWidth() == 0) {
            return;
        }
        this.g2d.setColor(stl.getBorderColor(pos));
        this.g2d.setStroke(stl.getStroke(pos));
        this.g2d.draw(line);
    }

    protected void caculateBottomBias(Rectangle2D rect, Style style) {
        this.line.setLine(this.left, this.right, this.right, this.top);
    }

    protected void caculateTopBias(Rectangle2D rect, Style style) {
        this.line.setLine(this.left, this.top, this.right, this.bottom);
    }

    public boolean isLeftActive() {
        return this.leftActive;
    }

    public void setLeftActive(boolean leftActive) {
        this.leftActive = leftActive;
    }

    public boolean isBottomActive() {
        return this.bottomActive;
    }

    public void setBottomActive(boolean bottomActive) {
        this.bottomActive = bottomActive;
    }

    public boolean isBottomBiasActive() {
        return this.bottomBiasActive;
    }

    public void setBottomBiasActive(boolean bottomBiasActive) {
        this.bottomBiasActive = bottomBiasActive;
    }

    public boolean isRightActive() {
        return this.rightActive;
    }

    public void setRightActive(boolean rightActive) {
        this.rightActive = rightActive;
    }

    public boolean isTopActive() {
        return this.topActive;
    }

    public void setTopActive(boolean topActive) {
        this.topActive = topActive;
    }

    public boolean isTopBiasActive() {
        return this.topBiasActive;
    }

    public void setTopBiasActive(boolean topBiasActive) {
        this.topBiasActive = topBiasActive;
    }

    public void loadDefaultSetting() {
        this.leftActive = false;
        this.rightActive = true;
        this.topActive = false;
        this.bottomActive = true;
        this.topBiasActive = false;
        this.bottomBiasActive = false;
    }

    public Graphics2D getG2d() {
        if (this.g2d == null) {
            throw new NullPointerException("BorderRender error:No graphic found.");
        }
        return this.g2d;
    }

    protected void setG2d(Graphics2D g2d) {
        this.g2d = g2d;
    }

    public void testDraw() {
        this.g2d.setStroke(new BasicStroke(4.0f));
        this.g2d.setPaint(Color.RED);
        this.g2d.drawLine(275, 427, 375, 427);
    }
}

