/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.data.wizard.common;

import com.kingdee.bos.ctrl.common.ui.NormalSelector;
import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.data.meta.MetaClass;
import com.kingdee.bos.ctrl.data.meta.MetaField;
import com.kingdee.bos.ctrl.data.modal.IDefObj;
import com.kingdee.bos.ctrl.data.modal.query.Column;
import com.kingdee.bos.ctrl.data.wizard.Wizard2Resource;
import com.kingdee.bos.ctrl.data.wizard.common.FieldEditorDialog;
import com.kingdee.bos.ctrl.data.wizard.formula.FormulaWizardEditor;
import com.kingdee.bos.ctrl.data.wizard.framework.query.IQueryWizardModel;
import com.kingdee.bos.ctrl.data.wizard.util.WizardUtil;
import com.kingdee.bos.ctrl.res.Resource;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.ITreeNode;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;

public abstract class AbstractFieldSelector
extends NormalSelector {
    protected KDTree _treSupply;
    private IQueryWizardModel _model;
    private FieldEditorDialog _fieldEditor;
    private FormulaWizardEditor _formulaWizard;

    public AbstractFieldSelector(IQueryWizardModel model) {
        this._model = model;
        this.init();
        this.installListener();
    }

    private void init() {
        this.lvSelected.addButton((Action)new ActionEdit(), "edit");
        this.lvSelected.syncBtn();
        this._treSupply = new KDTree((ITreeNode)new DefaultKingdeeTreeNode(), false);
        this._treSupply.setRootVisible(false);
        this._treSupply.setShowsRootHandles(true);
        this.setSupplyCtrl((JComponent)this._treSupply);
        this.setSupplyTitle(Wizard2Resource.getString("res_13"));
        this.setSelectedTitle(Wizard2Resource.getString("res_14"));
    }

    private void installListener() {
        this._treSupply.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                AbstractFieldSelector.this.syncSelectButton();
            }
        });
        this.getSelectedList().addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    AbstractFieldSelector.this.editField();
                }
            }
        });
        this._treSupply.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() != 2) {
                    return;
                }
                TreePath path = AbstractFieldSelector.this._treSupply.getSelectionPath();
                if (path != null && path.equals(AbstractFieldSelector.this._treSupply.getClosestPath(e.getX(), e.getY()))) {
                    DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)path.getLastPathComponent();
                    if (node.getChildCount() != 0) {
                        return;
                    }
                    AbstractFieldSelector.this.selectFields();
                }
            }
        });
    }

    protected void syncSelectButton() {
        boolean isSelectEnabled = false;
        boolean isSelectAllEnabled = false;
        TreePath path = this._treSupply.getSelectionPath();
        if (path != null) {
            Object userObj = ((DefaultKingdeeTreeNode)path.getLastPathComponent()).getUserObject();
            isSelectEnabled = userObj instanceof MetaField;
            isSelectAllEnabled = userObj instanceof MetaClass;
        }
        this.btnSelect.setEnabled(isSelectEnabled);
        this.btnSelectAll.setEnabled(isSelectAllEnabled);
    }

    public void updateSupplyTree() {
        this.updateSupplyTree(this._treSupply, this._model);
    }

    protected abstract void updateSupplyTree(KDTree var1, IQueryWizardModel var2);

    protected void onSelect() {
        this.selectFields();
        this.treeMoveNextNode();
    }

    protected void onSelectAll() {
        this.selectFields();
    }

    private void selectFields() {
        StringBuffer errPrompt = new StringBuffer();
        int errCount = 0;
        TreePath[] path = this._treSupply.getSelectionPaths();
        if (path != null && path.length > 0) {
            Object firstUserObject = null;
            for (int i = 0; i < path.length; ++i) {
                MetaClass metaClass;
                String err;
                DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)path[i].getLastPathComponent();
                Object userObject = node.getUserObject();
                if (firstUserObject == null) {
                    firstUserObject = userObject;
                }
                if (i > 0 && userObject.getClass() != firstUserObject.getClass()) {
                    return;
                }
                if (userObject instanceof MetaClass) {
                    for (int j = 0; j < node.getChildCount(); ++j) {
                        MetaField mf = (MetaField)((DefaultKingdeeTreeNode)node.getChildAt(j)).getUserObject();
                        String err2 = this.addField(mf, (MetaClass)userObject);
                        if (err2 == null) continue;
                        ++errCount;
                        if (errPrompt.length() != 0) continue;
                        errPrompt.append("\"");
                        errPrompt.append(err2);
                        errPrompt.append("\"");
                    }
                    continue;
                }
                if (!(userObject instanceof MetaField) || (err = this.addField((MetaField)userObject, metaClass = (MetaClass)((DefaultKingdeeTreeNode)node.getParent()).getUserObject())) == null) continue;
                ++errCount;
                if (errPrompt.length() != 0) continue;
                errPrompt.append("\"");
                errPrompt.append(err);
                errPrompt.append("\"");
            }
        }
        if (errCount > 0) {
            errPrompt.append("\u7b49");
            errPrompt.append(errCount);
            errPrompt.append("\u4e2a");
            errPrompt.append(Wizard2Resource.getString("res_30"));
            WindowUtil.msgboxWarning((Object)errPrompt.toString(), (String)"\u5b57\u6bb5", (Component)((Object)this));
        }
    }

    private String addField(MetaField metaField, MetaClass metaClass) {
        Column col = this.createObjectToSelect(metaField, metaClass);
        if (col == null) {
            return metaField.getAliasName();
        }
        WizardUtil.makeSureDefObjUnique(this.getSelectedList(), (IDefObj)col);
        this.getSelectedList().addElement((Object)col);
        this.getSelectedList().setSelectedValue((Object)col, true);
        return null;
    }

    protected abstract Column createObjectToSelect(MetaField var1, MetaClass var2);

    private void treeMoveNextNode() {
        if (this._treSupply.getSelectionCount() > 1) {
            return;
        }
        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)this._treSupply.getSelectionPath().getLastPathComponent();
        DefaultKingdeeTreeNode next = (DefaultKingdeeTreeNode)node.getNextSibling();
        if (next != null) {
            this._treSupply.setSelectionNode(next);
        }
    }

    protected FieldEditorDialog getFieldEditor() {
        if (this._fieldEditor == null) {
            this._fieldEditor = this.createFieldEditor();
            this._fieldEditor.setFormula(this.getFormulaWizard());
            this.updateFormulaWizard(this.getFormulaWizard());
            this._fieldEditor.addVerifyListener(new FieldEditorDialog.VerifyListener(){

                @Override
                public boolean isOK(FieldEditorDialog.VerifyEvent e) {
                    return AbstractFieldSelector.this.verify(e);
                }
            });
        }
        return this._fieldEditor;
    }

    protected FormulaWizardEditor getFormulaWizard() {
        if (this._formulaWizard == null) {
            this._formulaWizard = this.createFormulaWizard();
            if (this._formulaWizard != null) {
                this._formulaWizard.setTitle(Wizard2Resource.getString("res_16"));
                this._formulaWizard.setExampleShow(true);
            }
        }
        return this._formulaWizard;
    }

    protected abstract FieldEditorDialog createFieldEditor();

    protected abstract FormulaWizardEditor createFormulaWizard();

    public void updateFormulaWizard() {
        if (this._formulaWizard != null) {
            this.updateFormulaWizard(this._formulaWizard);
        }
    }

    protected abstract void updateFormulaWizard(FormulaWizardEditor var1);

    private boolean verify(FieldEditorDialog.VerifyEvent evt) {
        Column col = null;
        if (!evt.getNewMode()) {
            col = (Column)this.getSelectedList().getSelectedValue();
        }
        if (StringUtil.isEmptyString((String)evt.getId())) {
            WindowUtil.msgboxError((Object)Wizard2Resource.getString("res_17"), (String)Wizard2Resource.getString("res_18"), (Component)((Object)this));
            return false;
        }
        if (!WizardUtil.isValidString(evt.getId())) {
            WindowUtil.msgboxError((Object)Wizard2Resource.getString("res_19"), (String)Wizard2Resource.getString("res_18"), (Component)((Object)this));
            return false;
        }
        if (!WizardUtil.isIDUnique(this.getSelectedList(), (IDefObj)col, evt.getId())) {
            WindowUtil.msgboxError((Object)Wizard2Resource.getString("res_20"), (String)Wizard2Resource.getString("res_18"), (Component)((Object)this));
            return false;
        }
        if (!WizardUtil.isValidString(evt.getAlias())) {
            WindowUtil.msgboxError((Object)Wizard2Resource.getString("res_21"), (String)Wizard2Resource.getString("res_18"), (Component)((Object)this));
            return false;
        }
        return true;
    }

    protected void editField() {
        FieldEditorDialog editor = this.getFieldEditor();
        editor.setNewMode(false);
        Column col = (Column)this.getSelectedList().getSelectedValue();
        if (col == null) {
            return;
        }
        editor.setID(col.getName());
        editor.setAlias(col.getAlias());
        editor.setDesc(col.getDesc());
        editor.setExpr(col.getExpr());
        editor.setType(col.getDataType());
        if (editor.showDialog()) {
            this.setChanged(true);
            this.fireNameChanged(col, editor);
            col.setAlias(editor.getAlias());
            col.setName(editor.getID());
            col.setDesc(editor.getDesc());
            col.setDataType(editor.getDataType());
            col.setExpr(editor.getExpr());
            this.getSelectedList().repaint();
        }
    }

    protected abstract void fireNameChanged(Column var1, FieldEditorDialog var2);

    private class ActionEdit
    extends AbstractAction {
        public ActionEdit() {
            this.putValue("ShortDescription", Wizard2Resource.getString("res_15"));
            this.putValue("SmallIcon", Resource.ICON_EDIT);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AbstractFieldSelector.this.editField();
        }
    }
}

