/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.data.wizard.joineditor;

import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.data.wizard.joineditor.AbstractJoinAction;
import com.kingdee.bos.ctrl.data.wizard.joineditor.AbstractModelObject;
import com.kingdee.bos.ctrl.data.wizard.joineditor.ActionDisconnection;
import com.kingdee.bos.ctrl.data.wizard.joineditor.ActionDisconnectionAll;
import com.kingdee.bos.ctrl.data.wizard.joineditor.ActionProperty;
import com.kingdee.bos.ctrl.data.wizard.joineditor.JoineditorResource;
import com.kingdee.bos.ctrl.data.wizard.joineditor.ModelField;
import com.kingdee.bos.ctrl.data.wizard.joineditor.ModelLine;
import com.kingdee.bos.ctrl.data.wizard.joineditor.ModelTable;
import com.kingdee.bos.ctrl.data.wizard.joineditor.PropertyDialog;
import com.kingdee.bos.ctrl.data.wizard.joineditor.SelectionEvent;
import com.kingdee.bos.ctrl.data.wizard.joineditor.SelectionListener;
import com.kingdee.bos.ctrl.data.wizard.joineditor.UITable;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;

public class JoinPanel
extends JPanel {
    private ArrayList tableSet;
    private ArrayList lineSet;
    private AbstractModelObject currentObj;
    private JPopupMenu popMenu;
    private boolean showMenuItem_property = true;
    private boolean isDrawLineArrow = true;
    private boolean isDrawLineIndex = true;

    public JoinPanel() {
        this.setOpaque(false);
        this.setToolTipText("text your head");
        this.tableSet = new ArrayList();
        this.lineSet = new ArrayList();
        this.setLayout(null);
        this.initPopMenu();
        this.installListener();
    }

    public void setShowMenuItem_property(boolean b) {
        this.showMenuItem_property = b;
    }

    public void setShowPopupMenu(boolean isShow) {
        if (isShow) {
            if (this.popMenu == null) {
                this.initPopMenu();
            }
        } else {
            this.popMenu = null;
        }
    }

    private void initPopMenu() {
        this.popMenu = new JPopupMenu();
        ActionProperty property = new ActionProperty();
        property.setJoinPanel(this);
        if (this.showMenuItem_property) {
            this.popMenu.add(property);
            this.popMenu.add(new JSeparator());
        }
        ActionDisconnection del = new ActionDisconnection();
        del.setJoinPanel(this);
        this.popMenu.add(del);
        ActionDisconnectionAll delAll = new ActionDisconnectionAll();
        delAll.setJoinPanel(this);
        this.popMenu.add(delAll);
    }

    private void installListener() {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e)) {
                    JoinPanel.this.requestFocus();
                    ModelLine ml = JoinPanel.this.getNearestLine(e.getPoint());
                    AbstractModelObject old = JoinPanel.this.currentObj;
                    JoinPanel.this.setSelectedLine(ml);
                    if (ml != old) {
                        JoinPanel.this.fireLineSelected(ml, SelectionEvent.SELECTED);
                    }
                    if (e.getClickCount() == 2 && JoinPanel.this.popMenu != null) {
                        JoinPanel.this.showProperty();
                    }
                } else if (SwingUtilities.isRightMouseButton(e)) {
                    if (JoinPanel.this.popMenu == null) {
                        return;
                    }
                    for (int i = 0; i < JoinPanel.this.popMenu.getComponentCount(); ++i) {
                        JMenuItem item;
                        if (!(JoinPanel.this.popMenu.getComponent(i) instanceof JMenuItem) || !((item = (JMenuItem)JoinPanel.this.popMenu.getComponent(i)).getAction() instanceof AbstractJoinAction)) continue;
                        ((AbstractJoinAction)item.getAction()).verifyEnabled();
                    }
                    JoinPanel.this.popMenu.show(JoinPanel.this, e.getX(), e.getY());
                }
            }
        });
    }

    protected void clearSelectedDraw() {
        this.clearAllSelectedField();
        if (this.currentObj == null) {
            return;
        }
        switch (this.currentObj.getObjType()) {
            case 2: {
                this.paintLine(this.getGraphics(), (ModelLine)this.currentObj, false);
                break;
            }
            case 0: {
                ((ModelTable)this.currentObj).getUi().drawSelectedTag(false);
                break;
            }
        }
        this.fireEvent(this.currentObj, SelectionEvent.DESELECTED);
    }

    private void clearAllSelectedField() {
        for (ModelTable mt : this.tableSet) {
            mt.getUi().setSelectedField(null);
        }
    }

    @Override
    public String getToolTipText(MouseEvent e) {
        ModelLine ml = this.getNearestLine(e.getPoint());
        if (ml != null) {
            return ml.getToolTipText();
        }
        return null;
    }

    public void addTable(ModelTable table) {
        Dimension dim = UITable.caculateDefaultSize(table);
        Point xy = this.getNewChildPreferredXY(dim);
        Rectangle rect = new Rectangle(xy.x, xy.y, dim.width, dim.height);
        this.addTable(table, rect);
    }

    public void addTable(ModelTable table, Rectangle pos) {
        this.tableSet.add(table);
        UITable ui = new UITable(table);
        this.add(ui);
        ui.setBounds(pos.x, pos.y, pos.width, pos.height);
        ui.setParentPanel(this);
    }

    public void moveTable(ModelTable table, Rectangle pos) {
        table.getUi().setBounds(pos.x, pos.y, pos.width, pos.height);
    }

    public void removeTable(ModelTable table) {
        for (int i = this.lineSet.size() - 1; i >= 0; --i) {
            ModelLine line = (ModelLine)this.lineSet.get(i);
            if (line.getFromTable() != table && line.getToTable() != table) continue;
            this.lineSet.remove(line);
        }
        this.tableSet.remove(table);
        this.remove(table.getUi());
        this.repaint();
    }

    public void removeAllTable() {
        this.tableSet.clear();
        this.lineSet.clear();
        this.currentObj = null;
        this.removeAll();
    }

    protected void ensureTypeSame(ModelLine line, boolean isNewLine) {
        for (int i = 0; i < this.lineSet.size(); ++i) {
            ModelLine otherLine = (ModelLine)this.lineSet.get(i);
            if (otherLine == line || !this.isLinkedSameTables(line, otherLine)) continue;
            if (isNewLine) {
                line.setType(otherLine.getType());
                break;
            }
            otherLine.setType(line.getType());
        }
    }

    protected void ensureIndexNotSame(ModelLine line) {
        for (int i = 0; i < this.lineSet.size(); ++i) {
            ModelLine otherLine = (ModelLine)this.lineSet.get(i);
            if (otherLine == line || otherLine.getIndex() != line.getIndex()) continue;
            int minIdx = this.findMinNousedIndex();
            String content = "";
            content = content.replaceAll("{0}", String.valueOf(otherLine.getIndex()).toString());
            content = content.replaceAll("{1}", String.valueOf(minIdx).toString());
            WindowUtil.msgboxInfo((Object)content, (String)JoineditorResource.getString("res_5"), (Component)this);
            otherLine.setIndex(minIdx);
        }
    }

    private int findMinNousedIndex() {
        int newIdx;
        int[] idxs = new int[this.lineSet.size()];
        for (int i = 0; i < this.lineSet.size(); ++i) {
            idxs[i] = ((ModelLine)this.lineSet.get(i)).getIndex();
        }
        for (newIdx = 1; newIdx <= this.lineSet.size(); ++newIdx) {
            boolean found = true;
            for (int i = 0; i < this.lineSet.size(); ++i) {
                if (newIdx != idxs[i]) continue;
                found = false;
                break;
            }
            if (found) break;
        }
        return newIdx;
    }

    public void addLine(ModelLine line) {
        if (this.isExistLinkedOppositely(line)) {
            ModelTable tempTable = line.getToTable();
            ModelField tempField = line.getToField();
            line.setToTable(line.getFromTable());
            line.setToField(line.getFromField());
            line.setFromTable(tempTable);
            line.setFromField(tempField);
        }
        this.ensureTypeSame(line, true);
        line.setIndex(this.findMinNousedIndex());
        this.lineSet.add(line);
        this.repaint();
    }

    public void removeLine(ModelLine line) {
        this.lineSet.remove(line);
        this.repaint();
    }

    private boolean isExistLinkedOppositely(ModelLine line) {
        for (int i = 0; i < this.lineSet.size(); ++i) {
            ModelLine temp = (ModelLine)this.lineSet.get(i);
            if (temp.getFromTable() != line.getToTable() || temp.getToTable() != line.getFromTable()) continue;
            return true;
        }
        return false;
    }

    private ModelLine getNearestLine(Point pt) {
        for (ModelLine ml : this.lineSet) {
            Point ptRight;
            Point ptLeft;
            if (ml.getFromTable().getUi().getX() < ml.getToTable().getUi().getX()) {
                ptLeft = ml.getFromTable().getUi().getFieldRightPoint(ml.getFromField());
                ptRight = ml.getToTable().getUi().getFieldLeftPoint(ml.getToField());
            } else {
                ptLeft = ml.getToTable().getUi().getFieldRightPoint(ml.getToField());
                ptRight = ml.getFromTable().getUi().getFieldLeftPoint(ml.getFromField());
            }
            if (!this.isBetweenThePoints(ptLeft, ptRight, pt) || this.calculateDistance(ptLeft, ptRight, pt) >= 6) continue;
            return ml;
        }
        return null;
    }

    private boolean isBetweenThePoints(Point p1, Point p2, Point p) {
        int xMax = (p1.x > p2.x ? p1.x : p2.x) + 3;
        int xMin = (p1.x < p2.x ? p1.x : p2.x) - 3;
        int yMax = (p1.y > p2.y ? p1.y : p2.y) + 3;
        int yMin = (p1.y < p2.y ? p1.y : p2.y) - 3;
        return xMin < p.x && p.x < xMax && yMin < p.y && p.y < yMax;
    }

    private int calculateDistance(Point p1, Point p2, Point p) {
        int a = p2.y - p1.y;
        int b = p1.x - p2.x;
        int c = p2.x * p1.y - p1.x * p2.y;
        int d = (int)((double)Math.abs(a * p.x + b * p.y + c) / Math.sqrt(a * a + b * b));
        return d;
    }

    @Override
    public void paint(Graphics g) {
        int i;
        super.paint(g);
        for (i = this.lineSet.size() - 1; i >= 0; --i) {
            ModelLine ml = (ModelLine)this.lineSet.get(i);
            if (ml == this.currentObj) {
                this.paintLine(g, ml, true);
                continue;
            }
            this.paintLine(g, ml, false);
        }
        for (i = this.getComponentCount() - 1; i >= 0; --i) {
            this.getComponent(i).repaint();
        }
    }

    protected void paintLine(Graphics g, ModelLine ml, boolean isCurrent) {
        Point ptRight;
        Point ptLeft;
        if (g == null || ml == null) {
            return;
        }
        Color oldColor = g.getColor();
        Color color = isCurrent ? Color.BLUE : ml.getColor();
        g.setColor(color);
        if (ml.getFromTable().getUi().getX() < ml.getToTable().getUi().getX()) {
            ptLeft = ml.getFromTable().getUi().getFieldRightPoint(ml.getFromField());
            ptRight = ml.getToTable().getUi().getFieldLeftPoint(ml.getToField());
            if (this.isDrawLineArrow) {
                g.fillPolygon(new int[]{ptRight.x + 4, ptRight.x + 4, ptRight.x + 8}, new int[]{ptRight.y - 4, ptRight.y + 4, ptRight.y}, 3);
            }
        } else {
            ptLeft = ml.getToTable().getUi().getFieldRightPoint(ml.getToField());
            ptRight = ml.getFromTable().getUi().getFieldLeftPoint(ml.getFromField());
            if (this.isDrawLineArrow) {
                g.fillPolygon(new int[]{ptLeft.x - 4, ptLeft.x - 4, ptLeft.x - 8}, new int[]{ptLeft.y - 4, ptLeft.y + 4, ptLeft.y}, 3);
            }
        }
        g.drawLine(ptLeft.x - 8, ptLeft.y, ptLeft.x, ptLeft.y);
        g.drawLine(ptLeft.x, ptLeft.y, ptRight.x, ptRight.y);
        g.drawLine(ptRight.x, ptRight.y, ptRight.x + 8, ptRight.y);
        if (this.isDrawLineIndex) {
            int xMid = Math.abs(ptLeft.x - ptRight.x) / 2 + Math.min(ptLeft.x, ptRight.x);
            int yMid = Math.abs(ptLeft.y - ptRight.y) / 2 + Math.min(ptLeft.y, ptRight.y);
            g.setColor(this.getBackground());
            g.fillOval(xMid - 8, yMid - 8, 16, 16);
            g.setColor(color);
            g.drawOval(xMid - 8, yMid - 8, 16, 16);
            if (ml.getIndex() < 10) {
                g.setFont(new Font(g.getFont().getFamily(), 1, 14));
                g.drawString(String.valueOf(ml.getIndex()), xMid - 4, yMid + 5);
            } else {
                g.setFont(new Font(g.getFont().getFamily(), 1, 12));
                g.drawString(String.valueOf(ml.getIndex()), xMid - 7, yMid + 5);
            }
        }
        g.setColor(oldColor);
    }

    public boolean processDraggingLine(ModelLine draggingLine, Point pt) {
        for (ModelTable tb : this.tableSet) {
            if (tb == draggingLine.getFromTable()) continue;
            int x1 = tb.getUi().getX() + tb.getUi().getListViewRect().x;
            int y1 = tb.getUi().getY() + tb.getUi().getListViewRect().y;
            int x2 = x1 + tb.getUi().getListViewRect().width;
            int y2 = y1 + tb.getUi().getListViewRect().height;
            if (x1 >= pt.x || pt.x >= x2 || y1 >= pt.y || pt.y >= y2) continue;
            ModelField fd = tb.getUi().getFieldByPoint(pt);
            if (fd == null) {
                return false;
            }
            tb.getUi().setSelectedField(fd);
            if (fd.getType().equals(draggingLine.getFromField().getType())) {
                draggingLine.setToTable(tb);
                draggingLine.setToField(fd);
                return true;
            }
            return false;
        }
        return false;
    }

    public ModelLine[] sortLineByIndex() {
        Object[] ls = this.lineSet.toArray();
        ModelLine[] lines = new ModelLine[ls.length];
        for (int i = 0; i < ls.length; ++i) {
            lines[i] = (ModelLine)ls[i];
        }
        for (int i = 0; i < lines.length - 1; ++i) {
            int k = i;
            for (int j = i + 1; j < lines.length; ++j) {
                if (lines[k].getIndex() <= lines[j].getIndex()) continue;
                k = j;
            }
            if (k == i) continue;
            ModelLine temp = lines[k];
            lines[k] = lines[i];
            lines[i] = temp;
        }
        return lines;
    }

    public String getResult() {
        HashMap usedTable = new HashMap();
        ModelLine[] lineArray = this.sortLineByIndex();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < lineArray.length; ++i) {
            ModelLine line = lineArray[i];
            if (line == null) continue;
            if (usedTable.containsKey(line.getFromTable()) && usedTable.containsKey(line.getToTable())) {
                sb.append(" AND ");
            } else if (usedTable.containsKey(line.getFromTable())) {
                sb.insert(0, "(");
                sb.append(")");
                sb.append(line.getTypeString());
                sb.append(line.getToTable().toSQLString());
                sb.append(" ON ");
            } else if (usedTable.containsKey(line.getToTable())) {
                sb.insert(0, "(");
                sb.append(")");
                sb.insert(0, line.getTypeString());
                sb.insert(0, line.getFromTable().toSQLString());
                sb.append(" ON ");
            } else {
                sb.append(line.getFromTable().toSQLString());
                sb.append(line.getTypeString());
                sb.append(line.getToTable().toSQLString());
                sb.append(" ON ");
            }
            sb.append(ModelLine.builtFieldRelation(line));
            for (int j = i + 1; j < lineArray.length; ++j) {
                if (!this.isLinkedSameTables(line, lineArray[j])) continue;
                sb.append(" AND ");
                sb.append(ModelLine.builtFieldRelation(lineArray[j]));
                lineArray[j] = null;
            }
            usedTable.put(line.getFromTable(), null);
            usedTable.put(line.getToTable(), null);
            line = null;
        }
        for (int i = 0; i < this.tableSet.size(); ++i) {
            ModelTable mt = (ModelTable)this.tableSet.get(i);
            if (usedTable.containsKey(mt)) continue;
            sb.insert(0, sb.length() == 0 ? "" : ",");
            sb.insert(0, mt.toSQLString());
        }
        return sb.toString();
    }

    private boolean isLinkedSameTables(ModelLine line1, ModelLine line2) {
        if (line1 == null || line2 == null) {
            return false;
        }
        return line1.getFromTable() == line2.getFromTable() && line1.getToTable() == line2.getToTable();
    }

    public JPopupMenu getPopMenu() {
        return this.popMenu;
    }

    protected ModelLine getCurrentLine() {
        if (this.currentObj != null && this.currentObj.getObjType() == 2) {
            return (ModelLine)this.currentObj;
        }
        return null;
    }

    protected AbstractModelObject getCurrentObject() {
        return this.currentObj;
    }

    protected void setCurrentObject(AbstractModelObject mo) {
        this.currentObj = mo;
    }

    public ArrayList getLineSet() {
        return this.lineSet;
    }

    public ArrayList getTableSet() {
        return this.tableSet;
    }

    public boolean isDrawLineArrow() {
        return this.isDrawLineArrow;
    }

    public void setDrawLineArrow(boolean isDrawLineArrow) {
        this.isDrawLineArrow = isDrawLineArrow;
    }

    public boolean isDrawLineIndex() {
        return this.isDrawLineIndex;
    }

    public void setDrawLineIndex(boolean isDrawLineIndex) {
        this.isDrawLineIndex = isDrawLineIndex;
    }

    public void setTableIcon(ModelTable mo, Icon icon) {
        if (mo.getUi() != null) {
            mo.getUi().setIcon(icon);
        }
    }

    public void setTableBackground(ModelTable mo, Color color) {
        if (mo.getUi() != null) {
            mo.getUi().setTableBackground(color);
        }
    }

    protected Dimension getChildrenMaxRightDown() {
        int wMax = 0;
        int hMax = 0;
        for (int i = 0; i < this.getComponentCount(); ++i) {
            Rectangle rect = this.getComponent(i).getBounds();
            if (rect.x + rect.width > wMax) {
                wMax = rect.x + rect.width;
            }
            if (rect.y + rect.height <= hMax) continue;
            hMax = rect.y + rect.height;
        }
        return new Dimension(wMax, hMax);
    }

    private Point getNewChildPreferredXY(Dimension childSize) {
        Rectangle rectThis = new Rectangle(1, 1, childSize.width, childSize.height);
        for (int i = 0; i < this.getComponentCount(); ++i) {
            Rectangle rectOther = this.getComponent(i).getBounds();
            if (!rectOther.contains(rectThis.x, rectThis.y) && !rectThis.contains(rectOther.x, rectOther.y)) continue;
            rectThis.x = rectOther.x + rectOther.width + 50;
            rectThis.y = rectOther.y;
        }
        return new Point(rectThis.x, rectThis.y);
    }

    public void setSelectedLine(ModelLine ml) {
        if (this.currentObj != ml) {
            this.clearSelectedDraw();
            if (ml != null) {
                this.paintLine(this.getGraphics(), ml, true);
                ml.getToTable().getUi().setSelectedField(ml.getToField());
                ml.getFromTable().getUi().setSelectedField(ml.getFromField());
            }
            this.currentObj = ml;
        }
    }

    public void setSelectedTable(ModelTable mt) {
        if (this.currentObj != mt) {
            this.clearSelectedDraw();
            if (mt != null) {
                mt.getUi().drawSelectedTag(true);
            }
            this.currentObj = mt;
        }
    }

    public void setSelectedField(ModelTable mt, ModelField mf) {
        if (this.currentObj != mf) {
            this.clearSelectedDraw();
            this.selectFieldWithoutClearOthers(mt, mf);
            this.currentObj = mf;
        }
    }

    private void selectFieldWithoutClearOthers(ModelTable mt, ModelField mf) {
        if (mt != null) {
            mt.getUi().setSelectedField(mf);
        }
    }

    public void selectedRelativeLine(ModelLine[] lines, int selectionType) {
        Color color = selectionType == SelectionEvent.SELECTED ? Color.BLUE : Color.BLACK;
        for (int i = 0; i < lines.length; ++i) {
            ModelField toField;
            ModelField fromField;
            ModelLine line = lines[i];
            if (line == this.getCurrentLine()) continue;
            line.setColor(color);
            if (selectionType == SelectionEvent.SELECTED) {
                fromField = line.getFromField();
                toField = line.getToField();
            } else {
                fromField = null;
                toField = null;
            }
            if (this.getCurrentObject() != line.getFromField()) {
                this.selectFieldWithoutClearOthers(line.getFromTable(), fromField);
            }
            if (this.getCurrentObject() == line.getToField()) continue;
            this.selectFieldWithoutClearOthers(line.getToTable(), toField);
        }
        this.repaint();
    }

    public void addSelectionListener(SelectionListener l) {
        this.listenerList.add(SelectionListener.class, l);
    }

    public void removeSelectionListener(SelectionListener l) {
        this.listenerList.remove(SelectionListener.class, l);
    }

    private void fireEvent(AbstractModelObject source, int selectionType) {
        if (source == null) {
            return;
        }
        switch (source.getObjType()) {
            case 2: {
                this.fireLineSelected(source, selectionType);
                break;
            }
            case 1: {
                this.fireFieldSelected(source, selectionType);
                break;
            }
            case 0: {
                this.fireTableSelected(source, selectionType);
                break;
            }
        }
    }

    protected void fireLineSelected(Object source, int selectionType) {
        if (source == null) {
            return;
        }
        SelectionEvent evt = null;
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; --i) {
            if (listeners[i] != SelectionListener.class) continue;
            if (evt == null) {
                evt = new SelectionEvent(source, selectionType);
            }
            ((SelectionListener)listeners[i + 1]).lineSelected(evt);
        }
    }

    protected void fireFieldSelected(Object source, int selectionType) {
        SelectionEvent evt = null;
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; --i) {
            if (listeners[i] != SelectionListener.class) continue;
            if (evt == null) {
                evt = new SelectionEvent(source, selectionType);
            }
            ((SelectionListener)listeners[i + 1]).fieldSelected(evt);
        }
    }

    protected void fireTableSelected(Object source, int selectionType) {
        SelectionEvent evt = null;
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; --i) {
            if (listeners[i] != SelectionListener.class) continue;
            if (evt == null) {
                evt = new SelectionEvent(source, selectionType);
            }
            ((SelectionListener)listeners[i + 1]).tableSelected(evt);
        }
    }

    public void showProperty() {
        ModelLine ml = this.getCurrentLine();
        if (ml == null) {
            return;
        }
        PropertyDialog dlg = (PropertyDialog)((Object)WindowUtil.createWindow(PropertyDialog.class, (Component)this));
        dlg.initLineProperty(ml);
        if (dlg.showDialog()) {
            int oldIdx = ml.getIndex();
            int oldType = ml.getType();
            dlg.changeLineProperty(ml);
            if (oldIdx != ml.getIndex()) {
                this.ensureIndexNotSame(ml);
            }
            if (oldType != ml.getType()) {
                this.ensureTypeSame(ml, false);
            }
            this.repaint();
        }
    }
}

