/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.data.wizard.process;

import com.kingdee.bos.ctrl.common.util.LangUtil;
import com.kingdee.bos.ctrl.data.modal.types.DataSetType;
import com.kingdee.bos.ctrl.kdf.util.style.styledesigner.MultiColorListCellRenderer;
import com.kingdee.bos.ctrl.kdf.util.style.styledesigner.MultiColorListElement;
import com.kingdee.bos.ctrl.swing.KDList;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.ListCellRenderer;
import org.jdom2.Element;

public class DataSetProcessList
extends KDList {
    private ArrayList items = new ArrayList();
    private DataSetType curDSType;
    private ArrayList descs;

    public DataSetProcessList(Element processList) {
        super.setCellRenderer((ListCellRenderer)new MultiColorListCellRenderer());
        Iterator i = processList.getChildren().iterator();
        String tab = "         ";
        this.descs = new ArrayList();
        while (i.hasNext()) {
            Element processesE = (Element)i.next();
            Iterator i2 = processesE.getChildren().iterator();
            String processTypeAlias = LangUtil.getAttrValue((Element)processesE, (String)"alias");
            this.addElement(processTypeAlias);
            this.items.add(processTypeAlias);
            this.descs.add(processesE);
            while (i2.hasNext()) {
                Element processE = (Element)i2.next();
                String input = processE.getAttributeValue("input");
                String className = processE.getAttributeValue("className");
                String processAlias = LangUtil.getAttrValue((Element)processE, (String)"alias");
                this.items.add(new _Item(DataSetType.fromName((String)processesE.getAttributeValue("target")), DataSetType.fromName((String)input), className));
                String s = tab + processAlias;
                this.addElement(s);
                this.descs.add(processE);
            }
        }
    }

    public void addElement(String s) {
        MultiColorListElement e = new MultiColorListElement();
        e.setElement((Object)s);
        super.addElement((Object)e);
    }

    private void setElementColor(int index, Color color) {
        MultiColorListElement e = (MultiColorListElement)super.getElement(index);
        e.setForegroud(color);
    }

    public boolean currentIsValidProcess() {
        return this.isValiedProcess(this.getSelectedIndex());
    }

    public boolean isValiedProcess(int index) {
        if (index < 0) {
            return false;
        }
        Object itemObj = this.items.get(index);
        if (itemObj instanceof _Item) {
            return ((_Item)itemObj).sourceType == this.curDSType;
        }
        return false;
    }

    public void setCurrentSourceType(DataSetType dsType) {
        int curSel = this.getSelectedIndex();
        boolean setSel = false;
        if (curSel != -1 && this.isValiedProcess(curSel)) {
            setSel = true;
        }
        this.curDSType = dsType;
        for (int i = 0; i < this.getElementCount(); ++i) {
            if (!_Item.class.isInstance(this.items.get(i))) continue;
            if (this.isValiedProcess(i)) {
                this.setElementColor(i, Color.BLACK);
                if (setSel) continue;
                this.setSelectedIndex(i);
                setSel = true;
                continue;
            }
            this.setElementColor(i, Color.GRAY);
        }
    }

    public String getSelectedWizardClass() {
        int selected = this.getSelectedIndex();
        if (selected == -1) {
            return null;
        }
        Object obj = this.items.get(selected);
        if (obj instanceof _Item) {
            return ((_Item)obj).wizardClass;
        }
        return null;
    }

    public String getSelectedDescription() {
        Element e = this.getSelectedDes();
        if (e != null) {
            return LangUtil.getAttrValue((Element)e, (String)"description");
        }
        return null;
    }

    public Element getSelectedDes() {
        try {
            return (Element)this.descs.get(this.getSelectedIndex());
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    public static class _Item {
        DataSetType targetType;
        DataSetType sourceType;
        String wizardClass;

        public _Item(DataSetType s0, DataSetType s1, String s2) {
            this.targetType = s0;
            this.sourceType = s1;
            this.wizardClass = s2;
        }
    }
}

