/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.data.wizard.query;

import com.kingdee.bos.ctrl.common.FullPath;
import com.kingdee.bos.ctrl.common.layout.table.Cell;
import com.kingdee.bos.ctrl.common.ui.NormalSelector;
import com.kingdee.bos.ctrl.common.ui.TypicalDialog;
import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.common.ui.select.IObjectSelectListener;
import com.kingdee.bos.ctrl.common.ui.select.IObjectSelector;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.data.meta.MetaClass;
import com.kingdee.bos.ctrl.data.modal.DefObj;
import com.kingdee.bos.ctrl.data.modal.IDefObj;
import com.kingdee.bos.ctrl.data.modal.query.ITable;
import com.kingdee.bos.ctrl.data.modal.query.ITableList;
import com.kingdee.bos.ctrl.data.modal.query.Table;
import com.kingdee.bos.ctrl.data.wizard.Wizard2Resource;
import com.kingdee.bos.ctrl.data.wizard.framework.IDataWizardModel;
import com.kingdee.bos.ctrl.data.wizard.framework.query.AbstractQueryWizardTabbedUI;
import com.kingdee.bos.ctrl.data.wizard.framework.query.IQueryWizardModel;
import com.kingdee.bos.ctrl.data.wizard.query.QueryResource;
import com.kingdee.bos.ctrl.data.wizard.util.WizardUtil;
import com.kingdee.bos.ctrl.res.Resource;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDList;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDTextField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.EventListener;
import java.util.EventObject;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.event.EventListenerList;

public class TableWizardUI
extends AbstractQueryWizardTabbedUI {
    private CustomSelector _selector;

    public String getTabbedTitle() {
        return Wizard2Resource.getString("res_31");
    }

    @Override
    public void setModel(IDataWizardModel model) {
        super.setModel(model);
        if (model instanceof IQueryWizardModel && this._selector != null) {
            this._selector.addObjectSelectorUI(((IQueryWizardModel)model).getObjectSelector());
        }
    }

    @Override
    protected KDPanel createPanel() {
        this._selector = new CustomSelector();
        if (this.getModel() != null) {
            this._selector.addObjectSelectorUI(this.getModel().getObjectSelector());
        }
        return this._selector;
    }

    @Override
    protected void doShowModel2Ui() {
        this._selector.getSelectedList().removeAllElements();
        ITableList queryTables = this.getModel().getQuery().getTables();
        for (int i = 0; i < queryTables.size(); ++i) {
            ITable table = (ITable)queryTables.get(i);
            this._selector.getSelectedList().addElement((Object)table);
        }
    }

    @Override
    public void syncUi2Model() {
        ITableList queryTables = this.getModel().getQuery().getTables();
        queryTables.clear();
        int c = this._selector.getSelectedList().getElementCount();
        for (int i = 0; i < c; ++i) {
            ITable table = (ITable)this._selector.getSelectedList().getElement(i);
            queryTables.add(i, (Object)table);
        }
    }

    @Override
    public void syncModel2Ui() {
    }

    public static class TableEditorDialog
    extends TypicalDialog {
        private EventListenerList listenerList = new EventListenerList();
        private KDTextField txtID;
        private KDTextField txtAlias;
        private KDTextField txtDesc;
        private KDTextField txtExpr;

        public TableEditorDialog() {
        }

        public TableEditorDialog(Frame frame) {
            super(frame);
        }

        public TableEditorDialog(Dialog dialog) {
            super(dialog);
        }

        protected void todoInit() {
            this.setSize(480, 180);
            this.txtID = new KDTextField();
            this.txtAlias = new KDTextField();
            this.txtDesc = new KDTextField();
            this.txtExpr = new KDTextField();
            this.txtExpr.setEnabled(false);
            this.txtID.setPreferredSize(new Dimension(370, 19));
            this.txtAlias.setPreferredSize(new Dimension(370, 19));
            this.txtExpr.setPreferredSize(new Dimension(370, 19));
            KDLabelContainer lbcID = new KDLabelContainer((JComponent)this.txtID);
            lbcID.setBoundLabelText(QueryResource.getString("res_40"));
            lbcID.setBoundLabelLength(80);
            lbcID.setBoundLabelUnderline(true);
            KDLabelContainer lbcAlias = new KDLabelContainer((JComponent)this.txtAlias);
            lbcAlias.setBoundLabelText(QueryResource.getString("res_41"));
            lbcAlias.setBoundLabelLength(80);
            lbcAlias.setBoundLabelUnderline(true);
            KDLabelContainer lbcDesc = new KDLabelContainer((JComponent)this.txtDesc);
            lbcDesc.setBoundLabelText(QueryResource.getString("res_42"));
            lbcDesc.setBoundLabelLength(80);
            lbcDesc.setBoundLabelUnderline(true);
            KDLabelContainer lbcExpr = new KDLabelContainer((JComponent)this.txtExpr);
            lbcExpr.setBoundLabelText(QueryResource.getString("res_16"));
            lbcExpr.setBoundLabelLength(80);
            lbcExpr.setBoundLabelUnderline(true);
        }

        protected void todoAddControls(Container parent, Cell thisCell) {
            com.kingdee.bos.ctrl.common.layout.table.Table layout = thisCell.split(5, 1);
            for (int i = 0; i < 4; ++i) {
                layout.rowStyle(i).setHeight(19);
                layout.rowStyle(i).setMarginBottom(3);
            }
            layout.rowStyle(4).setPriY(1);
            parent.add((Component)this.txtID.getLabelContainer(), layout.cell(0, 0));
            parent.add((Component)this.txtAlias.getLabelContainer(), layout.cell(1, 0));
            parent.add((Component)this.txtDesc.getLabelContainer(), layout.cell(2, 0));
            parent.add((Component)this.txtExpr.getLabelContainer(), layout.cell(3, 0));
        }

        protected void todoActionPerformed(ActionEvent e) {
        }

        protected void todoKeyAction(int keyCode) {
        }

        public void setBosQueryMode(boolean isBosQueryMode) {
            this.txtID.setEnabled(!isBosQueryMode);
            this.txtAlias.setEnabled(!isBosQueryMode);
            this.txtDesc.setEnabled(!isBosQueryMode);
        }

        protected void onOk() {
            if (this.fireVerifEvent((Object)this, this.getAlias(), this.getID())) {
                super.onOk();
            }
        }

        public void addVerifyListener(VerifyListener l) {
            this.listenerList.add(VerifyListener.class, l);
        }

        public void removeVerifyListener(VerifyListener l) {
            this.listenerList.remove(VerifyListener.class, l);
        }

        protected boolean fireVerifEvent(Object source, String alias, String id) {
            Object[] listeners = this.listenerList.getListenerList();
            VerifyEvent evt = null;
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != VerifyListener.class) continue;
                if (evt == null) {
                    evt = new VerifyEvent(source, alias, id);
                }
                return ((VerifyListener)listeners[i + 1]).isOK(evt);
            }
            return true;
        }

        public String getAlias() {
            return this.txtAlias.getText();
        }

        public void setAlias(String alias) {
            this.txtAlias.setText(alias);
        }

        public String getDesc() {
            return this.txtDesc.getText();
        }

        public void setDesc(String desc) {
            this.txtDesc.setText(desc);
        }

        public String getID() {
            return this.txtID.getText();
        }

        public void setID(String ID) {
            this.txtID.setText(ID);
        }

        public String getExpr() {
            return this.txtExpr.getText();
        }

        public void setExpr(String expr) {
            this.txtExpr.setText(expr);
        }

        public static class VerifyEvent
        extends EventObject {
            private String alias;
            private String id;

            public VerifyEvent(Object source, String alias, String id) {
                super(source);
                this.alias = alias;
                this.id = id;
            }

            public String getAlias() {
                return this.alias;
            }

            public String getId() {
                return this.id;
            }
        }

        public static interface VerifyListener
        extends EventListener {
            public boolean isOK(VerifyEvent var1);
        }
    }

    private class ActionRename
    extends AbstractAction {
        public ActionRename() {
            this.putValue("SmallIcon", Resource.ICON_RENAME);
            this.putValue("ShortDescription", Wizard2Resource.getString("res_37"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.editTable();
        }

        private void editTable() {
            DefObj tbl = (DefObj)TableWizardUI.this._selector.getSelectedList().getSelectedValue();
            if (tbl == null) {
                return;
            }
            TableEditorDialog tableEditor = this.createTableEditor();
            tableEditor.setID(tbl.getName());
            tableEditor.setAlias(tbl.getAlias());
            tableEditor.setDesc(tbl.getDesc());
            if (tbl instanceof Table) {
                tableEditor.setExpr(((Table)tbl).getExpr());
            } else {
                tableEditor.setExpr("");
            }
            if (tableEditor.showDialog()) {
                if (!tableEditor.getAlias().equalsIgnoreCase(tbl.getAlias())) {
                    this.fireAliasChangedEvent(tbl, tbl.getAlias(), tableEditor.getAlias());
                }
                tbl.setAlias(tableEditor.getAlias());
                if (!tableEditor.getID().equalsIgnoreCase(tbl.getName())) {
                    this.fireNameChangedEvent(tbl, tbl.getName(), tableEditor.getID());
                }
                tbl.setName(tableEditor.getID());
                tbl.setDesc(tableEditor.getDesc());
                TableWizardUI.this._selector.getSelectedList().repaint();
            }
        }

        private TableEditorDialog createTableEditor() {
            TableEditorDialog tableEditor = (TableEditorDialog)((Object)WindowUtil.createWindow(TableEditorDialog.class, (Component)((Object)TableWizardUI.this._selector)));
            tableEditor.setTitle(Wizard2Resource.getString("res_38"));
            tableEditor.addVerifyListener(new TableEditorDialog.VerifyListener(){

                @Override
                public boolean isOK(TableEditorDialog.VerifyEvent e) {
                    return true;
                }
            });
            return tableEditor;
        }

        private void fireNameChangedEvent(Object source, String oldName, String newName) {
            TableWizardUI.this.getModel().firePropertyChanged(source, "table name", oldName, newName);
        }

        private void fireAliasChangedEvent(Object source, String oldAlias, String newAlias) {
            TableWizardUI.this.getModel().firePropertyChanged(source, "table alias", oldAlias, newAlias);
        }
    }

    private class CustomSelector
    extends NormalSelector {
        private ActionRename actionRename;

        public CustomSelector() {
            this.actionRename = new ActionRename();
            this.getSelected().addButton((Action)this.actionRename, "edit");
            this.getSelected().syncBtn();
            this.setSupplyTitle(Wizard2Resource.getString("res_33"));
            this.setSelectedTitle(Wizard2Resource.getString("res_34"));
            this.enableSelectAll(false);
            this.getSelectedList().addMouseListener((MouseListener)new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2) {
                        CustomSelector.this.actionRename.editTable();
                    } else {
                        Object obj = ((KDList)e.getSource()).getSelectedValue();
                        if (obj instanceof ITable) {
                            String expr = ((ITable)obj).getExpr();
                            TableWizardUI.this.getModel().getObjectSelector().setSelectedInfo(expr);
                        }
                    }
                }
            });
        }

        public void addObjectSelectorUI(IObjectSelector objectSelector) {
            this.setSupplyCtrlNoScroll(objectSelector.getUI());
            SupplySelectChangeHandler handler = new SupplySelectChangeHandler(objectSelector);
            objectSelector.setSelectListener((IObjectSelectListener)handler);
            this.syncSelectButton(objectSelector);
        }

        protected void onSelect() {
            String info = TableWizardUI.this.getModel().getObjectSelector().getSelectedInfo();
            MetaClass data = (MetaClass)TableWizardUI.this.getModel().getObjectSelector().getObject(info);
            if (data != null) {
                Table tbl = new Table();
                tbl.copy((IDefObj)data);
                tbl.setName(FullPath.cutCategory((String)data.getName()));
                tbl.setExpr(info);
                WizardUtil.makeSureDefObjUnique(this.getSelectedList(), (IDefObj)tbl);
                this.getSelectedList().addElement((Object)tbl);
                this.getSelectedList().setSelectedValue((Object)tbl, true);
            }
        }

        protected void syncListViewButton() {
            super.syncListViewButton();
            if (this.getSelectedList().getSelectedIndex() == -1 || this.getSelectedList().getSelectedIndices().length > 1) {
                this.lvSelected.getButton("edit").setEnabled(false);
                this.lvSelected.getButton("editSubQuery").setEnabled(false);
            } else {
                this.lvSelected.getButton("edit").setEnabled(true);
                this.lvSelected.getButton("editSubQuery").setEnabled(true);
            }
        }

        private void syncSelectButton(IObjectSelector objectSelector) {
            boolean isCanSelect = !StringUtil.isEmptyString((String)objectSelector.getSelectedInfo());
            this.enableSelect(isCanSelect);
        }

        class SupplySelectChangeHandler
        implements IObjectSelectListener {
            private IObjectSelector objectSelector;

            public SupplySelectChangeHandler(IObjectSelector objectSelector) {
                this.objectSelector = objectSelector;
            }

            public void selectChanged() {
                CustomSelector.this.syncSelectButton(this.objectSelector);
            }

            public void selectConfirm() {
            }
        }
    }
}

