/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.data.engine.script.beanshell;

import com.kingdee.bos.ctrl.common.CtrlUtil;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.data.modal.ParamUtil;
import com.kingdee.bos.ctrl.data.modal.Parameter;
import java.sql.ResultSet;
import java.util.HashMap;
import java.util.Iterator;

public class ScriptMaker {
    private HashMap importClasses = new HashMap();
    private HashMap varIndexes = new HashMap();
    private HashMap allVars = new HashMap();
    private int globalVarIndex;
    private StringBuffer codes = new StringBuffer(4096);
    public static final String VAR_NAME_RESULT = "result";
    public static final String[] ignore_packages = new String[]{"javax.swing.event", "javax.swing", "java.awt.event", "java.awt", "java.net", "java.util", "java.io", "java.lang"};

    public ScriptMaker() {
        this.codes.append("Object result = null;\n\n");
    }

    private boolean needImportClass(Class cls) {
        for (int i = 0; i < ignore_packages.length; ++i) {
            Package pck = Package.getPackage(ignore_packages[i]);
            if (!pck.equals(cls.getPackage())) continue;
            return false;
        }
        return true;
    }

    public void addImportClass(Class cls) {
        if (this.needImportClass(cls)) {
            this.importClasses.put(cls, cls);
        }
    }

    public String makeScript_imports() {
        StringBuffer sb = new StringBuffer(1024);
        for (Class cls : this.importClasses.keySet()) {
            String code = "import " + cls.getName() + ";\n";
            sb.append(code);
        }
        sb.append("\n");
        return sb.toString();
    }

    public String getScript_process() {
        return this.codes.toString();
    }

    public String addDeclareVarScript(Class cls) {
        String varName = this.makeVarName(cls);
        this.addScriptLine(StringUtil.getClassName((Class)cls, (boolean)false) + " " + varName + " = null;");
        return varName;
    }

    public String makeVarName(Class cls) {
        this.addImportClass(cls);
        String varName = StringUtil.makeTypeShortening((Class)cls);
        Integer index = (Integer)this.varIndexes.get(cls);
        varName = index != null ? varName + (index + 1) : varName + "0";
        this.varIndexes.put(cls, index == null ? new Integer(0) : new Integer(index + 1));
        if (this.allVars.get(varName) != null) {
            varName = varName + "_" + this.globalVarIndex++;
        }
        this.allVars.put(varName, varName);
        return varName;
    }

    public void addSetDataResultScript(String varName) {
        this.codes.append("\n");
        this.codes.append("context.setDataResult(result=" + varName + ");\n");
        this.codes.append("\n");
    }

    public String addInvokeImportScript(String importName, HashMap args) {
        String varArgs = null;
        String varName2 = this.addDeclareVarScript(Object.class);
        if (args != null) {
            varArgs = this.addDeclareVarScript(HashMap.class);
            this.addScriptLine(varArgs + " = new HashMap();");
            Iterator keys = args.keySet().iterator();
            Iterator vals = args.values().iterator();
            while (keys.hasNext()) {
                Object pVal = vals.next();
                Parameter param = (Parameter)keys.next();
                if (pVal == null) continue;
                if (pVal instanceof Parameter) {
                    pVal = "@" + ((Parameter)pVal).getName();
                } else if (pVal instanceof String) {
                    pVal = StringUtil.replace((String)((String)pVal), (String)"\"", (String)"\\\"", (boolean)false, (boolean)true);
                } else {
                    throw new UnsupportedOperationException("unsupport parameter value:" + pVal + ",type:" + pVal.getClass());
                }
                if (ParamUtil.isDataViewParam(param)) {
                    this.addScriptLine(varArgs + ".put(\"" + param.getName() + "\",builtInUtil.compExprVal2(\"" + pVal + "\"));");
                    continue;
                }
                this.addScriptLine(varArgs + ".put(\"" + param.getName() + "\",builtInUtil.compExprVal(\"" + pVal + "\"));");
            }
        }
        this.addScriptLine(varName2 + " = builtInUtil.executeImport(\"" + importName + "\"," + varArgs + ");");
        return varName2;
    }

    public String addWrappRSScript(String[] finalNames, String varName) {
        String varName2 = this.addDeclareVarScript(ResultSet.class);
        this.addScript(varName2 + " = builtInUtil.wrapResultSet(");
        this.addScript("(ResultSet)" + varName);
        this.addScript(",new String[]{");
        if (finalNames != null) {
            for (int i = 0; i < finalNames.length; ++i) {
                if (i != 0) {
                    this.addScript(",");
                }
                this.addScript("\"" + finalNames[i] + "\"");
            }
        }
        this.addScript("});\n");
        return varName2;
    }

    public void addScriptLine(String bshScript) {
        this.codes.append(bshScript);
        this.codes.append("\n");
    }

    public void addScript(String bshScript) {
        this.codes.append(bshScript);
    }

    public void addBatchOutputColumnsScript(int batchStep) {
        String varBatchRS = this.addDeclareVarScript(ResultSet.class);
        this.addScriptLine(varBatchRS + "=builtInUtil.batchOutputColumns(" + VAR_NAME_RESULT + "," + batchStep + ");");
        this.addSetDataResultScript(varBatchRS);
    }

    public static final String makeStringArrayStamentEx(String[] strs) {
        if (strs == null) {
            return "";
        }
        String[] temp = new String[strs.length];
        for (int i = 0; i < strs.length; ++i) {
            temp[i] = CtrlUtil.Str.replace((String)strs[i], (String)"\"", (String)"\\\"");
        }
        return ScriptMaker.makeStringArrayStament(temp);
    }

    public static final String makeStringArrayStament(String[] strs) {
        StringBuffer sb = new StringBuffer();
        sb.append("new String[]{");
        if (strs != null) {
            for (int i = 0; i < strs.length; ++i) {
                if (i != 0) {
                    sb.append(",");
                }
                if (strs[i] == null) {
                    sb.append("null");
                    continue;
                }
                sb.append("\"" + strs[i] + "\"");
            }
        }
        sb.append("}");
        return sb.toString();
    }

    public static final String makeIntArrayStament(int[] ints) {
        StringBuffer sb = new StringBuffer();
        sb.append("new int[]{");
        for (int i = 0; i < ints.length; ++i) {
            if (i != 0) {
                sb.append(",");
            }
            sb.append(ints[i]);
        }
        sb.append("}");
        return sb.toString();
    }
}

