/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.data.process.function;

import com.kingdee.bos.ctrl.data.process.function.ArgsHelper;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;

public class Functions {
    private static final HashMap funcMaps = new HashMap();
    static final HashMap CALENDAR_FIELDS;

    public static Object[] prosessNull(Object[] objs) {
        if (objs == null) {
            return null;
        }
        for (int i = 0; i < objs.length; ++i) {
            if (objs[i] != null) continue;
            return null;
        }
        return objs;
    }

    public static IFunction getFuncObject(String funcName) {
        return (IFunction)funcMaps.get(funcName.toUpperCase());
    }

    public static Object callFunc(String funcName, Object[] args) throws IllegalArgumentException {
        IFunction funcObj = Functions.getFuncObject(funcName);
        if (funcObj != null) {
            return funcObj.invoke(args);
        }
        throw new IllegalArgumentException("Unkown function name:'" + funcName + "'");
    }

    public static void main(String[] args) {
        System.out.println(new RIGHT().invoke(new Object[]{"abc", new Integer(2)}));
        System.out.println("current time:" + new java.util.Date(System.currentTimeMillis()));
        System.out.println("ADD_DAYS( 1):" + new ADD_DAYS().invoke(new Object[]{new java.util.Date(System.currentTimeMillis()), new Integer(1)}));
        System.out.println("ADD_HOUS( 1):" + new ADD_HOURS().invoke(new Object[]{new java.util.Date(System.currentTimeMillis()), new Integer(1)}));
        System.out.println("ADD_MITS( 1):" + new ADD_MINUTES().invoke(new Object[]{new java.util.Date(System.currentTimeMillis()), new Integer(1)}));
        System.out.println("ADD_MONS( 1):" + new ADD_MONTHS().invoke(new Object[]{new java.util.Date(System.currentTimeMillis()), new Integer(1)}));
        System.out.println("ADD_SNDS( 1):" + new ADD_SECONDS().invoke(new Object[]{new java.util.Date(System.currentTimeMillis()), new Integer(1)}));
        System.out.println("ADD_YARS( 1):" + new ADD_YEARS().invoke(new Object[]{new java.util.Date(System.currentTimeMillis()), new Integer(1)}));
        System.out.println("DAYNAME(cur):" + new DAYNAME().invoke(new Object[]{new java.util.Date(System.currentTimeMillis())}));
        System.out.println("CUR_DATE:" + new CURDATE().invoke(null));
        System.out.println("CUR_TIME:" + new CURTIME().invoke(null));
        System.out.println("NOW:" + new NOW().invoke(null));
        System.out.println(9);
        java.util.Date curDate = new java.util.Date(System.currentTimeMillis());
        System.out.println(new DATEADD().invoke(new Object[]{"day", new Integer(1), curDate}));
        DateFormat sdf = DateFormat.getDateInstance();
        try {
            System.out.println(sdf.parse("2005-09-08"));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    static {
        funcMaps.put("ABS", new ABS());
        funcMaps.put("ACOS", new ACOS());
        funcMaps.put("ADD_DAYS", new ADD_DAYS());
        funcMaps.put("ADD_HOURS", new ADD_HOURS());
        funcMaps.put("ADD_MINUTES", new ADD_MINUTES());
        funcMaps.put("ADD_MONTHS", new ADD_MONTHS());
        funcMaps.put("ADD_SECONDS", new ADD_SECONDS());
        funcMaps.put("ADD_YEARS", new ADD_YEARS());
        funcMaps.put("ASCII", new ASCII());
        funcMaps.put("ASIN", new ASIN());
        funcMaps.put("ATAN", new ATAN());
        funcMaps.put("ATN2", new ATN2());
        funcMaps.put("CEILING", new CEILING());
        funcMaps.put("CHAR", new CHAR());
        funcMaps.put("CHARINDEX", new CHARINDEX());
        funcMaps.put("CONTACT", new CONTACT());
        funcMaps.put("COS", new COS());
        funcMaps.put("CURDATE", new CURDATE());
        funcMaps.put("CURTIME", new CURTIME());
        funcMaps.put("DATEADD", new DATEADD());
        funcMaps.put("DATEDIFF", new DATEDIFF());
        funcMaps.put("DAYNAME", new DAYNAME());
        funcMaps.put("DAYOFMONTH", new DAYOFMONTH());
        funcMaps.put("DAYOFWEEK", new DAYOFWEEK());
        funcMaps.put("DAYOFYEAR", new DAYOFYEAR());
        funcMaps.put("EXP", new EXP());
        funcMaps.put("FLOOR", new FLOOR());
        funcMaps.put("GETDATE", new GETDATE());
        funcMaps.put("HOUR", new HOUR());
        funcMaps.put("ISNULL", new ISNULL());
        funcMaps.put("LEFT", new LEFT());
        funcMaps.put("LEN", new LEN());
        funcMaps.put("LOG", new LOG());
        funcMaps.put("LOWER", new LOWER());
        funcMaps.put("LTRIM", new LTRIM());
        funcMaps.put("MINUTE", new MINUTE());
        funcMaps.put("MOD", new MOD());
        funcMaps.put("MONTH", new MONTH());
        funcMaps.put("MONTHNAME", new MONTHNAME());
        funcMaps.put("MONTHS_BETWEEN", new MONTHS_BETWEEN());
        funcMaps.put("NOW", new NOW());
        funcMaps.put("NULLIF", new NULLIF());
        funcMaps.put("POWER", new POWER());
        funcMaps.put("QUARTER", new QUARTER());
        funcMaps.put("REPLACE", new REPLACE());
        funcMaps.put("RIGHT", new RIGHT());
        funcMaps.put("ROUND", new ROUND());
        funcMaps.put("RTRIM", new RTRIM());
        funcMaps.put("SECOND", new SECOND());
        funcMaps.put("SIGN", new SIGN());
        funcMaps.put("SIN", new SIN());
        funcMaps.put("SOUNDEX", new SOUNDEX());
        funcMaps.put("SQRT", new SQRT());
        funcMaps.put("SUBSTRING", new SUBSTRING());
        funcMaps.put("TAN", new TAN());
        funcMaps.put("TO_DATE", new TO_DATE());
        funcMaps.put("TO_INTEGER", new TO_INTEGER());
        funcMaps.put("TO_NUMBER", new TO_NUMBER());
        funcMaps.put("TOCHAR", new TOCHAR());
        funcMaps.put("TRIM", new TRIM());
        funcMaps.put("UPPER", new UPPER());
        funcMaps.put("WEEK", new WEEK());
        System.out.println(funcMaps);
        CALENDAR_FIELDS = new HashMap();
        CALENDAR_FIELDS.put("year", new Integer(1));
        CALENDAR_FIELDS.put("month", new Integer(2));
        CALENDAR_FIELDS.put("day", new Integer(6));
        CALENDAR_FIELDS.put("hour", new Integer(11));
        CALENDAR_FIELDS.put("minute", new Integer(12));
        CALENDAR_FIELDS.put("second", new Integer(13));
    }

    public static interface IFunction {
        public Object invoke(Object[] var1) throws IllegalArgumentException;
    }

    public static class DATEDIFF
    implements IFunction {
        @Override
        public Object invoke(Object[] params) throws IllegalArgumentException {
            try {
                ArgsHelper.checkArgsType("DATEDIFF", params, new Class[]{String.class, java.util.Date.class, java.util.Date.class});
            }
            catch (IllegalArgumentException e) {
                if (params.length == 3 && (params[1] == null || params[2] != null)) {
                    return null;
                }
                throw e;
            }
            if (params[0] == null) {
                throw new IllegalArgumentException("Type of DATEADD 's argment  1 must be not null!");
            }
            if (params[1] == null) {
                return null;
            }
            if (params[2] == null) {
                return null;
            }
            Calendar cal = Calendar.getInstance();
            cal.setTime((java.util.Date)params[1]);
            Calendar cal2 = Calendar.getInstance();
            cal2.setTime((java.util.Date)params[2]);
            String addType = params[0].toString().toLowerCase();
            Integer fieldObj = (Integer)CALENDAR_FIELDS.get(addType);
            if (fieldObj == null) {
                throw new IllegalArgumentException(addType + " \u4e0d\u662f\u53ef\u4ee5\u8bc6\u522b\u7684 DATEDIFF \u9009\u9879\u3002");
            }
            int field = fieldObj;
            return new Integer(cal.get(field) - cal2.get(field));
        }
    }

    public static class DATEADD
    implements IFunction {
        @Override
        public Object invoke(Object[] params) throws IllegalArgumentException {
            ArgsHelper.checkArgsType("DATEADD", params, new Class[]{String.class, Integer.class, java.util.Date.class});
            if (params[0] == null) {
                throw new IllegalArgumentException("Type of DATEADD 's argment  1 must be not null!");
            }
            if (params[2] == null) {
                return null;
            }
            if (params[1] == null) {
                return params[2];
            }
            Calendar cal = Calendar.getInstance();
            cal.setTime((java.util.Date)params[2]);
            String addType = params[0].toString().toLowerCase();
            Object fieldObj = CALENDAR_FIELDS.get(addType);
            if (fieldObj == null) {
                throw new IllegalArgumentException(addType + " \u4e0d\u662f\u53ef\u4ee5\u8bc6\u522b\u7684 DATEADD \u9009\u9879\u3002");
            }
            cal.roll((int)((Integer)fieldObj), (Integer)params[1]);
            return cal.getTime();
        }
    }

    public static class MONTHNAME
    implements IFunction {
        @Override
        public Object invoke(Object[] params) throws IllegalArgumentException {
            ArgsHelper.checkArgsType("MONTHNAME", params, new Class[]{java.util.Date.class});
            if (params[0] == null) {
                return null;
            }
            SimpleDateFormat sdf = new SimpleDateFormat("M");
            return sdf.format((java.util.Date)params[0]);
        }
    }

    public static class DAYNAME
    implements IFunction {
        @Override
        public Object invoke(Object[] params) throws IllegalArgumentException {
            ArgsHelper.checkArgsType("DAYNAME", params, new Class[]{java.util.Date.class});
            if (params[0] == null) {
                return null;
            }
            SimpleDateFormat sdf = new SimpleDateFormat("E");
            return sdf.format((java.util.Date)params[0]);
        }
    }

    public static class MONTHS_BETWEEN
    implements IFunction {
        @Override
        public Object invoke(Object[] params) throws IllegalArgumentException {
            ArgsHelper.checkArgsType("MONTHS_BETWEEN", params, new Class[]{java.util.Date.class, java.util.Date.class});
            if (params[0] == null) {
                return params[1];
            }
            if (params[1] == null) {
                return params[0];
            }
            Calendar cal = Calendar.getInstance();
            cal.setTime((java.util.Date)params[0]);
            int month0 = cal.get(2);
            cal.setTime((java.util.Date)params[1]);
            int month1 = cal.get(2);
            return new Integer(month0 - month1);
        }
    }

    public static class DAYOFWEEK
    implements IFunction {
        @Override
        public Object invoke(Object[] params) throws IllegalArgumentException {
            ArgsHelper.checkArgsType("DAYOFWEEK", params, new Class[]{java.util.Date.class});
            if (params[0] == null) {
                return null;
            }
            Calendar cal = Calendar.getInstance();
            cal.setTime((java.util.Date)params[0]);
            return new Integer(cal.get(7));
        }
    }

    public static class DAYOFYEAR
    implements IFunction {
        @Override
        public Object invoke(Object[] params) throws IllegalArgumentException {
            ArgsHelper.checkArgsType("DAYOFYEAR", params, new Class[]{java.util.Date.class});
            if (params[0] == null) {
                return null;
            }
            Calendar cal = Calendar.getInstance();
            cal.setTime((java.util.Date)params[0]);
            return new Integer(cal.get(6));
        }
    }

    public static class DAYOFMONTH
    implements IFunction {
        @Override
        public Object invoke(Object[] params) throws IllegalArgumentException {
            ArgsHelper.checkArgsType("DAYOFMONTH", params, new Class[]{java.util.Date.class});
            if (params[0] == null) {
                return null;
            }
            Calendar cal = Calendar.getInstance();
            cal.setTime((java.util.Date)params[0]);
            return new Integer(cal.get(5));
        }
    }

    public static class SECOND
    implements IFunction {
        @Override
        public Object invoke(Object[] params) throws IllegalArgumentException {
            ArgsHelper.checkArgsType("SECOND", params, new Class[]{java.util.Date.class});
            if (params[0] == null) {
                return null;
            }
            Calendar cal = Calendar.getInstance();
            cal.setTime((java.util.Date)params[0]);
            return new Integer(cal.get(13));
        }
    }

    public static class WEEK
    implements IFunction {
        @Override
        public Object invoke(Object[] params) throws IllegalArgumentException {
            ArgsHelper.checkArgsType("WEEK", params, new Class[]{java.util.Date.class});
            if (params[0] == null) {
                return null;
            }
            Calendar cal = Calendar.getInstance();
            cal.setTime((java.util.Date)params[0]);
            return new Integer(cal.get(3));
        }
    }

    public static class MONTH
    implements IFunction {
        @Override
        public Object invoke(Object[] params) throws IllegalArgumentException {
            ArgsHelper.checkArgsType("MONTH", params, new Class[]{java.util.Date.class});
            if (params[0] == null) {
                return null;
            }
            Calendar cal = Calendar.getInstance();
            cal.setTime((java.util.Date)params[0]);
            return new Integer(cal.get(2));
        }
    }

    public static class MINUTE
    implements IFunction {
        @Override
        public Object invoke(Object[] params) throws IllegalArgumentException {
            ArgsHelper.checkArgsType("MINUTE", params, new Class[]{java.util.Date.class});
            if (params[0] == null) {
                return null;
            }
            Calendar cal = Calendar.getInstance();
            cal.setTime((java.util.Date)params[0]);
            return new Integer(cal.get(12));
        }
    }

    public static class HOUR
    implements IFunction {
        @Override
        public Object invoke(Object[] params) throws IllegalArgumentException {
            ArgsHelper.checkArgsType("HOUR", params, new Class[]{java.util.Date.class});
            if (params[0] == null) {
                return null;
            }
            Calendar cal = Calendar.getInstance();
            cal.setTime((java.util.Date)params[0]);
            return new Integer(cal.get(11));
        }
    }

    public static class QUARTER
    implements IFunction {
        @Override
        public Object invoke(Object[] params) throws IllegalArgumentException {
            ArgsHelper.checkArgsType("QUARTER", params, new Class[]{java.util.Date.class});
            if (params[0] == null) {
                return null;
            }
            Calendar cal = Calendar.getInstance();
            cal.setTime((java.util.Date)params[0]);
            int month = cal.get(2);
            return new Integer(month / 3 + (month % 3 != 0 ? 1 : 0));
        }
    }

    public static class GETDATE
    extends NOW
    implements IFunction {
    }

    public static class NOW
    implements IFunction {
        @Override
        public Object invoke(Object[] params) throws IllegalArgumentException {
            ArgsHelper.checkArgsCount("NOW", params, 0);
            return new java.util.Date(System.currentTimeMillis());
        }
    }

    public static class CURTIME
    implements IFunction {
        @Override
        public Object invoke(Object[] params) throws IllegalArgumentException {
            ArgsHelper.checkArgsCount("CURTIME", params, 0);
            return new Time(System.currentTimeMillis());
        }
    }

    public static class CURDATE
    implements IFunction {
        @Override
        public Object invoke(Object[] params) throws IllegalArgumentException {
            ArgsHelper.checkArgsCount("CURDATE", params, 0);
            return new Date(System.currentTimeMillis());
        }
    }

    public static class ADD_YEARS
    implements IFunction {
        @Override
        public Object invoke(Object[] params) throws IllegalArgumentException {
            ArgsHelper.checkArgsType("ADD_YEARS", params, new Class[]{java.util.Date.class, Integer.class});
            if (params[0] == null) {
                return null;
            }
            if (params[1] == null) {
                return params[0];
            }
            Calendar cal = Calendar.getInstance();
            cal.setTime((java.util.Date)params[0]);
            cal.roll(1, ArgsHelper.intVal(params[1]));
            return cal.getTime();
        }
    }

    public static class ADD_SECONDS
    implements IFunction {
        @Override
        public Object invoke(Object[] params) throws IllegalArgumentException {
            ArgsHelper.checkArgsType("ADD_SECONDS", params, new Class[]{java.util.Date.class, Integer.class});
            if (params[0] == null) {
                return null;
            }
            if (params[1] == null) {
                return params[0];
            }
            Calendar cal = Calendar.getInstance();
            cal.setTime((java.util.Date)params[0]);
            cal.roll(13, ArgsHelper.intVal(params[1]));
            return cal.getTime();
        }
    }

    public static class ADD_MONTHS
    implements IFunction {
        @Override
        public Object invoke(Object[] params) throws IllegalArgumentException {
            ArgsHelper.checkArgsType("ADD_MONTHS", params, new Class[]{java.util.Date.class, Integer.class});
            if (params[0] == null) {
                return null;
            }
            if (params[1] == null) {
                return params[0];
            }
            Calendar cal = Calendar.getInstance();
            cal.setTime((java.util.Date)params[0]);
            cal.roll(2, ArgsHelper.intVal(params[1]));
            return cal.getTime();
        }
    }

    public static class ADD_MINUTES
    implements IFunction {
        @Override
        public Object invoke(Object[] params) throws IllegalArgumentException {
            ArgsHelper.checkArgsType("ADD_MINUTES", params, new Class[]{java.util.Date.class, Integer.class});
            if (params[0] == null) {
                return null;
            }
            if (params[1] == null) {
                return params[0];
            }
            Calendar cal = Calendar.getInstance();
            cal.setTime((java.util.Date)params[0]);
            cal.roll(12, ArgsHelper.intVal(params[1]));
            return cal.getTime();
        }
    }

    public static class ADD_HOURS
    implements IFunction {
        @Override
        public Object invoke(Object[] params) throws IllegalArgumentException {
            ArgsHelper.checkArgsType("ADD_HOURS", params, new Class[]{java.util.Date.class, Integer.class});
            if (params[0] == null) {
                return null;
            }
            if (params[1] == null) {
                return params[0];
            }
            Calendar cal = Calendar.getInstance();
            cal.setTime((java.util.Date)params[0]);
            cal.roll(11, ArgsHelper.intVal(params[1]));
            return cal.getTime();
        }
    }

    public static class ADD_DAYS
    implements IFunction {
        @Override
        public Object invoke(Object[] params) throws IllegalArgumentException {
            ArgsHelper.checkArgsType("ADD_DAYS", params, new Class[]{java.util.Date.class, Integer.class});
            if (params[0] == null) {
                return null;
            }
            if (params[1] == null) {
                return params[0];
            }
            Calendar cal = Calendar.getInstance();
            cal.setTime((java.util.Date)params[0]);
            cal.roll(6, ArgsHelper.intVal(params[1]));
            return cal.getTime();
        }
    }

    public static class TO_NUMBER
    implements IFunction {
        @Override
        public Object invoke(Object[] params) throws IllegalArgumentException {
            ArgsHelper.checkArgsType("TO_NUMBER", params, new Class[]{Object.class});
            if (params[0] == null) {
                return null;
            }
            return new Double(params[0].toString());
        }
    }

    public static class TO_INTEGER
    implements IFunction {
        @Override
        public Object invoke(Object[] params) throws IllegalArgumentException {
            ArgsHelper.checkArgsType("TO_INTEGER", params, new Class[]{Object.class});
            if (params[0] == null) {
                return null;
            }
            return new Integer(params[0].toString());
        }
    }

    public static class TO_DATE
    implements IFunction {
        @Override
        public Object invoke(Object[] params) throws IllegalArgumentException {
            ArgsHelper.checkArgsType("TO_DATE", params, new Class[]{String.class});
            if (params[0] == null) {
                return null;
            }
            try {
                return DateFormat.getDateInstance().parse((String)params[0]);
            }
            catch (ParseException e) {
                throw new IllegalArgumentException("Convert faild from '");
            }
        }
    }

    public static class NULLIF
    implements IFunction {
        @Override
        public Object invoke(Object[] params) throws IllegalArgumentException {
            ArgsHelper.checkArgsCount("NULLIF", params, 2);
            if (params[0] == null) {
                throw new IllegalArgumentException("CASE \u8bf4\u660e\u4e2d\u7684\u4efb\u4e00\u7ed3\u679c\u8868\u8fbe\u5f0f\u5747\u4e0d\u80fd\u662f NULL\u3002");
            }
            if (params[0] == params[1] || params[0] != null && params[0].equals(params[1])) {
                return null;
            }
            return params[0];
        }
    }

    public static class ISNULL
    implements IFunction {
        @Override
        public Object invoke(Object[] params) throws IllegalArgumentException {
            ArgsHelper.checkArgsCount("ISNULL", params, 2);
            if (params[0] == null && params[1] == null) {
                return null;
            }
            return params[0] == null ? params[1] : params[0];
        }
    }

    public static class TOCHAR
    implements IFunction {
        @Override
        public Object invoke(Object[] params) throws IllegalArgumentException {
            ArgsHelper.checkArgsType("TOCHAR", params, new Class[]{Number.class});
            if (params[0] == null) {
                return null;
            }
            String str = ArgsHelper.stringVal(params[0]);
            return str;
        }
    }

    public static class UPPER
    implements IFunction {
        @Override
        public Object invoke(Object[] params) throws IllegalArgumentException {
            ArgsHelper.checkArgsType("UPPER", params, new Class[]{String.class});
            if (params[0] == null) {
                return null;
            }
            String str = ArgsHelper.stringVal(params[0]);
            return str.toUpperCase();
        }
    }

    public static class TRIM
    implements IFunction {
        @Override
        public Object invoke(Object[] params) throws IllegalArgumentException {
            ArgsHelper.checkArgsType("TRIM", params, new Class[]{String.class});
            if (params[0] == null) {
                return null;
            }
            String str = ArgsHelper.stringVal(params[0]);
            return str.trim();
        }
    }

    public static class SUBSTRING
    implements IFunction {
        @Override
        public Object invoke(Object[] params) throws IllegalArgumentException {
            ArgsHelper.checkArgsType("SUBSTRING", params, new Class[]{String.class, Number.class, Number.class});
            if (params[0] == null || params[1] == null || params[2] == null) {
                return null;
            }
            String str = ArgsHelper.stringVal(params[0]);
            int from = (int)ArgsHelper.doubleVal(params[1]);
            int len = (int)ArgsHelper.doubleVal(params[2]);
            return str.substring(from - 1, from - 1 + len);
        }
    }

    public static class SOUNDEX
    implements IFunction {
        @Override
        public Object invoke(Object[] params) throws IllegalArgumentException {
            ArgsHelper.checkArgsType("SOUNDEX", params, new Class[]{String.class});
            String str = ArgsHelper.stringVal(params[0]);
            throw new UnsupportedOperationException();
        }
    }

    public static class RTRIM
    implements IFunction {
        @Override
        public Object invoke(Object[] params) throws IllegalArgumentException {
            ArgsHelper.checkArgsType("RTRIM", params, new Class[]{String.class});
            if (params[0] == null) {
                return null;
            }
            String str = ArgsHelper.stringVal(params[0]);
            for (int i = 0; i < str.length(); ++i) {
                if (str.charAt(i) != ' ') continue;
                return str.substring(0, i);
            }
            return str;
        }
    }

    public static class RIGHT
    implements IFunction {
        @Override
        public Object invoke(Object[] params) throws IllegalArgumentException {
            ArgsHelper.checkArgsType("RIGHT", params, new Class[]{String.class, Number.class});
            if (params[0] == null || params[1] == null) {
                return null;
            }
            String str = ArgsHelper.stringVal(params[0]);
            int count = (int)ArgsHelper.doubleVal(params[1]);
            return str.substring(str.length() - count);
        }
    }

    public static class REPLACE
    implements IFunction {
        @Override
        public Object invoke(Object[] params) throws IllegalArgumentException {
            ArgsHelper.checkArgsType("REPLACE", params, new Class[]{String.class, String.class, String.class});
            if (params[0] == null || params[1] == null || params[2] == null) {
                return null;
            }
            String str = ArgsHelper.stringVal(params[0]);
            return str.replaceAll(ArgsHelper.stringVal(params[1]), ArgsHelper.stringVal(params[2]));
        }
    }

    public static class LTRIM
    implements IFunction {
        @Override
        public Object invoke(Object[] params) throws IllegalArgumentException {
            ArgsHelper.checkArgsType("LTRIM", params, new Class[]{String.class});
            if (params[0] == null) {
                return null;
            }
            String s = ArgsHelper.stringVal(params[0]);
            for (int i = 0; i < s.length(); ++i) {
                if (s.charAt(i) == ' ') continue;
                return s.substring(i);
            }
            return "";
        }
    }

    public static class LOWER
    implements IFunction {
        @Override
        public Object invoke(Object[] params) throws IllegalArgumentException {
            ArgsHelper.checkArgsType("LOWER", params, new Class[]{String.class});
            if (params[0] == null) {
                return null;
            }
            return ArgsHelper.stringVal(params[0]).toLowerCase();
        }
    }

    public static class LEN
    implements IFunction {
        @Override
        public Object invoke(Object[] params) throws IllegalArgumentException {
            ArgsHelper.checkArgsType("LEN", params, new Class[]{String.class});
            if (params[0] == null) {
                return null;
            }
            int d = ArgsHelper.stringVal(params[0]).length();
            return new Integer(d);
        }
    }

    public static class LEFT
    implements IFunction {
        @Override
        public Object invoke(Object[] params) throws IllegalArgumentException {
            int strLenth;
            ArgsHelper.checkArgsType("LEFT", params, new Class[]{String.class, Number.class});
            if (params[0] == null) {
                return null;
            }
            if (params[1] == null) {
                return null;
            }
            int index = (int)ArgsHelper.doubleVal(params[1]);
            if (index >= (strLenth = params[0].toString().length())) {
                return params[0];
            }
            return ArgsHelper.stringVal(params[0]).substring(0, (int)ArgsHelper.doubleVal(params[1]));
        }
    }

    public static class CONTACT
    implements IFunction {
        @Override
        public Object invoke(Object[] params) throws IllegalArgumentException {
            ArgsHelper.checkArgsType("CONTACT", params, new Class[]{String.class, String.class});
            return ArgsHelper.stringVal(params[0]) + ArgsHelper.stringVal(params[1]);
        }
    }

    public static class CHARINDEX
    implements IFunction {
        @Override
        public Object invoke(Object[] params) throws IllegalArgumentException {
            ArgsHelper.checkArgsType("CHARINDEX", params, new Class[]{String.class, String.class});
            if (params[1] == null) {
                return null;
            }
            if (params[0] == null) {
                return null;
            }
            int d = ArgsHelper.stringVal(params[1]).indexOf(ArgsHelper.stringVal(params[0]));
            return new Integer(d + 1);
        }
    }

    public static class CHAR
    implements IFunction {
        @Override
        public Object invoke(Object[] params) throws IllegalArgumentException {
            ArgsHelper.checkNumericArgs("CHAR", params, 1);
            if (params[0] == null) {
                return null;
            }
            char c = (char)ArgsHelper.doubleVal(params[0]);
            return new Character(c);
        }
    }

    public static class ASCII
    implements IFunction {
        @Override
        public Object invoke(Object[] params) throws IllegalArgumentException {
            ArgsHelper.checkArgsType("ASCII", params, new Class[]{Character.class});
            if (params[0] == null) {
                return null;
            }
            char d = ArgsHelper.charVal(params[0]);
            return new Integer(d);
        }
    }

    public static class TAN
    implements IFunction {
        @Override
        public Object invoke(Object[] params) throws IllegalArgumentException {
            ArgsHelper.checkNumericArgs("TAN", params, 1);
            if (params[0] == null) {
                return null;
            }
            double d = StrictMath.tan(ArgsHelper.doubleVal(params[0]));
            return new Double(d);
        }
    }

    public static class SQRT
    implements IFunction {
        @Override
        public Object invoke(Object[] params) throws IllegalArgumentException {
            ArgsHelper.checkNumericArgs("SQRT", params, 1);
            if (params[0] == null) {
                return null;
            }
            double d = StrictMath.sqrt(ArgsHelper.doubleVal(params[0]));
            return new Double(d);
        }
    }

    public static class SIN
    implements IFunction {
        @Override
        public Object invoke(Object[] params) throws IllegalArgumentException {
            ArgsHelper.checkNumericArgs("SIN", params, 1);
            if (params[0] == null) {
                return null;
            }
            double d = StrictMath.sin(ArgsHelper.doubleVal(params[0]));
            return new Double(d);
        }
    }

    public static class SIGN
    implements IFunction {
        @Override
        public Object invoke(Object[] params) throws IllegalArgumentException {
            ArgsHelper.checkNumericArgs("SIGN", params, 1);
            if (params[0] == null) {
                return null;
            }
            int d = ArgsHelper.doubleVal(params[0]) > 0.0 ? 1 : -1;
            return new Integer(d);
        }
    }

    public static class ROUND
    implements IFunction {
        @Override
        public Object invoke(Object[] params) throws IllegalArgumentException {
            ArgsHelper.checkNumericArgs("ROUND", params, 2);
            throw new UnsupportedOperationException();
        }
    }

    public static class POWER
    implements IFunction {
        @Override
        public Object invoke(Object[] params) throws IllegalArgumentException {
            ArgsHelper.checkNumericArgs("POWER", params, 2);
            if (params[0] == null) {
                return null;
            }
            if (params[1] == null) {
                return params[0];
            }
            double d = StrictMath.pow(ArgsHelper.doubleVal(params[0]), ArgsHelper.doubleVal(params[1]));
            return new Double(d);
        }
    }

    public static class LOG
    implements IFunction {
        @Override
        public Object invoke(Object[] params) throws IllegalArgumentException {
            ArgsHelper.checkNumericArgs("LOG", params, 1);
            if (params[0] == null) {
                return null;
            }
            double d = StrictMath.log(ArgsHelper.doubleVal(params[0]));
            return new Double(d);
        }
    }

    public static class FLOOR
    implements IFunction {
        @Override
        public Object invoke(Object[] params) throws IllegalArgumentException {
            ArgsHelper.checkNumericArgs("FLOOR", params, 1);
            if (params[0] == null) {
                return null;
            }
            double d = StrictMath.floor(ArgsHelper.doubleVal(params[0]));
            return new Integer((int)d);
        }
    }

    public static class EXP
    implements IFunction {
        @Override
        public Object invoke(Object[] params) throws IllegalArgumentException {
            ArgsHelper.checkNumericArgs("EXP", params, 1);
            if (params[0] == null) {
                return null;
            }
            double d = StrictMath.exp(ArgsHelper.doubleVal(params[0]));
            return new Double(d);
        }
    }

    public static class COS
    implements IFunction {
        @Override
        public Object invoke(Object[] params) throws IllegalArgumentException {
            ArgsHelper.checkNumericArgs("COS", params, 1);
            if (params[0] == null) {
                return null;
            }
            double d = StrictMath.cos(ArgsHelper.doubleVal(params[0]));
            return new Double(d);
        }
    }

    public static class CEILING
    implements IFunction {
        @Override
        public Object invoke(Object[] params) throws IllegalArgumentException {
            ArgsHelper.checkNumericArgs("CEILING", params, 1);
            if (params[0] == null) {
                return null;
            }
            double d = StrictMath.ceil(ArgsHelper.doubleVal(params[0]));
            return new Integer((int)d);
        }
    }

    public static class ATN2
    implements IFunction {
        @Override
        public Object invoke(Object[] params) throws IllegalArgumentException {
            ArgsHelper.checkNumericArgs("ATN2", params, 2);
            if (params[0] == null || params[1] == null) {
                return null;
            }
            double d = StrictMath.atan2(ArgsHelper.doubleVal(params[0]), ArgsHelper.doubleVal(params[1]));
            return new Double(d);
        }
    }

    public static class ATAN
    implements IFunction {
        @Override
        public Object invoke(Object[] params) throws IllegalArgumentException {
            ArgsHelper.checkNumericArgs("ATAN", params, 1);
            if (params[0] == null) {
                return null;
            }
            double d = StrictMath.atan(ArgsHelper.doubleVal(params[0]));
            return new Double(d);
        }
    }

    public static class ASIN
    implements IFunction {
        @Override
        public Object invoke(Object[] params) throws IllegalArgumentException {
            ArgsHelper.checkNumericArgs("ASIN", params, 1);
            if (params[0] == null) {
                return null;
            }
            double d = StrictMath.asin(ArgsHelper.doubleVal(params[0]));
            return new Double(d);
        }
    }

    public static class ACOS
    implements IFunction {
        @Override
        public Object invoke(Object[] params) throws IllegalArgumentException {
            ArgsHelper.checkNumericArgs("ACOS", params, 1);
            if (params[0] == null) {
                return null;
            }
            double d = StrictMath.acos(ArgsHelper.doubleVal(params[0]));
            return new Double(d);
        }
    }

    public static class MOD
    implements IFunction {
        @Override
        public Object invoke(Object[] params) throws IllegalArgumentException {
            ArgsHelper.checkNumericArgs("MOD", params, 2);
            if (params[0] == null) {
                return null;
            }
            if (params[1] == null) {
                return params[0];
            }
            Class<?> class1 = params[0].getClass();
            Class<?> class2 = params[1].getClass();
            if (ArgsHelper.isIntegerLikedType(class1) && ArgsHelper.isIntegerLikedType(class2)) {
                int val = ((Number)params[0]).intValue() % ((Number)params[1]).intValue();
                return ArgsHelper.getNumber(val, ArgsHelper.getSmallerType(class1, class2));
            }
            throw new IllegalArgumentException("MOD only accept type of integer-liked argement.");
        }
    }

    public static class ABS
    implements IFunction {
        @Override
        public Object invoke(Object[] params) throws IllegalArgumentException {
            ArgsHelper.checkNumericArgs("ABS", params, 1);
            if (Functions.prosessNull(params) == null) {
                return null;
            }
            if (params[0] instanceof BigDecimal) {
                return ((BigDecimal)params[0]).abs();
            }
            double val = ((Number)params[0]).doubleValue();
            return val > 0.0 ? params[0] : ArgsHelper.getNumber(-val, params[0].getClass());
        }
    }
}

