/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.etl.base;

import com.kingdee.bos.ctrl.etl.base.Row;
import com.kingdee.bos.ctrl.etl.exception.ETLDatabaseException;
import com.kingdee.bos.ctrl.etl.exception.ETLException;
import com.kingdee.bos.ctrl.etl.exception.ETLXMLException;
import com.kingdee.bos.ctrl.etl.repository.Repository;
import com.kingdee.bos.ctrl.etl.util.Const;
import com.kingdee.bos.ctrl.etl.util.XMLHandler;
import com.kingdee.bos.ctrl.etl.util.XMLInterface;
import com.kingdee.bos.ctrl.etl.value.Value;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.regex.Pattern;
import org.w3c.dom.Node;

public class Condition
implements Cloneable,
XMLInterface {
    public static final String[] operators = new String[]{"-", "OR", "AND", "NOT", "OR NOT", "AND NOT", "XOR"};
    public static final int OPERATOR_NONE = 0;
    public static final int OPERATOR_OR = 1;
    public static final int OPERATOR_AND = 2;
    public static final int OPERATOR_NOT = 3;
    public static final int OPERATOR_OR_NOT = 4;
    public static final int OPERATOR_AND_NOT = 5;
    public static final int OPERATOR_XOR = 6;
    public static final String[] functions = new String[]{"=", "<>", "<", "<=", ">", ">=", "REGEXP", "IS NULL", "IS NOT NULL", "IN LIST", "CONTAINS", "STARTS WITH", "ENDS WITH"};
    public static final int FUNC_EQUAL = 0;
    public static final int FUNC_NOT_EQUAL = 1;
    public static final int FUNC_SMALLER = 2;
    public static final int FUNC_SMALLER_EQUAL = 3;
    public static final int FUNC_LARGER = 4;
    public static final int FUNC_LARGER_EQUAL = 5;
    public static final int FUNC_REGEXP = 6;
    public static final int FUNC_NULL = 7;
    public static final int FUNC_NOT_NULL = 8;
    public static final int FUNC_IN_LIST = 9;
    public static final int FUNC_CONTAINS = 10;
    public static final int FUNC_STARTS_WITH = 11;
    public static final int FUNC_ENDS_WITH = 12;
    private long id = -1L;
    private boolean negate = false;
    private int operator = 0;
    private String left_valuename;
    private int function;
    private String right_valuename;
    private Value right_exact;
    private long id_right_exact;
    private int left_fieldnr = -1;
    private int right_fieldnr = -1;
    private ArrayList list = new ArrayList();

    public Condition() {
    }

    public Condition(String valuename, int function, String valuename2, Value exact) {
        this();
        this.left_valuename = valuename;
        this.function = function;
        this.right_valuename = valuename2;
        this.right_exact = exact;
        this.clearFieldPositions();
    }

    public Condition(int operator, String valuename, int function, String valuename2, Value exact) {
        this();
        this.operator = operator;
        this.left_valuename = valuename;
        this.function = function;
        this.right_valuename = valuename2;
        this.right_exact = exact;
        this.clearFieldPositions();
    }

    public Condition(boolean negate, String valuename, int function, String valuename2, Value exact) {
        this(valuename, function, valuename2, exact);
        this.negate = negate;
    }

    public long getID() {
        return this.id;
    }

    public void setID(long id) {
        this.id = id;
    }

    public Object clone() {
        Condition retval = null;
        retval = new Condition();
        retval.negate = this.negate;
        retval.operator = this.operator;
        if (this.isComposite()) {
            for (int i = 0; i < this.nrConditions(); ++i) {
                Condition c = this.getCondition(i);
                Condition cCopy = (Condition)c.clone();
                retval.addCondition(cCopy);
            }
        } else {
            retval.negate = this.negate;
            retval.left_valuename = this.left_valuename;
            retval.operator = this.operator;
            retval.right_valuename = this.right_valuename;
            retval.function = this.function;
            retval.right_exact = this.right_exact != null ? (Value)this.right_exact.clone() : null;
        }
        return retval;
    }

    public void setOperator(int operator) {
        this.operator = operator;
    }

    public int getOperator() {
        return this.operator;
    }

    public String getOperatorDesc() {
        return Const.rightPad(operators[this.operator], 7);
    }

    public static final int getOperator(String description) {
        if (description == null) {
            return 0;
        }
        for (int i = 1; i < operators.length; ++i) {
            if (!operators[i].equalsIgnoreCase(Const.trim(description))) continue;
            return i;
        }
        return 0;
    }

    public static final String[] getOperators() {
        String[] retval = new String[operators.length - 1];
        for (int i = 1; i < operators.length; ++i) {
            retval[i - 1] = operators[i];
        }
        return retval;
    }

    public static final String[] getRealOperators() {
        return new String[]{"OR", "AND", "OR NOT", "AND NOT", "XOR"};
    }

    public void setLeftValuename(String left_valuename) {
        this.left_valuename = left_valuename;
    }

    public String getLeftValuename() {
        return this.left_valuename;
    }

    public int getFunction() {
        return this.function;
    }

    public void setFunction(int function) {
        this.function = function;
    }

    public String getFunctionDesc() {
        return functions[this.function];
    }

    public static final int getFunction(String description) {
        for (int i = 1; i < functions.length; ++i) {
            if (!functions[i].equalsIgnoreCase(Const.trim(description))) continue;
            return i;
        }
        return 0;
    }

    public void setRightValuename(String right_valuename) {
        this.right_valuename = right_valuename;
    }

    public String getRightValuename() {
        return this.right_valuename;
    }

    public void setRightExact(Value right_exact) {
        this.right_exact = right_exact;
    }

    public Value getRightExact() {
        return this.right_exact;
    }

    public String getRightExactString() {
        if (this.right_exact == null) {
            return null;
        }
        return this.right_exact.toString();
    }

    public long getRightExactID() {
        return this.id_right_exact;
    }

    public void setRightExactID(long id_right_exact) {
        this.id_right_exact = id_right_exact;
    }

    public boolean isAtomic() {
        return this.list.size() == 0;
    }

    public boolean isComposite() {
        return this.list.size() != 0;
    }

    public boolean isNegated() {
        return this.negate;
    }

    public void setNegated(boolean negate) {
        this.negate = negate;
    }

    public void negate() {
        this.setNegated(!this.isNegated());
    }

    public boolean isEmpty() {
        return this.isAtomic() && this.left_valuename == null;
    }

    public void clearFieldPositions() {
        this.left_fieldnr = -1;
        this.right_fieldnr = -1;
    }

    public boolean evaluate(Row r) {
        String debug = "Start of evaluate";
        boolean retval = false;
        try {
            if (this.isAtomic()) {
                debug = "Atomic : get fieldnrs left value";
                if (this.left_valuename != null && this.left_valuename.length() > 0 && this.left_fieldnr < 0) {
                    this.left_fieldnr = r.searchValueIndex(this.left_valuename);
                }
                debug = "Atomic : get fieldnrs right value";
                if (this.right_valuename != null && this.right_valuename.length() > 0 && this.right_fieldnr < 0) {
                    this.right_fieldnr = r.searchValueIndex(this.right_valuename);
                }
                debug = "Atomic : get fieldnrs left field";
                Value field = null;
                if (this.left_fieldnr >= 0) {
                    field = r.getValue(this.left_fieldnr);
                }
                debug = "Atomic : get fieldnrs right exact";
                Value field2 = this.right_exact;
                if (field2 == null && this.right_fieldnr >= 0) {
                    field2 = r.getValue(this.right_fieldnr);
                }
                debug = "Atomic : evaluate (function=" + functions[this.function] + ")";
                if (field != null && field2 != null) {
                    switch (this.function) {
                        case 0: {
                            retval = field.compare(field2) == 0;
                            break;
                        }
                        case 1: {
                            retval = field.compare(field2) != 0;
                            break;
                        }
                        case 2: {
                            retval = field.compare(field2) < 0;
                            break;
                        }
                        case 3: {
                            retval = field.compare(field2) <= 0;
                            break;
                        }
                        case 4: {
                            retval = field.compare(field2) > 0;
                            break;
                        }
                        case 5: {
                            retval = field.compare(field2) >= 0;
                            break;
                        }
                        case 6: {
                            retval = Pattern.matches(field2.getString(), field.getString());
                            break;
                        }
                        case 7: {
                            retval = field.isNull();
                            break;
                        }
                        case 8: {
                            retval = !field.isNull();
                            break;
                        }
                        case 9: {
                            String[] list = Const.splitString(field2.getString(), ";");
                            retval = Const.indexOfString(field.getString(), list) >= 0;
                            break;
                        }
                        case 10: {
                            retval = field.getString() != null ? field.getString().indexOf(field2.getString()) >= 0 : false;
                            break;
                        }
                        case 11: {
                            retval = field.getString() != null ? field.getString().startsWith(field2.getString()) : false;
                            break;
                        }
                        case 12: {
                            retval = field.getString() != null ? field.getString().endsWith(field2.getString()) : false;
                            break;
                        }
                    }
                }
                if (this.isNegated()) {
                    retval = !retval;
                }
            } else {
                debug = "Composite : get first";
                Condition cb0 = (Condition)this.list.get(0);
                retval = cb0.evaluate(r);
                block24: for (int i = 1; i < this.list.size(); ++i) {
                    debug = "Composite : evaluate #" + i;
                    Condition cb = (Condition)this.list.get(i);
                    boolean cmp = cb.evaluate(r);
                    switch (cb.getOperator()) {
                        case 1: {
                            retval = retval || cmp;
                            continue block24;
                        }
                        case 2: {
                            retval = retval && cmp;
                            continue block24;
                        }
                        case 4: {
                            retval = retval || !cmp;
                            continue block24;
                        }
                        case 5: {
                            retval = retval && !cmp;
                            continue block24;
                        }
                        case 6: {
                            retval ^= cmp;
                            continue block24;
                        }
                    }
                }
                if (this.isNegated()) {
                    retval = !retval;
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Unexpected error evaluation condition [" + this.toString() + "] in part [" + debug + "] for row: " + r + Const.CR + e.toString());
        }
        return retval;
    }

    public void addCondition(Condition cb) {
        if (this.isAtomic() && this.getLeftValuename() != null) {
            Condition current = new Condition(this.getLeftValuename(), this.getFunction(), this.getRightValuename(), this.getRightExact());
            current.setNegated(this.isNegated());
            this.setNegated(false);
            this.list.add(current);
        } else if (this.isComposite() && this.list.size() > 0 && cb.getOperator() == 0) {
            cb.setOperator(2);
        }
        this.list.add(cb);
    }

    public void addCondition(int idx, Condition cb) {
        if (this.isAtomic() && this.getLeftValuename() != null) {
            Condition current = new Condition(this.getLeftValuename(), this.getFunction(), this.getRightValuename(), this.getRightExact());
            current.setNegated(this.isNegated());
            this.setNegated(false);
            this.list.add(current);
        } else if (this.isComposite() && idx > 0 && cb.getOperator() == 0) {
            cb.setOperator(2);
        }
        this.list.add(idx, cb);
    }

    public void removeCondition(int nr) {
        if (this.isComposite()) {
            boolean moveUp;
            Condition c = (Condition)this.list.get(nr);
            this.list.remove(nr);
            boolean bl = moveUp = this.isAtomic() || this.nrConditions() == 1;
            if (this.nrConditions() == 1) {
                c = this.getCondition(0);
            }
            if (moveUp) {
                this.setLeftValuename(c.getLeftValuename());
                this.setFunction(c.getFunction());
                this.setRightValuename(c.getRightValuename());
                this.setRightExact(c.getRightExact());
                this.setNegated(c.isNegated());
            }
        }
    }

    public int nrConditions() {
        return this.list.size();
    }

    public Condition getCondition(int i) {
        return (Condition)this.list.get(i);
    }

    public void setCondition(int i, Condition subCondition) {
        this.list.set(i, subCondition);
    }

    public String toString() {
        return this.toString(0, true, true);
    }

    public String toString(int level, boolean show_negate, boolean show_operator) {
        String retval = "";
        if (this.isAtomic()) {
            for (int i = 0; i < level; ++i) {
                retval = retval + "  ";
            }
            retval = show_operator && this.getOperator() != 0 ? retval + this.getOperatorDesc() + " " : retval + "        ";
            retval = this.isNegated() && (show_negate || level > 0) ? retval + "NOT ( " : retval + "      ";
            retval = retval + this.left_valuename + " " + this.getFunctionDesc();
            if (this.function != 7 && this.function != 8) {
                retval = this.right_valuename != null ? retval + " " + this.right_valuename : retval + " [" + (this.getRightExactString() == null ? "" : this.getRightExactString()) + "]";
            }
            if (this.isNegated() && (show_negate || level > 0)) {
                retval = retval + " )";
            }
            retval = retval + Const.CR;
        } else {
            int i;
            if (this.isNegated() && (show_negate || level > 0)) {
                for (i = 0; i < level; ++i) {
                    retval = retval + "  ";
                }
                retval = retval + "NOT" + Const.CR;
            }
            if (this.getOperator() != 0 && (show_operator || level > 0)) {
                for (i = 0; i < level; ++i) {
                    retval = retval + "  ";
                }
                retval = retval + this.getOperatorDesc() + Const.CR;
            }
            for (i = 0; i < level; ++i) {
                retval = retval + "  ";
            }
            retval = retval + "(" + Const.CR;
            for (i = 0; i < this.list.size(); ++i) {
                Condition cb = (Condition)this.list.get(i);
                retval = retval + cb.toString(level + 1, true, i > 0);
            }
            for (i = 0; i < level; ++i) {
                retval = retval + "  ";
            }
            retval = retval + ")" + Const.CR;
        }
        return retval;
    }

    @Override
    public String getXML() {
        return this.getXML(0);
    }

    public String getXML(int level) {
        String retval = "";
        String indent1 = Const.rightPad(" ", level);
        String indent2 = Const.rightPad(" ", level + 1);
        String indent3 = Const.rightPad(" ", level + 2);
        retval = retval + indent1 + "<condition>" + Const.CR;
        retval = retval + indent2 + XMLHandler.addTagValue("negated", this.isNegated());
        if (this.getOperator() != 0) {
            retval = retval + indent2 + XMLHandler.addTagValue("operator", Const.rtrim(this.getOperatorDesc()));
        }
        if (this.isAtomic()) {
            retval = retval + indent2 + XMLHandler.addTagValue("leftvalue", this.getLeftValuename());
            retval = retval + indent2 + XMLHandler.addTagValue("function", this.getFunctionDesc());
            retval = retval + indent2 + XMLHandler.addTagValue("rightvalue", this.getRightValuename());
            if (this.getRightExact() != null) {
                retval = retval + "<value>  ";
                retval = retval + indent2 + this.getRightExact().getXML();
                retval = retval + "  </value>";
            }
        } else {
            retval = retval + indent2 + "<conditions>" + Const.CR;
            for (int i = 0; i < this.nrConditions(); ++i) {
                Condition c = this.getCondition(i);
                retval = retval + c.getXML(level + 2);
            }
            retval = retval + indent3 + "</conditions>" + Const.CR;
        }
        retval = retval + indent2 + "</condition>" + Const.CR;
        return retval;
    }

    public Condition(Node condnode) throws ETLXMLException {
        this();
        this.list = new ArrayList();
        try {
            String str_negated = XMLHandler.getTagValue(condnode, "negated");
            this.setNegated("Y".equalsIgnoreCase(str_negated));
            String str_operator = XMLHandler.getTagValue(condnode, "operator");
            this.setOperator(Condition.getOperator(str_operator));
            Node conditions = XMLHandler.getSubNode(condnode, "conditions");
            int nrconditions = XMLHandler.countNodes(conditions, "condition");
            if (nrconditions == 0) {
                this.setLeftValuename(XMLHandler.getTagValue(condnode, "leftvalue"));
                this.setFunction(Condition.getFunction(XMLHandler.getTagValue(condnode, "function")));
                this.setRightValuename(XMLHandler.getTagValue(condnode, "rightvalue"));
                Node exactnode = XMLHandler.getSubNode(condnode, "value");
                if (exactnode != null) {
                    Value exact = new Value(exactnode);
                    this.setRightExact(exact);
                }
            } else {
                for (int i = 0; i < nrconditions; ++i) {
                    Node subcondnode = XMLHandler.getSubNodeByNr(conditions, "condition", i);
                    Condition c = new Condition(subcondnode);
                    this.addCondition(c);
                }
            }
        }
        catch (Exception e) {
            throw new ETLXMLException("Unable to create condition using xml: " + Const.CR + condnode, e);
        }
    }

    public Condition(Repository rep, long id_condition) throws ETLException {
        this();
        this.list = new ArrayList();
        try {
            Row r = rep.getCondition(id_condition);
            this.negate = r.getBoolean("NEGATED", false);
            this.operator = Condition.getOperator(r.getString("OPERATOR", null));
            this.id = r.getInteger("ID_CONDITION", -1L);
            long[] subids = rep.getSubConditionIDs(this.id);
            if (subids.length == 0) {
                this.left_valuename = r.getString("LEFT_NAME", null);
                this.function = Condition.getFunction(r.getString("CONDITION_FUNCTION", null));
                this.right_valuename = r.getString("RIGHT_NAME", null);
                long id_value = r.getInteger("ID_VALUE_RIGHT", -1L);
                if (id_value > 0L) {
                    Value v;
                    this.right_exact = v = new Value(rep, id_value);
                }
            } else {
                for (int i = 0; i < subids.length; ++i) {
                    this.addCondition(new Condition(rep, subids[i]));
                }
            }
        }
        catch (ETLDatabaseException dbe) {
            throw new ETLException("Error loading condition from the repository (id_condition=" + id_condition + ")", dbe);
        }
    }

    public long saveRep(Repository rep) throws ETLException {
        return this.saveRep(0L, rep);
    }

    public long saveRep(long id_condition_parent, Repository rep) throws ETLException {
        try {
            this.id = rep.insertCondition(id_condition_parent, this);
            for (int i = 0; i < this.nrConditions(); ++i) {
                Condition subc = this.getCondition(i);
                subc.saveRep(this.getID(), rep);
            }
            return this.getID();
        }
        catch (ETLDatabaseException dbe) {
            throw new ETLException("Error saving condition to the repository.", dbe);
        }
    }

    public String[] getUsedFields() {
        Hashtable fields = new Hashtable();
        this.getUsedFields(fields);
        String[] retval = new String[fields.size()];
        Enumeration keys = fields.keys();
        int i = 0;
        while (keys.hasMoreElements()) {
            retval[i] = (String)keys.nextElement();
            ++i;
        }
        return retval;
    }

    public void getUsedFields(Hashtable fields) {
        if (this.isAtomic()) {
            if (this.getLeftValuename() != null) {
                fields.put(this.getLeftValuename(), "-");
            }
            if (this.getRightValuename() != null) {
                fields.put(this.getRightValuename(), "-");
            }
        } else {
            for (int i = 0; i < this.nrConditions(); ++i) {
                Condition subc = this.getCondition(i);
                subc.getUsedFields(fields);
            }
        }
    }
}

