/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.etl.base;

import com.kingdee.bos.ctrl.etl.base.Row;
import com.kingdee.bos.ctrl.etl.exception.ETLDatabaseException;
import com.kingdee.bos.ctrl.etl.exception.ETLException;
import com.kingdee.bos.ctrl.etl.exception.ETLXMLException;
import com.kingdee.bos.ctrl.etl.repository.Repository;
import com.kingdee.bos.ctrl.etl.util.Const;
import com.kingdee.bos.ctrl.etl.util.LogWriter;
import com.kingdee.bos.ctrl.etl.util.Point;
import com.kingdee.bos.ctrl.etl.util.XMLHandler;
import com.kingdee.bos.ctrl.etl.util.XMLInterface;
import org.w3c.dom.Node;

public class NotePadMeta
implements Cloneable,
XMLInterface {
    private String note;
    private Point location;
    public int width;
    public int height;
    private boolean selected;
    private boolean changed;
    private long id;

    public NotePadMeta() {
        this.note = null;
        this.location = null;
        this.width = -1;
        this.height = -1;
        this.selected = false;
    }

    public NotePadMeta(String n, int xl, int yl, int w, int h) {
        this.note = n;
        this.location = new Point(xl, yl);
        this.width = w;
        this.height = h;
        this.selected = false;
    }

    public NotePadMeta(Node notepadnode) throws ETLXMLException {
        try {
            this.note = XMLHandler.getTagValue(notepadnode, "note");
            String sxloc = XMLHandler.getTagValue(notepadnode, "xloc");
            String syloc = XMLHandler.getTagValue(notepadnode, "yloc");
            String swidth = XMLHandler.getTagValue(notepadnode, "width");
            String sheight = XMLHandler.getTagValue(notepadnode, "heigth");
            int x = Const.toInt(sxloc, 0);
            int y = Const.toInt(syloc, 0);
            this.location = new Point(x, y);
            this.width = Const.toInt(swidth, 0);
            this.height = Const.toInt(sheight, 0);
            this.selected = false;
        }
        catch (Exception e) {
            throw new ETLXMLException("Unable to read Notepad info from XML", e);
        }
    }

    public NotePadMeta(LogWriter log, Repository rep, long id_note) throws ETLException {
        this.readRep(log, rep, id_note);
    }

    private void readRep(LogWriter log, Repository rep, long id_note) throws ETLException {
        try {
            this.setID(id_note);
            Row r = rep.getNote(id_note);
            if (r == null) {
                this.setID(-1L);
                throw new ETLException("I couldn't find Notepad with id_note=" + id_note + " in the repository.");
            }
            this.note = r.getString("VALUE_STR", "");
            int x = (int)r.getInteger("GUI_LOCATION_X", 0L);
            int y = (int)r.getInteger("GUI_LOCATION_Y", 0L);
            this.location = new Point(x, y);
            this.width = (int)r.getInteger("GUI_LOCATION_WIDTH", 0L);
            this.height = (int)r.getInteger("GUI_LOCATION_HEIGHT", 0L);
            this.selected = false;
        }
        catch (ETLDatabaseException dbe) {
            this.setID(-1L);
            throw new ETLException("Unable to load Notepad from repository (id_note=" + id_note + ")", dbe);
        }
    }

    public void saveRep(Repository rep, long id_transformation) throws ETLException {
        try {
            int x = this.location == null ? -1 : this.location.x;
            int y = this.location == null ? -1 : this.location.y;
            this.setID(rep.insertNote(this.note, x, y, this.width, this.height));
        }
        catch (ETLDatabaseException dbe) {
            throw new ETLException("Unable to save notepad in repository (id_transformation=" + id_transformation + ")", dbe);
        }
    }

    public long getID() {
        return this.id;
    }

    public void setID(long id) {
        this.id = id;
    }

    public void setLocation(int x, int y) {
        if (x != this.location.x || y != this.location.y) {
            this.setChanged();
        }
        this.location.x = x;
        this.location.y = y;
    }

    public void setLocation(Point p) {
        this.setLocation(p.x, p.y);
    }

    public Point getLocation() {
        return this.location;
    }

    public String getNote() {
        return this.note;
    }

    public void setNote(String note) {
        this.note = note;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public void flipSelected() {
        this.selected = !this.selected;
    }

    public Object clone() {
        try {
            Object retval = super.clone();
            return retval;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public void setChanged() {
        this.setChanged(true);
    }

    public void setChanged(boolean ch) {
        this.changed = ch;
    }

    public boolean hasChanged() {
        return this.changed;
    }

    public String toString() {
        return this.note;
    }

    @Override
    public String getXML() {
        String retval = "";
        retval = retval + "    <notepad>" + Const.CR;
        retval = retval + "      " + XMLHandler.addTagValue("note", this.note);
        retval = retval + "      " + XMLHandler.addTagValue("xloc", this.location.x);
        retval = retval + "      " + XMLHandler.addTagValue("yloc", this.location.y);
        retval = retval + "      " + XMLHandler.addTagValue("width", this.width);
        retval = retval + "      " + XMLHandler.addTagValue("heigth", this.height);
        retval = retval + "      </notepad>" + Const.CR;
        return retval;
    }
}

