/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.etl.database;

import com.kingdee.bos.ctrl.etl.database.BaseDatabaseMeta;
import com.kingdee.bos.ctrl.etl.database.DatabaseInterface;
import com.kingdee.bos.ctrl.etl.util.Const;
import com.kingdee.bos.ctrl.etl.value.Value;

public class DB2DatabaseMeta
extends BaseDatabaseMeta
implements DatabaseInterface {
    public DB2DatabaseMeta(String name, String access, String host, String db, int port, String user, String pass) {
        super(name, access, host, db, port, user, pass);
    }

    public DB2DatabaseMeta() {
    }

    @Override
    public String getDatabaseTypeDesc() {
        return "DB2";
    }

    @Override
    public String getDatabaseTypeDescLong() {
        return "IBM DB2";
    }

    @Override
    public int getDatabaseType() {
        return 8;
    }

    @Override
    public int[] getAccessTypeList() {
        return new int[]{0, 1};
    }

    @Override
    public int getDefaultDatabasePort() {
        if (this.getAccessType() == 0) {
            return 50000;
        }
        return -1;
    }

    @Override
    public boolean supportsSetCharacterStream() {
        return false;
    }

    @Override
    public String getDriverClass() {
        if (this.getAccessType() == 1) {
            return "sun.jdbc.odbc.JdbcOdbcDriver";
        }
        return "com.ibm.db2.jcc.DB2Driver";
    }

    @Override
    public String getURL() {
        if (this.getAccessType() == 1) {
            return "jdbc:odbc:" + this.getDatabaseName();
        }
        return "jdbc:db2://" + this.getHostname() + ":" + this.getDatabasePortNumber() + "/" + this.getDatabaseName();
    }

    @Override
    public boolean supportsSchemas() {
        return false;
    }

    @Override
    public String getTruncateTableStatement(String tableName) {
        return "ALTER TABLE " + tableName + " ACTIVATE NOT LOGGED INITIALLY WITH EMPTY TABLE";
    }

    @Override
    public String getAddColumnStatement(String tablename, Value v, String tk, boolean use_autoinc, String pk, boolean semicolon) {
        return "ALTER TABLE " + tablename + " ADD COLUMN " + this.getFieldDefinition(v, tk, pk, use_autoinc, true, false);
    }

    @Override
    public String getDropColumnStatement(String tablename, Value v, String tk, boolean use_autoinc, String pk, boolean semicolon) {
        return "ALTER TABLE " + tablename + " DROP COLUMN " + v.getName() + Const.CR;
    }

    @Override
    public String getModifyColumnStatement(String tablename, Value v, String tk, boolean use_autoinc, String pk, boolean semicolon) {
        String retval = "";
        retval = retval + "ALTER TABLE " + tablename + " DROP COLUMN " + v.getName() + Const.CR + ";" + Const.CR;
        retval = retval + "ALTER TABLE " + tablename + " ADD COLUMN " + this.getFieldDefinition(v, tk, pk, use_autoinc, true, false);
        return retval;
    }

    @Override
    public String getFieldDefinition(Value v, String tk, String pk, boolean use_autoinc, boolean add_fieldname, boolean add_cr) {
        String retval = "";
        String fieldname = v.getName();
        int length = v.getLength();
        int precision = v.getPrecision();
        if (add_fieldname) {
            retval = retval + fieldname + " ";
        }
        int type = v.getType();
        switch (type) {
            case 3: {
                retval = retval + "TIMESTAMP";
                break;
            }
            case 4: {
                retval = retval + "CHARACTER(1)";
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                if (fieldname.equalsIgnoreCase(tk) && use_autoinc) {
                    retval = retval + "BIGINT NOT NULL GENERATED ALWAYS AS IDENTITY (START WITH 0, INCREMENT BY 1, NOCACHE)";
                    break;
                }
                if (length > 0) {
                    retval = retval + "DECIMAL(" + length;
                    if (precision > 0) {
                        retval = retval + ", " + precision;
                    }
                    retval = retval + ")";
                    break;
                }
                retval = retval + "FLOAT";
                break;
            }
            case 2: {
                if (length >= 9999999) {
                    retval = retval + "CLOB";
                } else {
                    retval = retval + "VARCHAR";
                    retval = length > 0 ? retval + "(" + length : retval + "(";
                    retval = retval + ")";
                    break;
                }
            }
            default: {
                retval = retval + " UNKNOWN";
            }
        }
        if (add_cr) {
            retval = retval + Const.CR;
        }
        return retval;
    }

    @Override
    public String getSQLLockTables(String[] tableNames) {
        String sql = "";
        for (int i = 0; i < tableNames.length; ++i) {
            sql = sql + "LOCK TABLE " + tableNames[i] + " IN SHARE MODE;" + Const.CR;
        }
        return sql;
    }

    @Override
    public String getSQLUnlockTables(String[] tableName) {
        return null;
    }
}

