/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.etl.job;

import com.kingdee.bos.ctrl.etl.exception.ETLStepLoaderException;
import com.kingdee.bos.ctrl.etl.job.JobPlugin;
import com.kingdee.bos.ctrl.etl.job.entry.JobEntryInterface;
import com.kingdee.bos.ctrl.etl.util.Const;
import com.kingdee.bos.ctrl.etl.util.LogWriter;
import com.kingdee.bos.ctrl.etl.util.XMLHandler;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class JobEntryLoader {
    private static JobEntryLoader jobEntryLoader = null;
    private String[] pluginDirectory;
    private ArrayList pluginList;
    private Hashtable classLoaders;

    private JobEntryLoader(String[] plugin_directory) {
        this.pluginDirectory = plugin_directory;
        this.pluginList = new ArrayList();
        this.classLoaders = new Hashtable();
    }

    public static final JobEntryLoader getInstance(String[] pluginDirectory) {
        if (jobEntryLoader != null) {
            return jobEntryLoader;
        }
        jobEntryLoader = new JobEntryLoader(pluginDirectory);
        return jobEntryLoader;
    }

    public static final JobEntryLoader getInstance() {
        if (jobEntryLoader != null) {
            return jobEntryLoader;
        }
        jobEntryLoader = new JobEntryLoader(new String[]{Const.PLUGIN_JOBENTRIES_DIRECTORY_PUBLIC, Const.PLUGIN_JOBENTRIES_DIRECTORY_PRIVATE});
        return jobEntryLoader;
    }

    public boolean read() {
        if (this.readNatives()) {
            return this.readPlugins();
        }
        return false;
    }

    public boolean readNatives() {
        for (int i = 1; i < JobEntryInterface.type_desc.length; ++i) {
            String id = JobEntryInterface.type_desc[i];
            String long_desc = JobEntryInterface.type_desc_long[i];
            String tooltip = JobEntryInterface.type_tooltip_desc[i];
            String iconfile = "/be/ibridge/kettle/images/" + JobEntryInterface.icon_filename[i];
            String classname = JobEntryInterface.type_classname[i].getName();
            String directory = null;
            String[] jarfiles = null;
            JobPlugin sp = new JobPlugin(1, id, long_desc, tooltip, directory, jarfiles, iconfile, classname);
            this.pluginList.add(sp);
        }
        return true;
    }

    public boolean readPlugins() {
        for (int dirNr = 0; dirNr < this.pluginDirectory.length; ++dirNr) {
            try {
                File f = new File(this.pluginDirectory[dirNr]);
                if (!f.isDirectory() || !f.exists()) continue;
                LogWriter log = LogWriter.getInstance();
                log.logDetailed("JobEntryLoader", "Looking for plugins in directory: " + this.pluginDirectory[dirNr]);
                String[] dirs = f.list();
                for (int i = 0; i < dirs.length; ++i) {
                    String pixml;
                    File fpixml;
                    String piDir = this.pluginDirectory[dirNr] + Const.FILE_SEPARATOR + dirs[i];
                    File pi = new File(piDir);
                    if (!pi.isDirectory() || !(fpixml = new File(pixml = pi.toString() + Const.FILE_SEPARATOR + "plugin.xml")).canRead()) continue;
                    try {
                        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                        dbf.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
                        DocumentBuilder db = dbf.newDocumentBuilder();
                        Document doc = db.parse(fpixml);
                        Node plugin = XMLHandler.getSubNode(doc, "plugin");
                        String id = XMLHandler.getTagAttribute(plugin, "id");
                        String description = XMLHandler.getTagAttribute(plugin, "description");
                        String iconfile = XMLHandler.getTagAttribute(plugin, "iconfile");
                        String tooltip = XMLHandler.getTagAttribute(plugin, "tooltip");
                        String classname = XMLHandler.getTagAttribute(plugin, "classname");
                        Node libsnode = XMLHandler.getSubNode(plugin, "libraries");
                        int nrlibs = XMLHandler.countNodes(libsnode, "library");
                        String[] jarfiles = new String[nrlibs];
                        for (int j = 0; j < nrlibs; ++j) {
                            Node libnode = XMLHandler.getSubNodeByNr(libsnode, "library", j);
                            String jarfile = XMLHandler.getTagAttribute(libnode, "name");
                            jarfiles[j] = pi.toString() + Const.FILE_SEPARATOR + jarfile;
                        }
                        String iconFilename = pi.toString() + Const.FILE_SEPARATOR + iconfile;
                        JobPlugin sp = new JobPlugin(2, id, description, tooltip, dirs[i], jarfiles, iconFilename, classname);
                        if (this.findJobPluginWithID(id) == null) {
                            this.pluginList.add(sp);
                            continue;
                        }
                        int idx = this.pluginList.indexOf(sp);
                        this.pluginList.set(idx, sp);
                        continue;
                    }
                    catch (Exception e) {
                        return false;
                    }
                }
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return true;
    }

    public JobEntryInterface getJobEntryClass(String desc) throws ETLStepLoaderException {
        JobPlugin jp = this.findJobEntriesWithDescription(desc);
        return this.getJobEntryClass(jp);
    }

    public JobEntryInterface getJobEntryClass(JobPlugin sp) throws ETLStepLoaderException {
        if (sp != null) {
            try {
                Class<?> cl = null;
                switch (sp.getType()) {
                    case 1: {
                        cl = Class.forName(sp.getClassname());
                        break;
                    }
                    case 2: {
                        String[] jarfiles = sp.getJarfiles();
                        URL[] urls = new URL[jarfiles.length];
                        for (int i = 0; i < jarfiles.length; ++i) {
                            File jarfile = new File(jarfiles[i]);
                            urls[i] = jarfile.toURL();
                        }
                        ClassLoader classLoader = this.getClass().getClassLoader();
                        URLClassLoader ucl = (URLClassLoader)this.classLoaders.get(sp.getID());
                        if (ucl == null) {
                            ucl = new URLClassLoader(urls, classLoader);
                            this.classLoaders.put(sp.getID(), ucl);
                        }
                        cl = ucl.loadClass(sp.getClassname());
                        break;
                    }
                    default: {
                        throw new ETLStepLoaderException("Unknown plugin type : " + sp.getType());
                    }
                }
                return (JobEntryInterface)cl.newInstance();
            }
            catch (ClassNotFoundException e) {
                throw new ETLStepLoaderException("Class not found", e);
            }
            catch (InstantiationException e) {
                throw new ETLStepLoaderException("Unable to instantiate class", e);
            }
            catch (IllegalAccessException e) {
                throw new ETLStepLoaderException("Illegal access to class", e);
            }
            catch (MalformedURLException e) {
                throw new ETLStepLoaderException("Malformed URL", e);
            }
            catch (Throwable e) {
                throw new ETLStepLoaderException("Unexpected error loading class", e);
            }
        }
        throw new ETLStepLoaderException("No valid step/plugin specified.");
    }

    public int nrJobEntriesWithType(int type) {
        int nr = 0;
        for (int i = 0; i < this.pluginList.size(); ++i) {
            JobPlugin sp = (JobPlugin)this.pluginList.get(i);
            if (sp.getType() != type && type != 0) continue;
            ++nr;
        }
        return nr;
    }

    public JobPlugin getJobEntryWithType(int type, int index) {
        int nr = 0;
        for (int i = 0; i < this.pluginList.size(); ++i) {
            JobPlugin sp = (JobPlugin)this.pluginList.get(i);
            if (sp.getType() != type && type != 0) continue;
            if (nr == index) {
                return sp;
            }
            ++nr;
        }
        return null;
    }

    public JobPlugin findJobPluginWithID(String stepid) {
        for (int i = 0; i < this.pluginList.size(); ++i) {
            JobPlugin sp = (JobPlugin)this.pluginList.get(i);
            if (!sp.getID().equalsIgnoreCase(stepid)) continue;
            return sp;
        }
        return null;
    }

    public JobPlugin[] getJobEntriesWithType(int type) {
        int nr = this.nrJobEntriesWithType(type);
        JobPlugin[] steps = new JobPlugin[nr];
        for (int i = 0; i < steps.length; ++i) {
            JobPlugin sp;
            steps[i] = sp = this.getJobEntryWithType(type, i);
        }
        return steps;
    }

    public JobPlugin findJobEntriesWithID(String stepid) {
        for (int i = 0; i < this.pluginList.size(); ++i) {
            JobPlugin sp = (JobPlugin)this.pluginList.get(i);
            if (!sp.getID().equalsIgnoreCase(stepid)) continue;
            return sp;
        }
        return null;
    }

    public JobPlugin findJobEntriesWithDescription(String description) {
        for (int i = 0; i < this.pluginList.size(); ++i) {
            JobPlugin sp = (JobPlugin)this.pluginList.get(i);
            if (!sp.getDescription().equalsIgnoreCase(description)) continue;
            return sp;
        }
        return null;
    }

    public String getJobEntryID(JobEntryInterface jei) {
        for (int i = 0; i < this.nrJobEntriesWithType(0); ++i) {
            JobPlugin sp = this.getJobEntryWithType(0, i);
            if (sp.getClassname() != jei.getClass().getName()) continue;
            return sp.getID();
        }
        return null;
    }
}

