/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.etl.job.entry.job;

import com.kingdee.bos.ctrl.etl.base.Result;
import com.kingdee.bos.ctrl.etl.base.Row;
import com.kingdee.bos.ctrl.etl.exception.ETLDatabaseException;
import com.kingdee.bos.ctrl.etl.exception.ETLException;
import com.kingdee.bos.ctrl.etl.exception.ETLXMLException;
import com.kingdee.bos.ctrl.etl.job.Job;
import com.kingdee.bos.ctrl.etl.job.entry.JobEntryBase;
import com.kingdee.bos.ctrl.etl.job.entry.JobEntryInterface;
import com.kingdee.bos.ctrl.etl.job.entry.job.JobEntryJobRunner;
import com.kingdee.bos.ctrl.etl.repository.Repository;
import com.kingdee.bos.ctrl.etl.repository.RepositoryDirectory;
import com.kingdee.bos.ctrl.etl.util.LogWriter;
import com.kingdee.bos.ctrl.etl.util.XMLHandler;
import java.sql.Connection;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.List;
import org.w3c.dom.Node;

public class JobEntryJob
extends JobEntryBase
implements Cloneable,
JobEntryInterface {
    private String jobname;
    private String filename;
    private RepositoryDirectory directory;
    public String[] arguments;
    public boolean argFromPrevious;
    public boolean setLogfile;
    public String logfile;
    public String logext;
    public boolean addDate;
    public boolean addTime;
    public int loglevel;
    public boolean parallel;
    private String directoryPath;

    public JobEntryJob(String name) {
        super(name, "");
        this.setType(2);
    }

    public JobEntryJob() {
        this("");
        this.clear();
    }

    public JobEntryJob(JobEntryBase jeb) {
        super(jeb);
    }

    public void setFileName(String n) {
        this.filename = n;
    }

    public String getFileName() {
        return this.filename;
    }

    public void setJobName(String jobname) {
        this.jobname = jobname;
    }

    public String getJobName() {
        return this.jobname;
    }

    public RepositoryDirectory getDirectory() {
        return this.directory;
    }

    public void setDirectory(RepositoryDirectory directory) {
        this.directory = directory;
    }

    public String getLogFilename() {
        String retval = "";
        if (this.setLogfile) {
            SimpleDateFormat sdf;
            retval = retval + this.logfile;
            Calendar cal = Calendar.getInstance();
            if (this.addDate) {
                sdf = new SimpleDateFormat("yyyyMMdd");
                retval = retval + "_" + sdf.format(cal.getTime());
            }
            if (this.addTime) {
                sdf = new SimpleDateFormat("HHmmss");
                retval = retval + "_" + sdf.format(cal.getTime());
            }
            if (this.logext != null && this.logext.length() > 0) {
                retval = retval + "." + this.logext;
            }
        }
        return retval;
    }

    @Override
    public String getXML() {
        String retval = "";
        retval = retval + super.getXML();
        retval = retval + "      " + XMLHandler.addTagValue("filename", this.filename);
        retval = retval + "      " + XMLHandler.addTagValue("jobname", this.jobname);
        if (this.directory != null) {
            retval = retval + "      " + XMLHandler.addTagValue("directory", this.directory.getPath());
        } else if (this.directoryPath != null) {
            retval = retval + "      " + XMLHandler.addTagValue("directory", this.directoryPath);
        }
        retval = retval + "      " + XMLHandler.addTagValue("arg_from_previous", this.argFromPrevious);
        retval = retval + "      " + XMLHandler.addTagValue("set_logfile", this.setLogfile);
        retval = retval + "      " + XMLHandler.addTagValue("logfile", this.logfile);
        retval = retval + "      " + XMLHandler.addTagValue("logext", this.logext);
        retval = retval + "      " + XMLHandler.addTagValue("add_date", this.addDate);
        retval = retval + "      " + XMLHandler.addTagValue("add_time", this.addTime);
        retval = retval + "      " + XMLHandler.addTagValue("loglevel", LogWriter.getLogLevelDesc(this.loglevel));
        if (this.arguments != null) {
            for (int i = 0; i < this.arguments.length; ++i) {
                retval = retval + "      " + XMLHandler.addTagValue("argument" + i, this.arguments[i]);
            }
        }
        return retval;
    }

    @Override
    public void loadXML(Node entrynode, List databases, Connection ctxConnection) throws ETLXMLException {
        try {
            super.loadXML(entrynode, databases, ctxConnection);
            this.setFileName(XMLHandler.getTagValue(entrynode, "filename"));
            this.setJobName(XMLHandler.getTagValue(entrynode, "jobname"));
            this.argFromPrevious = "Y".equalsIgnoreCase(XMLHandler.getTagValue(entrynode, "arg_from_previous"));
            this.setLogfile = "Y".equalsIgnoreCase(XMLHandler.getTagValue(entrynode, "set_logfile"));
            this.addDate = "Y".equalsIgnoreCase(XMLHandler.getTagValue(entrynode, "add_date"));
            this.addTime = "Y".equalsIgnoreCase(XMLHandler.getTagValue(entrynode, "add_time"));
            this.logfile = XMLHandler.getTagValue(entrynode, "logfile");
            this.logext = XMLHandler.getTagValue(entrynode, "logext");
            this.loglevel = LogWriter.getLogLevel(XMLHandler.getTagValue(entrynode, "loglevel"));
            this.directoryPath = XMLHandler.getTagValue(entrynode, "directory");
            int argnr = 0;
            while (XMLHandler.getTagValue(entrynode, "argument" + argnr) != null) {
                ++argnr;
            }
            this.arguments = new String[argnr];
            for (int a = 0; a < argnr; ++a) {
                this.arguments[a] = XMLHandler.getTagValue(entrynode, "argument" + a);
            }
        }
        catch (ETLXMLException xe) {
            throw new ETLXMLException("Unable to load 'job' job entry from XML node", xe);
        }
    }

    @Override
    public void loadRep(Repository rep, long id_jobentry, List databases) throws ETLException {
        try {
            super.loadRep(rep, id_jobentry, databases);
            long id_job_attr = rep.getJobEntryAttributeInteger(id_jobentry, "id_job");
            Row r = rep.getJob(id_job_attr);
            if (r != null) {
                this.jobname = r.getString("NAME", null);
                long id_directory = r.getInteger("ID_DIRECTORY", 0L);
                this.directory = id_directory > 0L ? rep.getDirectoryTree().findDirectory(id_directory) : rep.getDirectoryTree();
            }
            this.filename = rep.getJobEntryAttributeString(id_jobentry, "filename");
            this.argFromPrevious = rep.getJobEntryAttributeBoolean(id_jobentry, "arg_from_previous");
            this.setLogfile = rep.getJobEntryAttributeBoolean(id_jobentry, "set_logfile");
            this.addDate = rep.getJobEntryAttributeBoolean(id_jobentry, "add_date");
            this.addTime = rep.getJobEntryAttributeBoolean(id_jobentry, "arg_time");
            this.logfile = rep.getJobEntryAttributeString(id_jobentry, "logfile");
            this.logext = rep.getJobEntryAttributeString(id_jobentry, "logext");
            this.loglevel = LogWriter.getLogLevel(rep.getJobEntryAttributeString(id_jobentry, "loglevel"));
            int argnr = rep.countNrJobEntryAttributes(id_jobentry, "argument");
            this.arguments = new String[argnr];
            for (int a = 0; a < argnr; ++a) {
                this.arguments[a] = rep.getJobEntryAttributeString(id_jobentry, a, "argument");
            }
        }
        catch (ETLDatabaseException dbe) {
            throw new ETLException("Unable to load job entry of type 'job' from the repository with id_jobentry=" + id_jobentry, dbe);
        }
    }

    @Override
    public void saveRep(Repository rep, long id_job) throws ETLException {
        try {
            super.saveRep(rep, id_job);
            long id_job_attr = rep.getJobID(this.jobname, this.directory.getID());
            rep.saveJobEntryAttribute(id_job, this.getID(), "id_job", id_job_attr);
            rep.saveJobEntryAttribute(id_job, this.getID(), "file_name", this.filename);
            rep.saveJobEntryAttribute(id_job, this.getID(), "arg_from_previous", this.argFromPrevious);
            rep.saveJobEntryAttribute(id_job, this.getID(), "set_logfile", this.setLogfile);
            rep.saveJobEntryAttribute(id_job, this.getID(), "add_date", this.addDate);
            rep.saveJobEntryAttribute(id_job, this.getID(), "add_time", this.addTime);
            rep.saveJobEntryAttribute(id_job, this.getID(), "logfile", this.logfile);
            rep.saveJobEntryAttribute(id_job, this.getID(), "logext", this.logext);
            rep.saveJobEntryAttribute(id_job, this.getID(), "loglevel", LogWriter.getLogLevelDesc(this.loglevel));
            if (this.arguments != null) {
                for (int i = 0; i < this.arguments.length; ++i) {
                    rep.saveJobEntryAttribute(id_job, this.getID(), (long)i, "argument", this.arguments[i]);
                }
            }
        }
        catch (ETLDatabaseException dbe) {
            throw new ETLException("Unable to save job entry of type job to the repository with id_job=" + id_job, dbe);
        }
    }

    @Override
    public Result execute(Result prev_result, int nr, Repository rep, Job parentJob) {
        LogWriter log = LogWriter.getInstance();
        Result result = prev_result;
        result.setEntryNr(nr);
        LogWriter logwriter = log;
        if (this.setLogfile) {
            logwriter = LogWriter.getInstance(this.getLogFilename(), true, this.loglevel);
        }
        Job job = new Job(logwriter, this.getName(), this.getFileName(), this.arguments);
        try {
            job.open(rep, this.getFileName(), this.getName(), this.directory.getPath());
            job.setJobEntryResults(parentJob.getJobEntryResults());
            JobEntryJobRunner runner = new JobEntryJobRunner(job, prev_result, nr);
            new Thread(runner).start();
            while (!runner.isFinished() && !parentJob.isStopped()) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
            if (parentJob.isStopped()) {
                job.stopAll();
                runner.waitUntilFinished();
                job.endProcessing("stop");
            } else {
                job.endProcessing("end");
            }
            result = runner.getResult();
        }
        catch (ETLException je) {
            log.logError(this.toString(), "Unable to open job entry job with name [" + this.getName() + "]");
            result.setNrErrors(1L);
        }
        if (this.setLogfile) {
            logwriter.close();
        }
        if (result.getNrErrors() > 0L) {
            result.setResult(false);
        } else {
            result.setResult(true);
        }
        return result;
    }

    @Override
    public void clear() {
        super.clear();
        this.jobname = null;
        this.filename = null;
        this.directory = new RepositoryDirectory();
        this.arguments = null;
        this.argFromPrevious = false;
        this.addDate = false;
        this.addTime = false;
        this.logfile = null;
        this.logext = null;
        this.setLogfile = false;
    }

    @Override
    public boolean evaluates() {
        return true;
    }

    @Override
    public boolean isUnconditional() {
        return true;
    }
}

