/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.etl.schedule.entry.timer;

import com.kingdee.bos.ctrl.etl.schedule.entry.timer.ETLScheduledTimerTask;
import com.kingdee.bos.ctrl.etl.util.LogWriter;
import java.util.Timer;

public class ETLTimerFactory {
    protected final LogWriter logger = LogWriter.getInstance();
    private ETLScheduledTimerTask[] scheduledTimerTasks;
    private boolean daemon = true;
    private Timer timer;

    public void setScheduledTimerTasks(ETLScheduledTimerTask[] scheduledTimerTasks) {
        this.scheduledTimerTasks = scheduledTimerTasks;
    }

    public void setDaemon(boolean daemon) {
        this.daemon = daemon;
    }

    public void afterPropertiesSet() {
        this.logger.logBasic("ETLTimerFactory", "Initializing Timer");
        this.timer = this.createTimer(this.daemon);
        for (int i = 0; i < this.scheduledTimerTasks.length; ++i) {
            ETLScheduledTimerTask scheduledTask = this.scheduledTimerTasks[i];
            if (scheduledTask.isFixedRate()) {
                this.timer.scheduleAtFixedRate(scheduledTask.getTimerTask(), scheduledTask.getDelay(), scheduledTask.getPeriod());
                continue;
            }
            this.timer.schedule(scheduledTask.getTimerTask(), scheduledTask.getDelay(), scheduledTask.getPeriod());
        }
    }

    protected Timer createTimer(boolean daemon) {
        return new Timer(daemon);
    }

    public Object getObject() {
        return this.timer;
    }

    public Class getObjectType() {
        return Timer.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void destroy() {
        this.logger.logBasic("ETLTimerFactory", "Cancelling Timer");
        this.timer.cancel();
    }
}

