/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.etl.schedule.ui;

import com.kingdee.bos.ctrl.etl.schedule.entry.cron.CronExpression;
import com.kingdee.bos.ctrl.etl.schedule.entry.cron.CronExpressionUtil;
import com.kingdee.bos.ctrl.etl.schedule.ui.AbstractEveryMonth;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDRadioButton;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.StringTokenizer;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class EveryMonth
extends AbstractEveryMonth {
    private static final long serialVersionUID = 1L;
    public static final String DAY = "day";
    public static final String WEEK = "week";

    public EveryMonth() throws Exception {
        this.initializeUI();
    }

    private void setEnable(boolean enable) {
        Component[] componentArray = this.getComponents();
        for (int i = 0; i <= componentArray.length - 1; ++i) {
            Component destComponent = componentArray[i];
            if (destComponent instanceof KDLabel) continue;
            destComponent.setEnabled(enable);
        }
    }

    private void setDayState() {
        this.dayRangekDSpinner.setEnabled(this.daykDRadioButton.isSelected());
    }

    private void setWeekState() {
        this.weekNumkDComboBox.setEnabled(this.weekkDRadioButton.isSelected());
        this.weekkDComboBox.setEnabled(this.weekkDRadioButton.isSelected());
    }

    private void setMonthState(boolean state) {
        this.januarykDCheckBox.setSelected(state);
        this.februarykDCheckBox.setSelected(state);
        this.marchkDCheckBox.setSelected(state);
        this.aprilkDCheckBox.setSelected(state);
        this.maykDCheckBox.setSelected(state);
        this.junekDCheckBox.setSelected(state);
        this.julykDCheckBox.setSelected(state);
        this.augustkDCheckBox.setSelected(state);
        this.septemberkDCheckBox.setSelected(state);
        this.octoberkDCheckBox.setSelected(state);
        this.novemberkDCheckBox.setSelected(state);
        this.decemberkDCheckBox.setSelected(state);
    }

    private void initializeUI() {
        this.dayRangekDSpinner.setModel((SpinnerModel)new SpinnerNumberModel(1, 1, 31, 1));
        this.dayRangekDSpinner.setEditable(false);
        this.weekNumkDComboBox.removeAllItems();
        Object[] items = new Object[]{"\u7b2c\u4e00\u5468", "\u7b2c\u4e8c\u5468", "\u7b2c\u4e09\u5468", "\u7b2c\u56db\u5468", "\u6700\u540e\u4e00\u5468"};
        this.weekNumkDComboBox.addItems(items);
        this.weekkDComboBox.removeAllItems();
        items = new Object[]{"\u661f\u671f\u5929", "\u661f\u671f\u4e00", "\u661f\u671f\u4e8c", "\u661f\u671f\u4e09", "\u661f\u671f\u56db", "\u661f\u671f\u4e94", "\u661f\u671f\u516d"};
        this.weekkDComboBox.addItems(items);
        this.setMonthState(true);
        this.daykDRadioButton.setSelected(true);
        this.setDayState();
        this.setWeekState();
        this.daykDRadioButton.addChangeListener((ChangeListener)new CommonChangeListener());
        this.weekkDRadioButton.addChangeListener((ChangeListener)new CommonChangeListener());
    }

    private String getWeekField() {
        String returnValue = "";
        returnValue = returnValue + String.valueOf(this.weekkDComboBox.getSelectedIndex() + 1) + "#" + String.valueOf(this.weekNumkDComboBox.getSelectedIndex() + 1);
        return returnValue;
    }

    private void setWeekField(String value) {
        String week = value.substring(0, value.indexOf(35));
        this.weekkDComboBox.setSelectedIndex(Integer.valueOf(week) - 1);
        String weeknumber = value.substring(value.indexOf(35) + 1);
        this.weekNumkDComboBox.setSelectedIndex(Integer.valueOf(weeknumber) - 1);
    }

    private String getMonthField() {
        String returnValue = "";
        if (this.januarykDCheckBox.isSelected()) {
            returnValue = returnValue + (returnValue.equalsIgnoreCase("") ? "1" : ",1");
        }
        if (this.februarykDCheckBox.isSelected()) {
            returnValue = returnValue + (returnValue.equalsIgnoreCase("") ? "2" : ",2");
        }
        if (this.marchkDCheckBox.isSelected()) {
            returnValue = returnValue + (returnValue.equalsIgnoreCase("") ? "3" : ",3");
        }
        if (this.aprilkDCheckBox.isSelected()) {
            returnValue = returnValue + (returnValue.equalsIgnoreCase("") ? "4" : ",4");
        }
        if (this.maykDCheckBox.isSelected()) {
            returnValue = returnValue + (returnValue.equalsIgnoreCase("") ? "5" : ",5");
        }
        if (this.junekDCheckBox.isSelected()) {
            returnValue = returnValue + (returnValue.equalsIgnoreCase("") ? "6" : ",6");
        }
        if (this.julykDCheckBox.isSelected()) {
            returnValue = returnValue + (returnValue.equalsIgnoreCase("") ? "7" : ",7");
        }
        if (this.augustkDCheckBox.isSelected()) {
            returnValue = returnValue + (returnValue.equalsIgnoreCase("") ? "8" : ",8");
        }
        if (this.septemberkDCheckBox.isSelected()) {
            returnValue = returnValue + (returnValue.equalsIgnoreCase("") ? "9" : ",9");
        }
        if (this.octoberkDCheckBox.isSelected()) {
            returnValue = returnValue + (returnValue.equalsIgnoreCase("") ? "10" : ",10");
        }
        if (this.novemberkDCheckBox.isSelected()) {
            returnValue = returnValue + (returnValue.equalsIgnoreCase("") ? "11" : ",11");
        }
        if (this.septemberkDCheckBox.isSelected()) {
            returnValue = returnValue + (returnValue.equalsIgnoreCase("") ? "12" : ",12");
        }
        if (returnValue == null || returnValue.length() == 0) {
            returnValue = "?";
        }
        return returnValue;
    }

    private void setMonthField(String value) {
        this.setMonthState(false);
        if (!value.trim().equalsIgnoreCase("?")) {
            StringTokenizer st = new StringTokenizer(value, ",");
            while (st.hasMoreTokens()) {
                String tkn = st.nextToken();
                int month = Integer.valueOf(tkn);
                switch (month) {
                    case 1: {
                        this.januarykDCheckBox.setSelected(true);
                        break;
                    }
                    case 2: {
                        this.februarykDCheckBox.setSelected(true);
                        break;
                    }
                    case 3: {
                        this.marchkDCheckBox.setSelected(true);
                        break;
                    }
                    case 4: {
                        this.aprilkDCheckBox.setSelected(true);
                        break;
                    }
                    case 5: {
                        this.maykDCheckBox.setSelected(true);
                        break;
                    }
                    case 6: {
                        this.junekDCheckBox.setSelected(true);
                        break;
                    }
                    case 7: {
                        this.julykDCheckBox.setSelected(true);
                        break;
                    }
                    case 8: {
                        this.augustkDCheckBox.setSelected(true);
                        break;
                    }
                    case 9: {
                        this.septemberkDCheckBox.setSelected(true);
                        break;
                    }
                    case 10: {
                        this.octoberkDCheckBox.setSelected(true);
                        break;
                    }
                    case 11: {
                        this.novemberkDCheckBox.setSelected(true);
                        break;
                    }
                    case 12: {
                        this.decemberkDCheckBox.setSelected(true);
                    }
                }
            }
        }
    }

    public String getSchedule() {
        String returnValue = "";
        Date beginTime = (Date)this.beginTimekDTimePicker.getValue();
        GregorianCalendar beginTimeC = new GregorianCalendar();
        beginTimeC.setTime(beginTime);
        returnValue = returnValue + String.valueOf(beginTimeC.get(13));
        returnValue = returnValue + " " + String.valueOf(beginTimeC.get(12));
        returnValue = returnValue + " " + String.valueOf(beginTimeC.get(11));
        returnValue = this.daykDRadioButton.isSelected() ? returnValue + " " + String.valueOf((Integer)this.dayRangekDSpinner.getValue()) : returnValue + " ?";
        returnValue = returnValue + " " + this.getMonthField();
        returnValue = this.weekkDRadioButton.isSelected() ? returnValue + " " + this.getWeekField() : returnValue + " ?";
        return returnValue;
    }

    public void setSchedule(String value, boolean readOnly) {
        CronExpression se = CronExpressionUtil.parseSchedule(value);
        if (se != null) {
            this.beginTimekDTimePicker.setValue((Object)se.getBeginTime());
            String dayofmonth = se.getDayofmonth();
            if (dayofmonth.equalsIgnoreCase("?")) {
                this.weekkDRadioButton.setSelected(true);
                this.setWeekField(se.getDayofweek());
            } else {
                this.daykDRadioButton.setSelected(true);
                this.dayRangekDSpinner.setValue((Object)Integer.valueOf(dayofmonth));
            }
            this.setMonthField(se.getMonth());
        }
        this.setEnable(!readOnly);
    }

    private class CommonChangeListener
    implements ChangeListener {
        private CommonChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            try {
                String tempRBAC = ((KDRadioButton)e.getSource()).getActionCommand();
                if (tempRBAC.equalsIgnoreCase(EveryMonth.DAY)) {
                    EveryMonth.this.setDayState();
                }
                if (tempRBAC.equalsIgnoreCase(EveryMonth.WEEK)) {
                    EveryMonth.this.setWeekState();
                }
            }
            catch (Exception error) {
                error.printStackTrace();
            }
        }
    }

    private class CommonActionListener
    implements ActionListener {
        private CommonActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                if (EveryMonth.DAY.equalsIgnoreCase(e.getActionCommand())) {
                    EveryMonth.this.setDayState();
                }
                if (EveryMonth.WEEK.equalsIgnoreCase(e.getActionCommand())) {
                    EveryMonth.this.setWeekState();
                }
            }
            catch (Exception error) {
                error.printStackTrace();
            }
        }
    }
}

