/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.etl.server;

import com.kingdee.bos.ctrl.etl.base.IContext;
import com.kingdee.bos.ctrl.etl.exception.ETLDatabaseException;
import com.kingdee.bos.ctrl.etl.exception.ETLException;
import com.kingdee.bos.ctrl.etl.exception.ETLJobException;
import com.kingdee.bos.ctrl.etl.exception.ETLScheduleException;
import com.kingdee.bos.ctrl.etl.exception.ETLServerException;
import com.kingdee.bos.ctrl.etl.exception.ETLXMLException;
import com.kingdee.bos.ctrl.etl.job.Job;
import com.kingdee.bos.ctrl.etl.job.JobFactory;
import com.kingdee.bos.ctrl.etl.repository.Repository;
import com.kingdee.bos.ctrl.etl.schedule.Schedule;
import com.kingdee.bos.ctrl.etl.schedule.ScheduleFactory;
import com.kingdee.bos.ctrl.etl.server.ServerMeta;
import com.kingdee.bos.ctrl.etl.util.Const;
import com.kingdee.bos.ctrl.etl.util.LogWriter;
import java.sql.Connection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class Server {
    private IContext ctx = null;
    private boolean working = false;
    private LogWriter log = null;
    private ServerMeta sv = null;
    private HashMap mapSchedulerFactory = new HashMap();

    public Server(ServerMeta sv) {
        this.sv = sv;
    }

    public void run() {
        try {
            System.out.println("Start ETLServer " + this.sv.getName() + " ...");
            this.loadAllSchedule();
            this.startAllSchedule();
        }
        catch (ETLScheduleException e) {
            System.out.println("A serious error occurred(server run)!" + Const.CR + e.getMessage());
            return;
        }
        System.out.println("Start ETLServer " + this.sv.getName() + " OK!");
    }

    public List getJobs() {
        return this.sv.getJobs();
    }

    public void runJob(long id_job) throws ETLJobException {
        Job job = this.sv.findJob(id_job);
        if (job == null) {
            throw new ETLJobException("\u672a\u627e\u5230\u6307\u5b9a\u4efb\u52a1\u5305!");
        }
        job.run();
    }

    public void importJobFile(String filepathname) throws ETLJobException {
        Job job = null;
        Connection con = this.sv.getConnection();
        try {
            job = JobFactory.createJob(filepathname, con);
        }
        catch (ETLXMLException e) {
            e.printStackTrace();
        }
        Repository rep = this.sv.getRepository();
        if (rep == null) {
            return;
        }
        try {
            if (job != null) {
                job.getJobinfo().saveRep(rep);
            }
        }
        catch (ETLException e) {
            throw new ETLJobException(e);
        }
        if (this.isSchedule(job)) {
            System.out.println("same name job is scheduled,can't to be update!");
            throw new ETLJobException("\u540c\u540d\u4efb\u52a1\u6b63\u5728\u88ab\u8c03\u5ea6\uff0c\u4e0d\u80fd\u5bfc\u5165!");
        }
        this.sv.updateJob(job);
    }

    private boolean isSchedule(Job job) {
        for (String scheduleName : this.mapSchedulerFactory.keySet()) {
            Schedule schedule = (Schedule)this.mapSchedulerFactory.get(scheduleName);
            if (!schedule.getJob().getJobname().equalsIgnoreCase(job.getJobname())) continue;
            return true;
        }
        return false;
    }

    public List getSchedules() {
        return this.sv.getSchedules();
    }

    public boolean hasSchedulename(String name) {
        List lstSchedule = this.sv.getSchedules();
        for (Schedule s : lstSchedule) {
            if (!s.getName().equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    public List getLogAudits() {
        return this.sv.getLogAudits();
    }

    public List getLogErrors() {
        return this.sv.getLogErrors();
    }

    public void updateJob(String jobname, Job job) throws ETLServerException {
    }

    public void deleteJob(String jobname) throws ETLServerException {
    }

    public void updateSchedule(String schedulename, long id_job, String scheduleType, String user, boolean isUsed, String cron) throws ETLServerException {
        Repository rep = this.sv.getRepository();
        if (rep == null) {
            return;
        }
        long id_schedule = -1L;
        try {
            long id_directory = 0L;
            id_schedule = rep.getScheduleID(schedulename, id_directory);
            rep.delScheduleAttributes(id_schedule);
            rep.delSchedule(id_schedule);
            id_schedule = rep.insertSchedule(schedulename, id_directory, id_job, scheduleType, user, isUsed);
            rep.insertScheduleAttribute(id_schedule, scheduleType, 0L, "cronExpression", 0.0, cron);
        }
        catch (ETLDatabaseException e) {
            throw new ETLServerException("\u66f4\u65b0\u5b58\u50a8\u5e93\u5931\u8d25\uff01", e);
        }
        Schedule schedule = null;
        try {
            rep.disconnect();
            rep.connect(Repository.class.getName());
            Job job = JobFactory.createJob(rep, id_job);
            schedule = ScheduleFactory.createSchedule2(rep, id_schedule, job);
        }
        catch (ETLException e1) {
            throw new ETLServerException("\u5efa\u7acb\u8c03\u5ea6\u4efb\u52a1\u65f6\u5931\u8d25!", e1);
        }
        this.sv.updateSchedule(schedule);
        this.updateSchedule(schedule);
    }

    public void deleteSchedule(String schedulename) throws ETLServerException {
        Repository rep = this.sv.getRepository();
        if (rep == null) {
            return;
        }
        long id_schedule = -1L;
        try {
            long id_directory = 0L;
            id_schedule = rep.getScheduleID(schedulename, id_directory);
            rep.delScheduleAttributes(id_schedule);
            rep.delSchedule(id_schedule);
        }
        catch (ETLDatabaseException e) {
            throw new ETLServerException("\u5220\u9664\u5b58\u50a8\u5e93\u5931\u8d25\uff01", e);
        }
        this.removeSchedule(schedulename);
        this.sv.removeSchedule(schedulename);
    }

    public boolean isStillWorking() {
        return this.working;
    }

    public void refresh() {
        try {
            System.out.println("Refresh ETLServer " + this.sv.getName() + " ...");
            this.sv.refresh();
        }
        catch (ETLXMLException e) {
            System.out.println("A serious error occurred(server refresh)!" + Const.CR + e.getMessage());
            return;
        }
        this.stop();
        this.run();
        System.out.println("Refresh ETLServer " + this.sv.getName() + " OK!");
    }

    private void updateSchedule(Schedule schedule) {
        if (schedule == null) {
            return;
        }
        System.out.println("Add schedule " + schedule.getName() + " ...");
        Schedule obj = this.mapSchedulerFactory.put(schedule.getName(), schedule);
        if (obj instanceof Schedule) {
            Schedule oldSchduler = obj;
            if (this.isStillWorking()) {
                try {
                    System.out.println("Stop old schedule " + oldSchduler.getName() + " ...");
                    oldSchduler.stop();
                }
                catch (ETLScheduleException e) {
                    System.out.println("A serious error occurred(stop old schedule)!" + Const.CR + e.getMessage());
                    return;
                }
                System.out.println("Stop old schedule " + oldSchduler.getName() + " OK!");
            }
        }
        if (this.isStillWorking()) {
            try {
                System.out.println("Start new schedule " + schedule.getName() + " ...");
                schedule.run();
            }
            catch (ETLScheduleException e) {
                System.out.println("A serious error occurred(start new schedule)!" + Const.CR + e.getMessage());
                return;
            }
            System.out.println("Start new schedule " + schedule.getName() + " OK!");
        }
        System.out.println("Add schedule " + schedule.getName() + " OK!");
    }

    public void removeSchedule(String scheduleName) {
        Object obj = this.mapSchedulerFactory.remove(scheduleName);
        if (obj instanceof Schedule) {
            Schedule scheduler = (Schedule)obj;
            System.out.println("Remove schedule " + scheduleName + " ...");
            if (this.isStillWorking()) {
                try {
                    System.out.println("Stop schedule " + scheduleName + " ...");
                    scheduler.stop();
                }
                catch (ETLScheduleException e) {
                    System.out.println("A serious error occurred(stop schedule)!" + Const.CR + e.getMessage());
                    return;
                }
                System.out.println("Stop schedule " + scheduleName + " OK!");
            }
            System.out.println("Remove schedule " + scheduleName + " OK!");
        }
    }

    public void stop() {
        System.out.println("Stop ETLServer " + this.sv.getName() + " ...");
        Iterator it = this.mapSchedulerFactory.keySet().iterator();
        while (it.hasNext()) {
            Schedule schedule = (Schedule)this.mapSchedulerFactory.get(it.next());
            try {
                System.out.println("Stop schedule " + schedule.getName() + " ...");
                schedule.stop();
            }
            catch (ETLScheduleException e) {
                System.out.println("A serious error occured(stop schedule) )!" + Const.CR + e.getMessage());
                return;
            }
            System.out.println("Stop schedule " + schedule.getName() + " OK!");
        }
        this.working = false;
        System.out.println("Stop ETLServer " + this.sv.getName() + " OK!");
        Repository rep = this.sv.getRepository();
        if (rep != null) {
            rep.disconnect();
            System.out.println("Repository disconnect!");
        }
    }

    private void loadAllSchedule() throws ETLScheduleException {
        List scheduleList = this.sv.getSchedules();
        Iterator it = scheduleList.iterator();
        while (it.hasNext()) {
            this.updateSchedule((Schedule)it.next());
        }
    }

    private void startAllSchedule() throws ETLScheduleException {
        this.working = true;
        System.out.println("JobServer start!");
        for (String scheduleName : this.mapSchedulerFactory.keySet()) {
            Schedule schedule = (Schedule)this.mapSchedulerFactory.get(scheduleName);
            System.out.println("start schedule " + scheduleName);
            schedule.run();
        }
    }
}

