/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.etl.transformation;

import com.kingdee.bos.ctrl.etl.base.CheckResult;
import com.kingdee.bos.ctrl.etl.base.NotePadMeta;
import com.kingdee.bos.ctrl.etl.base.Row;
import com.kingdee.bos.ctrl.etl.base.SQLStatement;
import com.kingdee.bos.ctrl.etl.cache.DBCache;
import com.kingdee.bos.ctrl.etl.database.Database;
import com.kingdee.bos.ctrl.etl.database.DatabaseMeta;
import com.kingdee.bos.ctrl.etl.exception.ETLDatabaseException;
import com.kingdee.bos.ctrl.etl.exception.ETLException;
import com.kingdee.bos.ctrl.etl.exception.ETLStepException;
import com.kingdee.bos.ctrl.etl.exception.ETLXMLException;
import com.kingdee.bos.ctrl.etl.repository.Repository;
import com.kingdee.bos.ctrl.etl.repository.RepositoryDirectory;
import com.kingdee.bos.ctrl.etl.transformation.TransDependency;
import com.kingdee.bos.ctrl.etl.transformation.TransHopMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.StepMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.StepMetaInterface;
import com.kingdee.bos.ctrl.etl.util.Const;
import com.kingdee.bos.ctrl.etl.util.IProgressMonitor;
import com.kingdee.bos.ctrl.etl.util.LogWriter;
import com.kingdee.bos.ctrl.etl.util.Props;
import com.kingdee.bos.ctrl.etl.util.XMLHandler;
import com.kingdee.bos.ctrl.etl.util.XMLInterface;
import com.kingdee.bos.ctrl.etl.value.Value;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class TransMeta
implements XMLInterface {
    private static LogWriter log = LogWriter.getInstance();
    private List databases;
    private List steps;
    private List hops;
    private List notes;
    private List dependencies;
    private Hashtable variables;
    private RepositoryDirectory directory;
    private RepositoryDirectory directoryTree;
    private String name;
    private String filename;
    private StepMeta readStep;
    private StepMeta writeStep;
    private StepMeta inputStep;
    private StepMeta outputStep;
    private StepMeta updateStep;
    private String logTable;
    private DatabaseMeta logConnection;
    private int sizeRowset;
    private DatabaseMeta maxDateConnection;
    private String maxDateTable;
    private String maxDateField;
    private double maxDateOffset;
    private double maxDateDifference;
    private String[] arguments;
    private Hashtable counters;
    private List sourceRows;
    private List resultRows;
    private boolean changed;
    private boolean changed_steps;
    private boolean changed_databases;
    private boolean changed_hops;
    private boolean changed_notes;
    private List undo;
    private int max_undo;
    private DBCache dbCache;
    private long id;
    private boolean useBatchId;
    private long batchId;
    private boolean logfieldUsed;
    private String createdUser;
    private String modifiedUser;
    private Value createdDate;
    private Value modifiedDate;
    private int sleepTimeEmpty;
    private int sleepTimeFull;
    public static final int TYPE_UNDO_CHANGE = 1;
    public static final int TYPE_UNDO_NEW = 2;
    public static final int TYPE_UNDO_DELETE = 3;
    public static final int TYPE_UNDO_POSITION = 4;
    public static final String[] desc_type_undo = new String[]{"", "Undo change", "Undo new", "Undo delete", "Undo position"};

    public TransMeta() {
        this.clear();
    }

    public TransMeta(String filename, String name, String[] arguments) {
        this.clear();
        this.filename = filename;
        this.name = name;
        this.arguments = arguments;
    }

    public long getID() {
        return this.id;
    }

    private void setID(long id) {
        this.id = id;
    }

    public void clear() {
        this.setID(-1L);
        this.databases = new ArrayList();
        this.steps = new ArrayList();
        this.hops = new ArrayList();
        this.notes = new ArrayList();
        this.dependencies = new ArrayList();
        this.variables = new Hashtable();
        this.name = null;
        this.filename = null;
        this.readStep = null;
        this.writeStep = null;
        this.inputStep = null;
        this.outputStep = null;
        this.updateStep = null;
        this.logTable = null;
        this.logConnection = null;
        this.sizeRowset = 350;
        this.sleepTimeEmpty = 1;
        this.sleepTimeFull = 1;
        this.maxDateConnection = null;
        this.maxDateTable = null;
        this.maxDateField = null;
        this.maxDateOffset = 0.0;
        this.maxDateDifference = 0.0;
        this.undo = new ArrayList();
        this.max_undo = 100;
        this.counters = new Hashtable();
        this.resultRows = null;
        this.clearUndo();
        this.clearChanged();
        this.useBatchId = false;
        this.batchId = 0L;
        this.modifiedUser = "-";
        this.modifiedDate = new Value("modified_date", new Date());
        this.dbCache = DBCache.getInstance();
        this.directory = this.directoryTree = new RepositoryDirectory();
    }

    public void clearUndo() {
        this.undo = new ArrayList();
    }

    public List getDatabases() {
        return this.databases;
    }

    public void addDatabase(DatabaseMeta ci) {
        this.databases.add(ci);
        this.changed_databases = true;
    }

    public void addStep(StepMeta stepMeta) {
        this.steps.add(stepMeta);
        this.changed_steps = true;
    }

    public void addTransHop(TransHopMeta hi) {
        this.hops.add(hi);
        this.changed_hops = true;
    }

    public void addNote(NotePadMeta ni) {
        this.notes.add(ni);
        this.changed_notes = true;
    }

    public void addDependency(TransDependency td) {
        this.dependencies.add(td);
    }

    public void addDatabase(int index, DatabaseMeta database) {
        this.databases.add(index, database);
        this.changed_databases = true;
    }

    public void addStep(int index, StepMeta stepMeta) {
        this.steps.add(index, stepMeta);
        this.changed_steps = true;
    }

    public void addTransHop(int index, TransHopMeta hi) {
        this.hops.add(index, hi);
        this.changed_hops = true;
    }

    public void addNote(int p, NotePadMeta ni) {
        this.notes.add(p, ni);
        this.changed_notes = true;
    }

    public void addDependency(int p, TransDependency td) {
        this.dependencies.add(p, td);
    }

    public int databaseCount() {
        return this.databases.size();
    }

    public int stepCount() {
        return this.steps.size();
    }

    public int transHopCount() {
        return this.hops.size();
    }

    public int noteCount() {
        return this.notes.size();
    }

    public int dependencyCount() {
        return this.dependencies.size();
    }

    private void removeDatabase(int i) {
        if (i < 0 || i >= this.databases.size()) {
            return;
        }
        this.databases.remove(i);
        this.changed_databases = true;
    }

    private void removeStep(int i) {
        if (i < 0 || i >= this.steps.size()) {
            return;
        }
        this.steps.remove(i);
        this.changed_steps = true;
    }

    private void removeTransHop(int i) {
        if (i < 0 || i >= this.hops.size()) {
            return;
        }
        this.hops.remove(i);
        this.changed_hops = true;
    }

    private void removeNote(int i) {
        if (i < 0 || i >= this.notes.size()) {
            return;
        }
        this.notes.remove(i);
        this.changed_notes = true;
    }

    private void removeDependency(int i) {
        if (i < 0 || i >= this.dependencies.size()) {
            return;
        }
        this.dependencies.remove(i);
    }

    private void removeAllDependencies() {
        this.dependencies.clear();
    }

    public void setStep(int i, StepMeta stepMeta) {
        this.steps.set(i, stepMeta);
    }

    public void setTransHop(int i, TransHopMeta hi) {
        this.hops.set(i, hi);
    }

    public DatabaseMeta findDatabase(String name) {
        for (DatabaseMeta ci : this.databases) {
            if (!ci.getName().equalsIgnoreCase(name)) continue;
            return ci;
        }
        return null;
    }

    public StepMeta findStep(String name) {
        return this.findStep(name, null);
    }

    private StepMeta findStep(String name, StepMeta exclude) {
        if (name == null) {
            return null;
        }
        for (int i = 0; i < this.steps.size(); ++i) {
            StepMeta stepMeta = (StepMeta)this.steps.get(i);
            if (!stepMeta.getName().equalsIgnoreCase(name) || exclude != null && stepMeta.getName().equalsIgnoreCase(exclude.getName())) continue;
            return stepMeta;
        }
        return null;
    }

    private TransHopMeta findTransHopFrom(StepMeta fromstep) {
        for (TransHopMeta hi : this.hops) {
            if (hi.getFromStep() == null || !hi.getFromStep().equals(fromstep)) continue;
            return hi;
        }
        return null;
    }

    public TransHopMeta findTransHopTo(StepMeta tostep) {
        for (TransHopMeta hi : this.hops) {
            if (hi.getToStep() == null || !hi.getToStep().equals(tostep)) continue;
            return hi;
        }
        return null;
    }

    private boolean isStepInformative(StepMeta this_step, StepMeta prev_step) {
        String[] infoSteps = this_step.getStepMetaInterface().getInfoSteps();
        if (infoSteps == null) {
            return false;
        }
        for (int i = 0; i < infoSteps.length; ++i) {
            if (!prev_step.getName().equalsIgnoreCase(infoSteps[i])) continue;
            return true;
        }
        return false;
    }

    private int findPrevStepCount(StepMeta stepMeta) {
        return this.findPrevStepCount(stepMeta, false);
    }

    public StepMeta findPrevStep(StepMeta stepMeta, int nr) {
        return this.findPrevStep(stepMeta, nr, false);
    }

    public int findPrevStepCount(StepMeta stepMeta, boolean info) {
        int count = 0;
        for (TransHopMeta hi : this.hops) {
            if (hi.getToStep() == null || !hi.isEnabled() || !hi.getToStep().equals(stepMeta) || !info && this.isStepInformative(stepMeta, hi.getFromStep())) continue;
            ++count;
        }
        return count;
    }

    public StepMeta findPrevStep(StepMeta stepMeta, int index, boolean info) {
        int count = 0;
        for (TransHopMeta hi : this.hops) {
            if (hi.getToStep() == null || !hi.isEnabled() || !hi.getToStep().equals(stepMeta) || !info && this.isStepInformative(stepMeta, hi.getFromStep())) continue;
            if (count == index) {
                return hi.getFromStep();
            }
            ++count;
        }
        return null;
    }

    public StepMeta[] getInfoStep(StepMeta stepMeta) {
        String[] infoStepName = stepMeta.getStepMetaInterface().getInfoSteps();
        if (infoStepName == null) {
            return null;
        }
        StepMeta[] infoStep = new StepMeta[infoStepName.length];
        for (int i = 0; i < infoStep.length; ++i) {
            infoStep[i] = this.findStep(infoStepName[i]);
        }
        return infoStep;
    }

    public int findInfoStepCount(StepMeta stepMeta) {
        if (stepMeta == null) {
            return 0;
        }
        int count = 0;
        for (TransHopMeta hi : this.hops) {
            if (hi == null || hi.getToStep() == null) {
                log.logError(this.toString(), "Internal error detected, a hop's destination can't be null!");
            }
            if (hi == null || hi.getToStep() == null || !hi.isEnabled() || !hi.getToStep().equals(stepMeta) || !this.isStepInformative(stepMeta, hi.getFromStep())) continue;
            ++count;
        }
        return count;
    }

    public Row getPrevInfoFields(String stepname) throws ETLStepException {
        return this.getPrevInfoFields(this.findStep(stepname));
    }

    public Row getPrevInfoFields(StepMeta stepMeta) throws ETLStepException {
        Row row = new Row();
        for (TransHopMeta hi : this.hops) {
            if (!hi.isEnabled() || !hi.getToStep().equals(stepMeta) || !this.isStepInformative(stepMeta, hi.getFromStep())) continue;
            this.getThisStepFields(stepMeta, row);
            return row;
        }
        return row;
    }

    public int findNextStepCount(StepMeta stepMeta) {
        int count = 0;
        for (TransHopMeta hi : this.hops) {
            if (!hi.isEnabled() || !hi.getFromStep().equals(stepMeta)) continue;
            ++count;
        }
        return count;
    }

    public StepMeta findNextStep(StepMeta stepMeta, int index) {
        int count = 0;
        for (TransHopMeta hi : this.hops) {
            if (!hi.isEnabled() || !hi.getFromStep().equals(stepMeta)) continue;
            if (count == index) {
                return hi.getToStep();
            }
            ++count;
        }
        return null;
    }

    public StepMeta[] getPrevSteps(StepMeta stepMeta) {
        int nr = this.findPrevStepCount(stepMeta, true);
        StepMeta[] retval = new StepMeta[nr];
        for (int i = 0; i < nr; ++i) {
            retval[i] = this.findPrevStep(stepMeta, i, true);
        }
        return retval;
    }

    public String[] getPrevStepNames(String stepname) {
        return this.getPrevStepNames(this.findStep(stepname));
    }

    public String[] getPrevStepNames(StepMeta stepMeta) {
        StepMeta[] prevStepMetas = this.getPrevSteps(stepMeta);
        String[] retval = new String[prevStepMetas.length];
        for (int x = 0; x < prevStepMetas.length; ++x) {
            retval[x] = prevStepMetas[x].getName();
        }
        return retval;
    }

    public StepMeta[] getNextSteps(StepMeta stepMeta) {
        int count = this.findNextStepCount(stepMeta);
        StepMeta[] retval = new StepMeta[count];
        for (int i = 0; i < count; ++i) {
            retval[i] = this.findNextStep(stepMeta, i);
        }
        return retval;
    }

    public String[] getNextStepNames(StepMeta stepMeta) {
        StepMeta[] nextStepMeta = this.getNextSteps(stepMeta);
        String[] retval = new String[nextStepMeta.length];
        for (int x = 0; x < nextStepMeta.length; ++x) {
            retval[x] = nextStepMeta[x].getName();
        }
        return retval;
    }

    public boolean partOfTransHop(StepMeta stepMeta) {
        for (TransHopMeta hi : this.hops) {
            if (hi.getFromStep() == null || hi.getToStep() == null) {
                return false;
            }
            if (!hi.getFromStep().equals(stepMeta) && !hi.getToStep().equals(stepMeta)) continue;
            return true;
        }
        return false;
    }

    public Row getStepFields(String stepname) throws ETLStepException {
        StepMeta stepMeta = this.findStep(stepname);
        if (stepMeta != null) {
            return this.getStepFields(stepMeta);
        }
        return null;
    }

    public Row getStepFields(StepMeta stepMeta) throws ETLStepException {
        return this.getStepFields(stepMeta, null);
    }

    public Row getStepFields(StepMeta[] stepMeta) throws ETLStepException {
        Row fields = new Row();
        for (int i = 0; i < stepMeta.length; ++i) {
            Row flds = this.getStepFields(stepMeta[i]);
            if (flds == null) continue;
            fields.mergeRow(flds);
        }
        return fields;
    }

    public Row getStepFields(StepMeta stepMeta, IProgressMonitor monitor) throws ETLStepException {
        Row row = new Row();
        if (stepMeta == null) {
            return row;
        }
        log.logDebug(this.toString(), "From step: " + stepMeta.getName() + ", looking at " + this.findPrevStepCount(stepMeta) + " prev. steps.");
        for (int i = 0; i < this.findPrevStepCount(stepMeta); ++i) {
            Row add;
            StepMeta prevStepMeta = this.findPrevStep(stepMeta, i);
            if (monitor != null) {
                monitor.subTask("Checking step [" + prevStepMeta.getName() + "]");
            }
            if ((add = this.getStepFields(prevStepMeta, monitor)) == null) {
                add = new Row();
            }
            log.logDebug(this.toString(), "Found fields to add: " + add.toString());
            if (i == 0) {
                row.addRow(add);
                continue;
            }
            for (int x = 0; x < add.size(); ++x) {
                Value v = add.getValue(x);
                Value s = row.searchValue(v.getName());
                if (s != null) continue;
                row.addValue(v);
            }
        }
        return this.getThisStepFields(stepMeta, row, monitor);
    }

    public Row getPrevStepFields(String stepname) throws ETLStepException {
        return this.getPrevStepFields(this.findStep(stepname));
    }

    public Row getPrevStepFields(StepMeta stepMeta) throws ETLStepException {
        return this.getPrevStepFields(stepMeta, null);
    }

    public Row getPrevStepFields(StepMeta stepMeta, IProgressMonitor monitor) throws ETLStepException {
        Row row = new Row();
        if (stepMeta == null) {
            return null;
        }
        log.logDebug(this.toString(), "From step: " + stepMeta.getName() + ", looking at " + this.findPrevStepCount(stepMeta) + " prev. steps.");
        for (int i = 0; i < this.findPrevStepCount(stepMeta); ++i) {
            StepMeta prevStepMeta = this.findPrevStep(stepMeta, i);
            if (monitor != null) {
                monitor.subTask("Checking step [" + prevStepMeta.getName() + "]");
            }
            Row add = this.getStepFields(prevStepMeta, monitor);
            log.logDebug(this.toString(), "Found fields to add: " + add.toString());
            if (i == 0) {
                row.addRow(add);
                continue;
            }
            for (int x = 0; x < add.size(); ++x) {
                Value v = add.getValue(x);
                Value s = row.searchValue(v.getName());
                if (s != null) continue;
                row.addValue(v);
            }
        }
        return row;
    }

    public Row getThisStepFields(String stepname, Row row) throws ETLStepException {
        return this.getThisStepFields(this.findStep(stepname), row);
    }

    public Row getThisStepFields(StepMeta stepMeta, Row row) throws ETLStepException {
        return this.getThisStepFields(stepMeta, row, null);
    }

    public Row getThisStepFields(StepMeta stepMeta, Row row, IProgressMonitor monitor) throws ETLStepException {
        log.logDebug(this.toString(), "Getting fields from step: " + stepMeta.getName() + ", type=" + stepMeta.getStepID());
        String name = stepMeta.getName();
        if (monitor != null) {
            monitor.subTask("Getting fields from step [" + name + "]");
        }
        StepMetaInterface stepint = stepMeta.getStepMetaInterface();
        Row inform = null;
        StepMeta[] lu = this.getInfoStep(stepMeta);
        inform = lu != null ? this.getStepFields(lu) : stepint.getTableFields();
        stepint.getFields(row, name, inform);
        return row;
    }

    private void saveRepTrans(Repository rep) throws ETLDatabaseException {
        rep.insertTransformation(this.getID(), this.getName(), this.readStep == null ? -1L : this.readStep.getID(), this.writeStep == null ? -1L : this.writeStep.getID(), this.inputStep == null ? -1L : this.inputStep.getID(), this.outputStep == null ? -1L : this.outputStep.getID(), this.updateStep == null ? -1L : this.updateStep.getID(), this.modifiedUser, this.modifiedDate, this.sizeRowset, this.directory.getID());
    }

    public StepMeta getStep(int i) {
        return (StepMeta)this.steps.get(i);
    }

    public TransHopMeta getTransHop(int i) {
        return (TransHopMeta)this.hops.get(i);
    }

    public NotePadMeta getNote(int i) {
        return (NotePadMeta)this.notes.get(i);
    }

    public TransDependency getDependency(int i) {
        return (TransDependency)this.dependencies.get(i);
    }

    public DatabaseMeta getDatabase(int i) {
        return (DatabaseMeta)this.databases.get(i);
    }

    public void saveRep(Repository rep, IProgressMonitor monitor) throws ETLException {
        try {
            int i;
            rep.lockRepository();
            rep.clearNextIDCounters();
            if (this.directory.getID() < 0L) {
                throw new ETLException("Please select a valid directory before saving the transformation!");
            }
            int nrWorks = 2 + this.databaseCount() + this.noteCount() + this.stepCount() + this.transHopCount();
            if (monitor != null) {
                monitor.beginTask("Saving transformation " + this.getPathAndName(), nrWorks);
            }
            log.logDebug(this.toString(), "Saving of transofmation started.");
            if (monitor != null) {
                monitor.subTask("Handling old version of transformation (if any)...");
            }
            this.setID(rep.getTransformationID(this.getName(), this.directory.getID()));
            if (this.getID() <= 0L) {
                this.setID(rep.getNextTransformationID());
            } else {
                if (monitor != null) {
                    monitor.subTask("deleting old version of transformation...");
                }
                log.logDebug(this.toString(), "deleting old version of transformation...");
                rep.delAllFromTrans(this.getID());
                log.logDebug(this.toString(), "Old version of transformation removed.");
            }
            if (monitor != null) {
                monitor.worked(1);
            }
            log.logDebug(this.toString(), "Saving notes...");
            for (i = 0; i < this.noteCount(); ++i) {
                if (monitor != null) {
                    monitor.subTask("Saving note #" + (i + 1) + "/" + this.noteCount());
                }
                NotePadMeta ni = this.getNote(i);
                ni.saveRep(rep, this.getID());
                if (ni.getID() > 0L) {
                    rep.insertTransNote(this.getID(), ni.getID());
                }
                if (monitor == null) continue;
                monitor.worked(1);
            }
            log.logDebug(this.toString(), "Saving database connections...");
            for (i = 0; i < this.databaseCount(); ++i) {
                if (monitor != null) {
                    monitor.subTask("Saving database #" + (i + 1) + "/" + this.databaseCount());
                }
                DatabaseMeta ci = this.getDatabase(i);
                ci.saveRep(rep);
                if (monitor == null) continue;
                monitor.worked(1);
            }
            log.logDebug(this.toString(), "Checking step types...");
            rep.updateStepTypes();
            log.logDebug(this.toString(), "Saving steps...");
            for (i = 0; i < this.stepCount(); ++i) {
                if (monitor != null) {
                    monitor.subTask("Saving step #" + (i + 1) + "/" + this.stepCount());
                }
                StepMeta stepMeta = this.getStep(i);
                stepMeta.saveRep(rep, this.getID());
                if (monitor == null) continue;
                monitor.worked(1);
            }
            rep.closeStepAttributeInsertPreparedStatement();
            log.logDebug(this.toString(), "Saving hops...");
            for (i = 0; i < this.transHopCount(); ++i) {
                if (monitor != null) {
                    monitor.subTask("Saving hop #" + (i + 1) + "/" + this.transHopCount());
                }
                TransHopMeta hi = this.getTransHop(i);
                hi.saveRep(rep, this.getID());
                if (monitor == null) continue;
                monitor.worked(1);
            }
            if (monitor != null) {
                monitor.subTask("finishing...");
            }
            log.logDebug(this.toString(), "Saving transformation info...");
            this.saveRepTrans(rep);
            log.logDebug(this.toString(), "Saving dependencies...");
            for (i = 0; i < this.dependencyCount(); ++i) {
                TransDependency td = this.getDependency(i);
                td.saveRep(rep, this.getID());
            }
            log.logDebug(this.toString(), "Saving finished...");
            rep.commit();
            this.clearChanged();
            if (monitor != null) {
                monitor.worked(1);
            }
            if (monitor != null) {
                monitor.done();
            }
        }
        catch (ETLDatabaseException dbe) {
            rep.rollback();
            log.logError(this.toString(), "Error saving transformation to repository!" + Const.CR + dbe.getMessage());
            throw new ETLException("Error saving transformation to repository!", dbe);
        }
        finally {
            rep.unlockRepository();
        }
    }

    public void readDatabases(Repository rep) {
        try {
            long[] dbids = rep.getDatabaseIDs();
            for (int i = 0; i < dbids.length; ++i) {
                DatabaseMeta ci = new DatabaseMeta(rep, dbids[i]);
                if (ci.getName() == null || this.indexOfDatabase(ci) >= 0) continue;
                this.addDatabase(ci);
                ci.setChanged(false);
            }
            this.changed_databases = false;
        }
        catch (ETLDatabaseException dbe) {
            log.logError(this.toString(), "Unable to read database IDs from repository: " + dbe.getMessage());
        }
        catch (ETLException ke) {
            log.logError(this.toString(), "Unable to read databases from repository: " + ke.getMessage());
        }
    }

    public void loadRepTrans(Repository rep) throws ETLException {
        try {
            Row r = rep.getTransformation(this.getID());
            if (r != null) {
                long id_directory;
                this.name = r.searchValue("Name").getString();
                this.readStep = Const.findStep(this.steps, r.getInteger("ID_StepRead", -1L));
                this.writeStep = Const.findStep(this.steps, r.getInteger("ID_StepWrite", -1L));
                this.inputStep = Const.findStep(this.steps, r.getInteger("ID_StepInput", -1L));
                this.outputStep = Const.findStep(this.steps, r.getInteger("ID_StepOutput", -1L));
                this.updateStep = Const.findStep(this.steps, r.getInteger("ID_StepUpdate", -1L));
                this.modifiedUser = r.getString("ModifiedUser", null);
                this.modifiedDate = r.searchValue("ModifiedDate");
                this.sizeRowset = 350;
                Value val_size_rowset = r.searchValue("BufferRows");
                if (val_size_rowset != null && !val_size_rowset.isNull()) {
                    this.sizeRowset = (int)val_size_rowset.getInteger();
                }
                if ((id_directory = r.getInteger("ID_Directory", -1L)) >= 0L) {
                    log.logDetailed(this.toString(), "ID_Directory=" + id_directory);
                    this.directory = this.directoryTree.findDirectory(id_directory);
                }
            }
        }
        catch (ETLDatabaseException dbe) {
            throw new ETLException("Unable to load transformation information from the repository", dbe);
        }
    }

    public TransMeta(Repository rep, String transname, RepositoryDirectory repdir, Connection ctxConnection) throws ETLException {
        this(rep, transname, repdir, null, ctxConnection);
    }

    public TransMeta(Repository rep, String transname, RepositoryDirectory repdir, IProgressMonitor monitor, Connection ctxConnection) throws ETLException {
        try {
            String pathAndName = repdir.isRoot() ? repdir + transname : repdir + "/" + transname;
            this.clear();
            this.setName(transname);
            this.directory = repdir;
            this.directoryTree = this.directory.findRoot();
            log.logDetailed(this.toString(), "Looking for the transformation [" + transname + "] in directory [" + this.directory.getPath() + "]");
            if (monitor != null) {
                monitor.subTask("Reading transformation information");
            }
            this.setID(rep.getTransformationID(transname, this.directory.getID()));
            if (monitor != null) {
                monitor.worked(1);
            }
            if (this.getID() > 0L) {
                int i;
                long[] noteids = rep.getTransNoteIDs(this.getID());
                long[] stepids = rep.getStepIDs(this.getID());
                long[] hopids = rep.getTransHopIDs(this.getID());
                int nrWork = 3 + noteids.length + stepids.length + hopids.length;
                if (monitor != null) {
                    monitor.beginTask("Loading transformation " + pathAndName, nrWork);
                }
                log.logDetailed(this.toString(), "Loading transformation [" + this.getName() + "] from repository...");
                if (monitor != null) {
                    monitor.subTask("Reading the available database from the repository");
                }
                this.readDatabases(rep);
                if (ctxConnection != null) {
                    DatabaseMeta dbcon = new DatabaseMeta(ctxConnection);
                    this.addDatabase(dbcon);
                }
                if (monitor != null) {
                    monitor.worked(1);
                }
                if (monitor != null) {
                    monitor.subTask("Reading notes...");
                }
                for (i = 0; i < noteids.length; ++i) {
                    NotePadMeta ni = new NotePadMeta(log, rep, noteids[i]);
                    if (this.indexOfNote(ni) < 0) {
                        this.addNote(ni);
                    }
                    if (monitor == null) continue;
                    monitor.worked(1);
                }
                if (monitor != null) {
                    monitor.subTask("Reading steps...");
                }
                rep.fillStepAttributesBuffer(this.getID());
                for (i = 0; i < stepids.length; ++i) {
                    log.logDetailed(this.toString(), "Loading step with ID: " + stepids[i]);
                    if (monitor != null) {
                        monitor.subTask("Reading step #" + (i + 1) + "/" + stepids.length);
                    }
                    StepMeta stepMeta = new StepMeta(log, rep, stepids[i], this.databases, this.counters);
                    this.addStep(stepMeta);
                    if (monitor == null) continue;
                    monitor.worked(1);
                }
                if (monitor != null) {
                    monitor.worked(1);
                }
                rep.setStepAttributesBuffer(null);
                for (i = 0; i < this.stepCount(); ++i) {
                    StepMetaInterface sii = this.getStep(i).getStepMetaInterface();
                    sii.searchInfoAndTargetSteps(this.steps);
                }
                if (monitor != null) {
                    monitor.subTask("Reading the hops");
                }
                for (i = 0; i < hopids.length; ++i) {
                    TransHopMeta hi = new TransHopMeta(rep, hopids[i], this.steps);
                    this.addTransHop(hi);
                    if (monitor == null) continue;
                    monitor.worked(1);
                }
                if (monitor != null) {
                    monitor.subTask("Loading the transformation details");
                }
                this.loadRepTrans(rep);
                if (monitor != null) {
                    monitor.worked(1);
                }
                if (monitor != null) {
                    monitor.subTask("Reading the dependencies");
                }
                long[] depids = rep.getTransDependencyIDs(this.getID());
                for (int i2 = 0; i2 < depids.length; ++i2) {
                    TransDependency td = new TransDependency(rep, depids[i2], this.databases);
                    this.addDependency(td);
                }
                if (monitor != null) {
                    monitor.worked(1);
                }
                if (monitor != null) {
                    monitor.subTask("Sorting steps");
                }
                this.sortSteps();
                if (monitor != null) {
                    monitor.worked(1);
                }
                if (monitor != null) {
                    monitor.done();
                }
            } else {
                throw new ETLException("This transformation doesn't exist : " + this.name);
            }
            log.logDetailed(this.toString(), "Loaded the transformation [" + transname + "] , directory == null : " + (this.directory == null));
            log.logDetailed(this.toString(), "Loaded the transformation [" + transname + "] from the directory [" + this.directory.getPath() + "]");
        }
        catch (ETLDatabaseException e) {
            log.logError(this.toString(), "A database error occured reading a transformation from the repository" + Const.CR + e);
            throw new ETLException("A database error occured reading a transformation from the repository", e);
        }
        catch (Exception e) {
            log.logError(this.toString(), "A database error occured reading a transformation from the repository" + Const.CR + e);
            throw new ETLException("An error occured reading a transformation from the repository", e);
        }
    }

    public int indexOfTransHop(TransHopMeta hi) {
        return this.hops.indexOf(hi);
    }

    public int indexOfStep(StepMeta stepMeta) {
        return this.steps.indexOf(stepMeta);
    }

    public int indexOfDatabase(DatabaseMeta ci) {
        return this.databases.indexOf(ci);
    }

    public int indexOfNote(NotePadMeta ni) {
        return this.notes.indexOf(ni);
    }

    @Override
    public String getXML() {
        int i;
        String xml = "";
        xml = xml + "<transformation>" + Const.CR;
        xml = xml + "  <info>" + Const.CR;
        xml = xml + "    " + XMLHandler.addTagValue("name", this.name);
        xml = xml + "    " + XMLHandler.addTagValue("directory", this.directory != null ? this.directory.getPath() : "/");
        xml = xml + "    <log>" + Const.CR;
        xml = xml + "      " + XMLHandler.addTagValue("read", this.readStep == null ? "" : this.readStep.getName());
        xml = xml + "      " + XMLHandler.addTagValue("write", this.writeStep == null ? "" : this.writeStep.getName());
        xml = xml + "      " + XMLHandler.addTagValue("input", this.inputStep == null ? "" : this.inputStep.getName());
        xml = xml + "      " + XMLHandler.addTagValue("output", this.outputStep == null ? "" : this.outputStep.getName());
        xml = xml + "      " + XMLHandler.addTagValue("update", this.updateStep == null ? "" : this.updateStep.getName());
        xml = xml + "      " + XMLHandler.addTagValue("connection", this.logConnection == null ? "" : this.logConnection.getName());
        xml = xml + "      " + XMLHandler.addTagValue("table", this.logTable);
        xml = xml + "      " + XMLHandler.addTagValue("use_batchid", this.useBatchId);
        xml = xml + "      " + XMLHandler.addTagValue("use_logfield", this.logfieldUsed);
        xml = xml + "      </log>" + Const.CR;
        xml = xml + "    <maxdate>" + Const.CR;
        xml = xml + "      " + XMLHandler.addTagValue("connection", this.maxDateConnection == null ? "" : this.maxDateConnection.getName());
        xml = xml + "      " + XMLHandler.addTagValue("table", this.maxDateTable);
        xml = xml + "      " + XMLHandler.addTagValue("field", this.maxDateField);
        xml = xml + "      " + XMLHandler.addTagValue("offset", this.maxDateOffset);
        xml = xml + "      " + XMLHandler.addTagValue("maxdiff", this.maxDateDifference);
        xml = xml + "      </maxdate>" + Const.CR;
        xml = xml + "    " + XMLHandler.addTagValue("size_rowset", this.sizeRowset);
        xml = xml + "    " + XMLHandler.addTagValue("sleep_time_empty", this.sleepTimeEmpty);
        xml = xml + "    " + XMLHandler.addTagValue("sleep_time_full", this.sleepTimeFull);
        xml = xml + "    <dependencies>" + Const.CR;
        for (i = 0; i < this.dependencyCount(); ++i) {
            TransDependency td = this.getDependency(i);
            xml = xml + td.getXML();
        }
        xml = xml + "      </dependencies>" + Const.CR;
        xml = xml + "    </info>" + Const.CR;
        xml = xml + "  <notepads>" + Const.CR;
        if (this.notes != null) {
            for (i = 0; i < this.noteCount(); ++i) {
                NotePadMeta ni = this.getNote(i);
                xml = xml + ni.getXML();
            }
        }
        xml = xml + "    </notepads>" + Const.CR;
        for (i = 0; i < this.databaseCount(); ++i) {
            DatabaseMeta dbMeta = this.getDatabase(i);
            xml = xml + dbMeta.getXML();
        }
        xml = xml + "  <order>" + Const.CR;
        for (i = 0; i < this.transHopCount(); ++i) {
            TransHopMeta transHopMeta = this.getTransHop(i);
            xml = xml + transHopMeta.getXML();
        }
        xml = xml + "  </order>" + Const.CR + Const.CR;
        for (i = 0; i < this.stepCount(); ++i) {
            StepMeta stepMeta = this.getStep(i);
            xml = xml + stepMeta.getXML();
        }
        xml = xml + "</transformation>" + Const.CR;
        return xml;
    }

    public TransMeta(String fname, Connection ctxConnection) throws ETLXMLException {
        Document doc = XMLHandler.loadXMLFile(fname);
        if (doc == null) {
            throw new ETLXMLException("Error opening/validating the XML file!");
        }
        this.clearUndo();
        this.clear();
        Node transnode = XMLHandler.getSubNode(doc, "transformation");
        this.loadXML(transnode, ctxConnection);
        this.setFilename(fname);
    }

    public TransMeta(Node transnode, Connection ctxConnection) throws ETLXMLException {
        this.loadXML(transnode, ctxConnection);
    }

    private void loadXML(Node transnode, Connection ctxConnection) throws ETLXMLException {
        try {
            int i;
            this.clearUndo();
            this.clear();
            int n = XMLHandler.countNodes(transnode, "connection");
            log.logDebug(this.toString(), "We have " + n + " connections...");
            for (int i2 = 0; i2 < n; ++i2) {
                log.logDebug(this.toString(), "Looking at connection #" + i2);
                Node nodecon = XMLHandler.getSubNodeByNr(transnode, "connection", i2);
                DatabaseMeta dbcon = new DatabaseMeta(nodecon);
                DatabaseMeta exist = this.findDatabase(dbcon.getName());
                if (exist == null) {
                    this.addDatabase(dbcon);
                    continue;
                }
                int idx = this.indexOfDatabase(exist);
                this.removeDatabase(idx);
                this.addDatabase(idx, dbcon);
            }
            if (ctxConnection != null) {
                DatabaseMeta dbcon = new DatabaseMeta(ctxConnection);
                this.addDatabase(dbcon);
            }
            Node notepadsnode = XMLHandler.getSubNode(transnode, "notepads");
            int nrnotes = XMLHandler.countNodes(notepadsnode, "notepad");
            for (int i3 = 0; i3 < nrnotes; ++i3) {
                Node notepadnode = XMLHandler.getSubNodeByNr(notepadsnode, "notepad", i3);
                NotePadMeta ni = new NotePadMeta(notepadnode);
                this.notes.add(ni);
            }
            int s = XMLHandler.countNodes(transnode, "step");
            log.logDebug(this.toString(), "Reading " + s + " steps...");
            for (i = 0; i < s; ++i) {
                Node stepnode = XMLHandler.getSubNodeByNr(transnode, "step", i);
                log.logDebug(this.toString(), "Looking at step #" + i);
                StepMeta inf = new StepMeta(log, stepnode, this.databases, this.counters);
                this.addStep(inf);
            }
            for (i = 0; i < this.stepCount(); ++i) {
                StepMeta stepMeta = this.getStep(i);
                StepMetaInterface sii = stepMeta.getStepMetaInterface();
                if (sii == null) continue;
                sii.searchInfoAndTargetSteps(this.steps);
            }
            Node ordernode = XMLHandler.getSubNode(transnode, "order");
            n = XMLHandler.countNodes(ordernode, "hop");
            log.logDebug(this.toString(), "We have " + n + " hops...");
            for (int i4 = 0; i4 < n; ++i4) {
                log.logDebug(this.toString(), "Looking at hop #" + i4);
                Node hopnode = XMLHandler.getSubNodeByNr(ordernode, "hop", i4);
                TransHopMeta hopinf = new TransHopMeta(hopnode, this.steps);
                this.addTransHop(hopinf);
            }
            Node infonode = XMLHandler.getSubNode(transnode, "info");
            this.name = XMLHandler.getTagValue(infonode, "name");
            this.readStep = this.findStep(XMLHandler.getTagValue(infonode, "log", "read"));
            this.writeStep = this.findStep(XMLHandler.getTagValue(infonode, "log", "write"));
            this.inputStep = this.findStep(XMLHandler.getTagValue(infonode, "log", "input"));
            this.outputStep = this.findStep(XMLHandler.getTagValue(infonode, "log", "output"));
            this.updateStep = this.findStep(XMLHandler.getTagValue(infonode, "log", "update"));
            String logcon = XMLHandler.getTagValue(infonode, "log", "connection");
            this.logConnection = this.findDatabase(logcon);
            this.logTable = XMLHandler.getTagValue(infonode, "log", "table");
            this.useBatchId = "Y".equalsIgnoreCase(XMLHandler.getTagValue(infonode, "log", "use_batchid"));
            String maxdatcon = XMLHandler.getTagValue(infonode, "maxdate", "connection");
            this.maxDateConnection = this.findDatabase(maxdatcon);
            this.maxDateTable = XMLHandler.getTagValue(infonode, "maxdate", "table");
            this.maxDateField = XMLHandler.getTagValue(infonode, "maxdate", "field");
            String offset = XMLHandler.getTagValue(infonode, "maxdate", "offset");
            this.maxDateOffset = Const.toDouble(offset, 0.0);
            String mdiff = XMLHandler.getTagValue(infonode, "maxdate", "maxdiff");
            this.maxDateDifference = Const.toDouble(mdiff, 0.0);
            Node depsnode = XMLHandler.getSubNode(infonode, "dependencies");
            int deps = XMLHandler.countNodes(depsnode, "dependency");
            for (int i5 = 0; i5 < deps; ++i5) {
                Node depnode = XMLHandler.getSubNodeByNr(depsnode, "dependency", i5);
                TransDependency td = new TransDependency(depnode, this.databases);
                if (td.getDatabase() == null || td.getFieldname() == null) continue;
                this.addDependency(td);
            }
            String srowset = XMLHandler.getTagValue(infonode, "size_rowset");
            this.sizeRowset = Const.toInt(srowset, 350);
            this.sleepTimeEmpty = Const.toInt(XMLHandler.getTagValue(infonode, "sleep_time_empty"), 1);
            this.sleepTimeFull = Const.toInt(XMLHandler.getTagValue(infonode, "sleep_time_full"), 1);
            log.logDebug(this.toString(), "nr of steps read : " + this.stepCount());
            log.logDebug(this.toString(), "nr of hops  read : " + this.transHopCount());
            this.sortSteps();
        }
        catch (ETLXMLException xe) {
            throw new ETLXMLException("Error reading transformation from XML file", xe);
        }
    }

    public ArrayList getTransHopSteps(boolean all) {
        ArrayList<StepMeta> st = new ArrayList<StepMeta>();
        for (int x = 0; x < this.transHopCount(); ++x) {
            TransHopMeta hi = this.getTransHop(x);
            if (!hi.isEnabled() && !all) continue;
            int idx = st.indexOf(hi.getFromStep());
            if (idx < 0) {
                st.add(hi.getFromStep());
            }
            if ((idx = st.indexOf(hi.getToStep())) >= 0) continue;
            st.add(hi.getToStep());
        }
        return st;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String n) {
        this.name = n;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String fname) {
        this.filename = fname;
    }

    public boolean isStepUsedInTransHops(StepMeta stepMeta) {
        TransHopMeta fr = this.findTransHopFrom(stepMeta);
        TransHopMeta to = this.findTransHopTo(stepMeta);
        return fr != null || to != null;
    }

    public void setChanged() {
        this.setChanged(true);
    }

    public void setChanged(boolean ch) {
        this.changed = ch;
    }

    public void clearChanged() {
        int i;
        this.changed = false;
        this.changed_steps = false;
        this.changed_databases = false;
        this.changed_hops = false;
        this.changed_notes = false;
        for (i = 0; i < this.stepCount(); ++i) {
            this.getStep(i).setChanged(false);
        }
        for (i = 0; i < this.databaseCount(); ++i) {
            this.getDatabase(i).setChanged(false);
        }
        for (i = 0; i < this.transHopCount(); ++i) {
            this.getTransHop(i).setChanged(false);
        }
        for (i = 0; i < this.noteCount(); ++i) {
            this.getNote(i).setChanged(false);
        }
    }

    public boolean haveConnectionsChanged() {
        if (this.changed_databases) {
            return true;
        }
        for (int i = 0; i < this.databaseCount(); ++i) {
            DatabaseMeta ci = this.getDatabase(i);
            if (!ci.hasChanged()) continue;
            return true;
        }
        return false;
    }

    public boolean haveStepsChanged() {
        if (this.changed_steps) {
            return true;
        }
        for (int i = 0; i < this.stepCount(); ++i) {
            StepMeta stepMeta = this.getStep(i);
            if (!stepMeta.hasChanged()) continue;
            return true;
        }
        return false;
    }

    public boolean haveHopsChanged() {
        if (this.changed_hops) {
            return true;
        }
        for (int i = 0; i < this.transHopCount(); ++i) {
            TransHopMeta hi = this.getTransHop(i);
            if (!hi.hasChanged()) continue;
            return true;
        }
        return false;
    }

    public boolean haveNotesChanged() {
        if (this.changed_notes) {
            return true;
        }
        for (int i = 0; i < this.noteCount(); ++i) {
            NotePadMeta ni = this.getNote(i);
            if (!ni.hasChanged()) continue;
            return true;
        }
        return false;
    }

    public boolean hasChanged() {
        if (this.changed) {
            return true;
        }
        if (this.haveConnectionsChanged()) {
            return true;
        }
        if (this.haveStepsChanged()) {
            return true;
        }
        if (this.haveHopsChanged()) {
            return true;
        }
        return this.haveNotesChanged();
    }

    public boolean hasLoop(StepMeta stepMeta) {
        return this.hasLoop(stepMeta, null, true) || this.hasLoop(stepMeta, null, false);
    }

    public boolean hasLoop(StepMeta stepMeta, StepMeta lookup, boolean info) {
        int nr = this.findPrevStepCount(stepMeta, info);
        for (int i = 0; i < nr; ++i) {
            StepMeta prevStepMeta = this.findPrevStep(stepMeta, i, info);
            if (prevStepMeta == null) continue;
            if (prevStepMeta.equals(stepMeta)) {
                return true;
            }
            if (prevStepMeta.equals(lookup)) {
                return true;
            }
            if (!this.hasLoop(prevStepMeta, lookup == null ? stepMeta : lookup, info)) continue;
            return true;
        }
        return false;
    }

    public void selectAll() {
        int i;
        for (i = 0; i < this.stepCount(); ++i) {
            StepMeta stepMeta = this.getStep(i);
            stepMeta.setSelected(true);
        }
        for (i = 0; i < this.noteCount(); ++i) {
            NotePadMeta ni = this.getNote(i);
            ni.setSelected(true);
        }
    }

    public void unselectAll() {
        int i;
        for (i = 0; i < this.stepCount(); ++i) {
            StepMeta stepMeta = this.getStep(i);
            stepMeta.setSelected(false);
        }
        for (i = 0; i < this.noteCount(); ++i) {
            NotePadMeta ni = this.getNote(i);
            ni.setSelected(false);
        }
    }

    public int nrSelectedSteps() {
        int count = 0;
        for (int i = 0; i < this.stepCount(); ++i) {
            StepMeta stepMeta = this.getStep(i);
            if (!stepMeta.isSelected()) continue;
            ++count;
        }
        return count;
    }

    public StepMeta getSelectedStep(int nr) {
        int count = 0;
        for (int i = 0; i < this.stepCount(); ++i) {
            StepMeta stepMeta = this.getStep(i);
            if (!stepMeta.isSelected()) continue;
            if (nr == count) {
                return stepMeta;
            }
            ++count;
        }
        return null;
    }

    public int selectedNoteCount() {
        int count = 0;
        for (NotePadMeta ni : this.notes) {
            if (!ni.isSelected()) continue;
            ++count;
        }
        return count;
    }

    public NotePadMeta getSelectedNote(int nr) {
        int count = 0;
        for (int i = 0; i < this.noteCount(); ++i) {
            NotePadMeta ni = this.getNote(i);
            if (!ni.isSelected()) continue;
            if (nr == count) {
                return ni;
            }
            ++count;
        }
        return null;
    }

    public StepMeta[] getSelectedSteps() {
        int sels = this.nrSelectedSteps();
        if (sels == 0) {
            return null;
        }
        StepMeta[] retval = new StepMeta[sels];
        for (int i = 0; i < sels; ++i) {
            StepMeta stepMeta;
            retval[i] = stepMeta = this.getSelectedStep(i);
        }
        return retval;
    }

    public NotePadMeta[] getSelectedNotes() {
        int sels = this.selectedNoteCount();
        if (sels == 0) {
            return null;
        }
        NotePadMeta[] retval = new NotePadMeta[sels];
        for (int i = 0; i < sels; ++i) {
            NotePadMeta si;
            retval[i] = si = this.getSelectedNote(i);
        }
        return retval;
    }

    public String[] getSelectedStepNames() {
        int sels = this.nrSelectedSteps();
        if (sels == 0) {
            return null;
        }
        String[] retval = new String[sels];
        for (int i = 0; i < sels; ++i) {
            StepMeta stepMeta = this.getSelectedStep(i);
            retval[i] = stepMeta.getName();
        }
        return retval;
    }

    public int[] getStepIndexes(StepMeta[] steps) {
        int[] retval = new int[steps.length];
        for (int i = 0; i < steps.length; ++i) {
            retval[i] = this.indexOfStep(steps[i]);
        }
        return retval;
    }

    public int[] getNoteIndexes(NotePadMeta[] notes) {
        int[] retval = new int[notes.length];
        for (int i = 0; i < notes.length; ++i) {
            retval[i] = this.indexOfNote(notes[i]);
        }
        return retval;
    }

    public int getMaxUndo() {
        return this.max_undo;
    }

    public void setMaxUndo(int mu) {
        this.max_undo = mu;
        while (this.undo.size() > mu && this.undo.size() > 0) {
            this.undo.remove(0);
        }
    }

    public String[] getStepNames() {
        String[] retval = new String[this.stepCount()];
        for (int i = 0; i < this.stepCount(); ++i) {
            retval[i] = this.getStep(i).getName();
        }
        return retval;
    }

    public StepMeta[] getStepsArray() {
        StepMeta[] retval = new StepMeta[this.stepCount()];
        for (int i = 0; i < this.stepCount(); ++i) {
            retval[i] = this.getStep(i);
        }
        return retval;
    }

    public TransHopMeta[] getTransHopsArray() {
        TransHopMeta[] retval = new TransHopMeta[this.transHopCount()];
        for (int i = 0; i < this.transHopCount(); ++i) {
            retval[i] = this.getTransHop(i);
        }
        return retval;
    }

    public boolean findPrevious(StepMeta startStep, StepMeta stepToFind) {
        boolean found;
        StepMeta stepMeta;
        int i;
        int nrPrevious = this.findPrevStepCount(startStep, false);
        for (i = 0; i < nrPrevious; ++i) {
            stepMeta = this.findPrevStep(startStep, i, false);
            if (stepMeta.equals(stepToFind)) {
                return true;
            }
            found = this.findPrevious(stepMeta, stepToFind);
            if (!found) continue;
            return true;
        }
        nrPrevious = this.findPrevStepCount(startStep, true);
        for (i = 0; i < nrPrevious; ++i) {
            stepMeta = this.findPrevStep(startStep, i, true);
            if (stepMeta.equals(stepToFind)) {
                return true;
            }
            found = this.findPrevious(stepMeta, stepToFind);
            if (!found) continue;
            return true;
        }
        return false;
    }

    public void sortSteps() {
        try {
            Const.quickSort(this.steps);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void sortHops() {
        Const.quickSort(this.hops);
    }

    public void sortStepsNatural() {
        int len = this.steps.size();
        for (int j = 0; j < len; ++j) {
            for (int i = 0; i < len - 1; ++i) {
                StepMeta one = (StepMeta)this.steps.get(i);
                StepMeta two = (StepMeta)this.steps.get(i + 1);
                if (this.findPrevious(two, one)) continue;
                this.setStep(i + 1, one);
                this.setStep(i, two);
            }
        }
    }

    public void sortHopsNatural() {
        int len = this.hops.size();
        for (int j = 0; j < len; ++j) {
            for (int i = 0; i < len - 1; ++i) {
                StepMeta b;
                TransHopMeta one = (TransHopMeta)this.hops.get(i);
                TransHopMeta two = (TransHopMeta)this.hops.get(i + 1);
                StepMeta a = two.getFromStep();
                if (this.findPrevious(a, b = one.getToStep()) || a.equals(b)) continue;
                this.setTransHop(i + 1, one);
                this.setTransHop(i, two);
            }
        }
    }

    public String getAlternativeStepname(String stepname) {
        String newname = stepname;
        StepMeta stepMeta = this.findStep(newname);
        int nr = 1;
        while (stepMeta != null) {
            newname = stepname + " " + ++nr;
            stepMeta = this.findStep(newname);
        }
        return newname;
    }

    public ArrayList getSQLStatements() throws ETLStepException {
        return this.getSQLStatements(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getSQLStatements(IProgressMonitor monitor) throws ETLStepException {
        if (monitor != null) {
            monitor.beginTask("Getting the SQL needed for this transformation...", this.stepCount() + 1);
        }
        ArrayList<SQLStatement> stats = new ArrayList<SQLStatement>();
        for (int i = 0; i < this.stepCount(); ++i) {
            StepMeta stepMeta = this.getStep(i);
            if (monitor != null) {
                monitor.subTask("Getting SQL statements for step [" + stepMeta + "]");
            }
            Row prev = this.getPrevStepFields(stepMeta);
            SQLStatement sql = stepMeta.getStepMetaInterface().getSQLStatements(this, stepMeta, prev);
            if (sql.getSQL() != null || sql.hasError()) {
                stats.add(sql);
            }
            if (monitor == null) continue;
            monitor.worked(1);
        }
        if (monitor != null) {
            monitor.subTask("Getting SQL statements for the transformation (logtable, etc.)");
        }
        if (this.logConnection != null && this.logTable != null && this.logTable.length() > 0) {
            Database db = new Database(this.logConnection);
            try {
                db.connect();
                Row fields = Database.getTransLogrecordFields(this.useBatchId, this.logfieldUsed);
                String sql = db.getDDL(this.logTable, fields);
                if (sql != null && sql.length() > 0) {
                    SQLStatement stat = new SQLStatement("<this transformation>", this.logConnection, sql);
                    stats.add(stat);
                }
            }
            catch (ETLDatabaseException dbe) {
                SQLStatement stat = new SQLStatement("<this transformation>", this.logConnection, null);
                stat.setError("Error obtaining transformation log table info: " + dbe.getMessage());
                stats.add(stat);
            }
            finally {
                db.disconnect();
            }
        }
        if (monitor != null) {
            monitor.worked(1);
        }
        if (monitor != null) {
            monitor.done();
        }
        return stats;
    }

    public String getSQLStatementsString() throws ETLStepException {
        String sql = "";
        ArrayList stats = this.getSQLStatements();
        for (int i = 0; i < stats.size(); ++i) {
            SQLStatement stat = (SQLStatement)stats.get(i);
            if (stat.hasError() || !stat.hasSQL()) continue;
            sql = sql + stat.getSQL();
        }
        return sql;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkSteps(ArrayList remarks, boolean only_selected, IProgressMonitor monitor) {
        try {
            StepMeta[] steps;
            String[] stepnames;
            remarks.clear();
            Hashtable<Value, String> values = new Hashtable<Value, String>();
            if (!only_selected || this.nrSelectedSteps() == 0) {
                stepnames = this.getStepNames();
                steps = this.getStepsArray();
            } else {
                stepnames = this.getSelectedStepNames();
                steps = this.getSelectedSteps();
            }
            boolean stop_checking = false;
            if (monitor != null) {
                monitor.beginTask("Verifying this transformation...", steps.length + 2);
            }
            for (int i = 0; i < steps.length && !stop_checking; ++i) {
                CheckResult cr;
                if (monitor != null) {
                    monitor.subTask("Verifying step [" + stepnames[i] + "]");
                }
                StepMeta stepMeta = steps[i];
                int nrinfo = this.findInfoStepCount(stepMeta);
                StepMeta[] infostep = null;
                if (nrinfo > 0) {
                    infostep = this.getInfoStep(stepMeta);
                }
                Row info = null;
                if (infostep != null) {
                    try {
                        info = this.getStepFields(infostep);
                    }
                    catch (ETLStepException kse) {
                        info = null;
                        cr = new CheckResult(4, "An error occurred getting step info fields for step [" + stepMeta + "] :" + Const.CR + kse.getMessage(), stepMeta);
                        remarks.add(cr);
                    }
                }
                Row prev = null;
                try {
                    prev = this.getPrevStepFields(stepMeta);
                }
                catch (ETLStepException kse) {
                    CheckResult cr2 = new CheckResult(4, "An error occurred getting input fields for step [" + stepMeta + "] :" + Const.CR + kse.getMessage(), stepMeta);
                    remarks.add(cr2);
                    stop_checking = true;
                }
                if (this.isStepUsedInTransHops(stepMeta)) {
                    String[] input = this.getPrevStepNames(stepMeta);
                    String[] output = this.getPrevStepNames(stepMeta);
                    stepMeta.check(remarks, prev, input, output, info);
                    if (prev != null) {
                        for (int x = 0; x < prev.size(); ++x) {
                            Value v = prev.getValue(x);
                            String name = v.getName();
                            if (name == null) {
                                values.put(v, "Field name is empty.");
                                continue;
                            }
                            if (name.indexOf(32) >= 0) {
                                values.put(v, "Field name contains one or more spaces.  (database unfriendly!)");
                                continue;
                            }
                            char[] list = new char[]{'.', ',', '-', '/', '+', '*', '\'', '\t', '\"', '|', '@', '(', ')', '{', '}', '!', '^'};
                            for (int c = 0; c < list.length; ++c) {
                                if (name.indexOf(list[c]) < 0) continue;
                                values.put(v, "Field name contains one or more " + list[c] + "  (database unfriendly!)");
                            }
                        }
                        if (prev.size() > 1) {
                            String[] fieldNames = prev.getFieldNames();
                            String[] sortedNames = Const.sortStrings(fieldNames);
                            String prevName = sortedNames[0];
                            for (int x = 1; x < sortedNames.length; ++x) {
                                if (prevName.equalsIgnoreCase(sortedNames[x])) {
                                    CheckResult cr3 = new CheckResult(3, "I found input fields that have the same name [" + prevName + "]", stepMeta);
                                    remarks.add(cr3);
                                    continue;
                                }
                                prevName = sortedNames[x];
                            }
                        }
                    } else {
                        CheckResult cr4 = new CheckResult(4, "Can't find previous fields for step: " + stepMeta.getName(), stepMeta);
                        remarks.add(cr4);
                    }
                } else {
                    cr = new CheckResult(3, "This step is not used in the transformation.", stepMeta);
                    remarks.add(cr);
                }
                if (monitor == null) continue;
                monitor.worked(1);
                if (!monitor.isCanceled()) continue;
                stop_checking = true;
            }
            if (monitor == null || !monitor.isCanceled()) {
                if (monitor != null) {
                    monitor.subTask("Checking the logging table...");
                }
                if (this.getLogConnection() != null) {
                    Database logdb = new Database(this.getLogConnection());
                    try {
                        logdb.connect();
                        CheckResult cr = new CheckResult(1, "Transformation logging connection supplied: connecting works", null);
                        remarks.add(cr);
                        if (this.getLogTable() != null) {
                            if (logdb.checkTableExists(this.getLogTable())) {
                                cr = new CheckResult(1, "The logging table [" + this.getLogTable() + "] exists.", null);
                                remarks.add(cr);
                                Row fields = Database.getTransLogrecordFields(this.isBatchIdUsed(), this.isLogfieldUsed());
                                String sql = logdb.getDDL(this.getLogTable(), fields);
                                if (sql == null || sql.length() == 0) {
                                    cr = new CheckResult(1, "The logging table has the correct layout.", null);
                                    remarks.add(cr);
                                } else {
                                    cr = new CheckResult(4, "The logging table needs some adjustments:" + Const.CR + sql, null);
                                    remarks.add(cr);
                                }
                            } else {
                                cr = new CheckResult(4, "The logging table doesn't exist on the logging connection", null);
                                remarks.add(cr);
                            }
                        } else {
                            cr = new CheckResult(4, "The log table is not specified, the logging connection is", null);
                            remarks.add(cr);
                        }
                    }
                    catch (ETLDatabaseException cr) {
                    }
                    finally {
                        logdb.disconnect();
                    }
                }
                if (monitor != null) {
                    monitor.worked(1);
                }
            }
            if (monitor != null) {
                monitor.subTask("Checking for database unfriendly characters in field names...");
            }
            if (values.size() > 0) {
                Enumeration keys = values.keys();
                while (keys.hasMoreElements()) {
                    Value v = (Value)keys.nextElement();
                    String message = (String)values.get(v);
                    CheckResult cr = new CheckResult(3, "Field [" + v.getName() + "] : " + message + " in step [" + v.getOrigin() + "]", this.findStep(v.getOrigin()));
                    remarks.add(cr);
                }
            } else {
                CheckResult cr = new CheckResult(1, "None of the field names seem to contain spaces or other database unfriendly characters(OK)", null);
                remarks.add(cr);
            }
            if (monitor != null) {
                monitor.worked(1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public List getResultRows() {
        return this.resultRows;
    }

    public void setResultRows(ArrayList resultRows) {
        this.resultRows = resultRows;
    }

    public List getSourceRows() {
        return this.sourceRows;
    }

    public void setSourceRows(List sourceRows) {
        this.sourceRows = sourceRows;
    }

    public RepositoryDirectory getDirectory() {
        return this.directory;
    }

    public void setDirectory(RepositoryDirectory directory) {
        this.directory = directory;
    }

    public RepositoryDirectory getDirectoryTree() {
        return this.directoryTree;
    }

    public void setDirectoryTree(RepositoryDirectory directoryTree) {
        this.directoryTree = directoryTree;
    }

    public String getPathAndName() {
        if (this.getDirectory().isRoot()) {
            return this.getDirectory().getPath() + this.getName();
        }
        return this.getDirectory().getPath() + "/" + this.getName();
    }

    public String[] getArguments() {
        return this.arguments;
    }

    public void setArguments(String[] arguments) {
        this.arguments = arguments;
    }

    public Hashtable getCounters() {
        return this.counters;
    }

    public void setCounters(Hashtable counters) {
        this.counters = counters;
    }

    public List getDependencies() {
        return this.dependencies;
    }

    public void setDependencies(ArrayList dependencies) {
        this.dependencies = dependencies;
    }

    public StepMeta getInputStep() {
        return this.inputStep;
    }

    public void setInputStep(StepMeta inputStep) {
        this.inputStep = inputStep;
    }

    public DatabaseMeta getLogConnection() {
        return this.logConnection;
    }

    public void setLogConnection(DatabaseMeta logConnection) {
        this.logConnection = logConnection;
    }

    public String getLogTable() {
        return this.logTable;
    }

    public void setLogTable(String logTable) {
        this.logTable = logTable;
    }

    public DatabaseMeta getMaxDateConnection() {
        return this.maxDateConnection;
    }

    public void setMaxDateConnection(DatabaseMeta maxDateConnection) {
        this.maxDateConnection = maxDateConnection;
    }

    public double getMaxDateDifference() {
        return this.maxDateDifference;
    }

    public void setMaxDateDifference(double maxDateDifference) {
        this.maxDateDifference = maxDateDifference;
    }

    public String getMaxDateField() {
        return this.maxDateField;
    }

    public void setMaxDateField(String maxDateField) {
        this.maxDateField = maxDateField;
    }

    public double getMaxDateOffset() {
        return this.maxDateOffset;
    }

    public void setMaxDateOffset(double maxDateOffset) {
        this.maxDateOffset = maxDateOffset;
    }

    public String getMaxDateTable() {
        return this.maxDateTable;
    }

    public void setMaxDateTable(String maxDateTable) {
        this.maxDateTable = maxDateTable;
    }

    public StepMeta getOutputStep() {
        return this.outputStep;
    }

    public void setOutputStep(StepMeta outputStep) {
        this.outputStep = outputStep;
    }

    public StepMeta getReadStep() {
        return this.readStep;
    }

    public void setReadStep(StepMeta readStep) {
        this.readStep = readStep;
    }

    public StepMeta getUpdateStep() {
        return this.updateStep;
    }

    public void setUpdateStep(StepMeta updateStep) {
        this.updateStep = updateStep;
    }

    public Hashtable getVariables() {
        return this.variables;
    }

    public void setVariables(Hashtable variables) {
        this.variables = variables;
    }

    public StepMeta getWriteStep() {
        return this.writeStep;
    }

    public void setWriteStep(StepMeta writeStep) {
        this.writeStep = writeStep;
    }

    public int getSizeRowset() {
        return this.sizeRowset;
    }

    public void setSizeRowset(int sizeRowset) {
        this.sizeRowset = sizeRowset;
    }

    public DBCache getDbCache() {
        return this.dbCache;
    }

    public void setDbCache(DBCache dbCache) {
        this.dbCache = dbCache;
    }

    public long getBatchId() {
        return this.batchId;
    }

    public void setBatchId(long batchId) {
        this.batchId = batchId;
    }

    public boolean isBatchIdUsed() {
        return this.useBatchId;
    }

    public void setBatchIdUsed(boolean useBatchId) {
        this.useBatchId = useBatchId;
    }

    public boolean isLogfieldUsed() {
        return this.logfieldUsed;
    }

    public void setLogfieldUsed(boolean logfieldUsed) {
        this.logfieldUsed = logfieldUsed;
    }

    public Value getCreatedDate() {
        return this.createdDate;
    }

    public void setCreatedDate(Value createdDate) {
        this.createdDate = createdDate;
    }

    public void setCreatedUser(String createdUser) {
        this.createdUser = createdUser;
    }

    public String getCreatedUser() {
        return this.createdUser;
    }

    public void setModifiedDate(Value modifiedDate) {
        this.modifiedDate = modifiedDate;
    }

    public Value getModifiedDate() {
        return this.modifiedDate;
    }

    public void setModifiedUser(String modifiedUser) {
        this.modifiedUser = modifiedUser;
    }

    public String getModifiedUser() {
        return this.modifiedUser;
    }

    public String toString() {
        if (this.name != null) {
            return this.name;
        }
        return this.getClass().getName();
    }

    public void cancelQueries() throws ETLDatabaseException {
        for (int i = 0; i < this.stepCount(); ++i) {
            this.getStep(i).getStepMetaInterface().cancelQueries();
        }
    }

    public Row getUsedArguments(String[] arguments) {
        Row args = new Row();
        for (int i = 0; i < this.stepCount(); ++i) {
            StepMetaInterface smi = this.getStep(i).getStepMetaInterface();
            Row row = smi.getUsedArguments();
            if (row == null) continue;
            for (int x = 0; x < row.size(); ++x) {
                Value value = row.getValue(x);
                String argname = value.getName();
                if (args.searchValueIndex(argname) >= 0) continue;
                args.addValue(value);
            }
        }
        String[] saved = Props.getInstance().getLastArguments();
        if (arguments != null) {
            for (int i = 0; i < args.size(); ++i) {
                Value arg = args.getValue(i);
                int argNr = Const.toInt(arg.getName(), -1);
                if (argNr >= 0 && argNr < arguments.length) {
                    arg.setValue(arguments[argNr]);
                }
                if ((arg.isNull() || arg.getString() == null) && argNr >= 0 && argNr < saved.length && saved[argNr] != null) {
                    arg.setValue(saved[argNr]);
                }
                arg.setName("Argument " + arg.getName());
            }
        }
        return args;
    }

    public StepMeta getMappingInputStep() {
        for (int i = 0; i < this.stepCount(); ++i) {
            if (!this.getStep(i).getStepID().equalsIgnoreCase("MappingInput")) continue;
            return this.getStep(i);
        }
        return null;
    }

    public StepMeta getMappingOutputStep() {
        for (int i = 0; i < this.stepCount(); ++i) {
            if (!this.getStep(i).getStepID().equalsIgnoreCase("MappingOutput")) continue;
            return this.getStep(i);
        }
        return null;
    }

    public int getSleepTimeEmpty() {
        return 1;
    }

    public int getSleepTimeFull() {
        return 1;
    }

    public void setSleepTimeEmpty(int sleepTimeEmpty) {
        this.sleepTimeEmpty = sleepTimeEmpty;
    }

    public void setSleepTimeFull(int sleepTimeFull) {
        this.sleepTimeFull = sleepTimeFull;
    }

    public static final StepMeta findStep(List steps, String stepname) {
        if (steps == null) {
            return null;
        }
        for (int i = 0; i < steps.size(); ++i) {
            StepMeta stepMeta = (StepMeta)steps.get(i);
            if (!stepMeta.getName().equalsIgnoreCase(stepname)) continue;
            return stepMeta;
        }
        return null;
    }
}

