/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.etl.transformation.step;

import com.kingdee.bos.ctrl.etl.base.Row;
import com.kingdee.bos.ctrl.etl.exception.ETLDatabaseException;
import com.kingdee.bos.ctrl.etl.exception.ETLException;
import com.kingdee.bos.ctrl.etl.exception.ETLStepLoaderException;
import com.kingdee.bos.ctrl.etl.exception.ETLXMLException;
import com.kingdee.bos.ctrl.etl.repository.Repository;
import com.kingdee.bos.ctrl.etl.transformation.StepLoader;
import com.kingdee.bos.ctrl.etl.transformation.StepPlugin;
import com.kingdee.bos.ctrl.etl.transformation.step.BaseStep;
import com.kingdee.bos.ctrl.etl.transformation.step.BaseStepMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.StepMetaInterface;
import com.kingdee.bos.ctrl.etl.util.Const;
import com.kingdee.bos.ctrl.etl.util.LogWriter;
import com.kingdee.bos.ctrl.etl.util.XMLHandler;
import java.awt.Point;
import java.util.Hashtable;
import java.util.List;
import org.w3c.dom.Node;

public class StepMeta
implements Cloneable,
Comparable {
    private String stepid;
    private String stepname;
    private StepMetaInterface stepMetaInterface;
    private boolean selected;
    public boolean distributes;
    private int copies;
    private String description;
    private boolean terminator;
    private Point location;
    private boolean drawstep;
    private LogWriter log;
    private long id;

    public StepMeta(LogWriter l, String stepid, String name, StepMetaInterface info) {
        this.log = l;
        this.stepid = stepid;
        this.stepname = name;
        this.stepMetaInterface = info;
        this.selected = false;
        this.distributes = true;
        this.copies = 1;
        this.location = new Point(0, 0);
        this.drawstep = false;
        this.description = null;
    }

    public StepMeta(LogWriter log) {
        this(log, (String)null, (String)null, (StepMetaInterface)null);
    }

    public String getXML() {
        String retval = "";
        retval = retval + "  <step>" + Const.CR;
        retval = retval + "    " + XMLHandler.addTagValue("name", this.getName());
        retval = retval + "    " + XMLHandler.addTagValue("type", this.getStepID());
        retval = retval + "    " + XMLHandler.addTagValue("description", this.description);
        retval = retval + "    " + XMLHandler.addTagValue("distribute", this.distributes);
        retval = retval + "    " + XMLHandler.addTagValue("copies", this.copies);
        retval = retval + this.stepMetaInterface.getXML();
        retval = retval + "    <GUI>" + Const.CR;
        retval = retval + "      <xloc>" + this.location.x + "</xloc>" + Const.CR;
        retval = retval + "      <yloc>" + this.location.y + "</yloc>" + Const.CR;
        retval = retval + "      <draw>" + (this.drawstep ? "Y" : "N") + "</draw>" + Const.CR;
        retval = retval + "      </GUI>" + Const.CR;
        retval = retval + "    </step>" + Const.CR + Const.CR;
        retval = retval + "    </step>" + Const.CR + Const.CR;
        return retval;
    }

    public StepMeta(LogWriter log, Node stepnode, List databases, Hashtable counters) throws ETLXMLException {
        this.log = log;
        StepLoader steploader = StepLoader.getInstance();
        try {
            int y;
            int x;
            this.stepname = XMLHandler.getTagValue(stepnode, "name");
            this.stepid = XMLHandler.getTagValue(stepnode, "type");
            log.logDebug("StepMeta()", "looking for the right step node (" + this.stepname + ")");
            StepPlugin sp = steploader.findStepPluginWithID(this.stepid);
            if (sp == null) {
                throw new ETLStepLoaderException("Unable to load class for step/plugin with id [" + this.stepid + "]." + Const.CR + "Check if the plugin is available in the plugins subdirectory of the ETL distribution.");
            }
            this.stepMetaInterface = BaseStep.getStepInfo(sp, steploader);
            if (this.stepMetaInterface != null) {
                this.stepMetaInterface.loadXML(stepnode, databases, counters);
            }
            log.logDebug("StepMeta()", "specifics loaded for " + this.stepname);
            this.description = XMLHandler.getTagValue(stepnode, "description");
            this.copies = Const.toInt(XMLHandler.getTagValue(stepnode, "copies"), 1);
            String sdistri = XMLHandler.getTagValue(stepnode, "distribute");
            this.distributes = "Y".equalsIgnoreCase(sdistri);
            if (sdistri == null) {
                this.distributes = true;
            }
            String xloc = XMLHandler.getTagValue(stepnode, "GUI", "xloc");
            String yloc = XMLHandler.getTagValue(stepnode, "GUI", "yloc");
            try {
                x = Integer.parseInt(xloc);
            }
            catch (Exception e) {
                x = 0;
            }
            try {
                y = Integer.parseInt(yloc);
            }
            catch (Exception e) {
                y = 0;
            }
            this.location = new Point(x, y);
            this.drawstep = "Y".equalsIgnoreCase(XMLHandler.getTagValue(stepnode, "GUI", "draw"));
            log.logDebug("StepMeta()", "end of readXML()");
        }
        catch (Exception e) {
            throw new ETLXMLException("Unable to load step info from XML step node", e);
        }
    }

    public long getID() {
        return this.id;
    }

    public void setID(long id) {
        this.id = id;
    }

    public void setCopies(int c) {
        if (this.copies != c) {
            this.setChanged();
        }
        this.copies = c;
    }

    public int getCopies() {
        return this.copies;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        StepMeta stepMeta = (StepMeta)obj;
        return this.getName().equalsIgnoreCase(stepMeta.getName());
    }

    public int hashCode() {
        return this.stepname.hashCode();
    }

    public int compareTo(Object o) {
        return this.toString().compareTo(((StepMeta)o).toString());
    }

    public boolean hasChanged() {
        BaseStepMeta bsi = (BaseStepMeta)((Object)this.getStepMetaInterface());
        return bsi != null ? bsi.hasChanged() : false;
    }

    public void setChanged(boolean ch) {
        BaseStepMeta bsi = (BaseStepMeta)((Object)this.getStepMetaInterface());
        if (bsi != null) {
            bsi.setChanged(ch);
        }
    }

    public void setChanged() {
        BaseStepMeta bsi = (BaseStepMeta)((Object)this.getStepMetaInterface());
        if (bsi != null) {
            bsi.setChanged();
        }
    }

    public boolean chosesTargetSteps() {
        if (this.getStepMetaInterface() != null) {
            return this.getStepMetaInterface().getTargetSteps() != null;
        }
        return false;
    }

    public Object clone() {
        try {
            StepMeta retval = (StepMeta)super.clone();
            boolean changed = this.hasChanged();
            retval.stepMetaInterface = this.stepMetaInterface != null ? (StepMetaInterface)this.stepMetaInterface.clone() : null;
            retval.setChanged(changed);
            this.setChanged(changed);
            return retval;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public StepMetaInterface getStepMetaInterface() {
        return this.stepMetaInterface;
    }

    public String getStepID() {
        return this.stepid;
    }

    public String getName() {
        return this.stepname;
    }

    public void setName(String sname) {
        this.stepname = sname;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setSelected(boolean sel) {
        this.selected = sel;
    }

    public void flipSelected() {
        this.selected = !this.selected;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setTerminator() {
        this.setTerminator(true);
    }

    public void setTerminator(boolean t) {
        this.terminator = t;
    }

    public boolean hasTerminator() {
        return this.terminator;
    }

    public StepMeta(LogWriter log, long id_step) {
        this(log, (String)null, (String)null, (StepMetaInterface)null);
        this.setID(id_step);
    }

    public StepMeta(LogWriter log, Repository rep, long id_step, List databases, Hashtable counters) throws ETLException {
        block5: {
            this.log = log;
            try {
                StepLoader steploader = StepLoader.getInstance();
                Row r = rep.getStep(id_step);
                if (r != null) {
                    this.setID(id_step);
                    this.stepname = r.searchValue("Name").getString();
                    this.description = r.searchValue("Description").getString();
                    long id_step_type = r.searchValue("ID_StepType").getInteger();
                    Row steptyperow = rep.getStepType(id_step_type);
                    this.stepid = steptyperow.searchValue("Code").getString();
                    this.distributes = r.searchValue("Distribute").getBoolean();
                    this.copies = (int)r.searchValue("Copies").getInteger();
                    int x = (int)r.searchValue("GUILocationX").getInteger();
                    int y = (int)r.searchValue("GUILocationY").getInteger();
                    this.location = new Point(x, y);
                    this.drawstep = r.searchValue("GUIDraw").getBoolean();
                    StepPlugin sp = steploader.findStepPluginWithID(this.stepid);
                    if (sp == null) {
                        throw new ETLStepLoaderException("Unable to load class for step/plugin with id [" + this.stepid + "]." + Const.CR + "Check if the plugin is available in the plugins subdirectory of the ETL distribution.");
                    }
                    this.stepMetaInterface = BaseStep.getStepInfo(sp, steploader);
                    this.stepMetaInterface = BaseStep.getStepInfo(sp, steploader);
                    if (this.stepMetaInterface != null) {
                        this.stepMetaInterface.readRep(rep, this.getID(), databases, counters);
                    }
                    break block5;
                }
                throw new ETLException("Step information for id_step=" + id_step + " could not be found!");
            }
            catch (ETLDatabaseException dbe) {
                throw new ETLException("Step with id " + this.getID() + " could not be loaded from the repository!", dbe);
            }
        }
    }

    public void saveRep(Repository rep, long id_transformation) throws ETLException {
        try {
            this.log.logDebug(this.toString(), "STEP SAVE insert general...");
            this.setID(rep.insertStep(id_transformation, this.getName(), this.getDescription(), this.getStepID(), this.distributes, this.copies, -1L, -1L, false));
            this.log.logDebug(this.toString(), "STEP SAVE details...");
            this.stepMetaInterface.saveRep(rep, id_transformation, this.getID());
        }
        catch (ETLException e) {
            throw new ETLException("Unable to save step info to the repository for id_transformation=" + id_transformation, e);
        }
    }

    public void check(List remarks, Row prev, String[] input, String[] output, Row info) {
        this.stepMetaInterface.check(remarks, this, prev, input, output, info);
    }

    public String toString() {
        if (this.getName() == null) {
            return this.getClass().getName();
        }
        return this.getName();
    }

    public void setLocation(int x, int y) {
        int ny;
        int nx = x >= 0 ? x : 0;
        Point loc = new Point(nx, ny = y >= 0 ? y : 0);
        if (!loc.equals(this.location)) {
            this.setChanged();
        }
        this.location = loc;
    }

    public void setLocation(Point loc) {
        if (loc != null && !loc.equals(this.location)) {
            this.setChanged();
        }
        this.location = loc;
    }

    public Point getLocation() {
        return this.location;
    }
}

