/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.etl.transformation.step.calculator;

import com.kingdee.bos.ctrl.etl.base.Row;
import com.kingdee.bos.ctrl.etl.exception.ETLException;
import com.kingdee.bos.ctrl.etl.exception.ETLValueException;
import com.kingdee.bos.ctrl.etl.transformation.Trans;
import com.kingdee.bos.ctrl.etl.transformation.TransMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.BaseStep;
import com.kingdee.bos.ctrl.etl.transformation.step.StepDataInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.StepInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.StepMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.StepMetaInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.calculator.CalculatorData;
import com.kingdee.bos.ctrl.etl.transformation.step.calculator.CalculatorMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.calculator.CalculatorMetaFunction;
import com.kingdee.bos.ctrl.etl.value.Value;
import java.util.Calendar;

public class Calculator
extends BaseStep
implements StepInterface {
    private CalculatorMeta meta;
    private CalculatorData data;

    public Calculator(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    @Override
    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws ETLException {
        this.meta = (CalculatorMeta)smi;
        this.data = (CalculatorData)sdi;
        Row r = this.getRow();
        if (r == null) {
            this.setOutputDone();
            return false;
        }
        this.log.logRowlevel(this.toString(), "Read row #" + this.linesRead + " : " + r);
        this.calcFields(r);
        this.putRow(r);
        this.log.logRowlevel(this.toString(), "Wrote row #" + this.linesWritten + " : " + r);
        if (this.linesRead > 0L && this.linesRead % 5000L == 0L) {
            this.logBasic("Linenr " + this.linesRead);
        }
        return true;
    }

    private void calcFields(Row r) throws ETLValueException {
        CalculatorMetaFunction fn;
        int i;
        if (this.meta.getCalculation() != null) {
            for (i = 0; i < this.meta.getCalculation().length; ++i) {
                fn = this.meta.getCalculation()[i];
                if (fn.getFieldName() == null || fn.getFieldName().length() <= 0) continue;
                this.debug = "Processing function [" + fn.getCalcTypeLongDesc() + "] for field [" + fn.getFieldName() + "]";
                Value value = null;
                Value fieldA = null;
                Value fieldB = null;
                Value fieldC = null;
                if (fn.getCalcType() != 1) {
                    if (fn.getFieldA() != null && fn.getFieldA().length() > 0) {
                        Integer idxA = (Integer)this.data.indexCache.get(fn.getFieldA());
                        if (idxA == null) {
                            idxA = new Integer(r.searchValueIndex(fn.getFieldA()));
                        }
                        if (idxA < 0) {
                            throw new ETLValueException("Field [" + fn.getFieldA() + "] can't be found in the input row!");
                        }
                        this.data.indexCache.put(fn.getFieldA(), idxA);
                        fieldA = r.getValue(idxA);
                    }
                    if (fn.getFieldB() != null && fn.getFieldB().length() > 0) {
                        Integer idxB = (Integer)this.data.indexCache.get(fn.getFieldB());
                        if (idxB == null) {
                            idxB = new Integer(r.searchValueIndex(fn.getFieldB()));
                        }
                        if (idxB < 0) {
                            throw new ETLValueException("Field [" + fn.getFieldB() + "] can't be found in the input row!");
                        }
                        this.data.indexCache.put(fn.getFieldB(), idxB);
                        fieldB = r.getValue(idxB);
                    }
                    if (fn.getFieldC() != null && fn.getFieldC().length() > 0) {
                        Integer idxC = (Integer)this.data.indexCache.get(fn.getFieldC());
                        if (idxC == null) {
                            idxC = new Integer(r.searchValueIndex(fn.getFieldC()));
                        }
                        if (idxC < 0) {
                            throw new ETLValueException("Field [" + fn.getFieldC() + "] can't be found in the input row!");
                        }
                        this.data.indexCache.put(fn.getFieldC(), idxC);
                        fieldC = r.getValue(idxC);
                    }
                }
                switch (fn.getCalcType()) {
                    case 0: {
                        break;
                    }
                    case 2: {
                        value = new Value(fn.getFieldName(), fieldA);
                        value.plus(fieldB);
                        break;
                    }
                    case 3: {
                        value = new Value(fn.getFieldName(), fieldA);
                        value.minus(fieldB);
                        break;
                    }
                    case 4: {
                        value = new Value(fn.getFieldName(), fieldA);
                        value.multiply(fieldB);
                        break;
                    }
                    case 5: {
                        value = new Value(fn.getFieldName(), fieldA);
                        value.divide(fieldB);
                        break;
                    }
                    case 6: {
                        value = new Value(fn.getFieldName(), fieldA);
                        value.multiply(fieldA);
                        break;
                    }
                    case 7: {
                        value = new Value(fn.getFieldName(), fieldA);
                        value.sqrt();
                        break;
                    }
                    case 8: {
                        value = new Value(fn.getFieldName(), fieldA);
                        value.multiply(100);
                        value.divide(fieldB);
                        break;
                    }
                    case 9: {
                        value = new Value(fn.getFieldName(), fieldA);
                        Value value2 = new Value(fn.getFieldName(), fieldA);
                        value2.multiply(fieldB);
                        value2.divide(100);
                        value.minus(value2);
                        break;
                    }
                    case 10: {
                        value = new Value(fn.getFieldName(), fieldA);
                        Value value2 = new Value(fn.getFieldName(), fieldA);
                        value2.multiply(fieldB);
                        value2.divide(100);
                        value.plus(value2);
                        break;
                    }
                    case 11: {
                        value = new Value(fn.getFieldName(), fieldA);
                        Value value2 = new Value(fn.getFieldName(), fieldB);
                        value2.multiply(fieldC);
                        value.plus(value2);
                        break;
                    }
                    case 12: {
                        value = new Value(fn.getFieldName(), fieldA);
                        value.multiply(fieldA);
                        Value value2 = new Value(fn.getFieldName(), fieldB);
                        value2.multiply(fieldB);
                        value.plus(value2);
                        value.sqrt();
                        break;
                    }
                    case 13: {
                        value = new Value(fn.getFieldName(), fieldA);
                        value.round();
                        break;
                    }
                    case 14: {
                        value = new Value(fn.getFieldName(), fieldA);
                        if (fieldB == null) break;
                        value.round((int)fieldB.getInteger());
                        break;
                    }
                    case 1: {
                        value = new Value(fn.getFieldName(), fn.getFieldA());
                        value.convertString(fn.getValueType());
                        break;
                    }
                    case 15: {
                        value = new Value(fn.getFieldName(), fieldA);
                        value.nvl(fieldB);
                        break;
                    }
                    case 16: {
                        value = new Value(fn.getFieldName(), fieldA);
                        if (fieldB == null) break;
                        value.add_days(fieldB.getInteger());
                        break;
                    }
                    case 17: {
                        value = new Value(fn.getFieldName(), fieldA);
                        if (fieldA == null) break;
                        Calendar calendar = Calendar.getInstance();
                        calendar.setTime(fieldA.getDate());
                        value.setValue(calendar.get(1));
                        break;
                    }
                    case 18: {
                        value = new Value(fn.getFieldName(), fieldA);
                        if (fieldA == null) break;
                        Calendar calendar = Calendar.getInstance();
                        calendar.setTime(fieldA.getDate());
                        value.setValue(calendar.get(2) + 1);
                        break;
                    }
                    case 19: {
                        value = new Value(fn.getFieldName(), fieldA);
                        if (fieldA == null) break;
                        Calendar calendar = Calendar.getInstance();
                        calendar.setTime(fieldA.getDate());
                        value.setValue(calendar.get(6));
                        break;
                    }
                    case 20: {
                        value = new Value(fn.getFieldName(), fieldA);
                        if (fieldA == null) break;
                        Calendar calendar = Calendar.getInstance();
                        calendar.setTime(fieldA.getDate());
                        value.setValue(calendar.get(5));
                        break;
                    }
                    case 21: {
                        value = new Value(fn.getFieldName(), fieldA);
                        if (fieldA == null) break;
                        Calendar calendar = Calendar.getInstance();
                        calendar.setTime(fieldA.getDate());
                        value.setValue(calendar.get(7));
                        break;
                    }
                    case 22: {
                        value = new Value(fn.getFieldName(), fieldA);
                        if (fieldA == null) break;
                        Calendar calendar = Calendar.getInstance();
                        calendar.setTime(fieldA.getDate());
                        value.setValue(calendar.get(3));
                        break;
                    }
                    default: {
                        throw new ETLValueException("Unknown calculation type #" + fn.getCalcType());
                    }
                }
                if (value == null) continue;
                if (fn.getValueType() != 0) {
                    value.setType(fn.getValueType());
                    value.setLength(fn.getValueLength(), fn.getValuePrecision());
                }
                r.addValue(value);
            }
        }
        this.debug = "remove specified fields from result";
        for (i = this.meta.getCalculation().length - 1; i >= 0; --i) {
            fn = this.meta.getCalculation()[i];
            if (!fn.isRemovedFromResult()) continue;
            Integer idx = (Integer)this.data.indexCache.get(fn.getFieldName());
            if (idx != null) {
                r.removeValue(idx);
                continue;
            }
            throw new ETLValueException("Couldn't find field [" + fn.getFieldName() + "] to remove from result.");
        }
    }

    @Override
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (CalculatorMeta)smi;
        this.data = (CalculatorData)sdi;
        return super.init(smi, sdi);
    }

    @Override
    public void run() {
        try {
            this.logBasic("Starting to run...");
            while (this.processRow(this.meta, this.data) && !this.isStopped()) {
            }
        }
        catch (Exception e) {
            this.logError("Unexpected error in '" + this.debug + "' : " + e.toString());
            this.setErrors(1L);
            this.stopAll();
        }
        finally {
            this.dispose(this.meta, this.data);
            this.logSummary();
            this.markStop();
        }
    }
}

