/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.etl.transformation.step.combinationlookup;

import com.kingdee.bos.ctrl.etl.base.CheckResult;
import com.kingdee.bos.ctrl.etl.base.Row;
import com.kingdee.bos.ctrl.etl.base.SQLStatement;
import com.kingdee.bos.ctrl.etl.database.Database;
import com.kingdee.bos.ctrl.etl.database.DatabaseMeta;
import com.kingdee.bos.ctrl.etl.exception.ETLException;
import com.kingdee.bos.ctrl.etl.exception.ETLXMLException;
import com.kingdee.bos.ctrl.etl.repository.Repository;
import com.kingdee.bos.ctrl.etl.transformation.DatabaseImpact;
import com.kingdee.bos.ctrl.etl.transformation.Trans;
import com.kingdee.bos.ctrl.etl.transformation.TransMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.BaseStepMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.StepDataInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.StepInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.StepMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.StepMetaInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.combinationlookup.CombinationLookup;
import com.kingdee.bos.ctrl.etl.transformation.step.combinationlookup.CombinationLookupData;
import com.kingdee.bos.ctrl.etl.util.Const;
import com.kingdee.bos.ctrl.etl.util.XMLHandler;
import com.kingdee.bos.ctrl.etl.value.Value;
import java.util.Hashtable;
import java.util.List;
import org.w3c.dom.Node;

public class CombinationLookupMeta
extends BaseStepMeta
implements StepMetaInterface {
    private String tablename;
    private DatabaseMeta database;
    private boolean replaceFields;
    private String[] keyField;
    private String[] keyLookup;
    private boolean useHash;
    private String hashField;
    private String technicalKeyField;
    private String sequenceFrom;
    private int commitSize;
    private boolean useAutoinc;

    public DatabaseMeta getDatabase() {
        return this.database;
    }

    public void setDatabase(DatabaseMeta database) {
        this.database = database;
    }

    public int getCommitSize() {
        return this.commitSize;
    }

    public void setCommitSize(int commitSize) {
        this.commitSize = commitSize;
    }

    public String getHashField() {
        return this.hashField;
    }

    public void setHashField(String hashField) {
        this.hashField = hashField;
    }

    public String[] getKeyField() {
        return this.keyField;
    }

    public void setKeyField(String[] keyField) {
        this.keyField = keyField;
    }

    public String[] getKeyLookup() {
        return this.keyLookup;
    }

    public void setKeyLookup(String[] keyLookup) {
        this.keyLookup = keyLookup;
    }

    public boolean replaceFields() {
        return this.replaceFields;
    }

    public void setReplaceFields(boolean replaceFields) {
        this.replaceFields = replaceFields;
    }

    public String getSequenceFrom() {
        return this.sequenceFrom;
    }

    public void setSequenceFrom(String sequenceFrom) {
        this.sequenceFrom = sequenceFrom;
    }

    public String getTablename() {
        return this.tablename;
    }

    public void setTablename(String tablename) {
        this.tablename = tablename;
    }

    public String getTechnicalKeyField() {
        return this.technicalKeyField;
    }

    public void setTechnicalKeyField(String technicalKeyField) {
        this.technicalKeyField = technicalKeyField;
    }

    public boolean isUseAutoinc() {
        return this.useAutoinc;
    }

    public void setUseAutoinc(boolean useAutoinc) {
        this.useAutoinc = useAutoinc;
    }

    public boolean useHash() {
        return this.useHash;
    }

    public void setUseHash(boolean useHash) {
        this.useHash = useHash;
    }

    @Override
    public void loadXML(Node stepnode, List databases, Hashtable counters) throws ETLXMLException {
        this.readData(stepnode, databases);
    }

    public void allocate(int nrkeys) {
        this.keyField = new String[nrkeys];
        this.keyLookup = new String[nrkeys];
    }

    @Override
    public Object clone() {
        CombinationLookupMeta retval = (CombinationLookupMeta)super.clone();
        int nrkeys = this.keyField.length;
        retval.allocate(nrkeys);
        for (int i = 0; i < nrkeys; ++i) {
            retval.keyField[i] = this.keyField[i];
            retval.keyLookup[i] = this.keyLookup[i];
        }
        return retval;
    }

    private void readData(Node stepnode, List databases) throws ETLXMLException {
        try {
            this.tablename = XMLHandler.getTagValue(stepnode, "table");
            String con = XMLHandler.getTagValue(stepnode, "connection");
            this.database = Const.findDatabase(databases, con);
            String commit = XMLHandler.getTagValue(stepnode, "commit");
            this.commitSize = Const.toInt(commit, 0);
            this.replaceFields = "Y".equalsIgnoreCase(XMLHandler.getTagValue(stepnode, "replace"));
            this.useHash = "Y".equalsIgnoreCase(XMLHandler.getTagValue(stepnode, "crc"));
            this.hashField = XMLHandler.getTagValue(stepnode, "crcfield");
            Node keys = XMLHandler.getSubNode(stepnode, "fields");
            int nrkeys = XMLHandler.countNodes(keys, "key");
            this.allocate(nrkeys);
            for (int i = 0; i < nrkeys; ++i) {
                Node knode = XMLHandler.getSubNodeByNr(keys, "key", i);
                this.keyField[i] = XMLHandler.getTagValue(knode, "name");
                this.keyLookup[i] = XMLHandler.getTagValue(knode, "lookup");
            }
            this.sequenceFrom = XMLHandler.getTagValue(stepnode, "sequence");
            Node fields = XMLHandler.getSubNode(stepnode, "fields");
            Node retkey = XMLHandler.getSubNode(fields, "return");
            this.technicalKeyField = XMLHandler.getTagValue(retkey, "name");
            this.useAutoinc = !"N".equalsIgnoreCase(XMLHandler.getTagValue(retkey, "use_autoinc"));
        }
        catch (Exception e) {
            throw new ETLXMLException("Unable to load step info from XML", e);
        }
    }

    @Override
    public void setDefault() {
        this.tablename = "dim table name";
        this.database = null;
        this.commitSize = 0;
        this.replaceFields = true;
        this.useHash = true;
        this.hashField = "hashcode";
        int nrkeys = 0;
        this.allocate(nrkeys);
        for (int i = 0; i < nrkeys; ++i) {
            this.keyField[i] = "key" + i;
            this.keyLookup[i] = "keylookup" + i;
        }
        this.technicalKeyField = "technical /surrogate key field";
        this.useAutoinc = true;
    }

    @Override
    public Row getFields(Row r, String name, Row info) {
        Row row = r == null ? new Row() : r;
        Value v = new Value(this.technicalKeyField, 5);
        v.setLength(10, 0);
        v.setOrigin(name);
        row.addValue(v);
        if (this.replaceFields) {
            for (int i = 0; i < this.keyField.length; ++i) {
                int idx = r.searchValueIndex(this.keyField[i]);
                if (idx < 0) continue;
                row.removeValue(idx);
            }
        }
        return row;
    }

    @Override
    public String getXML() {
        String retval = "";
        retval = retval + "      " + XMLHandler.addTagValue("table", this.tablename);
        retval = retval + "      " + XMLHandler.addTagValue("connection", this.database == null ? "" : this.database.getName());
        retval = retval + "      " + XMLHandler.addTagValue("commit", this.commitSize);
        retval = retval + "      " + XMLHandler.addTagValue("replace", this.replaceFields);
        retval = retval + "      " + XMLHandler.addTagValue("crc", this.useHash);
        retval = retval + "      " + XMLHandler.addTagValue("crcfield", this.hashField);
        retval = retval + "      <fields>" + Const.CR;
        for (int i = 0; i < this.keyField.length; ++i) {
            retval = retval + "        <key>" + Const.CR;
            retval = retval + "          " + XMLHandler.addTagValue("name", this.keyField[i]);
            retval = retval + "          " + XMLHandler.addTagValue("lookup", this.keyLookup[i]);
            retval = retval + "          </key>" + Const.CR;
        }
        retval = retval + "        <return>" + Const.CR;
        retval = retval + "          " + XMLHandler.addTagValue("name", this.technicalKeyField);
        retval = retval + "          " + XMLHandler.addTagValue("use_autoinc", this.useAutoinc);
        retval = retval + "        </return>" + Const.CR;
        retval = retval + "      </fields>" + Const.CR;
        retval = retval + "      " + XMLHandler.addTagValue("sequence", this.sequenceFrom);
        return retval;
    }

    @Override
    public void readRep(Repository rep, long id_step, List databases, Hashtable counters) throws ETLException {
        try {
            long id_connection = rep.getStepAttributeInteger(id_step, "id_connection");
            this.database = Const.findDatabase(databases, id_connection);
            this.tablename = rep.getStepAttributeString(id_step, "table");
            this.commitSize = (int)rep.getStepAttributeInteger(id_step, "commit");
            this.replaceFields = rep.getStepAttributeBoolean(id_step, "replace");
            this.useHash = rep.getStepAttributeBoolean(id_step, "crc");
            this.hashField = rep.getStepAttributeString(id_step, "crcfield");
            int nrkeys = rep.countNrStepAttributes(id_step, "lookup_key_name");
            this.allocate(nrkeys);
            for (int i = 0; i < nrkeys; ++i) {
                this.keyField[i] = rep.getStepAttributeString(id_step, i, "lookup_key_name");
                this.keyLookup[i] = rep.getStepAttributeString(id_step, i, "lookup_key_field");
            }
            this.technicalKeyField = rep.getStepAttributeString(id_step, "return_name");
            this.useAutoinc = rep.getStepAttributeBoolean(id_step, "use_autoinc");
            this.sequenceFrom = rep.getStepAttributeString(id_step, "sequence");
        }
        catch (Exception e) {
            throw new ETLException("Unexpected error reading step information from the repository", e);
        }
    }

    @Override
    public void saveRep(Repository rep, long id_transformation, long id_step) throws ETLException {
        try {
            long id = rep.saveStepAttribute(id_transformation, id_step, "table", this.tablename);
            if (id > 0L) {
                id = rep.saveStepAttribute(id_transformation, id_step, "id_connection", this.database == null ? -1.0 : (double)this.database.getID());
            }
            if (id > 0L) {
                id = rep.saveStepAttribute(id_transformation, id_step, "commit", this.commitSize);
            }
            if (id > 0L) {
                id = rep.saveStepAttribute(id_transformation, id_step, "replace", this.replaceFields);
            }
            if (id > 0L) {
                id = rep.saveStepAttribute(id_transformation, id_step, "crc", this.useHash);
            }
            if (id > 0L) {
                id = rep.saveStepAttribute(id_transformation, id_step, "crcfield", this.hashField);
            }
            for (int i = 0; i < this.keyField.length; ++i) {
                if (id > 0L) {
                    id = rep.saveStepAttribute(id_transformation, id_step, (long)i, "lookup_key_name", this.keyField[i]);
                }
                if (id <= 0L) continue;
                id = rep.saveStepAttribute(id_transformation, id_step, (long)i, "lookup_key_field", this.keyLookup[i]);
            }
            if (id > 0L) {
                id = rep.saveStepAttribute(id_transformation, id_step, "return_name", this.technicalKeyField);
            }
            if (id > 0L) {
                id = rep.saveStepAttribute(id_transformation, id_step, "use_autoinc", this.useAutoinc);
            }
            if (id > 0L) {
                id = rep.saveStepAttribute(id_transformation, id_step, "sequence", this.sequenceFrom);
            }
            if (this.database != null) {
                rep.insertStepDatabase(id_transformation, id_step, this.database.getID());
            }
        }
        catch (Exception e) {
            throw new ETLException("Unable to save step information to the repository for id_step=" + id_step, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void check(List remarks, StepMeta stepMeta, Row prev, String[] input, String[] output, Row info) {
        error_message = "";
        if (this.database != null) {
            db = new Database(this.database);
            try {
                db.connect();
                if (this.tablename != null && this.tablename.length() != 0) {
                    first = true;
                    error_found = false;
                    error_message = "";
                    r = db.getTableFields(this.tablename);
                    if (r != null) {
                        for (i = 0; i < this.keyLookup.length; ++i) {
                            lufield = this.keyLookup[i];
                            v = r.searchValue(lufield);
                            if (v != null) continue;
                            if (first) {
                                first = false;
                                error_message = error_message + "Missing compare fields in target table:" + Const.CR;
                            }
                            error_found = true;
                            error_message = error_message + "\t\t" + lufield + Const.CR;
                        }
                        cr = error_found != false ? new CheckResult(4, error_message, stepMeta) : new CheckResult(1, "All lookup fields found in the table.", stepMeta);
                        remarks.add(cr);
                        if (r.searchValueIndex(this.technicalKeyField) < 0) {
                            error_message = "Technical key [" + this.technicalKeyField + "] not found in target table." + Const.CR;
                            cr = new CheckResult(4, error_message, stepMeta);
                        } else {
                            error_message = "Technical key [" + this.technicalKeyField + "] found in target table." + Const.CR;
                            cr = new CheckResult(1, error_message, stepMeta);
                        }
                        remarks.add(cr);
                    } else {
                        error_message = "Couldn't read the table info, please check the table-name & permissions.";
                        cr = new CheckResult(4, error_message, stepMeta);
                        remarks.add(cr);
                    }
                }
                if (prev != null && prev.size() > 0) {
                    first = true;
                    error_message = "";
                    error_found = false;
                    for (i = 0; i < this.keyField.length; ++i) {
                        v = prev.searchValue(this.keyField[i]);
                        if (v != null) continue;
                        if (first) {
                            first = false;
                            error_message = error_message + "Missing fields, not found in input from previous steps:" + Const.CR;
                        }
                        error_found = true;
                        error_message = error_message + "\t\t" + this.keyField[i] + Const.CR;
                    }
                    cr = error_found != false ? new CheckResult(4, error_message, stepMeta) : new CheckResult(1, "All fields found in the input stream.", stepMeta);
                    remarks.add(cr);
                } else {
                    error_message = "Couldn't read fields from the previous step." + Const.CR;
                    cr = new CheckResult(4, error_message, stepMeta);
                    remarks.add(cr);
                }
                if (!this.database.supportsSequences() || this.sequenceFrom == null || this.sequenceFrom.length() == 0) ** GOTO lbl85
                last = db.checkSequence(this.sequenceFrom);
                if (last != null) {
                    error_message = "No problem reading sequence " + this.sequenceFrom + ", it's at value " + last;
                    cr = new CheckResult(1, error_message, stepMeta);
                    remarks.add(cr);
                }
                error_message = error_message + "Error reading sequence " + this.sequenceFrom + "!";
                cr = new CheckResult(4, error_message, stepMeta);
                remarks.add(cr);
            }
            catch (ETLException e) {
                error_message = "An error occurred: " + e.getMessage();
                cr = new CheckResult(4, error_message, stepMeta);
                remarks.add(cr);
            }
            finally {
                db.disconnect();
            }
        } else {
            error_message = "Please select or create a connection!";
            cr = new CheckResult(4, error_message, stepMeta);
            remarks.add(cr);
        }
lbl85:
        // 5 sources

        if (input.length > 0) {
            cr = new CheckResult(1, "Step is receiving info from other steps.", stepMeta);
            remarks.add(cr);
        } else {
            cr = new CheckResult(4, "No input received from other steps!", stepMeta);
            remarks.add(cr);
        }
    }

    @Override
    public SQLStatement getSQLStatements(TransMeta transMeta, StepMeta stepMeta, Row prev) {
        SQLStatement retval = new SQLStatement(stepMeta.getName(), this.database, null);
        if (this.database != null) {
            if (prev != null && prev.size() > 0) {
                if (this.tablename != null && this.tablename.length() > 0) {
                    Database db = new Database(this.database);
                    try {
                        db.connect();
                        Row fields = new Row();
                        Value vkeyfield = new Value(this.technicalKeyField, 5);
                        vkeyfield.setLength(10, 0);
                        fields.addValue(vkeyfield);
                        if (this.useHash && this.hashField != null && this.hashField.length() > 0) {
                            Value vhashfield = new Value(this.hashField, 5);
                            vhashfield.setLength(15, 0);
                            fields.addValue(vhashfield);
                        }
                        for (int i = 0; i < this.keyLookup.length; ++i) {
                            String error_fields = "";
                            Value vkey = prev.searchValue(this.keyLookup[i]);
                            if (vkey != null) {
                                fields.addValue(vkey);
                            } else {
                                if (error_fields.length() > 0) {
                                    error_fields = error_fields + ", ";
                                }
                                error_fields = error_fields + this.keyLookup[i];
                            }
                            if (error_fields.length() <= 0) continue;
                            retval.setError("Can't find fields : " + error_fields);
                        }
                        String cr_table = db.getDDL(this.tablename, fields, this.sequenceFrom != null && this.sequenceFrom.length() == 0 ? this.technicalKeyField : null, this.useAutoinc, null, true);
                        String cr_index = "";
                        String[] idx_fields = null;
                        if (this.useHash) {
                            if (this.hashField != null && this.hashField.length() > 0) {
                                idx_fields = new String[]{this.hashField};
                            } else {
                                retval.setError("No hashfield is specified.  Please enter a name for the hashfield.");
                            }
                        } else if (this.keyLookup != null && this.keyLookup.length > 0) {
                            int nrfields = this.keyLookup.length;
                            if (nrfields > 32 && this.database.getDatabaseType() == 4) {
                                nrfields = 32;
                            }
                            idx_fields = new String[nrfields];
                            for (int i = 0; i < nrfields; ++i) {
                                idx_fields[i] = this.keyLookup[i];
                            }
                        } else {
                            retval.setError("No fields are specified.  Please specify the fields to combine in this table.");
                        }
                        if (idx_fields != null && idx_fields.length > 0 && !db.checkIndexExists(this.tablename, idx_fields)) {
                            String indexname = "idx_" + this.tablename + "_lookup";
                            cr_index = db.getCreateIndexStatement(this.tablename, indexname, idx_fields, false, false, false, true);
                            cr_index = cr_index + Const.CR;
                        }
                        String cr_seq = "";
                        if (this.database.getDatabaseType() == 4 && this.sequenceFrom != null && this.sequenceFrom.length() > 0 && !db.checkSequenceExists(this.sequenceFrom)) {
                            cr_seq = cr_seq + db.getCreateSequenceStatement(this.sequenceFrom, 1L, 1L, -1L, true);
                            cr_seq = cr_seq + Const.CR;
                        }
                        retval.setSQL(cr_table + cr_index + cr_seq);
                    }
                    catch (ETLException e) {
                        retval.setError("An error occurred: " + Const.CR + e.getMessage());
                    }
                } else {
                    retval.setError("No table is defined on this connection.");
                }
            } else {
                retval.setError("Not receiving any fields from previous steps. Check the previous steps for errors & the connecting hops.");
            }
        } else {
            retval.setError("There is no connection defined in this step.");
        }
        return retval;
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta transMeta, Trans trans) {
        return new CombinationLookup(stepMeta, stepDataInterface, cnr, transMeta, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new CombinationLookupData();
    }

    @Override
    public void analyseImpact(List impact, TransMeta transMeta, StepMeta stepMeta, Row prev, String[] input, String[] output, Row info) {
        for (int i = 0; i < this.keyField.length; ++i) {
            Value v = prev.searchValue(this.keyField[i]);
            DatabaseImpact ii = new DatabaseImpact(3, transMeta.getName(), stepMeta.getName(), this.database.getDatabaseName(), this.tablename, this.keyLookup[i], this.keyField[i], v != null ? v.getOrigin() : "?", "", this.useHash ? "read and insert" : "key lookup and insert");
            impact.add(ii);
        }
        if (this.useHash) {
            DatabaseImpact ii = new DatabaseImpact(3, transMeta.getName(), stepMeta.getName(), this.database.getDatabaseName(), this.tablename, this.hashField, "", "", "", "key lookup on hash-field");
            impact.add(ii);
        }
    }
}

