/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.etl.transformation.step.databasejoin;

import com.kingdee.bos.ctrl.etl.base.Row;
import com.kingdee.bos.ctrl.etl.database.Database;
import com.kingdee.bos.ctrl.etl.exception.ETLException;
import com.kingdee.bos.ctrl.etl.exception.ETLStepException;
import com.kingdee.bos.ctrl.etl.transformation.Trans;
import com.kingdee.bos.ctrl.etl.transformation.TransMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.BaseStep;
import com.kingdee.bos.ctrl.etl.transformation.step.StepDataInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.StepInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.StepMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.StepMetaInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.databasejoin.DatabaseJoinData;
import com.kingdee.bos.ctrl.etl.transformation.step.databasejoin.DatabaseJoinMeta;
import java.sql.ResultSet;

public class DatabaseJoin
extends BaseStep
implements StepInterface {
    private DatabaseJoinMeta meta;
    private DatabaseJoinData data;

    public DatabaseJoin(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    private synchronized void lookupValues(Row row) throws ETLException {
        this.debug = "Start of lookupValues()";
        if (this.first) {
            this.first = false;
            this.debug = "first row: set lookup statement";
            this.logDetailed("Checking row: " + row.toString());
            this.data.keynrs = new int[this.meta.getParameterField().length];
            this.debug = "first row: get key fieldnrs";
            for (int i = 0; i < this.meta.getParameterField().length; ++i) {
                this.data.keynrs[i] = row.searchValueIndex(this.meta.getParameterField()[i]);
                if (this.data.keynrs[i] >= 0) continue;
                throw new ETLStepException("Field [" + this.meta.getParameterField()[i] + "] is required and couldn't be found!");
            }
        }
        this.debug = "get parameters";
        Row param = new Row();
        for (int i = 0; i < this.data.keynrs.length; ++i) {
            param.addValue(row.getValue(this.data.keynrs[i]));
        }
        this.debug = "open query & resultset";
        ResultSet rs = this.data.db.openQuery(this.data.pstmt, param);
        this.debug = "get row";
        Row add = this.data.db.getRow(rs);
        ++this.linesInput;
        int counter = 0;
        while (add != null && (this.meta.getRowLimit() == 0 || counter < this.meta.getRowLimit())) {
            Row newrow = new Row(row);
            newrow.addRow(add);
            this.putRow(newrow);
            this.logRowlevel("Put out row: " + add);
            if (this.meta.getRowLimit() != 0 && ++counter >= this.meta.getRowLimit()) continue;
            add = this.data.db.getRow(rs);
            ++this.linesInput;
        }
        if (counter == 0 && this.meta.isOuterJoin()) {
            if (this.data.notfound == null) {
                this.data.notfound = new Row(this.data.db.getReturnRow());
                for (int i = 0; i < this.data.notfound.size(); ++i) {
                    this.data.notfound.getValue(i).setNull();
                }
            }
            Row newrow = new Row(row);
            newrow.addRow(this.data.notfound);
            this.putRow(newrow);
        }
        this.debug = "close query";
        this.data.db.closeQuery(rs);
        this.debug = "end of lookupValues()";
    }

    @Override
    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws ETLException {
        this.meta = (DatabaseJoinMeta)smi;
        this.data = (DatabaseJoinData)sdi;
        Row r = this.getRow();
        if (r == null) {
            this.setOutputDone();
            return false;
        }
        try {
            this.lookupValues(r);
            if (this.linesRead > 0L && this.linesRead % 5000L == 0L) {
                this.logBasic("linenr " + this.linesRead);
            }
        }
        catch (ETLException e) {
            this.logError("Because of an error, this step can't continue: " + e.getMessage());
            this.setErrors(1L);
            this.stopAll();
            this.setOutputDone();
            return false;
        }
        return true;
    }

    @Override
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (DatabaseJoinMeta)smi;
        this.data = (DatabaseJoinData)sdi;
        if (super.init(smi, sdi)) {
            this.data.db = new Database(this.meta.getDatabaseMeta());
            try {
                this.data.db.connect();
                this.logBasic("Connected to database...");
                this.data.pstmt = this.data.db.prepareSQL(this.meta.getSql());
                this.data.db.setQueryLimit(this.meta.getRowLimit());
                return true;
            }
            catch (ETLException e) {
                this.logError("A database error occurred, stopping everything: " + e.getMessage());
                this.data.db.disconnect();
            }
        }
        return false;
    }

    @Override
    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (DatabaseJoinMeta)smi;
        this.data = (DatabaseJoinData)sdi;
        this.data.db.disconnect();
        super.dispose(smi, sdi);
    }

    @Override
    public void run() {
        this.logBasic("Starting to run...");
        try {
            while (this.processRow(this.meta, this.data) && !this.isStopped()) {
            }
        }
        catch (Exception e) {
            this.logError("Unexpected error in part : [" + this.debug + "]");
            this.logError(e.toString());
            this.setErrors(1L);
            this.stopAll();
        }
        finally {
            this.dispose(this.meta, this.data);
            this.logSummary();
            this.markStop();
        }
    }

    @Override
    public String toString() {
        return this.getClass().getName();
    }
}

