/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.etl.transformation.step.denormaliser;

import com.kingdee.bos.ctrl.etl.base.CheckResult;
import com.kingdee.bos.ctrl.etl.base.Row;
import com.kingdee.bos.ctrl.etl.exception.ETLException;
import com.kingdee.bos.ctrl.etl.exception.ETLStepException;
import com.kingdee.bos.ctrl.etl.exception.ETLXMLException;
import com.kingdee.bos.ctrl.etl.repository.Repository;
import com.kingdee.bos.ctrl.etl.transformation.Trans;
import com.kingdee.bos.ctrl.etl.transformation.TransMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.BaseStepMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.StepDataInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.StepInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.StepMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.StepMetaInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.denormaliser.Denormaliser;
import com.kingdee.bos.ctrl.etl.transformation.step.denormaliser.DenormaliserData;
import com.kingdee.bos.ctrl.etl.transformation.step.denormaliser.DenormaliserTargetField;
import com.kingdee.bos.ctrl.etl.util.Const;
import com.kingdee.bos.ctrl.etl.util.XMLHandler;
import com.kingdee.bos.ctrl.etl.value.Value;
import java.util.Hashtable;
import java.util.List;
import org.w3c.dom.Node;

public class DenormaliserMeta
extends BaseStepMeta
implements StepMetaInterface {
    private String[] groupField;
    private String keyField;
    private DenormaliserTargetField[] denormaliserTargetField;

    public String getKeyField() {
        return this.keyField;
    }

    public void setKeyField(String keyField) {
        this.keyField = keyField;
    }

    public String[] getGroupField() {
        return this.groupField;
    }

    public void setGroupField(String[] groupField) {
        this.groupField = groupField;
    }

    public DenormaliserTargetField[] getDenormaliserTargetField() {
        return this.denormaliserTargetField;
    }

    public void setDenormaliserTargetField(DenormaliserTargetField[] pivotField) {
        this.denormaliserTargetField = pivotField;
    }

    @Override
    public void loadXML(Node stepnode, List databases, Hashtable counters) throws ETLXMLException {
        this.readData(stepnode);
    }

    public void allocate(int sizegroup, int nrfields) {
        this.groupField = new String[sizegroup];
        this.denormaliserTargetField = new DenormaliserTargetField[nrfields];
    }

    @Override
    public Object clone() {
        Object retval = super.clone();
        return retval;
    }

    @Override
    public void setDefault() {
        int sizegroup = 0;
        int nrfields = 0;
        this.allocate(sizegroup, nrfields);
    }

    @Override
    public Row getFields(Row r, String name, Row info) throws ETLStepException {
        int i;
        int idx;
        Row row = r;
        if (this.keyField != null && this.keyField.length() > 0) {
            idx = row.searchValueIndex(this.keyField);
            if (idx < 0) {
                throw new ETLStepException("Unable to locate [" + this.keyField + "] in the input fields");
            }
        } else {
            throw new ETLStepException("The key field is not specified");
        }
        row.removeValue(idx);
        for (i = 0; i < this.denormaliserTargetField.length; ++i) {
            String fieldname = this.denormaliserTargetField[i].getFieldName();
            if (fieldname != null && fieldname.length() > 0) {
                int idx2 = row.searchValueIndex(fieldname);
                if (idx2 < 0) continue;
                row.removeValue(idx2);
                continue;
            }
            throw new ETLStepException("The fieldname of target field #" + (i + 1) + " is not specified.");
        }
        for (i = 0; i < this.denormaliserTargetField.length; ++i) {
            DenormaliserTargetField field = this.denormaliserTargetField[i];
            Value target = new Value(field.getTargetName(), field.getTargetType());
            target.setLength(field.getTargetLength(), field.getTargetPrecision());
            target.setOrigin(name);
            row.addValue(target);
        }
        return row;
    }

    private void readData(Node stepnode) throws ETLXMLException {
        try {
            Node fnode;
            int i;
            this.keyField = XMLHandler.getTagValue(stepnode, "key_field");
            Node groupn = XMLHandler.getSubNode(stepnode, "group");
            Node fields = XMLHandler.getSubNode(stepnode, "fields");
            int sizegroup = XMLHandler.countNodes(groupn, "field");
            int nrfields = XMLHandler.countNodes(fields, "field");
            this.allocate(sizegroup, nrfields);
            for (i = 0; i < sizegroup; ++i) {
                fnode = XMLHandler.getSubNodeByNr(groupn, "field", i);
                this.groupField[i] = XMLHandler.getTagValue(fnode, "name");
            }
            for (i = 0; i < nrfields; ++i) {
                fnode = XMLHandler.getSubNodeByNr(fields, "field", i);
                this.denormaliserTargetField[i] = new DenormaliserTargetField();
                this.denormaliserTargetField[i].setFieldName(XMLHandler.getTagValue(fnode, "field_name"));
                this.denormaliserTargetField[i].setKeyValue(XMLHandler.getTagValue(fnode, "key_value"));
                this.denormaliserTargetField[i].setTargetName(XMLHandler.getTagValue(fnode, "target_name"));
                this.denormaliserTargetField[i].setTargetType(XMLHandler.getTagValue(fnode, "target_type"));
                this.denormaliserTargetField[i].setTargetLength(Const.toInt(XMLHandler.getTagValue(fnode, "target_length"), -1));
                this.denormaliserTargetField[i].setTargetPrecision(Const.toInt(XMLHandler.getTagValue(fnode, "target_precision"), -1));
                this.denormaliserTargetField[i].setTargetDecimalSymbol(XMLHandler.getTagValue(fnode, "target_decimal_symbol"));
                this.denormaliserTargetField[i].setTargetGroupingSymbol(XMLHandler.getTagValue(fnode, "target_grouping_symbol"));
                this.denormaliserTargetField[i].setTargetCurrencySymbol(XMLHandler.getTagValue(fnode, "target_currency_symbol"));
                this.denormaliserTargetField[i].setTargetNullString(XMLHandler.getTagValue(fnode, "target_null_string"));
                this.denormaliserTargetField[i].setTargetAggregationType(XMLHandler.getTagValue(fnode, "target_aggregation_type"));
            }
        }
        catch (Exception e) {
            throw new ETLXMLException("Unable to load step info from XML", e);
        }
    }

    @Override
    public String getXML() {
        int i;
        String retval = "";
        retval = retval + "      " + XMLHandler.addTagValue("key_field", this.keyField);
        retval = retval + "      <group>" + Const.CR;
        for (i = 0; i < this.groupField.length; ++i) {
            retval = retval + "        <field>" + Const.CR;
            retval = retval + "          " + XMLHandler.addTagValue("name", this.groupField[i]);
            retval = retval + "          </field>" + Const.CR;
        }
        retval = retval + "        </group>" + Const.CR;
        retval = retval + "      <fields>" + Const.CR;
        for (i = 0; i < this.denormaliserTargetField.length; ++i) {
            DenormaliserTargetField field = this.denormaliserTargetField[i];
            retval = retval + "        <field>" + Const.CR;
            retval = retval + "          " + XMLHandler.addTagValue("field_name", field.getFieldName());
            retval = retval + "          " + XMLHandler.addTagValue("key_value", field.getKeyValue());
            retval = retval + "          " + XMLHandler.addTagValue("target_name", field.getTargetName());
            retval = retval + "          " + XMLHandler.addTagValue("target_type", field.getTargetTypeDesc());
            retval = retval + "          " + XMLHandler.addTagValue("target_length", field.getTargetLength());
            retval = retval + "          " + XMLHandler.addTagValue("target_precision", field.getTargetPrecision());
            retval = retval + "          " + XMLHandler.addTagValue("target_decimal_symbol", field.getTargetDecimalSymbol());
            retval = retval + "          " + XMLHandler.addTagValue("target_grouping_symbol", field.getTargetGroupingSymbol());
            retval = retval + "          " + XMLHandler.addTagValue("target_currency_symbol", field.getTargetCurrencySymbol());
            retval = retval + "          " + XMLHandler.addTagValue("target_null_string", field.getTargetNullString());
            retval = retval + "          " + XMLHandler.addTagValue("target_aggregation_type", field.getTargetAggregationTypeDesc());
            retval = retval + "          </field>" + Const.CR;
        }
        retval = retval + "        </fields>" + Const.CR;
        return retval;
    }

    @Override
    public void readRep(Repository rep, long id_step, List databases, Hashtable counters) throws ETLException {
        try {
            int i;
            this.keyField = rep.getStepAttributeString(id_step, "key_field");
            int groupsize = rep.countNrStepAttributes(id_step, "group_name");
            int nrvalues = rep.countNrStepAttributes(id_step, "field_name");
            this.allocate(groupsize, nrvalues);
            for (i = 0; i < groupsize; ++i) {
                this.groupField[i] = rep.getStepAttributeString(id_step, i, "group_name");
            }
            for (i = 0; i < nrvalues; ++i) {
                this.denormaliserTargetField[i] = new DenormaliserTargetField();
                this.denormaliserTargetField[i].setFieldName(rep.getStepAttributeString(id_step, i, "field_name"));
                this.denormaliserTargetField[i].setKeyValue(rep.getStepAttributeString(id_step, i, "key_value"));
                this.denormaliserTargetField[i].setTargetName(rep.getStepAttributeString(id_step, i, "target_name"));
                this.denormaliserTargetField[i].setTargetType(rep.getStepAttributeString(id_step, i, "target_type"));
                this.denormaliserTargetField[i].setTargetLength((int)rep.getStepAttributeInteger(id_step, i, "target_length"));
                this.denormaliserTargetField[i].setTargetPrecision((int)rep.getStepAttributeInteger(id_step, i, "target_precision"));
                this.denormaliserTargetField[i].setTargetDecimalSymbol(rep.getStepAttributeString(id_step, i, "target_decimal_symbol"));
                this.denormaliserTargetField[i].setTargetGroupingSymbol(rep.getStepAttributeString(id_step, i, "target_grouping_symbol"));
                this.denormaliserTargetField[i].setTargetCurrencySymbol(rep.getStepAttributeString(id_step, i, "target_currency_symbol"));
                this.denormaliserTargetField[i].setTargetNullString(rep.getStepAttributeString(id_step, i, "target_null_string"));
                this.denormaliserTargetField[i].setTargetAggregationType(rep.getStepAttributeString(id_step, i, "target_aggregation_type"));
            }
        }
        catch (Exception e) {
            throw new ETLException("Unexpected error reading step information from the repository", e);
        }
    }

    @Override
    public void saveRep(Repository rep, long id_transformation, long id_step) throws ETLException {
        try {
            int i;
            rep.saveStepAttribute(id_transformation, id_step, "key_field", this.keyField);
            for (i = 0; i < this.groupField.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "group_name", this.groupField[i]);
            }
            for (i = 0; i < this.denormaliserTargetField.length; ++i) {
                DenormaliserTargetField field = this.denormaliserTargetField[i];
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "field_name", field.getFieldName());
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "key_value", field.getKeyValue());
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "target_name", field.getTargetName());
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "target_type", field.getTargetTypeDesc());
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "target_length", field.getTargetLength());
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "target_precision", field.getTargetPrecision());
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "target_decimal_symbol", field.getTargetDecimalSymbol());
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "target_grouping_symbol", field.getTargetGroupingSymbol());
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "target_currency_symbol", field.getTargetCurrencySymbol());
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "target_null_string", field.getTargetNullString());
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "target_aggregation_type", field.getTargetAggregationTypeDesc());
            }
        }
        catch (Exception e) {
            throw new ETLException("Unable to save step information to the repository for id_step=" + id_step, e);
        }
    }

    @Override
    public void check(List remarks, StepMeta stepMeta, Row prev, String[] input, String[] output, Row info) {
        if (input.length > 0) {
            CheckResult cr = new CheckResult(1, "Step is receiving info from other steps.", stepMeta);
            remarks.add(cr);
        } else {
            CheckResult cr = new CheckResult(4, "No input received from other steps!", stepMeta);
            remarks.add(cr);
        }
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta transMeta, Trans trans) {
        return new Denormaliser(stepMeta, stepDataInterface, cnr, transMeta, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new DenormaliserData();
    }
}

