/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.etl.transformation.step.filterrows;

import com.kingdee.bos.ctrl.etl.base.CheckResult;
import com.kingdee.bos.ctrl.etl.base.Condition;
import com.kingdee.bos.ctrl.etl.base.Row;
import com.kingdee.bos.ctrl.etl.exception.ETLException;
import com.kingdee.bos.ctrl.etl.exception.ETLXMLException;
import com.kingdee.bos.ctrl.etl.repository.Repository;
import com.kingdee.bos.ctrl.etl.transformation.Trans;
import com.kingdee.bos.ctrl.etl.transformation.TransMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.BaseStepMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.StepDataInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.StepInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.StepMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.StepMetaInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.filterrows.FilterRows;
import com.kingdee.bos.ctrl.etl.transformation.step.filterrows.FilterRowsData;
import com.kingdee.bos.ctrl.etl.util.Const;
import com.kingdee.bos.ctrl.etl.util.XMLHandler;
import com.kingdee.bos.ctrl.etl.value.Value;
import java.util.Hashtable;
import java.util.List;
import org.w3c.dom.Node;

public class FilterRowsMeta
extends BaseStepMeta
implements StepMetaInterface {
    private Condition condition;
    private String sendTrueStepname;
    private StepMeta sendTrueStep;
    private String sendFalseStepname;
    private StepMeta sendFalseStep;

    @Override
    public void loadXML(Node stepnode, List databases, Hashtable counters) throws ETLXMLException {
        this.readData(stepnode);
    }

    public Condition getCondition() {
        return this.condition;
    }

    public void setCondition(Condition condition) {
        this.condition = condition;
    }

    public String getSendFalseStepname() {
        if (this.sendFalseStep != null && this.sendFalseStep.getName() != null && this.sendFalseStep.getName().length() > 0) {
            return this.sendFalseStep.getName();
        }
        return null;
    }

    public String getSendTrueStepname() {
        if (this.sendTrueStep != null && this.sendTrueStep.getName() != null && this.sendTrueStep.getName().length() > 0) {
            return this.sendTrueStep.getName();
        }
        return null;
    }

    public void setSendFalseStepname(String sendFalseStepname) {
        this.sendFalseStepname = sendFalseStepname;
    }

    public void setSendTrueStepname(String sendTrueStepname) {
        this.sendTrueStepname = sendTrueStepname;
    }

    public StepMeta getSendFalseStep() {
        return this.sendFalseStep;
    }

    public StepMeta getSendTrueStep() {
        return this.sendTrueStep;
    }

    public void setSendFalseStep(StepMeta sendFalseStep) {
        this.sendFalseStep = sendFalseStep;
    }

    public void setSendTrueStep(StepMeta sendTrueStep) {
        this.sendTrueStep = sendTrueStep;
    }

    public void allocate() {
        this.condition = new Condition();
    }

    @Override
    public Object clone() {
        FilterRowsMeta retval = (FilterRowsMeta)super.clone();
        retval.condition = this.condition != null ? (Condition)this.condition.clone() : null;
        return retval;
    }

    @Override
    public String getXML() {
        String retval = "";
        retval = retval + XMLHandler.addTagValue("send_true_to", this.getSendTrueStepname());
        retval = retval + XMLHandler.addTagValue("send_false_to", this.getSendFalseStepname());
        retval = retval + "    <compare>" + Const.CR;
        if (this.condition != null) {
            retval = retval + this.condition.getXML();
        }
        retval = retval + "    </compare>" + Const.CR;
        return retval;
    }

    private void readData(Node stepnode) throws ETLXMLException {
        try {
            this.sendFalseStepname = XMLHandler.getTagValue(stepnode, "send_false_to");
            this.sendTrueStepname = XMLHandler.getTagValue(stepnode, "send_true_to");
            Node compare = XMLHandler.getSubNode(stepnode, "compare");
            Node condnode = XMLHandler.getSubNode(compare, "condition");
            if (condnode != null) {
                this.condition = new Condition(condnode);
            } else {
                this.condition = new Condition();
                int nrkeys = XMLHandler.countNodes(compare, "key");
                if (nrkeys == 1) {
                    Node knode = XMLHandler.getSubNodeByNr(compare, "key", 0);
                    String key = XMLHandler.getTagValue(knode, "name");
                    String value = XMLHandler.getTagValue(knode, "value");
                    String field = XMLHandler.getTagValue(knode, "field");
                    String comparator = XMLHandler.getTagValue(knode, "condition");
                    this.condition.setOperator(0);
                    this.condition.setLeftValuename(key);
                    this.condition.setFunction(Condition.getFunction(comparator));
                    this.condition.setRightValuename(field);
                    this.condition.setRightExact(new Value("value", value));
                } else {
                    for (int i = 0; i < nrkeys; ++i) {
                        Node knode = XMLHandler.getSubNodeByNr(compare, "key", i);
                        String key = XMLHandler.getTagValue(knode, "name");
                        String value = XMLHandler.getTagValue(knode, "value");
                        String field = XMLHandler.getTagValue(knode, "field");
                        String comparator = XMLHandler.getTagValue(knode, "condition");
                        Condition subc = new Condition();
                        if (i > 0) {
                            subc.setOperator(1);
                        } else {
                            subc.setOperator(0);
                        }
                        subc.setLeftValuename(key);
                        subc.setFunction(Condition.getFunction(comparator));
                        subc.setRightValuename(field);
                        subc.setRightExact(new Value("value", value));
                        this.condition.addCondition(subc);
                    }
                }
            }
        }
        catch (Exception e) {
            throw new ETLXMLException("Unable to load step info from XML", e);
        }
    }

    @Override
    public void setDefault() {
        this.allocate();
    }

    @Override
    public void readRep(Repository rep, long id_step, List databases, Hashtable counters) throws ETLException {
        try {
            this.allocate();
            this.sendTrueStepname = rep.getStepAttributeString(id_step, "send_true_to");
            this.sendFalseStepname = rep.getStepAttributeString(id_step, "send_false_to");
            long id_condition = rep.getStepAttributeInteger(id_step, 0, "id_condition");
            if (id_condition > 0L) {
                this.condition = new Condition(rep, id_condition);
            } else {
                int nrkeys = rep.countNrStepAttributes(id_step, "compare_name");
                if (nrkeys == 1) {
                    String key = rep.getStepAttributeString(id_step, 0, "compare_name");
                    String comparator = rep.getStepAttributeString(id_step, 0, "compare_condition");
                    String value = rep.getStepAttributeString(id_step, 0, "compare_value");
                    String field = rep.getStepAttributeString(id_step, 0, "compare_field");
                    this.condition = new Condition();
                    this.condition.setOperator(0);
                    this.condition.setLeftValuename(key);
                    this.condition.setFunction(Condition.getFunction(comparator));
                    this.condition.setRightValuename(field);
                    this.condition.setRightExact(new Value("value", value));
                } else {
                    this.condition = new Condition();
                    for (int i = 0; i < nrkeys; ++i) {
                        String key = rep.getStepAttributeString(id_step, i, "compare_name");
                        String comparator = rep.getStepAttributeString(id_step, i, "compare_condition");
                        String value = rep.getStepAttributeString(id_step, i, "compare_value");
                        String field = rep.getStepAttributeString(id_step, i, "compare_field");
                        Condition subc = new Condition();
                        if (i > 0) {
                            subc.setOperator(1);
                        } else {
                            subc.setOperator(0);
                        }
                        subc.setLeftValuename(key);
                        subc.setFunction(Condition.getFunction(comparator));
                        subc.setRightValuename(field);
                        subc.setRightExact(new Value("value", value));
                        this.condition.addCondition(subc);
                    }
                }
            }
        }
        catch (Exception e) {
            throw new ETLException("Unexpected error reading step information from the repository", e);
        }
    }

    @Override
    public void saveRep(Repository rep, long id_transformation, long id_step) throws ETLException {
        try {
            if (this.condition != null) {
                this.condition.saveRep(rep);
                rep.saveStepAttribute(id_transformation, id_step, "id_condition", this.condition.getID());
                rep.insertTransStepCondition(id_transformation, id_step, this.condition.getID());
                rep.saveStepAttribute(id_transformation, id_step, "send_true_to", this.getSendTrueStepname());
                rep.saveStepAttribute(id_transformation, id_step, "send_false_to", this.getSendFalseStepname());
            }
        }
        catch (Exception e) {
            throw new ETLException("Unable to save step information to the repository for id_step=" + id_step, e);
        }
    }

    @Override
    public void searchInfoAndTargetSteps(List steps) {
        this.sendTrueStep = TransMeta.findStep(steps, this.sendTrueStepname);
        this.sendFalseStep = TransMeta.findStep(steps, this.sendFalseStepname);
    }

    @Override
    public boolean chosesTargetSteps() {
        return this.sendTrueStep != null && this.sendFalseStep != null;
    }

    @Override
    public String[] getTargetSteps() {
        if (this.chosesTargetSteps()) {
            return new String[]{this.getSendTrueStepname(), this.getSendFalseStepname()};
        }
        return null;
    }

    @Override
    public void check(List remarks, StepMeta stepinfo, Row prev, String[] input, String[] output, Row info) {
        CheckResult cr;
        String error_message = "";
        if (this.getSendTrueStepname() != null && this.getSendFalseStepname() != null) {
            cr = new CheckResult(1, "Both 'true' and 'false' steps are specified.  I know how to split the incoming stream(s) of data.", stepinfo);
            remarks.add(cr);
        } else if (this.getSendTrueStepname() == null && this.getSendFalseStepname() == null) {
            cr = new CheckResult(1, "Neither 'true' and 'false' steps are specified.  Only when the condition is true, rows are sent to the next steps.", stepinfo);
            remarks.add(cr);
        } else {
            cr = new CheckResult(1, "Please specify both the 'true' AND 'false' steps.  That way Kettle know for sure where to send the data after computing the condition.", stepinfo);
            remarks.add(cr);
        }
        if (prev != null && prev.size() > 0) {
            cr = new CheckResult(1, "Step is connected to previous one, receiving " + prev.size() + " fields", stepinfo);
            remarks.add(cr);
            boolean first = true;
            error_message = "";
            boolean error_found = false;
            String[] key = this.condition.getUsedFields();
            for (int i = 0; i < key.length; ++i) {
                Value v = prev.searchValue(key[i]);
                if (v != null) continue;
                if (first) {
                    first = false;
                    error_message = error_message + "Fields used in the condition, not found in input from previous steps:" + Const.CR;
                }
                error_found = true;
                error_message = error_message + "\t\t" + key[i] + Const.CR;
            }
            cr = error_found ? new CheckResult(4, error_message, stepinfo) : new CheckResult(1, "All fields to compare with are found in the input stream.", stepinfo);
            remarks.add(cr);
        } else {
            error_message = "Couldn't read fields from the previous step." + Const.CR;
            cr = new CheckResult(4, error_message, stepinfo);
            remarks.add(cr);
        }
        if (input.length > 0) {
            cr = new CheckResult(1, "Step is receiving info from other steps.", stepinfo);
            remarks.add(cr);
        } else {
            cr = new CheckResult(4, "No input received from other steps!", stepinfo);
            remarks.add(cr);
        }
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta tr, Trans trans) {
        return new FilterRows(stepMeta, stepDataInterface, cnr, tr, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new FilterRowsData();
    }
}

