/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.etl.transformation.step.flattener;

import com.kingdee.bos.ctrl.etl.base.CheckResult;
import com.kingdee.bos.ctrl.etl.base.Row;
import com.kingdee.bos.ctrl.etl.exception.ETLException;
import com.kingdee.bos.ctrl.etl.exception.ETLStepException;
import com.kingdee.bos.ctrl.etl.exception.ETLXMLException;
import com.kingdee.bos.ctrl.etl.repository.Repository;
import com.kingdee.bos.ctrl.etl.transformation.Trans;
import com.kingdee.bos.ctrl.etl.transformation.TransMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.BaseStepMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.StepDataInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.StepInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.StepMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.StepMetaInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.flattener.Flattener;
import com.kingdee.bos.ctrl.etl.transformation.step.flattener.FlattenerData;
import com.kingdee.bos.ctrl.etl.util.Const;
import com.kingdee.bos.ctrl.etl.util.XMLHandler;
import com.kingdee.bos.ctrl.etl.value.Value;
import java.util.Hashtable;
import java.util.List;
import org.w3c.dom.Node;

public class FlattenerMeta
extends BaseStepMeta
implements StepMetaInterface {
    private String fieldName;
    private String[] targetField;

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public String[] getTargetField() {
        return this.targetField;
    }

    public void setTargetField(String[] targetField) {
        this.targetField = targetField;
    }

    @Override
    public void loadXML(Node stepnode, List databases, Hashtable counters) throws ETLXMLException {
        this.readData(stepnode);
    }

    public void allocate(int nrfields) {
        this.targetField = new String[nrfields];
    }

    @Override
    public Object clone() {
        Object retval = super.clone();
        return retval;
    }

    @Override
    public void setDefault() {
        int nrfields = 0;
        this.allocate(nrfields);
    }

    @Override
    public Row getFields(Row r, String name, Row info) throws ETLStepException {
        Row row = r;
        if (this.fieldName != null && this.fieldName.length() > 0) {
            int idx = row.searchValueIndex(this.fieldName);
            if (idx < 0) {
                throw new ETLStepException("Unable to locate [" + this.fieldName + "] in the input fields");
            }
            Value v = row.getValue(idx);
            row.removeValue(idx);
            for (int i = 0; i < this.targetField.length; ++i) {
                Value value = v.Clone();
                value.setName(this.targetField[i]);
                value.setOrigin(name);
                row.addValue(value);
            }
        } else {
            throw new ETLStepException("The field to flatten is not specified");
        }
        return row;
    }

    private void readData(Node stepnode) throws ETLXMLException {
        try {
            this.fieldName = XMLHandler.getTagValue(stepnode, "field_name");
            Node fields = XMLHandler.getSubNode(stepnode, "fields");
            int nrfields = XMLHandler.countNodes(fields, "field");
            this.allocate(nrfields);
            for (int i = 0; i < nrfields; ++i) {
                Node fnode = XMLHandler.getSubNodeByNr(fields, "field", i);
                this.targetField[i] = XMLHandler.getTagValue(fnode, "name");
            }
        }
        catch (Exception e) {
            throw new ETLXMLException("Unable to load step info from XML", e);
        }
    }

    @Override
    public String getXML() {
        String retval = "";
        retval = retval + "      " + XMLHandler.addTagValue("field_name", this.fieldName);
        retval = retval + "      <fields>" + Const.CR;
        for (int i = 0; i < this.targetField.length; ++i) {
            retval = retval + "        <field>" + Const.CR;
            retval = retval + "          " + XMLHandler.addTagValue("name", this.targetField[i]);
            retval = retval + "          </field>" + Const.CR;
        }
        retval = retval + "        </fields>" + Const.CR;
        return retval;
    }

    @Override
    public void readRep(Repository rep, long id_step, List databases, Hashtable counters) throws ETLException {
        try {
            this.fieldName = rep.getStepAttributeString(id_step, "field_name");
            int nrvalues = rep.countNrStepAttributes(id_step, "target_field");
            this.allocate(nrvalues);
            for (int i = 0; i < nrvalues; ++i) {
                this.targetField[i] = rep.getStepAttributeString(id_step, i, "target_field");
            }
        }
        catch (Exception e) {
            throw new ETLException("Unexpected error reading step information from the repository", e);
        }
    }

    @Override
    public void saveRep(Repository rep, long id_transformation, long id_step) throws ETLException {
        try {
            rep.saveStepAttribute(id_transformation, id_step, "field_name", this.fieldName);
            for (int i = 0; i < this.targetField.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "target_field", this.targetField[i]);
            }
        }
        catch (Exception e) {
            throw new ETLException("Unable to save step information to the repository for id_step=" + id_step, e);
        }
    }

    @Override
    public void check(List remarks, StepMeta stepMeta, Row prev, String[] input, String[] output, Row info) {
        if (input.length > 0) {
            CheckResult cr = new CheckResult(1, "Step is receiving info from other steps.", stepMeta);
            remarks.add(cr);
        } else {
            CheckResult cr = new CheckResult(4, "No input received from other steps!", stepMeta);
            remarks.add(cr);
        }
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta transMeta, Trans trans) {
        return new Flattener(stepMeta, stepDataInterface, cnr, transMeta, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new FlattenerData();
    }
}

