/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.etl.transformation.step.mappingoutput;

import com.kingdee.bos.ctrl.etl.base.Row;
import com.kingdee.bos.ctrl.etl.exception.ETLException;
import com.kingdee.bos.ctrl.etl.exception.ETLStepException;
import com.kingdee.bos.ctrl.etl.transformation.Trans;
import com.kingdee.bos.ctrl.etl.transformation.TransMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.BaseStep;
import com.kingdee.bos.ctrl.etl.transformation.step.StepDataInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.StepInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.StepMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.StepMetaInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.mapping.Mapping;
import com.kingdee.bos.ctrl.etl.transformation.step.mappingoutput.MappingOutputData;
import com.kingdee.bos.ctrl.etl.transformation.step.mappingoutput.MappingOutputMeta;
import com.kingdee.bos.ctrl.etl.value.Value;

public class MappingOutput
extends BaseStep
implements StepInterface {
    private MappingOutputMeta meta;
    private MappingOutputData data;

    public MappingOutput(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    @Override
    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws ETLException {
        this.meta = (MappingOutputMeta)smi;
        this.data = (MappingOutputData)sdi;
        Row r = this.getRow();
        if (r == null) {
            this.data.mapping.setOutputDone();
            return false;
        }
        if (this.first) {
            this.first = false;
            while (!this.isStopped() && this.data.mapping == null) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e) {
                    this.stopAll();
                }
            }
        }
        for (int i = 0; i < this.data.outputMapping.length; ++i) {
            Value v = r.searchValue(this.data.outputMapping[i]);
            if (v == null) {
                throw new ETLStepException("Mapping output field specified couldn't be found: " + this.data.outputMapping[i]);
            }
            v.setName(this.data.outputField[i]);
        }
        this.data.mapping.putRow(r);
        if (this.linesRead > 0L && this.linesRead % 5000L == 0L) {
            this.logBasic("Linenr " + this.linesRead);
        }
        return true;
    }

    @Override
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (MappingOutputMeta)smi;
        this.data = (MappingOutputData)sdi;
        return super.init(smi, sdi);
    }

    @Override
    public void run() {
        try {
            this.logBasic("Starting to run...");
            while (this.processRow(this.meta, this.data) && !this.isStopped()) {
            }
        }
        catch (Exception e) {
            this.logError("Unexpected error in '" + this.debug + "' : " + e.toString());
            this.setErrors(1L);
            this.stopAll();
        }
        finally {
            this.dispose(this.meta, this.data);
            this.logSummary();
            this.markStop();
        }
    }

    public synchronized void setConnectorStep(Mapping mapping) {
        this.data.mapping = mapping;
    }

    public void setOutputField(String[] outputField) {
        this.data.outputField = outputField;
    }

    public void setOutputMapping(String[] outputMapping) {
        this.data.outputMapping = outputMapping;
    }
}

