/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.etl.transformation.step.selectvalues;

import com.kingdee.bos.ctrl.etl.base.CheckResult;
import com.kingdee.bos.ctrl.etl.base.Row;
import com.kingdee.bos.ctrl.etl.exception.ETLException;
import com.kingdee.bos.ctrl.etl.exception.ETLXMLException;
import com.kingdee.bos.ctrl.etl.repository.Repository;
import com.kingdee.bos.ctrl.etl.transformation.Trans;
import com.kingdee.bos.ctrl.etl.transformation.TransMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.BaseStepMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.StepDataInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.StepInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.StepMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.StepMetaInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.selectvalues.SelectValues;
import com.kingdee.bos.ctrl.etl.transformation.step.selectvalues.SelectValuesData;
import com.kingdee.bos.ctrl.etl.util.Const;
import com.kingdee.bos.ctrl.etl.util.XMLHandler;
import com.kingdee.bos.ctrl.etl.value.Value;
import java.util.Hashtable;
import java.util.List;
import org.w3c.dom.Node;

public class SelectValuesMeta
extends BaseStepMeta
implements StepMetaInterface {
    private String[] selectName;
    private String[] selectRename;
    private int[] selectLength;
    private int[] selectPrecision;
    private String[] deleteName;
    private String[] metaName;
    private String[] metaRename;
    private int[] metaType;
    private int[] metaLength;
    private int[] metaPrecision;

    public String[] getDeleteName() {
        return this.deleteName;
    }

    public void setDeleteName(String[] deleteName) {
        this.deleteName = deleteName;
    }

    public int[] getMetaLength() {
        return this.metaLength;
    }

    public void setMetaLength(int[] metaLength) {
        this.metaLength = metaLength;
    }

    public String[] getMetaName() {
        return this.metaName;
    }

    public void setMetaName(String[] metaName) {
        this.metaName = metaName;
    }

    public int[] getMetaPrecision() {
        return this.metaPrecision;
    }

    public void setMetaPrecision(int[] metaPrecision) {
        this.metaPrecision = metaPrecision;
    }

    public String[] getMetaRename() {
        return this.metaRename;
    }

    public void setMetaRename(String[] metaRename) {
        this.metaRename = metaRename;
    }

    public int[] getMetaType() {
        return this.metaType;
    }

    public void setMetaType(int[] metaType) {
        this.metaType = metaType;
    }

    public int[] getSelectLength() {
        return this.selectLength;
    }

    public void setSelectLength(int[] selectLength) {
        this.selectLength = selectLength;
    }

    public String[] getSelectName() {
        return this.selectName;
    }

    public void setSelectName(String[] selectName) {
        this.selectName = selectName;
    }

    public int[] getSelectPrecision() {
        return this.selectPrecision;
    }

    public void setSelectPrecision(int[] selectPrecision) {
        this.selectPrecision = selectPrecision;
    }

    public String[] getSelectRename() {
        return this.selectRename;
    }

    public void setSelectRename(String[] selectRename) {
        this.selectRename = selectRename;
    }

    @Override
    public void loadXML(Node stepnode, List databases, Hashtable counters) throws ETLXMLException {
        this.readData(stepnode);
    }

    public void allocate(int nrfields, int nrremove, int nrmeta) {
        this.selectName = new String[nrfields];
        this.selectRename = new String[nrfields];
        this.selectLength = new int[nrfields];
        this.selectPrecision = new int[nrfields];
        this.deleteName = new String[nrremove];
        this.metaName = new String[nrmeta];
        this.metaRename = new String[nrmeta];
        this.metaType = new int[nrmeta];
        this.metaLength = new int[nrmeta];
        this.metaPrecision = new int[nrmeta];
    }

    @Override
    public Object clone() {
        int i;
        SelectValuesMeta retval = (SelectValuesMeta)super.clone();
        int nrfields = this.selectName.length;
        int nrremove = this.deleteName.length;
        int nrmeta = this.metaName.length;
        retval.allocate(nrfields, nrremove, nrmeta);
        for (i = 0; i < nrfields; ++i) {
            retval.selectName[i] = this.selectName[i];
            retval.selectRename[i] = this.selectRename[i];
            retval.selectLength[i] = this.selectLength[i];
            retval.selectPrecision[i] = this.selectPrecision[i];
        }
        for (i = 0; i < nrremove; ++i) {
            retval.deleteName[i] = this.deleteName[i];
        }
        for (i = 0; i < nrmeta; ++i) {
            retval.metaName[i] = this.metaName[i];
            retval.metaRename[i] = this.metaRename[i];
            retval.metaType[i] = this.metaType[i];
            retval.metaLength[i] = this.metaLength[i];
            retval.metaPrecision[i] = this.metaPrecision[i];
        }
        return retval;
    }

    private void readData(Node step) throws ETLXMLException {
        try {
            Node line;
            int i;
            Node fields = XMLHandler.getSubNode(step, "fields");
            int nrfields = XMLHandler.countNodes(fields, "field");
            int nrremove = XMLHandler.countNodes(fields, "remove");
            int nrmeta = XMLHandler.countNodes(fields, "meta");
            this.allocate(nrfields, nrremove, nrmeta);
            for (i = 0; i < nrfields; ++i) {
                line = XMLHandler.getSubNodeByNr(fields, "field", i);
                this.selectName[i] = XMLHandler.getTagValue(line, "name");
                this.selectRename[i] = XMLHandler.getTagValue(line, "rename");
                this.selectLength[i] = Const.toInt(XMLHandler.getTagValue(line, "length"), -2);
                this.selectPrecision[i] = Const.toInt(XMLHandler.getTagValue(line, "precision"), -2);
            }
            for (i = 0; i < nrremove; ++i) {
                line = XMLHandler.getSubNodeByNr(fields, "remove", i);
                this.deleteName[i] = XMLHandler.getTagValue(line, "name");
            }
            for (i = 0; i < nrmeta; ++i) {
                line = XMLHandler.getSubNodeByNr(fields, "meta", i);
                this.metaName[i] = XMLHandler.getTagValue(line, "name");
                this.metaRename[i] = XMLHandler.getTagValue(line, "rename");
                this.metaType[i] = Value.getType(XMLHandler.getTagValue(line, "type"));
                this.metaLength[i] = Const.toInt(XMLHandler.getTagValue(line, "length"), -2);
                this.metaPrecision[i] = Const.toInt(XMLHandler.getTagValue(line, "precision"), -2);
            }
        }
        catch (Exception e) {
            throw new ETLXMLException("Unable to read step information from XML", e);
        }
    }

    @Override
    public void setDefault() {
        int i;
        int nrfields = 0;
        int nrremove = 0;
        int nrmeta = 0;
        this.allocate(nrfields, nrremove, nrmeta);
        for (i = 0; i < nrfields; ++i) {
            this.selectName[i] = "fieldname" + (i + 1);
            this.selectRename[i] = "";
            this.selectLength[i] = -2;
            this.selectPrecision[i] = -2;
        }
        for (i = 0; i < nrremove; ++i) {
            this.deleteName[i] = "fieldname" + (i + 1);
        }
        for (i = 0; i < nrmeta; ++i) {
            this.metaName[i] = "fieldname" + (i + 1);
            this.metaRename[i] = "";
            this.metaType[i] = 0;
            this.metaLength[i] = -2;
            this.metaPrecision[i] = -2;
        }
    }

    @Override
    public Row getFields(Row r, String name, Row info) {
        int i;
        Row row = null;
        if (this.selectName != null && this.selectName.length > 0) {
            Value v;
            if (r == null) {
                row = new Row();
                for (i = 0; i < this.selectRename.length; ++i) {
                    v = new Value(this.selectRename[i], 0);
                    row.addValue(v);
                }
            } else {
                row = new Row();
                for (i = 0; i < this.selectName.length; ++i) {
                    v = r.searchValue(this.selectName[i]);
                    if (v == null) continue;
                    if (!v.getName().equals(this.selectRename[i]) && this.selectRename[i] != null && this.selectRename[i].length() > 0) {
                        v.setName(this.selectRename[i]);
                        v.setOrigin(name);
                    }
                    if (this.selectLength[i] != -2) {
                        v.setLength(this.selectLength[i]);
                        v.setOrigin(name);
                    }
                    if (this.selectPrecision[i] != -2) {
                        v.setPrecision(this.selectPrecision[i]);
                        v.setOrigin(name);
                    }
                    row.addValue(v);
                }
                r.clear();
                r.addRow(row);
            }
        }
        if (this.deleteName != null && this.deleteName.length > 0) {
            if (r != null) {
                for (i = 0; i < this.deleteName.length; ++i) {
                    r.removeValue(this.deleteName[i]);
                }
            } else {
                row = new Row();
            }
        }
        if (this.metaName != null && this.metaName.length > 0) {
            if (r != null) {
                for (i = 0; i < this.metaName.length; ++i) {
                    int idx = r.searchValueIndex(this.metaName[i]);
                    if (idx < 0) continue;
                    Value v = r.getValue(idx);
                    if (!v.getName().equals(this.metaRename[i]) && this.metaRename[i] != null && this.metaRename[i].length() > 0) {
                        v.setName(this.metaRename[i]);
                        v.setOrigin(name);
                    }
                    if (this.metaType[i] != 0) {
                        v.setType(this.metaType[i]);
                    }
                    if (this.metaLength[i] != -2) {
                        v.setLength(this.metaLength[i]);
                        v.setOrigin(name);
                    }
                    if (this.metaPrecision[i] == -2) continue;
                    v.setPrecision(this.metaPrecision[i]);
                    v.setOrigin(name);
                }
            } else {
                row = new Row();
            }
        }
        if (row == null) {
            row = new Row(r);
        }
        return row;
    }

    @Override
    public String getXML() {
        int i;
        String retval = "";
        retval = retval + "    <fields>";
        for (i = 0; i < this.selectName.length; ++i) {
            retval = retval + "      <field>";
            retval = retval + "        " + XMLHandler.addTagValue("name", this.selectName[i]);
            retval = retval + "        " + XMLHandler.addTagValue("rename", this.selectRename[i]);
            retval = retval + "        " + XMLHandler.addTagValue("length", this.selectLength[i]);
            retval = retval + "        " + XMLHandler.addTagValue("precision", this.selectPrecision[i]);
            retval = retval + "        </field>";
        }
        for (i = 0; i < this.deleteName.length; ++i) {
            retval = retval + "      <remove>";
            retval = retval + "        " + XMLHandler.addTagValue("name", this.deleteName[i]);
            retval = retval + "        </remove>";
        }
        for (i = 0; i < this.metaName.length; ++i) {
            retval = retval + "      <meta>";
            retval = retval + "        " + XMLHandler.addTagValue("name", this.metaName[i]);
            retval = retval + "        " + XMLHandler.addTagValue("rename", this.metaRename[i]);
            retval = retval + "        " + XMLHandler.addTagValue("type", this.metaType[i]);
            retval = retval + "        " + XMLHandler.addTagValue("length", this.metaLength[i]);
            retval = retval + "        " + XMLHandler.addTagValue("precision", this.metaPrecision[i]);
            retval = retval + "        </meta>";
        }
        retval = retval + "      </fields>";
        return retval;
    }

    @Override
    public void readRep(Repository rep, long id_step, List databases, Hashtable counters) throws ETLException {
        try {
            int i;
            int nrfields = rep.countNrStepAttributes(id_step, "field_name");
            int nrremove = rep.countNrStepAttributes(id_step, "remove_name");
            int nrmeta = rep.countNrStepAttributes(id_step, "meta_name");
            this.allocate(nrfields, nrremove, nrmeta);
            for (i = 0; i < nrfields; ++i) {
                this.selectName[i] = rep.getStepAttributeString(id_step, i, "field_name");
                this.selectRename[i] = rep.getStepAttributeString(id_step, i, "field_rename");
                this.selectLength[i] = (int)rep.getStepAttributeInteger(id_step, i, "field_length");
                this.selectPrecision[i] = (int)rep.getStepAttributeInteger(id_step, i, "field_precision");
            }
            for (i = 0; i < nrremove; ++i) {
                this.deleteName[i] = rep.getStepAttributeString(id_step, i, "remove_name");
            }
            for (i = 0; i < nrmeta; ++i) {
                this.metaName[i] = rep.getStepAttributeString(id_step, i, "meta_name");
                this.metaRename[i] = rep.getStepAttributeString(id_step, i, "meta_rename");
                this.metaType[i] = (int)rep.getStepAttributeInteger(id_step, i, "meta_type");
                this.metaLength[i] = (int)rep.getStepAttributeInteger(id_step, i, "meta_length");
                this.metaPrecision[i] = (int)rep.getStepAttributeInteger(id_step, i, "meta_precision");
            }
        }
        catch (Exception e) {
            throw new ETLException("Unexpected error reading step information from the repository", e);
        }
    }

    @Override
    public void saveRep(Repository rep, long id_transformation, long id_step) throws ETLException {
        try {
            int i;
            for (i = 0; i < this.selectName.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "field_name", this.selectName[i]);
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "field_rename", this.selectRename[i]);
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "field_length", this.selectLength[i]);
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "field_precision", this.selectPrecision[i]);
            }
            for (i = 0; i < this.deleteName.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "remove_name", this.deleteName[i]);
            }
            for (i = 0; i < this.metaName.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "meta_name", this.metaName[i]);
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "meta_rename", this.metaRename[i]);
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "meta_type", this.metaType[i]);
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "meta_length", this.metaLength[i]);
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "meta_precision", this.metaPrecision[i]);
            }
        }
        catch (Exception e) {
            throw new ETLException("Unable to save step information to the repository for id_step=" + id_step, e);
        }
    }

    @Override
    public void check(List remarks, StepMeta stepMeta, Row prev, String[] input, String[] output, Row info) {
        boolean error_found;
        CheckResult cr;
        if (prev != null && prev.size() > 0) {
            int i;
            cr = new CheckResult(1, "Step is connected to previous one, receiving " + prev.size() + " fields", stepMeta);
            remarks.add(cr);
            String error_message = "";
            error_found = false;
            for (i = 0; i < this.selectName.length; ++i) {
                int idx = prev.searchValueIndex(this.selectName[i]);
                if (idx >= 0) continue;
                error_message = error_message + "\t\t" + this.selectName[i] + Const.CR;
                error_found = true;
            }
            if (error_found) {
                error_message = "Selected fields that were not found in input stream:" + Const.CR + Const.CR + error_message;
                cr = new CheckResult(4, error_message, stepMeta);
                remarks.add(cr);
            } else {
                cr = new CheckResult(1, "All selected fields are found in the input stream, coming from previous steps", stepMeta);
                remarks.add(cr);
            }
            if (this.selectName.length > 0) {
                for (i = 0; i < prev.size(); ++i) {
                    Value pv = prev.getValue(i);
                    int idx = Const.indexOfString(pv.getName(), this.selectName);
                    if (idx >= 0) continue;
                    error_message = error_message + "\t\t" + pv.getName() + " (" + pv.getTypeDesc() + ")" + Const.CR;
                    error_found = true;
                }
                if (error_found) {
                    error_message = "Fields in input stream, not found in selection:" + Const.CR + Const.CR + error_message;
                    cr = new CheckResult(2, error_message, stepMeta);
                    remarks.add(cr);
                } else {
                    cr = new CheckResult(1, "All selected fields, coming from previous steps, are found in the selection", stepMeta);
                    remarks.add(cr);
                }
            }
            error_message = "";
            error_found = false;
            for (i = 0; i < this.deleteName.length; ++i) {
                int idx = prev.searchValueIndex(this.deleteName[i]);
                if (idx >= 0) continue;
                error_message = error_message + "\t\t" + this.deleteName[i] + Const.CR;
                error_found = true;
            }
            if (error_found) {
                error_message = "De-Selected fields that were not found in input stream:" + Const.CR + Const.CR + error_message;
                cr = new CheckResult(4, error_message, stepMeta);
                remarks.add(cr);
            } else {
                cr = new CheckResult(1, "All de-selected fields in the table are found in the input stream, coming from previous steps", stepMeta);
                remarks.add(cr);
            }
            error_message = "";
            error_found = false;
            for (i = 0; i < this.metaName.length; ++i) {
                int idx = prev.searchValueIndex(this.metaName[i]);
                if (idx >= 0) continue;
                error_message = error_message + "\t\t" + this.metaName[i] + Const.CR;
                error_found = true;
            }
            if (error_found) {
                error_message = "Meta-data fields that were not found in input stream:" + Const.CR + Const.CR + error_message;
                cr = new CheckResult(4, error_message, stepMeta);
                remarks.add(cr);
            } else {
                cr = new CheckResult(1, "All meta-data fields are found in the input stream, coming from previous steps", stepMeta);
                remarks.add(cr);
            }
        } else {
            cr = new CheckResult(4, "Couldn't find fields from previous steps, check the hops...!", stepMeta);
            remarks.add(cr);
        }
        if (input.length > 0) {
            cr = new CheckResult(1, "Step is receiving info from other steps.", stepMeta);
            remarks.add(cr);
        } else {
            cr = new CheckResult(4, "No input received from other steps!", stepMeta);
            remarks.add(cr);
        }
        int[] cnt = new int[this.selectName.length];
        error_found = false;
        String error_message = "";
        for (int i = 0; i < this.selectName.length; ++i) {
            cnt[i] = 0;
            for (int j = 0; j < this.selectName.length; ++j) {
                if (!this.selectName[i].equals(this.selectName[j])) continue;
                int n = i;
                cnt[n] = cnt[n] + 1;
            }
            if (cnt[i] <= 1) continue;
            if (!error_found) {
                error_message = "Duplicate fields specified:" + Const.CR;
            } else {
                error_found = true;
            }
            error_message = error_message + "\t\trow #" + i + " : " + this.selectName[i] + "  (" + cnt[i] + " occurences)" + Const.CR;
            error_found = true;
        }
        if (error_found) {
            cr = new CheckResult(4, error_message, stepMeta);
            remarks.add(cr);
        }
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta transMeta, Trans trans) {
        return new SelectValues(stepMeta, stepDataInterface, cnr, transMeta, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new SelectValuesData();
    }
}

