/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.etl.transformation.step.uniquerows;

import com.kingdee.bos.ctrl.etl.base.Row;
import com.kingdee.bos.ctrl.etl.exception.ETLException;
import com.kingdee.bos.ctrl.etl.transformation.Trans;
import com.kingdee.bos.ctrl.etl.transformation.TransMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.BaseStep;
import com.kingdee.bos.ctrl.etl.transformation.step.StepDataInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.StepInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.StepMeta;
import com.kingdee.bos.ctrl.etl.transformation.step.StepMetaInterface;
import com.kingdee.bos.ctrl.etl.transformation.step.uniquerows.UniqueRowsData;
import com.kingdee.bos.ctrl.etl.transformation.step.uniquerows.UniqueRowsMeta;
import com.kingdee.bos.ctrl.etl.value.Value;

public class UniqueRows
extends BaseStep
implements StepInterface {
    private UniqueRowsMeta meta = (UniqueRowsMeta)this.getStepMeta().getStepMetaInterface();
    private UniqueRowsData data;

    public UniqueRows(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
        this.data = (UniqueRowsData)stepDataInterface;
    }

    @Override
    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws ETLException {
        this.meta = (UniqueRowsMeta)smi;
        this.data = (UniqueRowsData)sdi;
        this.debug = "start of processRow()";
        Row r = this.getRow();
        if (r == null) {
            if (this.data.previous != null) {
                this.addCounter(this.data.previous, this.data.counter);
                this.putRow(this.data.previous);
            }
            this.setOutputDone();
            return false;
        }
        if (this.first) {
            this.debug = "first: create new row";
            this.data.previous = new Row(r);
            this.first = false;
            this.data.fieldnrs = new int[this.meta.getCompareFields().length];
            this.data.ascending = new boolean[this.meta.getCompareFields().length];
            this.data.caseInsensitive = new boolean[this.meta.getCaseInsensitive().length];
            for (int i = 0; i < this.meta.getCompareFields().length; ++i) {
                this.data.ascending[i] = false;
                this.data.fieldnrs[i] = r.searchValueIndex(this.meta.getCompareFields()[i]);
                this.data.caseInsensitive[i] = this.meta.getCaseInsensitive()[i];
                if (this.data.fieldnrs[i] >= 0) continue;
                this.logError("Couldn't find field [" + this.meta.getCompareFields()[i] + " in row!");
                this.setErrors(1L);
                this.stopAll();
                return false;
            }
        }
        this.debug = "check for doubles...";
        boolean isEqual = false;
        if (this.meta.getCompareFields() == null || this.meta.getCompareFields().length == 0) {
            isEqual = this.data.previous.compare(r) == 0;
        } else {
            boolean bl = isEqual = this.data.previous.compare(r, this.data.fieldnrs, this.data.ascending, this.data.caseInsensitive) == 0;
        }
        if (!isEqual) {
            this.addCounter(this.data.previous, this.data.counter);
            this.putRow(this.data.previous);
            this.data.previous = new Row(r);
            this.data.counter = 1L;
        } else {
            ++this.data.counter;
        }
        if (this.linesRead > 0L && this.linesRead % 5000L == 0L) {
            this.logBasic("Linenr " + this.linesRead);
        }
        return true;
    }

    private void addCounter(Row r, long count) {
        if (this.meta.isCountRows()) {
            Value v = new Value(this.meta.getCountField(), 5);
            v.setValue(count);
            v.setLength(9, 0);
            r.addValue(v);
        }
    }

    @Override
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (UniqueRowsMeta)smi;
        this.data = (UniqueRowsData)sdi;
        return super.init(smi, sdi);
    }

    @Override
    public void run() {
        try {
            this.logBasic("Starting to run...");
            while (this.processRow(this.meta, this.data) && !this.isStopped()) {
            }
        }
        catch (Exception e) {
            this.logError("Unexpected error in '" + this.debug + "' : " + e.toString());
            this.setErrors(1L);
            this.stopAll();
        }
        finally {
            this.dispose(this.meta, this.data);
            this.logSummary();
            this.markStop();
        }
    }
}

