/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.freechart.chart.plot;

import com.kingdee.bos.ctrl.freechart.chart.JFreeChart;
import com.kingdee.bos.ctrl.freechart.chart.LegendItem;
import com.kingdee.bos.ctrl.freechart.chart.LegendItemCollection;
import com.kingdee.bos.ctrl.freechart.chart.entity.CategoryItemEntity;
import com.kingdee.bos.ctrl.freechart.chart.entity.EntityCollection;
import com.kingdee.bos.ctrl.freechart.chart.event.PlotChangeEvent;
import com.kingdee.bos.ctrl.freechart.chart.labels.CategoryItemLabelGenerator;
import com.kingdee.bos.ctrl.freechart.chart.labels.CategoryToolTipGenerator;
import com.kingdee.bos.ctrl.freechart.chart.labels.IntervalCategoryItemLabelGenerator;
import com.kingdee.bos.ctrl.freechart.chart.labels.IntervalCategoryToolTipGenerator;
import com.kingdee.bos.ctrl.freechart.chart.labels.StandardCategoryItemLabelGenerator;
import com.kingdee.bos.ctrl.freechart.chart.labels.StandardCategoryToolTipGenerator;
import com.kingdee.bos.ctrl.freechart.chart.plot.DefaultDrawingSupplier;
import com.kingdee.bos.ctrl.freechart.chart.plot.DrawingSupplier;
import com.kingdee.bos.ctrl.freechart.chart.plot.Plot;
import com.kingdee.bos.ctrl.freechart.chart.plot.PlotRenderingInfo;
import com.kingdee.bos.ctrl.freechart.chart.plot.PlotState;
import com.kingdee.bos.ctrl.freechart.chart.urls.CategoryURLGenerator;
import com.kingdee.bos.ctrl.freechart.data.category.CategoryDataset;
import com.kingdee.bos.ctrl.freechart.data.general.DatasetChangeEvent;
import com.kingdee.bos.ctrl.freechart.data.general.DatasetUtilities;
import com.kingdee.bos.ctrl.freechart.text.G2TextMeasurer;
import com.kingdee.bos.ctrl.freechart.text.TextBlock;
import com.kingdee.bos.ctrl.freechart.text.TextBlockAnchor;
import com.kingdee.bos.ctrl.freechart.text.TextUtilities;
import com.kingdee.bos.ctrl.freechart.ui.RectangleInsets;
import com.kingdee.bos.ctrl.freechart.util.PaintList;
import com.kingdee.bos.ctrl.freechart.util.Rotation;
import com.kingdee.bos.ctrl.freechart.util.StrokeList;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.NumberFormat;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;

public class RadarPlot2
extends Plot
implements Cloneable,
Serializable {
    public static final int DEFAULT_CALIBRATION_DENSITY = 5;
    public static final double DEFAULT_HEAD = 0.02;
    public static final double DEFAULT_INTERIOR_GAP = 0.25;
    public static final double DEFAULT_START_ANGLE = 90.0;
    public static final Shape DEFAULT_LEGEND_ITEM_CIRCLE = new Ellipse2D.Double(-4.0, -4.0, 8.0, 8.0);
    public static final Font DEFAULT_LABEL_FONT = new Font("SansSerif", 0, 10);
    public static final Paint DEFAULT_LABEL_PAINT = Color.black;
    public static final double DEFAULT_AXIS_LABEL_GAP = 0.1;
    public static final double DEFAULT_MAX_STD = 0.8;
    public static final double DEFAULT_MIN_STD = 0.3;
    public static final Stroke DEFAULT_RANGE_STROKE = new BasicStroke(1.0f, 0, 0, 10.0f, new float[]{2.0f}, 0.0f);
    public static final int RANGE_STYLE_CIRCLE = 0;
    public static final int RANGE_STYLE_POLYGON = 1;
    public static final double MAX_INTERIOR_GAP = 0.4;
    private static final int DEFAULT_MIN_RANGE_INDEX = 0;
    private static final int DEFAULT_MAX_RANGE_INDEX = 1;
    protected double headPercent;
    private double interiorGap;
    private CategoryDataset dataset;
    private boolean isWrongData;
    private String wrongDataMessage = "Wrong Data";
    private Font wrongDataMessageFont;
    private transient Paint wrongDataMessagePaint;
    private Rotation direction;
    private double startAngle;
    private Font labelFont;
    private transient Paint labelPaint;
    private CategoryItemLabelGenerator labelGenerator;
    private CategoryToolTipGenerator tooltipGenerator;
    private CategoryURLGenerator urlGenerator;
    private boolean webFilled;
    private transient Paint axisLinePaint;
    private transient Stroke axisLineStroke;
    private transient Stroke rangeStroke;
    private transient Paint seriesPaint;
    private PaintList seriesPaintList;
    private transient Paint baseSeriesPaint;
    private transient Paint seriesOutlinePaint;
    private PaintList seriesOutlinePaintList;
    private transient Paint baseSeriesOutlinePaint;
    private transient Stroke seriesOutlineStroke;
    private StrokeList seriesOutlineStrokeList;
    private transient Stroke baseSeriesOutlineStroke;
    private double axisLabelGap;
    private transient Shape legendItemShape;
    private boolean rangeDrawn;
    private boolean valueDrawn;
    private int calibrationDensity;
    private int rangeStyle;
    private double max_range_std;
    private double min_range_std;
    private Hashtable formattedCategorySet;
    private int minRangeIndex = 0;
    private int maxRangeIndex = 1;
    private boolean showCategoryName = true;
    private boolean showStandardValue = true;
    private Stroke webOutlineStroke = new BasicStroke(0.8f);
    boolean isShowPercentFormatForValue = false;
    boolean isShowPercentFormatForTooltip = false;

    public RadarPlot2(CategoryDataset data, int minIndex, int maxIndex, boolean isShowPercentFormatForValue, boolean isShowPercentFormatForTooltip) {
        this.isShowPercentFormatForValue = isShowPercentFormatForValue;
        this.isShowPercentFormatForTooltip = isShowPercentFormatForTooltip;
        this.dataset = data;
        if (this.dataset != null) {
            this.dataset.addChangeListener(this);
            int rowLength = data.getRowCount();
            if (minIndex >= 0 && minIndex < rowLength) {
                this.minRangeIndex = minIndex;
            } else {
                this.isWrongData = true;
                this.minRangeIndex = 0;
            }
            if (maxIndex >= 0 && maxIndex < rowLength) {
                this.maxRangeIndex = maxIndex;
            } else {
                this.isWrongData = true;
                this.maxRangeIndex = 1;
            }
        }
        this.initialize();
    }

    private void initialize() {
        Paint tmp;
        Paint[] customPaintSequence = DefaultDrawingSupplier.DEFAULT_PAINT_SEQUENCE;
        Paint[] requiredPaintSequence = new Paint[]{Color.decode("#FF0000"), Color.decode("#3886FB"), Color.decode("#4FBD37"), Color.decode("#F2AB0C"), Color.decode("#787DE3"), Color.decode("#FF8A00"), Color.decode("#A1846E"), Color.decode("#E36AE2"), Color.decode("#8092B1"), Color.decode("#79B4E0"), Color.decode("#F5848B"), Color.decode("#57C9DD"), Color.decode("#8ABC20"), Color.decode("#55A6BE"), Color.decode("#AE5454"), Color.decode("#FDDAA7")};
        int requiredLength = requiredPaintSequence.length;
        if (this.minRangeIndex < requiredLength) {
            tmp = requiredPaintSequence[this.minRangeIndex];
            requiredPaintSequence[this.minRangeIndex] = requiredPaintSequence[0];
            requiredPaintSequence[0] = tmp;
        }
        if (this.maxRangeIndex < requiredLength) {
            tmp = requiredPaintSequence[this.maxRangeIndex];
            requiredPaintSequence[this.maxRangeIndex] = requiredPaintSequence[1];
            requiredPaintSequence[1] = tmp;
        }
        for (int i = 0; i < requiredLength; ++i) {
            customPaintSequence[i] = requiredPaintSequence[i];
        }
        DefaultDrawingSupplier customRadarDrawingSupplier = new DefaultDrawingSupplier(customPaintSequence, DefaultDrawingSupplier.DEFAULT_OUTLINE_PAINT_SEQUENCE, DefaultDrawingSupplier.DEFAULT_STROKE_SEQUENCE, DefaultDrawingSupplier.DEFAULT_OUTLINE_STROKE_SEQUENCE, DefaultDrawingSupplier.DEFAULT_SHAPE_SEQUENCE);
        this.setDrawingSupplier(customRadarDrawingSupplier);
        this.headPercent = 0.02;
        this.startAngle = 90.0;
        this.axisLinePaint = Color.black;
        this.axisLinePaint = Color.black;
        this.axisLineStroke = new BasicStroke(1.0f);
        this.axisLabelGap = 0.1;
        this.interiorGap = 0.25;
        this.startAngle = 90.0;
        this.direction = Rotation.CLOCKWISE;
        this.rangeStroke = DEFAULT_RANGE_STROKE;
        this.seriesPaint = null;
        this.seriesPaintList = new PaintList();
        this.baseSeriesPaint = null;
        this.seriesOutlinePaint = null;
        this.seriesOutlinePaintList = new PaintList();
        this.baseSeriesOutlinePaint = DEFAULT_OUTLINE_PAINT;
        this.seriesOutlineStroke = null;
        this.seriesOutlineStrokeList = new StrokeList();
        this.baseSeriesOutlineStroke = DEFAULT_OUTLINE_STROKE;
        this.labelFont = DEFAULT_LABEL_FONT;
        this.labelPaint = DEFAULT_LABEL_PAINT;
        this.initCategoryItemLabelGenerator();
        this.legendItemShape = DEFAULT_LEGEND_ITEM_CIRCLE;
        this.calibrationDensity = 5;
        this.rangeDrawn = true;
        this.webFilled = true;
        this.max_range_std = 0.8;
        this.min_range_std = 0.3;
        this.rangeStyle = 0;
        this.formattedCategorySet = new Hashtable();
        this.wrongDataMessageFont = new Font("SansSerif", 0, 16);
        this.wrongDataMessagePaint = Color.black;
        this.setNoDataMessage("No Data!");
        this.setNoDataMessageFont(new Font("SansSerif", 0, 16));
        this.setNoDataMessagePaint(Color.black);
    }

    public void initCategoryItemLabelGenerator() {
        DecimalFormat percentFormatter = new DecimalFormat("#,###.##%");
        this.labelGenerator = this.isShowPercentFormatForValue ? new IntervalCategoryItemLabelGenerator("{2}", percentFormatter) : new StandardCategoryItemLabelGenerator();
        this.tooltipGenerator = this.isShowPercentFormatForTooltip ? new IntervalCategoryToolTipGenerator("({0}, {1}) = {2}", percentFormatter) : new StandardCategoryToolTipGenerator();
    }

    public double getStandardMaxRange() {
        return this.max_range_std;
    }

    public void setStandardMaxRange(double range) {
        if (range < 0.0 || range > 1.0) {
            throw new IllegalArgumentException("'range' argument has to be between 0 and 1.");
        }
        this.max_range_std = range;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public double getStandardMinRange() {
        return this.min_range_std;
    }

    public void setStandardMinRange(double range) {
        if (range < 0.0 || range > 1.0) {
            throw new IllegalArgumentException("'range' argument has to be between 0 and 1.");
        }
        this.min_range_std = range;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public int getRangeStyle() {
        return this.rangeStyle;
    }

    public void setRangeStyle(int style) {
        if (style != 0 && style != 1) {
            throw new IllegalArgumentException("'style' argument has to be RANGE_STYLE_CIRCLE or RANGE_STYLE_BROKEN_LINE.");
        }
        this.rangeStyle = style;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public CategoryDataset getDataset() {
        return this.dataset;
    }

    public void setDataset(CategoryDataset dataset) {
        if (this.dataset != null) {
            this.dataset.removeChangeListener(this);
        }
        this.dataset = dataset;
        if (dataset != null) {
            this.setDatasetGroup(dataset.getGroup());
            dataset.addChangeListener(this);
        }
        this.datasetChanged(new DatasetChangeEvent(this, dataset));
    }

    public Shape getLegendItemShape() {
        return this.legendItemShape;
    }

    public void setLegendItemShape(Shape shape) {
        if (shape == null) {
            throw new IllegalArgumentException("Null 'shape' argument.");
        }
        this.legendItemShape = shape;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Font getLabelFont() {
        return this.labelFont;
    }

    public void setLabelFont(Font font) {
        if (font == null) {
            throw new IllegalArgumentException("Null 'font' argument.");
        }
        this.labelFont = font;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Paint getLabelPaint() {
        return this.labelPaint;
    }

    public void setLabelPaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.labelPaint = paint;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    protected String formatCategoryItemValue(Format format, int category, String value) {
        String result = ((NumberFormat)format).format(Double.parseDouble(value));
        return result;
    }

    public boolean isCategoryItemValueFormatting(int category) {
        return this.formattedCategorySet.containsKey(new Integer(category));
    }

    public void setCategoryItemValueFormat(int category, Format format) {
        this.formattedCategorySet.put(new Integer(category), format);
    }

    public Format getCategoryItemValueFormat(int category) {
        return (Format)this.formattedCategorySet.get(new Integer(category));
    }

    public CategoryItemLabelGenerator getLabelGenerator() {
        return this.labelGenerator;
    }

    public void setLabelGenerator(CategoryItemLabelGenerator generator) {
        if (generator == null) {
            throw new IllegalArgumentException("Null 'generator' argument.");
        }
        this.labelGenerator = generator;
    }

    public CategoryToolTipGenerator getToolTipGenerator() {
        return this.tooltipGenerator;
    }

    public void setToolTipGenerator(CategoryToolTipGenerator generator) {
        this.tooltipGenerator = generator;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public CategoryURLGenerator getURLGenerator() {
        return this.urlGenerator;
    }

    public void setURLGenerator(CategoryURLGenerator generator) {
        this.urlGenerator = generator;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public boolean isWebFilled() {
        return this.webFilled;
    }

    public void setWebFilled(boolean flag) {
        this.webFilled = flag;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public boolean isRangeDrawn() {
        return this.rangeDrawn;
    }

    public void setRangeDrawn(boolean flag) {
        this.rangeDrawn = flag;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public boolean isTargetValueDrawn() {
        return this.valueDrawn;
    }

    public void setTargetValueDrawn(boolean b) {
        this.valueDrawn = b;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public double getStartAngle() {
        return this.startAngle;
    }

    public void setStartAngle(double angle) {
        this.startAngle = angle;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public int getCalibrationDensity() {
        return this.calibrationDensity;
    }

    public void setCalibrationDensity(int d) {
        if (d < 2) {
            throw new IllegalArgumentException("argument can't be less than 2");
        }
        this.calibrationDensity = d;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public double getAxisLabelGap() {
        return this.axisLabelGap;
    }

    public void setAxisLabelGap(double gap) {
        this.axisLabelGap = gap;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Paint getAxisLinePaint() {
        return this.axisLinePaint;
    }

    public void setAxisLinePaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.axisLinePaint = paint;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public double getInteriorGap() {
        return this.interiorGap;
    }

    public void setInteriorGap(double percent) {
        if (percent < 0.0 || percent > 0.4) {
            throw new IllegalArgumentException("Percentage outside valid range.");
        }
        if (this.interiorGap != percent) {
            this.interiorGap = percent;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public Stroke getAxisLineStroke() {
        return this.axisLineStroke;
    }

    public void setAxisLineStroke(Stroke stroke) {
        if (stroke == null) {
            throw new IllegalArgumentException("Null 'stroke' argument.");
        }
        this.axisLineStroke = stroke;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Stroke getRangeStroke() {
        return this.rangeStroke;
    }

    public void setRangeStroke(Stroke stroke) {
        if (stroke == null) {
            throw new IllegalArgumentException("Null 'stroke' argument.");
        }
        this.rangeStroke = stroke;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Paint getSeriesPaint() {
        return this.seriesPaint;
    }

    public void setSeriesPaint(Paint paint) {
        this.seriesPaint = paint;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Paint getSeriesPaint(int series) {
        if (this.seriesPaint != null) {
            return this.seriesPaint;
        }
        Paint result = this.seriesPaintList.getPaint(series);
        if (result == null) {
            DrawingSupplier supplier = this.getDrawingSupplier();
            if (supplier != null) {
                Paint p = supplier.getNextPaint();
                this.seriesPaintList.setPaint(series, p);
                result = p;
            } else {
                result = this.baseSeriesPaint;
            }
        }
        return result;
    }

    public void setSeriesPaint(int series, Paint paint) {
        this.seriesPaintList.setPaint(series, paint);
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Paint getBaseSeriesPaint() {
        return this.baseSeriesPaint;
    }

    public void setBaseSeriesPaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.baseSeriesPaint = paint;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Paint getSeriesOutlinePaint() {
        return this.seriesOutlinePaint;
    }

    public void setSeriesOutlinePaint(Paint paint) {
        this.seriesOutlinePaint = paint;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Paint getSeriesOutlinePaint(int series) {
        if (this.seriesOutlinePaint != null) {
            return this.seriesOutlinePaint;
        }
        Paint result = this.seriesOutlinePaintList.getPaint(series);
        if (result == null) {
            result = this.baseSeriesOutlinePaint;
        }
        return result;
    }

    public void setSeriesOutlinePaint(int series, Paint paint) {
        this.seriesOutlinePaintList.setPaint(series, paint);
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Paint getBaseSeriesOutlinePaint() {
        return this.baseSeriesOutlinePaint;
    }

    public void setBaseSeriesOutlinePaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.baseSeriesOutlinePaint = paint;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Stroke getSeriesOutlineStroke() {
        return this.seriesOutlineStroke;
    }

    public void setSeriesOutlineStroke(Stroke stroke) {
        this.seriesOutlineStroke = stroke;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Stroke getSeriesOutlineStroke(int series) {
        if (this.seriesOutlineStroke != null) {
            return this.seriesOutlineStroke;
        }
        Stroke result = this.seriesOutlineStrokeList.getStroke(series);
        if (result == null) {
            result = this.baseSeriesOutlineStroke;
        }
        return result;
    }

    public void setSeriesOutlineStroke(int series, Stroke stroke) {
        this.seriesOutlineStrokeList.setStroke(series, stroke);
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Stroke getBaseSeriesOutlineStroke() {
        return this.baseSeriesOutlineStroke;
    }

    public void setBaseSeriesOutlineStroke(Stroke stroke) {
        if (stroke == null) {
            throw new IllegalArgumentException("Null 'stroke' argument.");
        }
        this.baseSeriesOutlineStroke = stroke;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public double getHeadPercent() {
        return this.headPercent;
    }

    public void setHeadPercent(double percent) {
        this.headPercent = percent;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Rotation getDirection() {
        return this.direction;
    }

    public void setDirection(Rotation direction) {
        if (direction == null) {
            throw new IllegalArgumentException("Null 'direction' argument.");
        }
        this.direction = direction;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    @Override
    public LegendItemCollection getLegendItems() {
        LegendItemCollection result = new LegendItemCollection();
        List keys = null;
        keys = this.dataset.getRowKeys();
        if (keys != null) {
            int series = 0;
            Iterator iterator = keys.iterator();
            Shape shape = this.getLegendItemShape();
            while (iterator.hasNext()) {
                String label;
                String description = label = iterator.next().toString();
                Paint paint = this.getSeriesPaint(series);
                Paint outlinePaint = this.getSeriesOutlinePaint(series);
                Stroke stroke = this.getSeriesOutlineStroke(series);
                LegendItem item = new LegendItem(label, description, null, null, shape, paint, stroke, outlinePaint);
                result.add(item);
                ++series;
            }
        }
        return result;
    }

    public boolean isShowCategoryName() {
        return this.showCategoryName;
    }

    public void setShowCategoryName(boolean b) {
        this.showCategoryName = b;
    }

    public boolean isShowStandardValue() {
        return this.showStandardValue;
    }

    public void setShowStandardValue(boolean b) {
        this.showStandardValue = b;
    }

    public String getWrongDataMessage() {
        return this.wrongDataMessage;
    }

    public void setWrongDataMessage(String message) {
        this.wrongDataMessage = message;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Font getWRongDataMessageFont() {
        return this.wrongDataMessageFont;
    }

    public void setWrongDataMessageFont(Font font) {
        if (font == null) {
            throw new IllegalArgumentException("Null 'font' argument.");
        }
        this.wrongDataMessageFont = font;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Paint getWrongDataMessagePaint() {
        return this.wrongDataMessagePaint;
    }

    public void setWrongDataMessagePaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.wrongDataMessagePaint = paint;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    protected Point2D getWebPoint(Rectangle2D bounds, double angle, double length) {
        double angrad = Math.toRadians(angle);
        double x = Math.cos(angrad) * length * bounds.getWidth() / 2.0;
        double y = -Math.sin(angrad) * length * bounds.getHeight() / 2.0;
        return new Point2D.Double(bounds.getX() + x + bounds.getWidth() / 2.0, bounds.getY() + y + bounds.getHeight() / 2.0);
    }

    private Point2D calculateExcessWidthForCategoryLabel(Graphics2D g2, Rectangle2D plotArea, Rectangle2D radarArea) {
        double leftExtraWidth = 0.0;
        double rightExtraWidth = 0.0;
        if (!DatasetUtilities.isEmptyOrNull(this.dataset)) {
            int catCount = this.dataset.getColumnCount();
            FontRenderContext frc = g2.getFontRenderContext();
            double minX = plotArea.getX();
            double maxX = plotArea.getX() + plotArea.getWidth();
            for (int i = 0; i < catCount; ++i) {
                double angle = this.getStartAngle() + this.getDirection().getFactor() * (double)i * 360.0 / (double)catCount;
                String label = this.dataset.getColumnKey(i).toString();
                Rectangle2D labelBounds = this.getLabelFont().getStringBounds(label, frc);
                LineMetrics lm = this.getLabelFont().getLineMetrics(label, frc);
                double ascent = lm.getAscent();
                Point2D labelPoint = this.calculateLabelLocation(labelBounds, ascent, radarArea, angle);
                double x = labelPoint.getX();
                double labelWidth = labelBounds.getWidth();
                minX = Math.min(x, minX);
                maxX = Math.max(x + labelWidth, maxX);
            }
            if (minX < plotArea.getX()) {
                leftExtraWidth = plotArea.getX() - minX;
            }
            if (maxX > plotArea.getX() + plotArea.getWidth()) {
                rightExtraWidth = maxX - (plotArea.getX() + plotArea.getWidth());
            }
        }
        return new Point2D.Double(leftExtraWidth, rightExtraWidth);
    }

    @Override
    public void draw(Graphics2D g2, Rectangle2D plotArea, Point2D anchor, PlotState parentState, PlotRenderingInfo info) {
        RectangleInsets insets = this.getInsets();
        insets.trim(plotArea);
        if (insets != null) {
            plotArea.setRect(plotArea.getX() + insets.getLeft(), plotArea.getY() + insets.getTop(), plotArea.getWidth() - insets.getLeft() - insets.getRight(), plotArea.getHeight() - insets.getTop() - insets.getBottom());
        }
        if (info != null) {
            info.setPlotArea(plotArea);
            info.setDataArea(plotArea);
        }
        this.drawBackground(g2, plotArea);
        Shape savedClip = g2.getClip();
        g2.clip(plotArea);
        Composite originalComposite = g2.getComposite();
        g2.setComposite(AlphaComposite.getInstance(3, this.getForegroundAlpha()));
        if (!DatasetUtilities.isEmptyOrNull(this.dataset)) {
            if (this.isWrongData) {
                this.drawWrongDataMessage(g2, plotArea);
                return;
            }
            int seriesCount = 0;
            int catCount = 0;
            seriesCount = this.dataset.getRowCount();
            catCount = this.dataset.getColumnCount();
            double gapHorizontal = plotArea.getWidth() * this.getInteriorGap();
            double gapVertical = plotArea.getHeight() * this.getInteriorGap();
            double X = plotArea.getX() + gapHorizontal / 2.0;
            double Y = plotArea.getY() + gapVertical / 2.0;
            double W = plotArea.getWidth() - gapHorizontal;
            double H = plotArea.getHeight() - gapVertical;
            double min = Math.min(W, H) / 2.0;
            X = (X + X + W) / 2.0 - min;
            Y = (Y + Y + H) / 2.0 - min;
            W = 2.0 * min;
            H = 2.0 * min;
            Rectangle2D.Double radarArea = new Rectangle2D.Double(X, Y, W, H);
            Point2D extraWidth = this.calculateExcessWidthForCategoryLabel(g2, plotArea, radarArea);
            double leftExtraPlotAreaWidth = extraWidth.getX();
            double rightExtraPlotAreaWidth = extraWidth.getY();
            Y += (H - (W -= leftExtraPlotAreaWidth + rightExtraPlotAreaWidth)) / 2.0;
            H = W;
            ((Rectangle2D)radarArea).setRect(X += leftExtraPlotAreaWidth, Y, W, H);
            Point2D.Double centre = new Point2D.Double(X + W / 2.0, Y + H / 2.0);
            Rectangle2D.Double maxRect = new Rectangle2D.Double((int)(X + W / 2.0 * (1.0 - this.max_range_std)), (int)(Y + H / 2.0 * (1.0 - this.max_range_std)), (int)(W * this.max_range_std), (int)(H * this.max_range_std));
            Rectangle2D.Double minRect = new Rectangle2D.Double((int)(X + W / 2.0 * (1.0 - this.min_range_std)), (int)(Y + H / 2.0 * (1.0 - this.min_range_std)), (int)(W * this.min_range_std), (int)(H * this.min_range_std));
            double headW = ((RectangularShape)radarArea).getWidth() * this.headPercent;
            double headH = ((RectangularShape)radarArea).getHeight() * this.headPercent;
            Polygon maxPoly = new Polygon();
            Polygon minPoly = new Polygon();
            if (this.rangeStyle == 0) {
                g2.setPaint(new GradientPaint((float)maxRect.getMinX(), (float)maxRect.getMinY(), Color.decode("#E0ECFC"), (float)maxRect.getMaxX(), (float)maxRect.getMaxY(), Color.decode("#94B1DB")));
                g2.fillOval((int)((RectangularShape)maxRect).getX(), (int)((RectangularShape)maxRect).getY(), (int)((RectangularShape)maxRect).getWidth(), (int)((RectangularShape)maxRect).getHeight());
                g2.setPaint(new GradientPaint((float)minRect.getMinX(), (float)minRect.getMinY(), Color.decode("#DFEAF7"), (float)minRect.getMaxX(), (float)minRect.getMaxY(), Color.decode("#CBD9EC")));
                g2.fillOval((int)((RectangularShape)minRect).getX(), (int)((RectangularShape)minRect).getY(), (int)((RectangularShape)minRect).getWidth(), (int)((RectangularShape)minRect).getHeight());
            }
            for (int cat = 0; cat < catCount; ++cat) {
                double angle = this.getStartAngle() + this.getDirection().getFactor() * (double)cat * 360.0 / (double)catCount;
                Point2D endPoint = this.getWebPoint(radarArea, angle, 1.0);
                Line2D.Double line = new Line2D.Double(centre, endPoint);
                g2.setPaint(this.axisLinePaint);
                g2.setStroke(this.axisLineStroke);
                g2.draw(line);
                if (this.isShowCategoryName()) {
                    this.drawLabel(g2, radarArea, 0.0, cat, angle, 360.0 / (double)catCount);
                }
                Point2D maxRangeNode = this.getWebPoint(radarArea, angle, this.max_range_std);
                Point2D minRangeNode = this.getWebPoint(radarArea, angle, this.min_range_std);
                int part = this.getCalibrationDensity();
                for (int i = 1; i < part; ++i) {
                    int r = (int)((this.min_range_std + (this.max_range_std - this.min_range_std) / (double)part * (double)i) * W / 2.0);
                    Point2D.Double leftCorner = new Point2D.Double(X + W / 2.0 - (double)r, Y + H / 2.0 - (double)r);
                    g2.drawArc((int)((Point2D)leftCorner).getX(), (int)((Point2D)leftCorner).getY(), r * 2, r * 2, (int)angle - 1, 2);
                }
                if (this.isShowStandardValue()) {
                    this.drawLabelForNode(g2, minRect, cat, this.minRangeIndex, angle, info, minRangeNode);
                    this.drawLabelForNode(g2, maxRect, cat, this.maxRangeIndex, angle, info, maxRangeNode);
                }
                maxPoly.addPoint((int)maxRangeNode.getX(), (int)maxRangeNode.getY());
                minPoly.addPoint((int)minRangeNode.getX(), (int)minRangeNode.getY());
            }
            if (this.rangeStyle == 0) {
                g2.setStroke(this.rangeStroke);
                g2.setPaint(this.getSeriesPaint(this.minRangeIndex));
                g2.drawOval((int)((RectangularShape)minRect).getX(), (int)((RectangularShape)minRect).getY(), (int)((RectangularShape)minRect).getWidth(), (int)((RectangularShape)minRect).getHeight());
                g2.setPaint(this.getSeriesPaint(this.maxRangeIndex));
                g2.drawOval((int)((RectangularShape)maxRect).getX(), (int)((RectangularShape)maxRect).getY(), (int)((RectangularShape)maxRect).getWidth(), (int)((RectangularShape)maxRect).getHeight());
            } else if (this.rangeStyle == 1) {
                g2.setStroke(new BasicStroke(1.0f));
                g2.setPaint(this.getSeriesPaint(this.minRangeIndex));
                g2.drawPolygon(minPoly);
                g2.setPaint(this.getSeriesPaint(this.maxRangeIndex));
                g2.drawPolygon(maxPoly);
            }
            for (int series = 0; series < seriesCount; ++series) {
                if (series == this.minRangeIndex || series == this.maxRangeIndex) continue;
                this.drawRadarPoly(g2, radarArea, centre, info, series, catCount, headH, headW);
            }
        } else {
            this.drawNoDataMessage(g2, plotArea);
        }
        g2.setClip(savedClip);
        g2.setComposite(originalComposite);
        this.drawOutline(g2, plotArea);
    }

    protected void drawLabel(Graphics2D g2, Rectangle2D plotArea, double value, int cat, double startAngle, double extent) {
        FontRenderContext frc = g2.getFontRenderContext();
        String label = this.dataset.getColumnKey(cat).toString();
        Rectangle2D labelBounds = this.getLabelFont().getStringBounds(label, frc);
        LineMetrics lm = this.getLabelFont().getLineMetrics(label, frc);
        double ascent = lm.getAscent();
        Point2D labelLocation = this.calculateLabelLocation(labelBounds, ascent, plotArea, startAngle);
        Composite saveComposite = g2.getComposite();
        g2.setComposite(AlphaComposite.getInstance(3, 1.0f));
        g2.setPaint(this.getLabelPaint());
        JFreeChart.adjustForChineseDrawableFont(g2, this.getLabelFont());
        g2.drawString(label, (float)labelLocation.getX(), (float)labelLocation.getY());
        g2.setComposite(saveComposite);
    }

    protected void drawLabelForNode(Graphics2D g2, Rectangle2D plotArea, int cat, int series, double angle, PlotRenderingInfo info, Point2D point) {
        FontRenderContext frc = g2.getFontRenderContext();
        double stretch = 5.0;
        Rectangle2D area = (Rectangle2D)plotArea.clone();
        area.setRect(plotArea.getX() + stretch, plotArea.getY() + stretch, plotArea.getWidth() - 2.0 * stretch, plotArea.getHeight() - 2.0 * stretch);
        if (this.labelGenerator != null) {
            Format format;
            String label = this.labelGenerator.generateLabel(this.dataset, series, cat);
            if (label == null || label.length() == 0) {
                return;
            }
            if (this.isCategoryItemValueFormatting(cat) && (format = this.getCategoryItemValueFormat(cat)) != null && format instanceof NumberFormat) {
                label = this.formatCategoryItemValue(format, cat, label);
            }
            Rectangle2D labelBounds = this.getLabelFont().getStringBounds(label, frc);
            LineMetrics lm = this.getLabelFont().getLineMetrics(label, frc);
            double ascent = lm.getAscent();
            Point2D labelLocation = this.calculateLabelLocation(labelBounds, ascent, area, angle - 5.0);
            Composite saveComposite = g2.getComposite();
            g2.setComposite(AlphaComposite.getInstance(3, 1.0f));
            g2.setPaint(this.getSeriesPaint(series));
            JFreeChart.adjustForChineseDrawableFont(g2, this.getLabelFont());
            g2.drawString(label, (float)labelLocation.getX(), (float)labelLocation.getY());
            g2.setComposite(saveComposite);
        }
        EntityCollection entities = null;
        if (info != null) {
            entities = info.getOwner().getEntityCollection();
        }
        if (entities != null) {
            String tip = null;
            if (this.tooltipGenerator != null) {
                tip = this.tooltipGenerator.generateToolTip(this.dataset, series, cat);
            }
            String url = null;
            if (this.urlGenerator != null) {
                url = this.urlGenerator.generateURL(this.dataset, series, cat);
            }
            Rectangle rect = new Rectangle((int)(point.getX() - 2.0), (int)(point.getY() - 2.0), 4, 4);
            CategoryItemEntity entity = new CategoryItemEntity(rect, tip, url, this.dataset, series, this.dataset.getColumnKey(cat), cat);
            entities.add(entity);
        }
    }

    protected Point2D calculateLabelLocation(Rectangle2D labelBounds, double ascent, Rectangle2D plotArea, double startAngle) {
        Arc2D.Double arc1 = new Arc2D.Double(plotArea, startAngle, 0.0, 0);
        Point2D point1 = arc1.getEndPoint();
        double deltaX = -(point1.getX() - plotArea.getCenterX()) * this.axisLabelGap;
        double deltaY = -(point1.getY() - plotArea.getCenterY()) * this.axisLabelGap;
        double labelX = point1.getX() - deltaX;
        double labelY = point1.getY() - deltaY;
        if (labelX < plotArea.getCenterX()) {
            labelX -= labelBounds.getWidth();
        }
        if (labelX == plotArea.getCenterX()) {
            labelX -= labelBounds.getWidth() / 2.0;
        }
        if (labelY > plotArea.getCenterY()) {
            labelY += ascent;
        }
        return new Point2D.Double(labelX, labelY);
    }

    protected void drawRadarPoly(Graphics2D g2, Rectangle2D plotArea, Point2D centre, PlotRenderingInfo info, int series, int catCount, double headH, double headW) {
        Polygon polygon = new Polygon();
        EntityCollection entities = null;
        if (info != null) {
            entities = info.getOwner().getEntityCollection();
        }
        for (int cat = 0; cat < catCount; ++cat) {
            Number dataValue = this.getPlotValue(series, cat);
            Number minValue = this.getPlotValue(this.minRangeIndex, cat);
            Number maxValue = this.getPlotValue(this.maxRangeIndex, cat);
            if (minValue == null || maxValue == null || dataValue == null) {
                double angle = this.getStartAngle() + this.getDirection().getFactor() * (double)cat * 360.0 / (double)catCount;
                Point2D p = this.getWebPoint(plotArea, angle, 0.5);
                String label = null;
                if (dataValue != null) {
                    Format format;
                    label = this.labelGenerator.generateLabel(this.dataset, series, cat);
                    if (this.isCategoryItemValueFormatting(cat) && (format = this.getCategoryItemValueFormat(cat)) != null && format instanceof NumberFormat) {
                        label = this.formatCategoryItemValue(format, cat, label);
                    }
                } else {
                    label = "NULL";
                }
                g2.setPaint(Color.red);
                FontRenderContext frc = g2.getFontRenderContext();
                int woff = (int)g2.getFont().getStringBounds(label, frc).getWidth() / 2;
                g2.drawString(label, (int)p.getX() - woff, (int)p.getY());
                continue;
            }
            if (dataValue == null) continue;
            double value = dataValue.doubleValue();
            double minVal = minValue.doubleValue();
            double maxVal = maxValue.doubleValue();
            double length = 1.0;
            double angle = this.getStartAngle() + this.getDirection().getFactor() * (double)cat * 360.0 / (double)catCount;
            Point2D point = null;
            if (minVal > maxVal) {
                if (value > minVal) {
                    double tmpMulti = (1.5707963267948966 + Math.atan(0.01 * -value)) / Math.PI;
                    tmpMulti = tmpMulti * 0.75 + 0.1;
                    length = this.min_range_std * tmpMulti;
                } else if (value >= maxVal && value <= minVal) {
                    length = this.min_range_std + (minVal - value) * (this.max_range_std - this.min_range_std) / (minVal - maxVal);
                } else if (value < maxVal) {
                    length = this.max_range_std + (1.0 - this.max_range_std) * (1.5707963267948966 + Math.atan(0.01 * -value)) / Math.PI;
                }
                point = this.getWebPoint(plotArea, angle, length);
            } else if (minVal < maxVal) {
                if (value > maxVal) {
                    length = this.max_range_std + (1.0 - this.max_range_std) * (1.5707963267948966 + Math.atan(0.01 * value)) / Math.PI;
                } else if (value >= minVal && value <= maxVal) {
                    length = this.min_range_std + (value - minVal) * (this.max_range_std - this.min_range_std) / (maxVal - minVal);
                } else if (value < minVal) {
                    double tmpMulti = (1.5707963267948966 + Math.atan(0.01 * value)) / Math.PI;
                    tmpMulti = tmpMulti * 0.75 + 0.1;
                    length = this.min_range_std * tmpMulti;
                }
                point = this.getWebPoint(plotArea, angle, length);
            } else {
                length = value > maxVal ? this.max_range_std + (1.0 - this.max_range_std) * (1.5707963267948966 + Math.atan(0.01 * value)) / Math.PI : (value == maxVal ? this.max_range_std : this.min_range_std * (1.5707963267948966 + Math.atan(0.6 * value)) / Math.PI);
                point = this.getWebPoint(plotArea, angle, length);
            }
            polygon.addPoint((int)point.getX(), (int)point.getY());
            Ellipse2D.Double head = new Ellipse2D.Double(point.getX() - headW / 2.0, point.getY() - headH / 2.0, headW, headH);
            Composite orgC = g2.getComposite();
            g2.setComposite(AlphaComposite.getInstance(3, 0.5f));
            g2.setPaint(Color.decode("#787878"));
            g2.translate(2, 2);
            g2.fill(head);
            g2.translate(-2, -2);
            g2.setComposite(orgC);
            Paint paint = this.getSeriesPaint(series);
            Paint outlinePaint = this.getSeriesOutlinePaint(series);
            Stroke outlineStroke = this.getSeriesOutlineStroke(series);
            if (paint instanceof GradientPaint) {
                g2.setPaint(new GradientPaint((float)head.getMinX(), (float)head.getMinY(), ((GradientPaint)paint).getColor1(), (float)head.getMaxX(), (float)head.getMaxY(), ((GradientPaint)paint).getColor2()));
            } else if (paint instanceof Color) {
                g2.setPaint(new GradientPaint((float)head.getMinX(), (float)head.getMinY(), ((Color)paint).brighter(), (float)head.getMaxX(), (float)head.getMaxY(), ((Color)paint).darker()));
            } else {
                g2.setPaint(paint);
            }
            g2.fill(head);
            g2.setStroke(outlineStroke);
            g2.setPaint(outlinePaint);
            g2.draw(head);
            if (this.isTargetValueDrawn()) {
                if (paint instanceof GradientPaint) {
                    g2.setPaint(((GradientPaint)paint).getColor2());
                } else if (paint instanceof Color) {
                    g2.setPaint(((Color)paint).darker());
                } else {
                    g2.setPaint(paint);
                }
                g2.drawString(String.valueOf(value), (int)point.getX(), (int)point.getY());
            }
            if (entities == null) continue;
            String tip = null;
            if (this.tooltipGenerator != null) {
                tip = this.tooltipGenerator.generateToolTip(this.dataset, series, cat);
            }
            String url = null;
            if (this.urlGenerator != null) {
                url = this.urlGenerator.generateURL(this.dataset, series, cat);
            }
            Rectangle area = new Rectangle((int)(point.getX() - headW), (int)(point.getY() - headH), (int)(headW * 2.0), (int)(headH * 2.0));
            CategoryItemEntity entity = new CategoryItemEntity(area, tip, url, this.dataset, series, this.dataset.getColumnKey(cat), cat);
            entities.add(entity);
        }
        Paint paint = this.getSeriesPaint(series);
        g2.setPaint(paint);
        g2.setStroke(this.webOutlineStroke);
        g2.draw(polygon);
        if (this.webFilled) {
            g2.setComposite(AlphaComposite.getInstance(3, 0.3f));
            g2.fill(polygon);
            g2.setComposite(AlphaComposite.getInstance(3, this.getForegroundAlpha()));
        }
    }

    protected void drawWrongDataMessage(Graphics2D g2, Rectangle2D area) {
        Shape savedClip = g2.getClip();
        g2.clip(area);
        String message = this.wrongDataMessage;
        if (message != null) {
            JFreeChart.adjustForChineseDrawableFont(g2, this.wrongDataMessageFont);
            g2.setPaint(this.wrongDataMessagePaint);
            TextBlock block = TextUtilities.createTextBlock(this.wrongDataMessage, this.wrongDataMessageFont, this.wrongDataMessagePaint, 0.9f * (float)area.getWidth(), new G2TextMeasurer(g2));
            block.draw(g2, (float)area.getCenterX(), (float)area.getCenterY(), TextBlockAnchor.CENTER);
        }
        g2.setClip(savedClip);
    }

    protected Number getPlotValue(int series, int cat) {
        Number value = null;
        value = this.dataset.getValue(series, cat);
        return value;
    }

    @Override
    public String getPlotType() {
        return "Radar Plot";
    }
}

