/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.freechart.data.time.ohlc;

import com.kingdee.bos.ctrl.freechart.data.time.RegularTimePeriod;
import com.kingdee.bos.ctrl.freechart.data.time.TimePeriodAnchor;
import com.kingdee.bos.ctrl.freechart.data.time.ohlc.OHLCItem;
import com.kingdee.bos.ctrl.freechart.data.time.ohlc.OHLCSeries;
import com.kingdee.bos.ctrl.freechart.data.xy.AbstractXYDataset;
import com.kingdee.bos.ctrl.freechart.data.xy.OHLCDataset;
import com.kingdee.bos.ctrl.freechart.util.ObjectUtilities;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class OHLCSeriesCollection
extends AbstractXYDataset
implements OHLCDataset,
Serializable {
    private List data;
    private TimePeriodAnchor xPosition = TimePeriodAnchor.MIDDLE;

    public OHLCSeriesCollection() {
        this.data = new ArrayList();
    }

    public void addSeries(OHLCSeries series) {
        if (series == null) {
            throw new IllegalArgumentException("Null 'series' argument.");
        }
        this.data.add(series);
        series.addChangeListener(this);
        this.fireDatasetChanged();
    }

    @Override
    public int getSeriesCount() {
        return this.data.size();
    }

    public OHLCSeries getSeries(int series) {
        if (series < 0 || series >= this.getSeriesCount()) {
            throw new IllegalArgumentException("Series index out of bounds");
        }
        return (OHLCSeries)this.data.get(series);
    }

    @Override
    public Comparable getSeriesKey(int series) {
        return this.getSeries(series).getKey();
    }

    @Override
    public int getItemCount(int series) {
        return this.getSeries(series).getItemCount();
    }

    protected synchronized long getX(RegularTimePeriod period) {
        long result = 0L;
        if (this.xPosition == TimePeriodAnchor.START) {
            result = period.getFirstMillisecond();
        } else if (this.xPosition == TimePeriodAnchor.MIDDLE) {
            result = period.getMiddleMillisecond();
        } else if (this.xPosition == TimePeriodAnchor.END) {
            result = period.getLastMillisecond();
        }
        return result;
    }

    @Override
    public double getXValue(int series, int item) {
        OHLCSeries s = (OHLCSeries)this.data.get(series);
        OHLCItem di = (OHLCItem)s.getDataItem(item);
        RegularTimePeriod period = di.getPeriod();
        return this.getX(period);
    }

    @Override
    public Number getX(int series, int item) {
        return new Double(this.getXValue(series, item));
    }

    @Override
    public Number getY(int series, int item) {
        OHLCSeries s = (OHLCSeries)this.data.get(series);
        OHLCItem di = (OHLCItem)s.getDataItem(item);
        return new Double(di.getYValue());
    }

    @Override
    public double getOpenValue(int series, int item) {
        OHLCSeries s = (OHLCSeries)this.data.get(series);
        OHLCItem di = (OHLCItem)s.getDataItem(item);
        return di.getOpenValue();
    }

    @Override
    public Number getOpen(int series, int item) {
        return new Double(this.getOpenValue(series, item));
    }

    @Override
    public double getCloseValue(int series, int item) {
        OHLCSeries s = (OHLCSeries)this.data.get(series);
        OHLCItem di = (OHLCItem)s.getDataItem(item);
        return di.getCloseValue();
    }

    @Override
    public Number getClose(int series, int item) {
        return new Double(this.getCloseValue(series, item));
    }

    @Override
    public double getHighValue(int series, int item) {
        OHLCSeries s = (OHLCSeries)this.data.get(series);
        OHLCItem di = (OHLCItem)s.getDataItem(item);
        return di.getHighValue();
    }

    @Override
    public Number getHigh(int series, int item) {
        return new Double(this.getHighValue(series, item));
    }

    @Override
    public double getLowValue(int series, int item) {
        OHLCSeries s = (OHLCSeries)this.data.get(series);
        OHLCItem di = (OHLCItem)s.getDataItem(item);
        return di.getLowValue();
    }

    @Override
    public Number getLow(int series, int item) {
        return new Double(this.getLowValue(series, item));
    }

    @Override
    public Number getVolume(int series, int item) {
        return null;
    }

    @Override
    public double getVolumeValue(int series, int item) {
        return Double.NaN;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof OHLCSeriesCollection)) {
            return false;
        }
        OHLCSeriesCollection that = (OHLCSeriesCollection)obj;
        return ObjectUtilities.equal(this.data, that.data);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        OHLCSeriesCollection clone = (OHLCSeriesCollection)super.clone();
        clone.data = (List)ObjectUtilities.deepClone(this.data);
        return clone;
    }
}

