/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.jcr;

import com.kingdee.bos.ctrl.jcr.Explorer;
import com.kingdee.bos.ctrl.jcr.NamespaceUtil;
import com.kingdee.bos.ctrl.jcr.PathUtil;
import com.kingdee.bos.ctrl.jcr.SMResource;
import com.kingdee.bos.ctrl.jcr.exception.SMException;
import com.kingdee.bos.ctrl.jcr.exception.SMExistException;
import com.kingdee.bos.ctrl.jcr.exception.SMNameValidException;
import com.kingdee.bos.ctrl.jcr.exception.SMPathException;
import com.kingdee.bos.ctrl.jcr.exception.SMResourceTypeException;
import com.kingdee.bos.ctrl.jcr.search.SMSearchInfo;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.query.Query;
import javax.jcr.query.QueryResult;

public class SMFolder
extends SMResource {
    protected SMFolder(Explorer explorer, Node node) {
        super(explorer, node);
    }

    @Override
    public boolean isFile() {
        return false;
    }

    public boolean isChildExist(String path) throws SMException {
        if (!PathUtil.isRelativePath(path)) {
            throw new SMPathException(path + " must be relative. That means not start with /.");
        }
        if (!PathUtil.isPathValid(path)) {
            throw new SMPathException("Invalid path: " + path);
        }
        String tiedPath = PathUtil.tieNamespace(path);
        return this.innerIsExist(tiedPath);
    }

    public SMResource getChild(String path) throws SMException {
        Node targetNode;
        if (!this.isChildExist(path)) {
            throw new SMExistException(path + " not exist.");
        }
        String tiedPath = PathUtil.tieNamespace(path);
        try {
            targetNode = this.getNode().getNode(tiedPath);
        }
        catch (RepositoryException e) {
            throw SMException.makeException(e);
        }
        return this._explorer.wrapResource(targetNode);
    }

    public int getChildCount() throws SMException {
        ArrayList res = new ArrayList();
        NodeIterator it = null;
        try {
            it = this.getNode().getNodes();
        }
        catch (RepositoryException e) {
            throw SMException.makeException(e);
        }
        int counter = 0;
        while (it.hasNext()) {
            Node node = (Node)it.next();
            ++counter;
        }
        return counter;
    }

    public SMResource[] getChildren() throws SMException {
        ArrayList<SMResource> res = new ArrayList<SMResource>();
        NodeIterator it = null;
        try {
            it = this.getNode().getNodes();
        }
        catch (RepositoryException e) {
            throw SMException.makeException(e);
        }
        while (it.hasNext()) {
            Node node = (Node)it.next();
            res.add(this._explorer.wrapResource(node));
        }
        return res.toArray(new SMResource[0]);
    }

    public SMResource[] search(SMSearchInfo searchInfo) throws SMException {
        ArrayList<SMResource> result = new ArrayList<SMResource>();
        try {
            StringBuffer statement = new StringBuffer("/jcr:root");
            if (!this.isRoot()) {
                statement.append(this.getNode().getPath());
            }
            statement.append(searchInfo.toString());
            Query query = this._explorer.getSession().getWorkspace().getQueryManager().createQuery(statement.toString(), "xpath");
            QueryResult queryResult = query.execute();
            NodeIterator nodeIt = queryResult.getNodes();
            while (nodeIt.hasNext()) {
                Node node = nodeIt.nextNode();
                if (node.getDepth() == this.getNode().getDepth() || !node.getName().startsWith("ctrl:")) continue;
                result.add(this._explorer.wrapResource(node));
            }
        }
        catch (RepositoryException e) {
            throw SMException.makeException(e);
        }
        return result.toArray(new SMResource[0]);
    }

    public SMResource addChild(String path, int resType) throws SMException {
        if (!PathUtil.isRelativePath(path)) {
            throw new SMPathException(path + " must be relative. That means not start with /.");
        }
        if (!PathUtil.isPathValid(path)) {
            throw new SMPathException("Invalid path: " + path);
        }
        String[] names = PathUtil.splitPath(path);
        for (int i = 0; i < names.length; ++i) {
            if (PathUtil.isNameValid(names[i])) continue;
            throw new SMNameValidException(names[i]);
        }
        boolean isFile = SMFolder.isFile(resType);
        String tiedPath = PathUtil.tieNamespace(path);
        String[] parts = PathUtil.splitPath(tiedPath);
        StringBuffer sb = new StringBuffer();
        int c = parts.length - 1;
        for (int i = 0; i < c; ++i) {
            sb.append(parts[i]);
            String parentPath = sb.toString();
            if (!this.innerIsExist(parentPath)) {
                this.innerCreate(parentPath, false);
            }
            sb.append('/');
        }
        if (this.innerIsExist(tiedPath)) {
            throw new SMExistException("Child " + path + " has already existed.");
        }
        Node node = this.innerCreate(tiedPath, isFile);
        this._explorer.innerSave();
        return this._explorer.wrapResource(node, isFile);
    }

    private Node innerCreate(String tiedPath, boolean isFile) throws SMException {
        try {
            Node newNode = this.getNode().addNode(tiedPath);
            SMFolder.initProperties(newNode, isFile);
            return newNode;
        }
        catch (RepositoryException e) {
            throw SMException.makeException(e);
        }
    }

    private boolean innerIsExist(String tiedPath) throws SMException {
        try {
            return this.getNode().hasNode(tiedPath);
        }
        catch (RepositoryException e) {
            SMException.makeException(e);
            return false;
        }
    }

    static void initProperties(Node node, boolean isFile) throws SMException {
        try {
            Calendar currentTime = Calendar.getInstance();
            currentTime.setTime(new Date(System.currentTimeMillis()));
            node.setProperty(NamespaceUtil.Created, currentTime);
            node.setProperty(NamespaceUtil.LastModified, currentTime);
            if (isFile) {
                ByteArrayInputStream content = new ByteArrayInputStream(new byte[0]);
                node.setProperty(NamespaceUtil.Content, (InputStream)content);
            }
        }
        catch (RepositoryException e) {
            throw SMException.makeException(e);
        }
    }

    private static boolean isFile(int resType) throws SMResourceTypeException {
        if (resType == 1) {
            return false;
        }
        if (resType == 16) {
            return true;
        }
        throw new SMResourceTypeException("unknow resType");
    }

    public void removeAllChildren() throws SMException {
        NodeIterator nodeIt = null;
        try {
            nodeIt = this.getNode().getNodes("ctrl:*");
        }
        catch (RepositoryException e) {
            throw SMException.makeException(e);
        }
        while (nodeIt.hasNext()) {
            Node child = nodeIt.nextNode();
            SMFolder.innerDelete(child);
        }
        this._explorer.innerSave();
    }
}

