/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.lucene.index;

import com.kingdee.bos.ctrl.lucene.document.Document;
import com.kingdee.bos.ctrl.lucene.document.FieldSelector;
import com.kingdee.bos.ctrl.lucene.document.FieldSelectorResult;
import com.kingdee.bos.ctrl.lucene.document.Fieldable;
import com.kingdee.bos.ctrl.lucene.index.CorruptIndexException;
import com.kingdee.bos.ctrl.lucene.index.IndexReader;
import com.kingdee.bos.ctrl.lucene.index.Term;
import com.kingdee.bos.ctrl.lucene.index.TermDocs;
import com.kingdee.bos.ctrl.lucene.index.TermEnum;
import com.kingdee.bos.ctrl.lucene.index.TermFreqVector;
import com.kingdee.bos.ctrl.lucene.index.TermPositions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public class ParallelReader
extends IndexReader {
    private List readers = new ArrayList();
    private SortedMap fieldToReader = new TreeMap();
    private Map readerToFields = new HashMap();
    private List storedFieldReaders = new ArrayList();
    private int maxDoc;
    private int numDocs;
    private boolean hasDeletions;

    public ParallelReader() throws IOException {
        super(null);
    }

    public void add(IndexReader reader) throws IOException {
        this.ensureOpen();
        this.add(reader, false);
    }

    public void add(IndexReader reader, boolean ignoreStoredFields) throws IOException {
        this.ensureOpen();
        if (this.readers.size() == 0) {
            this.maxDoc = reader.maxDoc();
            this.numDocs = reader.numDocs();
            this.hasDeletions = reader.hasDeletions();
        }
        if (reader.maxDoc() != this.maxDoc) {
            throw new IllegalArgumentException("All readers must have same maxDoc: " + this.maxDoc + "!=" + reader.maxDoc());
        }
        if (reader.numDocs() != this.numDocs) {
            throw new IllegalArgumentException("All readers must have same numDocs: " + this.numDocs + "!=" + reader.numDocs());
        }
        Collection fields = reader.getFieldNames(IndexReader.FieldOption.ALL);
        this.readerToFields.put(reader, fields);
        for (String field : fields) {
            if (this.fieldToReader.get(field) != null) continue;
            this.fieldToReader.put(field, reader);
        }
        if (!ignoreStoredFields) {
            this.storedFieldReaders.add(reader);
        }
        this.readers.add(reader);
    }

    @Override
    public int numDocs() {
        return this.numDocs;
    }

    @Override
    public int maxDoc() {
        return this.maxDoc;
    }

    @Override
    public boolean hasDeletions() {
        return this.hasDeletions;
    }

    @Override
    public boolean isDeleted(int n) {
        if (this.readers.size() > 0) {
            return ((IndexReader)this.readers.get(0)).isDeleted(n);
        }
        return false;
    }

    @Override
    protected void doDelete(int n) throws CorruptIndexException, IOException {
        for (int i = 0; i < this.readers.size(); ++i) {
            ((IndexReader)this.readers.get(i)).deleteDocument(n);
        }
        this.hasDeletions = true;
    }

    @Override
    protected void doUndeleteAll() throws CorruptIndexException, IOException {
        for (int i = 0; i < this.readers.size(); ++i) {
            ((IndexReader)this.readers.get(i)).undeleteAll();
        }
        this.hasDeletions = false;
    }

    @Override
    public Document document(int n, FieldSelector fieldSelector) throws CorruptIndexException, IOException {
        this.ensureOpen();
        Document result = new Document();
        for (int i = 0; i < this.storedFieldReaders.size(); ++i) {
            boolean include;
            IndexReader reader = (IndexReader)this.storedFieldReaders.get(i);
            boolean bl = include = fieldSelector == null;
            if (!include) {
                Iterator it = ((Collection)this.readerToFields.get(reader)).iterator();
                while (it.hasNext()) {
                    if (fieldSelector.accept((String)it.next()) == FieldSelectorResult.NO_LOAD) continue;
                    include = true;
                    break;
                }
            }
            if (!include) continue;
            Iterator fieldIterator = reader.document(n, fieldSelector).getFields().iterator();
            while (fieldIterator.hasNext()) {
                result.add((Fieldable)fieldIterator.next());
            }
        }
        return result;
    }

    @Override
    public TermFreqVector[] getTermFreqVectors(int n) throws IOException {
        this.ensureOpen();
        ArrayList<TermFreqVector> results = new ArrayList<TermFreqVector>();
        for (Map.Entry e : this.fieldToReader.entrySet()) {
            String field = (String)e.getKey();
            IndexReader reader = (IndexReader)e.getValue();
            TermFreqVector vector = reader.getTermFreqVector(n, field);
            if (vector == null) continue;
            results.add(vector);
        }
        return results.toArray(new TermFreqVector[results.size()]);
    }

    @Override
    public TermFreqVector getTermFreqVector(int n, String field) throws IOException {
        this.ensureOpen();
        IndexReader reader = (IndexReader)this.fieldToReader.get(field);
        return reader == null ? null : reader.getTermFreqVector(n, field);
    }

    @Override
    public boolean hasNorms(String field) throws IOException {
        this.ensureOpen();
        IndexReader reader = (IndexReader)this.fieldToReader.get(field);
        return reader == null ? false : reader.hasNorms(field);
    }

    @Override
    public byte[] norms(String field) throws IOException {
        this.ensureOpen();
        IndexReader reader = (IndexReader)this.fieldToReader.get(field);
        return reader == null ? null : reader.norms(field);
    }

    @Override
    public void norms(String field, byte[] result, int offset) throws IOException {
        this.ensureOpen();
        IndexReader reader = (IndexReader)this.fieldToReader.get(field);
        if (reader != null) {
            reader.norms(field, result, offset);
        }
    }

    @Override
    protected void doSetNorm(int n, String field, byte value) throws CorruptIndexException, IOException {
        IndexReader reader = (IndexReader)this.fieldToReader.get(field);
        if (reader != null) {
            reader.doSetNorm(n, field, value);
        }
    }

    @Override
    public TermEnum terms() throws IOException {
        this.ensureOpen();
        return new ParallelTermEnum();
    }

    @Override
    public TermEnum terms(Term term) throws IOException {
        this.ensureOpen();
        return new ParallelTermEnum(term);
    }

    @Override
    public int docFreq(Term term) throws IOException {
        this.ensureOpen();
        IndexReader reader = (IndexReader)this.fieldToReader.get(term.field());
        return reader == null ? 0 : reader.docFreq(term);
    }

    @Override
    public TermDocs termDocs(Term term) throws IOException {
        this.ensureOpen();
        return new ParallelTermDocs(term);
    }

    @Override
    public TermDocs termDocs() throws IOException {
        this.ensureOpen();
        return new ParallelTermDocs();
    }

    @Override
    public TermPositions termPositions(Term term) throws IOException {
        this.ensureOpen();
        return new ParallelTermPositions(term);
    }

    @Override
    public TermPositions termPositions() throws IOException {
        this.ensureOpen();
        return new ParallelTermPositions();
    }

    @Override
    protected void doCommit() throws IOException {
        for (int i = 0; i < this.readers.size(); ++i) {
            ((IndexReader)this.readers.get(i)).commit();
        }
    }

    @Override
    protected synchronized void doClose() throws IOException {
        for (int i = 0; i < this.readers.size(); ++i) {
            ((IndexReader)this.readers.get(i)).close();
        }
    }

    @Override
    public Collection getFieldNames(IndexReader.FieldOption fieldNames) {
        this.ensureOpen();
        HashSet fieldSet = new HashSet();
        for (int i = 0; i < this.readers.size(); ++i) {
            IndexReader reader = (IndexReader)this.readers.get(i);
            Collection names = reader.getFieldNames(fieldNames);
            fieldSet.addAll(names);
        }
        return fieldSet;
    }

    private class ParallelTermPositions
    extends ParallelTermDocs
    implements TermPositions {
        public ParallelTermPositions() {
        }

        public ParallelTermPositions(Term term) throws IOException {
            this.seek(term);
        }

        @Override
        public void seek(Term term) throws IOException {
            IndexReader reader = (IndexReader)ParallelReader.this.fieldToReader.get(term.field());
            this.termDocs = reader != null ? reader.termPositions(term) : null;
        }

        @Override
        public int nextPosition() throws IOException {
            return ((TermPositions)this.termDocs).nextPosition();
        }

        @Override
        public int getPayloadLength() {
            return ((TermPositions)this.termDocs).getPayloadLength();
        }

        @Override
        public byte[] getPayload(byte[] data, int offset) throws IOException {
            return ((TermPositions)this.termDocs).getPayload(data, offset);
        }

        @Override
        public boolean isPayloadAvailable() {
            return ((TermPositions)this.termDocs).isPayloadAvailable();
        }
    }

    private class ParallelTermDocs
    implements TermDocs {
        protected TermDocs termDocs;

        public ParallelTermDocs() {
        }

        public ParallelTermDocs(Term term) throws IOException {
            this.seek(term);
        }

        @Override
        public int doc() {
            return this.termDocs.doc();
        }

        @Override
        public int freq() {
            return this.termDocs.freq();
        }

        @Override
        public void seek(Term term) throws IOException {
            IndexReader reader = (IndexReader)ParallelReader.this.fieldToReader.get(term.field());
            this.termDocs = reader != null ? reader.termDocs(term) : null;
        }

        @Override
        public void seek(TermEnum termEnum) throws IOException {
            this.seek(termEnum.term());
        }

        @Override
        public boolean next() throws IOException {
            if (this.termDocs == null) {
                return false;
            }
            return this.termDocs.next();
        }

        @Override
        public int read(int[] docs, int[] freqs) throws IOException {
            if (this.termDocs == null) {
                return 0;
            }
            return this.termDocs.read(docs, freqs);
        }

        @Override
        public boolean skipTo(int target) throws IOException {
            if (this.termDocs == null) {
                return false;
            }
            return this.termDocs.skipTo(target);
        }

        @Override
        public void close() throws IOException {
            if (this.termDocs != null) {
                this.termDocs.close();
            }
        }
    }

    private class ParallelTermEnum
    extends TermEnum {
        private String field;
        private Iterator fieldIterator;
        private TermEnum termEnum;

        public ParallelTermEnum() throws IOException {
            this.field = (String)ParallelReader.this.fieldToReader.firstKey();
            if (this.field != null) {
                this.termEnum = ((IndexReader)ParallelReader.this.fieldToReader.get(this.field)).terms();
            }
        }

        public ParallelTermEnum(Term term) throws IOException {
            this.field = term.field();
            IndexReader reader = (IndexReader)ParallelReader.this.fieldToReader.get(this.field);
            if (reader != null) {
                this.termEnum = reader.terms(term);
            }
        }

        @Override
        public boolean next() throws IOException {
            if (this.termEnum == null) {
                return false;
            }
            if (this.termEnum.next() && this.termEnum.term().field() == this.field) {
                return true;
            }
            this.termEnum.close();
            if (this.fieldIterator == null) {
                this.fieldIterator = ParallelReader.this.fieldToReader.tailMap(this.field).keySet().iterator();
                this.fieldIterator.next();
            }
            while (this.fieldIterator.hasNext()) {
                this.field = (String)this.fieldIterator.next();
                this.termEnum = ((IndexReader)ParallelReader.this.fieldToReader.get(this.field)).terms(new Term(this.field, ""));
                Term term = this.termEnum.term();
                if (term != null && term.field() == this.field) {
                    return true;
                }
                this.termEnum.close();
            }
            return false;
        }

        @Override
        public Term term() {
            if (this.termEnum == null) {
                return null;
            }
            return this.termEnum.term();
        }

        @Override
        public int docFreq() {
            if (this.termEnum == null) {
                return 0;
            }
            return this.termEnum.docFreq();
        }

        @Override
        public void close() throws IOException {
            if (this.termEnum != null) {
                this.termEnum.close();
            }
        }
    }
}

