/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.lucene.search;

import com.kingdee.bos.ctrl.lucene.index.IndexReader;
import com.kingdee.bos.ctrl.lucene.index.Term;
import com.kingdee.bos.ctrl.lucene.search.FilteredTermEnum;
import java.io.IOException;

public final class FuzzyTermEnum
extends FilteredTermEnum {
    private static final int TYPICAL_LONGEST_WORD_IN_INDEX = 19;
    private int[][] d;
    private float similarity;
    private boolean endEnum = false;
    private Term searchTerm = null;
    private final String field;
    private final String text;
    private final String prefix;
    private final float minimumSimilarity;
    private final float scale_factor;
    private final int[] maxDistances = new int[19];

    public FuzzyTermEnum(IndexReader reader, Term term) throws IOException {
        this(reader, term, 0.5f, 0);
    }

    public FuzzyTermEnum(IndexReader reader, Term term, float minSimilarity) throws IOException {
        this(reader, term, minSimilarity, 0);
    }

    public FuzzyTermEnum(IndexReader reader, Term term, float minSimilarity, int prefixLength) throws IOException {
        if (minSimilarity >= 1.0f) {
            throw new IllegalArgumentException("minimumSimilarity cannot be greater than or equal to 1");
        }
        if (minSimilarity < 0.0f) {
            throw new IllegalArgumentException("minimumSimilarity cannot be less than 0");
        }
        if (prefixLength < 0) {
            throw new IllegalArgumentException("prefixLength cannot be less than 0");
        }
        this.minimumSimilarity = minSimilarity;
        this.scale_factor = 1.0f / (1.0f - this.minimumSimilarity);
        this.searchTerm = term;
        this.field = this.searchTerm.field();
        int fullSearchTermLength = this.searchTerm.text().length();
        int realPrefixLength = prefixLength > fullSearchTermLength ? fullSearchTermLength : prefixLength;
        this.text = this.searchTerm.text().substring(realPrefixLength);
        this.prefix = this.searchTerm.text().substring(0, realPrefixLength);
        this.initializeMaxDistances();
        this.d = this.initDistanceArray();
        this.setEnum(reader.terms(new Term(this.searchTerm.field(), this.prefix)));
    }

    @Override
    protected final boolean termCompare(Term term) {
        if (this.field == term.field() && term.text().startsWith(this.prefix)) {
            String target = term.text().substring(this.prefix.length());
            this.similarity = this.similarity(target);
            return this.similarity > this.minimumSimilarity;
        }
        this.endEnum = true;
        return false;
    }

    @Override
    public final float difference() {
        return (this.similarity - this.minimumSimilarity) * this.scale_factor;
    }

    @Override
    public final boolean endEnum() {
        return this.endEnum;
    }

    private static final int min(int a, int b, int c) {
        int t = a < b ? a : b;
        return t < c ? t : c;
    }

    private final int[][] initDistanceArray() {
        return new int[this.text.length() + 1][19];
    }

    private final synchronized float similarity(String target) {
        int i;
        int m = target.length();
        int n = this.text.length();
        if (n == 0) {
            return this.prefix.length() == 0 ? 0.0f : 1.0f - (float)m / (float)this.prefix.length();
        }
        if (m == 0) {
            return this.prefix.length() == 0 ? 0.0f : 1.0f - (float)n / (float)this.prefix.length();
        }
        int maxDistance = this.getMaxDistance(m);
        if (maxDistance < Math.abs(m - n)) {
            return 0.0f;
        }
        if (this.d[0].length <= m) {
            this.growDistanceArray(m);
        }
        for (i = 0; i <= n; ++i) {
            this.d[i][0] = i;
        }
        for (int j = 0; j <= m; ++j) {
            this.d[0][j] = j;
        }
        for (i = 1; i <= n; ++i) {
            int bestPossibleEditDistance = m;
            char s_i = this.text.charAt(i - 1);
            for (int j = 1; j <= m; ++j) {
                this.d[i][j] = s_i != target.charAt(j - 1) ? FuzzyTermEnum.min(this.d[i - 1][j], this.d[i][j - 1], this.d[i - 1][j - 1]) + 1 : FuzzyTermEnum.min(this.d[i - 1][j] + 1, this.d[i][j - 1] + 1, this.d[i - 1][j - 1]);
                bestPossibleEditDistance = Math.min(bestPossibleEditDistance, this.d[i][j]);
            }
            if (i <= maxDistance || bestPossibleEditDistance <= maxDistance) continue;
            return 0.0f;
        }
        return 1.0f - (float)this.d[n][m] / (float)(this.prefix.length() + Math.min(n, m));
    }

    private void growDistanceArray(int m) {
        for (int i = 0; i < this.d.length; ++i) {
            this.d[i] = new int[m + 1];
        }
    }

    private final int getMaxDistance(int m) {
        return m < this.maxDistances.length ? this.maxDistances[m] : this.calculateMaxDistance(m);
    }

    private void initializeMaxDistances() {
        for (int i = 0; i < this.maxDistances.length; ++i) {
            this.maxDistances[i] = this.calculateMaxDistance(i);
        }
    }

    private int calculateMaxDistance(int m) {
        return (int)((1.0f - this.minimumSimilarity) * (float)(Math.min(this.text.length(), m) + this.prefix.length()));
    }

    @Override
    public void close() throws IOException {
        super.close();
    }
}

