/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.lucene.search;

import com.kingdee.bos.ctrl.lucene.index.Term;
import com.kingdee.bos.ctrl.lucene.search.FieldDocSortedHitQueue;
import com.kingdee.bos.ctrl.lucene.search.Filter;
import com.kingdee.bos.ctrl.lucene.search.HitCollector;
import com.kingdee.bos.ctrl.lucene.search.HitQueue;
import com.kingdee.bos.ctrl.lucene.search.MultiSearcher;
import com.kingdee.bos.ctrl.lucene.search.MultiSearcherThread;
import com.kingdee.bos.ctrl.lucene.search.Query;
import com.kingdee.bos.ctrl.lucene.search.ScoreDoc;
import com.kingdee.bos.ctrl.lucene.search.Searchable;
import com.kingdee.bos.ctrl.lucene.search.Sort;
import com.kingdee.bos.ctrl.lucene.search.TopDocs;
import com.kingdee.bos.ctrl.lucene.search.TopFieldDocs;
import com.kingdee.bos.ctrl.lucene.search.Weight;
import java.io.IOException;

public class ParallelMultiSearcher
extends MultiSearcher {
    private Searchable[] searchables;
    private int[] starts;

    public ParallelMultiSearcher(Searchable[] searchables) throws IOException {
        super(searchables);
        this.searchables = searchables;
        this.starts = this.getStarts();
    }

    @Override
    public int docFreq(Term term) throws IOException {
        return super.docFreq(term);
    }

    @Override
    public TopDocs search(Weight weight, Filter filter, int nDocs) throws IOException {
        int i;
        HitQueue hq = new HitQueue(nDocs);
        int totalHits = 0;
        MultiSearcherThread[] msta = new MultiSearcherThread[this.searchables.length];
        for (i = 0; i < this.searchables.length; ++i) {
            msta[i] = new MultiSearcherThread(this.searchables[i], weight, filter, nDocs, hq, i, this.starts, "MultiSearcher thread #" + (i + 1));
            msta[i].start();
        }
        for (i = 0; i < this.searchables.length; ++i) {
            try {
                msta[i].join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            IOException ioe = msta[i].getIOException();
            if (ioe == null) {
                totalHits += msta[i].hits();
                continue;
            }
            throw ioe;
        }
        ScoreDoc[] scoreDocs = new ScoreDoc[hq.size()];
        for (int i2 = hq.size() - 1; i2 >= 0; --i2) {
            scoreDocs[i2] = (ScoreDoc)hq.pop();
        }
        float maxScore = totalHits == 0 ? Float.NEGATIVE_INFINITY : scoreDocs[0].score;
        return new TopDocs(totalHits, scoreDocs, maxScore);
    }

    @Override
    public TopFieldDocs search(Weight weight, Filter filter, int nDocs, Sort sort) throws IOException {
        FieldDocSortedHitQueue hq = new FieldDocSortedHitQueue(null, nDocs);
        int totalHits = 0;
        MultiSearcherThread[] msta = new MultiSearcherThread[this.searchables.length];
        for (int i = 0; i < this.searchables.length; ++i) {
            msta[i] = new MultiSearcherThread(this.searchables[i], weight, filter, nDocs, hq, sort, i, this.starts, "MultiSearcher thread #" + (i + 1));
            msta[i].start();
        }
        float maxScore = Float.NEGATIVE_INFINITY;
        for (int i = 0; i < this.searchables.length; ++i) {
            try {
                msta[i].join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            IOException ioe = msta[i].getIOException();
            if (ioe == null) {
                totalHits += msta[i].hits();
            } else {
                throw ioe;
            }
            maxScore = Math.max(maxScore, msta[i].getMaxScore());
        }
        ScoreDoc[] scoreDocs = new ScoreDoc[hq.size()];
        for (int i = hq.size() - 1; i >= 0; --i) {
            scoreDocs[i] = (ScoreDoc)hq.pop();
        }
        return new TopFieldDocs(totalHits, scoreDocs, hq.getFields(), maxScore);
    }

    @Override
    public void search(Weight weight, Filter filter, final HitCollector results) throws IOException {
        for (int i = 0; i < this.searchables.length; ++i) {
            final int start = this.starts[i];
            this.searchables[i].search(weight, filter, new HitCollector(){

                @Override
                public void collect(int doc, float score) {
                    results.collect(doc + start, score);
                }
            });
        }
    }

    @Override
    public Query rewrite(Query original) throws IOException {
        return super.rewrite(original);
    }
}

