/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.lucene.search;

import com.kingdee.bos.ctrl.lucene.index.IndexReader;
import com.kingdee.bos.ctrl.lucene.index.Term;
import com.kingdee.bos.ctrl.lucene.index.TermDocs;
import com.kingdee.bos.ctrl.lucene.index.TermEnum;
import com.kingdee.bos.ctrl.lucene.search.IdGenerator;
import java.io.IOException;

abstract class PrefixGenerator
implements IdGenerator {
    protected final Term prefix;

    PrefixGenerator(Term prefix) {
        this.prefix = prefix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void generate(IndexReader reader) throws IOException {
        TermEnum enumerator = reader.terms(this.prefix);
        TermDocs termDocs = reader.termDocs();
        try {
            Term term;
            String prefixText = this.prefix.text();
            String prefixField = this.prefix.field();
            while ((term = enumerator.term()) != null && term.text().startsWith(prefixText) && term.field() == prefixField) {
                termDocs.seek(term);
                while (termDocs.next()) {
                    this.handleDoc(termDocs.doc());
                }
                if (enumerator.next()) continue;
                break;
            }
        }
        finally {
            termDocs.close();
            enumerator.close();
        }
    }
}

