/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.lucene.store;

import com.kingdee.bos.ctrl.lucene.store.IndexInput;
import com.kingdee.bos.ctrl.lucene.store.RAMFile;
import java.io.IOException;

class RAMInputStream
extends IndexInput
implements Cloneable {
    static final int BUFFER_SIZE = 1024;
    private RAMFile file;
    private long length;
    private byte[] currentBuffer;
    private int currentBufferIndex;
    private int bufferPosition;
    private long bufferStart;
    private int bufferLength;

    public RAMInputStream(RAMFile f) {
        this.file = f;
        this.length = this.file.length;
        this.currentBufferIndex = -1;
        this.currentBuffer = null;
    }

    @Override
    public void close() {
    }

    @Override
    public long length() {
        return this.length;
    }

    @Override
    public byte readByte() throws IOException {
        if (this.bufferPosition >= this.bufferLength) {
            ++this.currentBufferIndex;
            this.switchCurrentBuffer();
        }
        return this.currentBuffer[this.bufferPosition++];
    }

    @Override
    public void readBytes(byte[] b, int offset, int len) throws IOException {
        while (len > 0) {
            int remainInBuffer;
            if (this.bufferPosition >= this.bufferLength) {
                ++this.currentBufferIndex;
                this.switchCurrentBuffer();
            }
            int bytesToCopy = len < (remainInBuffer = this.bufferLength - this.bufferPosition) ? len : remainInBuffer;
            System.arraycopy(this.currentBuffer, this.bufferPosition, b, offset, bytesToCopy);
            offset += bytesToCopy;
            len -= bytesToCopy;
            this.bufferPosition += bytesToCopy;
        }
    }

    private final void switchCurrentBuffer() throws IOException {
        if (this.currentBufferIndex >= this.file.buffers.size()) {
            throw new IOException("Read past EOF");
        }
        this.currentBuffer = (byte[])this.file.buffers.get(this.currentBufferIndex);
        this.bufferPosition = 0;
        this.bufferStart = 1024 * this.currentBufferIndex;
        this.bufferLength = (int)(this.length - this.bufferStart);
        if (this.bufferLength > 1024) {
            this.bufferLength = 1024;
        }
    }

    @Override
    public long getFilePointer() {
        return this.currentBufferIndex < 0 ? 0L : this.bufferStart + (long)this.bufferPosition;
    }

    @Override
    public void seek(long pos) throws IOException {
        long bufferStart = this.currentBufferIndex * 1024;
        if (pos < bufferStart || pos >= bufferStart + 1024L) {
            this.currentBufferIndex = (int)(pos / 1024L);
            this.switchCurrentBuffer();
        }
        this.bufferPosition = (int)(pos % 1024L);
    }
}

