/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core;

import com.kingdee.bos.ctrl.common.util.CommonSLF4JLogger;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.jcr.ItemNotFoundException;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import org.apache.commons.collections.map.ReferenceMap;
import org.apache.jackrabbit.core.HierarchyManagerImpl;
import org.apache.jackrabbit.core.ItemId;
import org.apache.jackrabbit.core.NodeId;
import org.apache.jackrabbit.core.PropertyId;
import org.apache.jackrabbit.core.state.ItemState;
import org.apache.jackrabbit.core.state.ItemStateException;
import org.apache.jackrabbit.core.state.ItemStateManager;
import org.apache.jackrabbit.core.state.NodeState;
import org.apache.jackrabbit.core.state.NodeStateListener;
import org.apache.jackrabbit.core.util.Dumpable;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.commons.conversion.MalformedPathException;
import org.apache.jackrabbit.spi.commons.conversion.PathResolver;
import org.apache.jackrabbit.spi.commons.name.PathBuilder;
import org.apache.jackrabbit.spi.commons.name.PathFactoryImpl;
import org.apache.jackrabbit.spi.commons.name.PathMap;
import org.slf4j.Logger;

public class CachingHierarchyManager
extends HierarchyManagerImpl
implements NodeStateListener,
Dumpable {
    public static final int DEFAULT_UPPER_LIMIT = 10000;
    private static Logger log = CommonSLF4JLogger.getLogger(CachingHierarchyManager.class);
    private final PathMap pathCache = new PathMap();
    private final ReferenceMap idCache = new ReferenceMap(0, 0);
    private final Set movedIds = new HashSet();
    private final Object cacheMonitor = new Object();
    private final int upperLimit;
    private LRUEntry head;
    private LRUEntry tail;

    public CachingHierarchyManager(NodeId rootNodeId, ItemStateManager provider, PathResolver resolver) {
        super(rootNodeId, provider, resolver);
        this.upperLimit = 10000;
    }

    @Override
    protected void beforeResolvePath(Path path, ItemState state, int next) {
        if (state.isNode() && !this.isCached(state.getId())) {
            try {
                PathBuilder builder = new PathBuilder();
                Path.Element[] elements = path.getElements();
                for (int i = 0; i < next; ++i) {
                    builder.addLast(elements[i]);
                }
                Path parentPath = builder.getPath();
                this.cache(((NodeState)state).getNodeId(), parentPath);
            }
            catch (MalformedPathException mpe) {
                log.warn("Failed to build path of " + state.getId(), (Throwable)((Object)mpe));
            }
        }
    }

    @Override
    protected void buildPath(PathBuilder builder, ItemState state) throws ItemStateException, RepositoryException {
        PathMap.Element element;
        if (state.isNode() && (element = this.get(state.getId())) != null) {
            try {
                Path.Element[] elements = element.getPath().getElements();
                for (int i = elements.length - 1; i >= 0; --i) {
                    builder.addFirst(elements[i]);
                }
                return;
            }
            catch (MalformedPathException mpe) {
                String msg = "Failed to build path of " + state.getId();
                log.debug(msg);
                throw new RepositoryException(msg, (Throwable)((Object)mpe));
            }
        }
        super.buildPath(builder, state);
        if (state.isNode()) {
            try {
                this.cache(((NodeState)state).getNodeId(), builder.getPath());
            }
            catch (MalformedPathException mpe) {
                log.warn("Failed to build path of " + state.getId());
            }
        }
    }

    @Override
    public ItemId resolvePath(Path path) throws RepositoryException {
        ItemId id;
        if (path.denotesRoot()) {
            return this.rootNodeId;
        }
        if (!path.isCanonical()) {
            String msg = "path is not canonical";
            log.debug(msg);
            throw new RepositoryException(msg);
        }
        PathMap.Element element = this.map(path);
        if (element == null) {
            id = super.resolvePath(path);
        } else {
            LRUEntry entry = (LRUEntry)element.get();
            if (element.hasPath(path)) {
                entry.touch();
                return entry.getId();
            }
            id = super.resolvePath(path, entry.getId(), element.getDepth() + 1, true);
            if (id == null) {
                id = super.resolvePath(path, entry.getId(), element.getDepth() + 1, false);
            }
        }
        if (id != null && id.denotesNode() && !this.isCached(id)) {
            this.cache((NodeId)id, path);
        }
        return id;
    }

    @Override
    public NodeId resolveNodePath(Path path) throws RepositoryException {
        ItemId id = this.resolvePath(path);
        return id != null && id.denotesNode() ? (NodeId)id : null;
    }

    @Override
    public PropertyId resolvePropertyPath(Path path) throws RepositoryException {
        if (path.denotesRoot()) {
            return null;
        }
        if (!path.isCanonical()) {
            String msg = "path is not canonical";
            log.debug(msg);
            throw new RepositoryException(msg);
        }
        PathMap.Element element = this.map(path.getAncestor(1));
        if (element == null) {
            return super.resolvePropertyPath(path);
        }
        LRUEntry entry = (LRUEntry)element.get();
        return (PropertyId)super.resolvePath(path, entry.getId(), element.getDepth() + 1, false);
    }

    @Override
    public Path getPath(ItemId id) throws ItemNotFoundException, RepositoryException {
        PathMap.Element element;
        if (id.denotesNode() && (element = this.get(id)) != null) {
            try {
                return element.getPath();
            }
            catch (MalformedPathException mpe) {
                String msg = "Failed to build path of " + id;
                log.debug(msg);
                throw new RepositoryException(msg, (Throwable)((Object)mpe));
            }
        }
        return super.getPath(id);
    }

    @Override
    public Name getName(ItemId id) throws ItemNotFoundException, RepositoryException {
        PathMap.Element element;
        if (id.denotesNode() && (element = this.get(id)) != null) {
            return element.getName();
        }
        return super.getName(id);
    }

    @Override
    public int getDepth(ItemId id) throws ItemNotFoundException, RepositoryException {
        PathMap.Element element;
        if (id.denotesNode() && (element = this.get(id)) != null) {
            return element.getDepth();
        }
        return super.getDepth(id);
    }

    @Override
    public boolean isAncestor(NodeId nodeId, ItemId itemId) throws ItemNotFoundException, RepositoryException {
        PathMap.Element child;
        PathMap.Element element;
        if (itemId.denotesNode() && (element = this.get(nodeId)) != null && (child = this.get(itemId)) != null) {
            return element.isAncestorOf(child);
        }
        return super.isAncestor(nodeId, itemId);
    }

    @Override
    public void stateCreated(ItemState created) {
    }

    @Override
    public void stateModified(ItemState modified) {
        if (modified.isNode()) {
            this.nodeModified((NodeState)modified);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void nodeModified(NodeState modified) {
        Object object = this.cacheMonitor;
        synchronized (object) {
            LRUEntry entry = (LRUEntry)this.idCache.get((Object)modified.getNodeId());
            if (entry == null) {
                return;
            }
            PathMap.Element element = entry.getElement();
            Iterator iter = element.getChildren();
            while (iter.hasNext()) {
                PathMap.Element child = (PathMap.Element)iter.next();
                NodeState.ChildNodeEntry cne = modified.getChildNodeEntry(child.getName(), child.getNormalizedIndex());
                if (cne == null) {
                    child.remove();
                    this.remove(child);
                    return;
                }
                LRUEntry childEntry = (LRUEntry)child.get();
                if (childEntry == null || cne.getId().equals(childEntry.getId())) continue;
                child.remove();
                this.remove(child);
            }
        }
    }

    @Override
    public void stateDestroyed(ItemState destroyed) {
        this.remove(destroyed.getId());
    }

    @Override
    public void stateDiscarded(ItemState discarded) {
        if (discarded.isTransient() && !discarded.hasOverlayedState() && discarded.getStatus() == 4) {
            this.remove(discarded.getId());
        } else if (this.provider.hasItemState(discarded.getId())) {
            this.evict(discarded.getId());
        } else {
            this.remove(discarded.getId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void nodeAdded(NodeState state, Name name, int index, NodeId id) {
        Object object = this.cacheMonitor;
        synchronized (object) {
            if (this.idCache.containsKey((Object)state.getNodeId())) {
                try {
                    Path path = PathFactoryImpl.getInstance().create(this.getPath(state.getNodeId()), name, index, true);
                    this.insert(path, id);
                }
                catch (PathNotFoundException e) {
                    log.warn("Unable to get path of node " + state.getNodeId() + ", event ignored.");
                }
                catch (MalformedPathException e) {
                    log.warn("Unable to create path of " + id, (Throwable)((Object)e));
                }
                catch (ItemNotFoundException e) {
                    log.warn("Unable to find item " + state.getNodeId(), (Throwable)e);
                }
                catch (RepositoryException e) {
                    log.warn("Unable to get path of " + state.getNodeId(), (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void nodesReplaced(NodeState state) {
        Object object = this.cacheMonitor;
        synchronized (object) {
            LRUEntry entry = (LRUEntry)this.idCache.get((Object)state.getNodeId());
            if (entry != null) {
                PathMap.Element parent = entry.getElement();
                HashMap<Path.Element, PathMap.Element> newChildrenOrder = new HashMap<Path.Element, PathMap.Element>();
                boolean orderChanged = false;
                Iterator iter = parent.getChildren();
                while (iter.hasNext()) {
                    PathMap.Element child = (PathMap.Element)iter.next();
                    LRUEntry childEntry = (LRUEntry)child.get();
                    if (childEntry == null) {
                        child.remove(false);
                        this.remove(child);
                        continue;
                    }
                    NodeId childId = childEntry.getId();
                    NodeState.ChildNodeEntry cne = state.getChildNodeEntry(childId);
                    if (cne == null) {
                        child.remove(false);
                        this.remove(child);
                        continue;
                    }
                    Path.Element newNameIndex = PathFactoryImpl.getInstance().createElement(cne.getName(), cne.getIndex());
                    newChildrenOrder.put(newNameIndex, child);
                    if (newNameIndex.equals(child.getPathElement())) continue;
                    orderChanged = true;
                }
                if (orderChanged) {
                    parent.setChildren(newChildrenOrder);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void nodeRemoved(NodeState state, Name name, int index, NodeId id) {
        Object object = this.cacheMonitor;
        synchronized (object) {
            if (this.idCache.containsKey((Object)state.getNodeId())) {
                try {
                    Path path = PathFactoryImpl.getInstance().create(this.getPath(state.getNodeId()), name, index, true);
                    this.remove(path, id);
                }
                catch (PathNotFoundException e) {
                    log.warn("Unable to get path of node " + state.getNodeId() + ", event ignored.");
                }
                catch (MalformedPathException e) {
                    log.warn("Unable to create path of " + id, (Throwable)((Object)e));
                }
                catch (ItemNotFoundException e) {
                    log.warn("Unable to get path of " + state.getNodeId(), (Throwable)e);
                }
                catch (RepositoryException e) {
                    log.warn("Unable to get path of " + state.getNodeId(), (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PathMap.Element get(ItemId id) {
        Object object = this.cacheMonitor;
        synchronized (object) {
            LRUEntry entry = (LRUEntry)this.idCache.get((Object)id);
            if (entry != null) {
                entry.touch();
                return entry.getElement();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PathMap.Element map(Path path) {
        Object object = this.cacheMonitor;
        synchronized (object) {
            for (PathMap.Element element = this.pathCache.map(path, false); element != null; element = element.getParent()) {
                LRUEntry entry = (LRUEntry)element.get();
                if (entry == null) continue;
                entry.touch();
                return element;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cache(NodeId id, Path path) {
        Object object = this.cacheMonitor;
        synchronized (object) {
            PathMap.Element element;
            if (this.idCache.get((Object)id) != null) {
                return;
            }
            if (this.idCache.size() >= this.upperLimit) {
                for (LRUEntry entry = this.head; entry != null; entry = entry.getNext()) {
                    PathMap.Element element2 = entry.getElement();
                    if (element2.getChildrenCount() != 0) continue;
                    this.evict(entry, true);
                    return;
                }
            }
            if ((element = this.pathCache.put(path)).get() != null && !id.equals(((LRUEntry)element.get()).getId())) {
                log.warn("overwriting PathMap.Element");
            }
            LRUEntry entry = new LRUEntry(id, element);
            element.set(entry);
            this.idCache.put((Object)id, (Object)entry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isCached(ItemId id) {
        Object object = this.cacheMonitor;
        synchronized (object) {
            return this.idCache.get((Object)id) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void remove(ItemId id) {
        Object object = this.cacheMonitor;
        synchronized (object) {
            LRUEntry entry = (LRUEntry)this.idCache.get((Object)id);
            if (entry != null) {
                this.remove(entry, true);
            }
        }
    }

    private void remove(LRUEntry entry, boolean removeFromPathCache) {
        if (removeFromPathCache) {
            PathMap.Element element = entry.getElement();
            this.remove(element);
            element.remove();
        } else {
            this.idCache.remove((Object)entry.getId());
            entry.remove();
        }
    }

    private void evict(LRUEntry entry, boolean removeFromPathCache) {
        if (removeFromPathCache) {
            PathMap.Element element = entry.getElement();
            element.traverse(new PathMap.ElementVisitor(){

                @Override
                public void elementVisited(PathMap.Element element) {
                    CachingHierarchyManager.this.evict((LRUEntry)element.get(), false);
                }
            }, false);
            element.remove(false);
        } else {
            this.idCache.remove((Object)entry.getId());
            entry.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void evict(ItemId id) {
        Object object = this.cacheMonitor;
        synchronized (object) {
            LRUEntry entry = (LRUEntry)this.idCache.get((Object)id);
            if (entry != null) {
                this.evict(entry, true);
            }
        }
    }

    private void remove(PathMap.Element element) {
        element.traverse(new PathMap.ElementVisitor(){

            @Override
            public void elementVisited(PathMap.Element element) {
                CachingHierarchyManager.this.remove((LRUEntry)element.get(), false);
            }
        }, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insert(Path path, ItemId id) throws PathNotFoundException {
        Object object = this.cacheMonitor;
        synchronized (object) {
            PathMap.Element parent;
            PathMap.Element element = null;
            LRUEntry entry = (LRUEntry)this.idCache.get((Object)id);
            if (entry != null) {
                element = entry.getElement();
                element.remove();
            }
            if ((parent = this.pathCache.map(path.getAncestor(1), true)) != null) {
                parent.insert(path.getNameElement());
            }
            if (element != null) {
                this.pathCache.put(path, element);
                this.movedIds.add(id);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void remove(Path path, ItemId id) throws PathNotFoundException {
        Object object = this.cacheMonitor;
        synchronized (object) {
            PathMap.Element element;
            if (this.movedIds.remove(id)) {
                return;
            }
            PathMap.Element parent = this.pathCache.map(path.getAncestor(1), true);
            if (parent != null && (element = parent.remove(path.getNameElement())) != null) {
                this.remove(element);
            }
        }
    }

    @Override
    public void dump(final PrintStream ps) {
        this.pathCache.traverse(new PathMap.ElementVisitor(){

            @Override
            public void elementVisited(PathMap.Element element) {
                StringBuffer line = new StringBuffer();
                for (int i = 0; i < element.getDepth(); ++i) {
                    line.append("--");
                }
                line.append(element.getName());
                int index = element.getIndex();
                if (index != 0 && index != 1) {
                    line.append('[');
                    line.append(index);
                    line.append(']');
                }
                line.append("  ");
                line.append(element.get());
                ps.println(line.toString());
            }
        }, true);
    }

    private class LRUEntry {
        private LRUEntry previous;
        private LRUEntry next;
        private final NodeId id;
        private final PathMap.Element element;

        public LRUEntry(NodeId id, PathMap.Element element) {
            this.id = id;
            this.element = element;
            this.append();
        }

        public void append() {
            if (CachingHierarchyManager.this.tail == null) {
                CachingHierarchyManager.this.head = this;
                CachingHierarchyManager.this.tail = this;
            } else {
                this.previous = CachingHierarchyManager.this.tail;
                ((CachingHierarchyManager)CachingHierarchyManager.this).tail.next = this;
                CachingHierarchyManager.this.tail = this;
            }
        }

        public void remove() {
            try {
                if (this.previous != null) {
                    this.previous.next = this.next;
                }
                if (this.next != null) {
                    this.next.previous = this.previous;
                }
            }
            catch (Throwable e) {
                return;
            }
            if (CachingHierarchyManager.this.head == this) {
                CachingHierarchyManager.this.head = this.next;
            }
            if (CachingHierarchyManager.this.tail == this) {
                CachingHierarchyManager.this.tail = this.previous;
            }
            this.previous = null;
            this.next = null;
        }

        public void touch() {
            this.remove();
            this.append();
        }

        public LRUEntry getPrevious() {
            return this.previous;
        }

        public LRUEntry getNext() {
            return this.next;
        }

        public NodeId getId() {
            return this.id;
        }

        public PathMap.Element getElement() {
            return this.element;
        }

        public String toString() {
            return this.id.toString();
        }
    }
}

