/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.journal;

import com.kingdee.bos.ctrl.common.util.CommonSLF4JLogger;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.apache.jackrabbit.core.journal.JournalException;
import org.slf4j.Logger;

public class FileRevision {
    private static final Logger log = CommonSLF4JLogger.getLogger(FileRevision.class);
    private final RandomAccessFile raf;
    private long value;

    public FileRevision(File file) throws JournalException {
        try {
            if (!file.exists()) {
                file.createNewFile();
            }
            this.raf = new RandomAccessFile(file, "rw");
            if (this.raf.length() == 0L) {
                this.set(0L);
            }
        }
        catch (IOException e) {
            String msg = "I/O error while attempting to create new file '" + file + "'.";
            throw new JournalException(msg, e);
        }
    }

    public synchronized long get() throws JournalException {
        try {
            this.raf.seek(0L);
            this.value = this.raf.readLong();
            return this.value;
        }
        catch (IOException e) {
            throw new JournalException("I/O error occurred.", e);
        }
    }

    public synchronized void set(long value) throws JournalException {
        try {
            this.raf.seek(0L);
            this.raf.writeLong(value);
            this.raf.getFD().sync();
            this.value = value;
        }
        catch (IOException e) {
            throw new JournalException("I/O error occurred.", e);
        }
    }
}

