/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.nodetype;

import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.ConstraintViolationException;
import org.apache.jackrabbit.core.nodetype.InvalidConstraintException;
import org.apache.jackrabbit.core.nodetype.ValueConstraint;
import org.apache.jackrabbit.core.value.InternalValue;

class BooleanConstraint
extends ValueConstraint {
    final boolean reqBool;

    BooleanConstraint(String definition) throws InvalidConstraintException {
        super(definition);
        if (definition.equals("true")) {
            this.reqBool = true;
        } else if (definition.equals("false")) {
            this.reqBool = false;
        } else {
            String msg = "'" + definition + "' is not a valid value constraint format for BOOLEAN values";
            log.debug(msg);
            throw new InvalidConstraintException(msg);
        }
    }

    void check(boolean bool) throws ConstraintViolationException {
        if (bool != this.reqBool) {
            throw new ConstraintViolationException("'" + bool + "' does not satisfy the constraint '" + this.definition + "'");
        }
    }

    @Override
    void check(InternalValue value) throws ConstraintViolationException, RepositoryException {
        if (value == null) {
            throw new ConstraintViolationException("null value does not satisfy the constraint '" + this.definition + "'");
        }
        switch (value.getType()) {
            case 6: {
                this.check(value.getBoolean());
                return;
            }
        }
        String msg = "BOOLEAN constraint can not be applied to value of type: " + PropertyType.nameFromValue((int)value.getType());
        log.debug(msg);
        throw new RepositoryException(msg);
    }
}

